#!/usr/bin/perl -w

=head1 NAME

example-pointlist.pl - Geo::Spline example to list a set of points between GPS fixes

=cut

use strict;
use lib qw{./lib ../lib};
use Geo::Spline;

my $p0={time=>1160449100.67,
        lat=>39.197807,
        lon=>-77.263510,
        speed=>31.124,
        heading=>144.8300};
my $p1={time=>1160449225.66,
        lat=>39.167718,
        lon=>-77.242278,
        speed=>30.615,
        heading=>150.5300};
my $spline=Geo::Spline->new($p0, $p1);
print "--- 10 points ---\n";
my $point=$spline->pointlist(@{$spline->timelist(10)});
my $i=1;
foreach (@$point) {
  print $i++, ":", $_->{'time'}, ":", $_->{'lat'}, ":", $_->{'lon'}, "\n";
}
print "--- Default number of points ---\n";
$point=$spline->pointlist();
$i=1;
foreach (@$point) {
  print $i++, ":", $_->{'time'}, ":", $_->{'lat'}, ":", $_->{'lon'}, "\n";
}

__END__

=head1 SAMPLE OUTPUT

  --- 10 points ---
  1:1160449100.67:39.197807:-77.26351
  2:1160449113.169:39.1949130770032:-77.2614372445289
  3:1160449125.668:39.1919698025198:-77.259266501007
  4:1160449138.167:39.1889861018478:-77.2570303111743
  5:1160449150.666:39.1859709004531:-77.2547612168946
  6:1160449163.165:39.1829331238041:-77.2524917600344
  7:1160449175.664:39.1798816971951:-77.2502544823298
  8:1160449188.163:39.1768255460942:-77.2480819256475
  9:1160449200.662:39.1737735959116:-77.2460066318109
  10:1160449213.161:39.1707347721154:-77.2440611426788
  11:1160449225.66:39.167718:-77.242278
  --- Default number of points ---
  1:1160449100.67:39.197807:-77.26351
  2:1160449101.66992:39.1975775125346:-77.2633485519677
  3:1160449102.66984:39.1973476566117:-77.2631862851667
  4:1160449103.66976:39.1971174369108:-77.2630232163359
  5:1160449104.66968:39.1968868578919:-77.2628593620588
  6:1160449105.6696:39.1966559242347:-77.2626947390751
  7:1160449106.66952:39.196424640399:-77.2625293639677
  8:1160449107.66944:39.1961930110648:-77.2623632534768
  9:1160449108.66936:39.1959610406916:-77.2621964241846
  10:1160449109.66928:39.1957287339596:-77.2620288928321
  11:1160449110.6692:39.195496095328:-77.2618606760009
  12:1160449111.66912:39.1952631294775:-77.2616917904325
  13:1160449112.66904:39.1950298409225:-77.2615222527483
  14:1160449113.66896:39.1947962341771:-77.2613520795691
  15:1160449114.66888:39.1945623139224:-77.2611812876375
  16:1160449115.6688:39.1943280846167:-77.2610098935334
  17:1160449116.66872:39.1940935509416:-77.260837914
  18:1160449117.66864:39.1938587173549:-77.2606653656166
  19:1160449118.66856:39.1936235885386:-77.260492265127
  20:1160449119.66848:39.1933881689502:-77.26031862911
  21:1160449120.6684:39.1931524632719:-77.2601444743099
  22:1160449121.66832:39.192916475961:-77.259969817305
  23:1160449122.66824:39.1926802117:-77.25979467484
  24:1160449123.66816:39.1924436750023:-77.2596190635348
  25:1160449124.66808:39.1922068703814:-77.2594430000087
  26:1160449125.668:39.1919698025198:-77.259266501007
  27:1160449126.66792:39.1917324758745:-77.2590895831071
  28:1160449127.66784:39.1914948951283:-77.2589122630547
  29:1160449128.66776:39.1912570647378:-77.2587345574267
  30:1160449129.66768:39.1910189893863:-77.2585564829692
  31:1160449130.6676:39.1907806735299:-77.2583780562587
  32:1160449131.66752:39.1905421218522:-77.2581992940418
  33:1160449132.66744:39.1903033388091:-77.2580202128945
  34:1160449133.66736:39.1900643290845:-77.2578408295637
  35:1160449134.66728:39.189825097134:-77.2576611606253
  36:1160449135.6672:39.1895856476417:-77.2574812228264
  37:1160449136.66712:39.1893459851203:-77.2573010327855
  38:1160449137.66704:39.1891061140823:-77.257120607121
  39:1160449138.66696:39.1888660392121:-77.2569399625804
  40:1160449139.66688:39.1886257649648:-77.256759115739
  41:1160449140.6668:39.188385296025:-77.2565780833444
  42:1160449141.66672:39.1881446368477:-77.2563968819717
  43:1160449142.66664:39.1879037921175:-77.2562155283687
  44:1160449143.66656:39.1876627662894:-77.2560340391103
  45:1160449144.66648:39.1874215640481:-77.2558524309445
  46:1160449145.6664:39.1871801898484:-77.2556707204461
  47:1160449146.66632:39.1869386483752:-77.2554889243632
  48:1160449147.66624:39.1866969441408:-77.2553070593139
  49:1160449148.66616:39.1864550816574:-77.2551251419162
  50:1160449149.66608:39.18621306561:-77.2549431889182
  51:1160449150.666:39.1859709004531:-77.2547612168946
  52:1160449151.66592:39.1857285908719:-77.2545792425937
  53:1160449152.66584:39.1854861413208:-77.2543972825899
  54:1160449153.66576:39.185243556485:-77.2542153536316
  55:1160449154.66568:39.1850008408189:-77.2540334722934
  56:1160449155.6656:39.1847579990079:-77.2538516553234
  57:1160449156.66552:39.184515035506:-77.2536699192963
  58:1160449157.66544:39.184271954999:-77.2534882809602
  59:1160449158.66536:39.1840287619986:-77.2533067569332
  60:1160449159.66528:39.1837854610167:-77.2531253638335
  61:1160449160.6652:39.1835420567391:-77.2529441184089
  62:1160449161.66512:39.1832985536196:-77.2527630372345
  63:1160449162.66504:39.1830549563441:-77.2525821370579
  64:1160449163.66496:39.1828112693661:-77.2524014344545
  65:1160449164.66488:39.1825674973719:-77.2522209461716
  66:1160449165.6648:39.1823236448148:-77.2520406887848
  67:1160449166.66472:39.182079716381:-77.2518606790414
  68:1160449167.66464:39.1818357165241:-77.2516809335169
  69:1160449168.66456:39.1815916499301:-77.2515014689584
  70:1160449169.66448:39.1813475211106:-77.2513223019845
  71:1160449170.6644:39.1811033345774:-77.251143449214
  72:1160449171.66432:39.1808590950166:-77.2509649273936
  73:1160449172.66424:39.1806148068815:-77.2507867530995
  74:1160449173.66416:39.1803704748586:-77.2506089430782
  75:1160449174.66408:39.180126103401:-77.2504315139063
  76:1160449175.664:39.1798816971951:-77.2502544823298
  77:1160449176.66392:39.1796372606942:-77.2500778649256
  78:1160449177.66384:39.1793927985846:-77.2499016784395
  79:1160449178.66376:39.1791483153196:-77.2497259394488
  80:1160449179.66368:39.1789038155856:-77.2495506646987
  81:1160449180.6636:39.1786593038941:-77.2493758708087
  82:1160449181.66352:39.1784147847566:-77.2492015743988
  83:1160449182.66344:39.1781702628595:-77.2490277922133
  84:1160449183.66336:39.177925742656:-77.2488545408309
  85:1160449184.66328:39.1776812288325:-77.2486818369956
  86:1160449185.6632:39.1774367258423:-77.2485096972865
  87:1160449186.66312:39.1771922383718:-77.248338138447
  88:1160449187.66304:39.1769477708741:-77.2481671770568
  89:1160449188.66296:39.1767033280357:-77.2479968298588
  90:1160449189.66288:39.1764589143097:-77.2478271134331
  91:1160449190.6628:39.1762145343827:-77.2476580445222
  92:1160449191.66272:39.175970192766:-77.2474896397469
  93:1160449192.66264:39.1757258939713:-77.2473219157287
  94:1160449193.66256:39.1754816426849:-77.247154889209
  95:1160449194.66248:39.17523744336:-77.2469885767695
  96:1160449195.6624:39.1749933006831:-77.246822995151
  97:1160449196.66232:39.1747492191073:-77.2466581609359
  98:1160449197.66224:39.1745052033191:-77.2464940908643
  99:1160449198.66216:39.1742612577717:-77.2463308015193
  100:1160449199.66208:39.1740173871514:-77.2461683096401
  101:1160449200.662:39.1737735959116:-77.2460066318109
  102:1160449201.66192:39.1735298887384:-77.2458457847699
  103:1160449202.66184:39.1732862700855:-77.245685785102
  104:1160449203.66176:39.1730427446387:-77.2455266495449
  105:1160449204.66168:39.1727993169099:-77.2453683947217
  106:1160449205.6616:39.1725559914108:-77.2452110372564
  107:1160449206.66152:39.1723127728272:-77.2450545938854
  108:1160449207.66144:39.1720696656131:-77.2448990811957
  109:1160449208.66136:39.171826674454:-77.2447445159227
  110:1160449209.66128:39.171583803804:-77.2445909146541
  111:1160449210.6612:39.1713410583488:-77.2444382941247
  112:1160449211.66112:39.1710984425422:-77.244286670923
  113:1160449212.66104:39.1708559610699:-77.2441360617828
  114:1160449213.66096:39.170613618386:-77.2439864832937
  115:1160449214.66088:39.1703714191759:-77.2438379521883
  116:1160449215.6608:39.1701293679517:-77.2436904850924
  117:1160449216.66072:39.1698874692254:-77.2435440986326
  118:1160449217.66064:39.1696457276822:-77.24339880954
  119:1160449218.66056:39.1694041477766:-77.2432546344068
  120:1160449219.66048:39.1691627341938:-77.2431115899632
  121:1160449220.6604:39.1689214913883:-77.2429696928024
  122:1160449221.66032:39.168680424045:-77.2428289596534
  123:1160449222.66024:39.1684395366187:-77.2426894071106
  124:1160449223.66016:39.1681988337942:-77.2425510519019
  125:1160449224.66008:39.1679583200265:-77.2424139106228
  126:1160449225.66:39.167718:-77.242278

=cut
