/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;

public class FreeBox
implements Box {
    public static final String TYPE = "free";
    ByteBuffer data;
    List<Box> replacers = new LinkedList<Box>();
    private Container parent;
    private long offset;

    public FreeBox() {
        this.data = ByteBuffer.wrap(new byte[0]);
    }

    public FreeBox(int size) {
        this.data = ByteBuffer.allocate(size);
    }

    public long getOffset() {
        return this.offset;
    }

    public ByteBuffer getData() {
        if (this.data != null) {
            return (ByteBuffer)this.data.duplicate().rewind();
        }
        return null;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        for (Box replacer : this.replacers) {
            replacer.getBox(os);
        }
        ByteBuffer header = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt32(header, 8 + this.data.limit());
        header.put(TYPE.getBytes());
        header.rewind();
        os.write(header);
        header.rewind();
        this.data.rewind();
        os.write(this.data);
        this.data.rewind();
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public long getSize() {
        long size = 8L;
        for (Box replacer : this.replacers) {
            size += replacer.getSize();
        }
        return size += (long)this.data.limit();
    }

    public String getType() {
        return TYPE;
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.offset = dataSource.position() - (long)header.remaining();
        if (contentSize > 0x100000L) {
            this.data = dataSource.map(dataSource.position(), contentSize);
            dataSource.position(dataSource.position() + contentSize);
        } else {
            assert (contentSize < Integer.MAX_VALUE);
            this.data = ByteBuffer.allocate(CastUtils.l2i(contentSize));
            dataSource.read(this.data);
        }
    }

    public void addAndReplace(Box box) {
        this.data.position(CastUtils.l2i(box.getSize()));
        this.data = this.data.slice();
        this.replacers.add(box);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreeBox freeBox = (FreeBox)o;
        return !(this.getData() != null ? !this.getData().equals(freeBox.getData()) : freeBox.getData() != null);
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }
}

