#!/usr/bin/perl -T
use strict;
use Test::More;

my %data = (
    "A"         => "1.65", 
    "B"         => "1.66", 
    "AB"        => "2.65.66", 
    "ABC"       => "3.65.66.67", 
    "ABCD"      => "4.65.66.67.68", 
    "ABCDE"     => "5.65.66.67.68.69", 
    "ABCDEF"    => "6.65.66.67.68.69.70", 
    "ABCDEFG"   => "7.65.66.67.68.69.70.71", 
    "ABCDEFGH"  => "8.65.66.67.68.69.70.71.72", 
    "ABCDEFGHI" => "9.65.66.67.68.69.70.71.72.73", 
    "hostname"  => "8.104.111.115.116.110.97.109.101", 
    "database"  => "8.100.97.116.97.98.97.115.101", 
    "schema"    => "6.115.99.104.101.109.97", 
    "localhost" => "9.108.111.99.97.108.104.111.115.116", 
    "zeruel"    => "6.122.101.114.117.101.108", 
    "saper"     => "5.115.97.112.101.114", 
    "public"    => "6.112.117.98.108.105.99", 
    "foo"       => "3.102.111.111", 
    "bar"       => "3.98.97.114", 
    "foo bar"   => "7.102.111.111.32.98.97.114", 
    '@'         => "1.64", 
    "/"         => "1.47", 
    "/var"      => "4.47.118.97.114", 
    "/var/log"  => "8.47.118.97.114.47.108.111.103", 
);

plan tests => 1 + 2 * keys %data;

use_ok("SNMP::ToolBox");

for my $string (sort keys %data) {
    my $result = eval { oid_encode($string) };
    is( $@, "", "oid_encode('$string')" );
    is( $result, $data{$string}, " - '$result'" );
}
