# Generated by default/object.tt
package Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk;
  use Moose;
  has BackloggedStorageBytes => (is => 'ro', isa => 'Int', request_name => 'backloggedStorageBytes', traits => ['NameInRequest']);
  has DeviceName => (is => 'ro', isa => 'Str', request_name => 'deviceName', traits => ['NameInRequest']);
  has ReplicatedStorageBytes => (is => 'ro', isa => 'Int', request_name => 'replicatedStorageBytes', traits => ['NameInRequest']);
  has RescannedStorageBytes => (is => 'ro', isa => 'Int', request_name => 'rescannedStorageBytes', traits => ['NameInRequest']);
  has TotalStorageBytes => (is => 'ro', isa => 'Int', request_name => 'totalStorageBytes', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk object:

  $service_obj->Method(Att1 => { BackloggedStorageBytes => $value, ..., TotalStorageBytes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk object:

  $result = $service_obj->Method(...);
  $result->Att1->BackloggedStorageBytes

=head1 DESCRIPTION

Request to query disks replicated.

=head1 ATTRIBUTES


=head2 BackloggedStorageBytes => Int

Request to query data replication backlog size in bytes.


=head2 DeviceName => Str

Request to query device name.


=head2 ReplicatedStorageBytes => Int

Request to query amount of data replicated in bytes.


=head2 RescannedStorageBytes => Int

Request to query amount of data rescanned in bytes.


=head2 TotalStorageBytes => Int

Request to query total amount of data replicated in bytes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

