# Generated by default/object.tt
package Paws::SageMakerFeatureStoreRuntime::BatchGetRecordError;
  use Moose;
  has ErrorCode => (is => 'ro', isa => 'Str', required => 1);
  has ErrorMessage => (is => 'ro', isa => 'Str', required => 1);
  has FeatureGroupName => (is => 'ro', isa => 'Str', required => 1);
  has RecordIdentifierValueAsString => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMakerFeatureStoreRuntime::BatchGetRecordError

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMakerFeatureStoreRuntime::BatchGetRecordError object:

  $service_obj->Method(Att1 => { ErrorCode => $value, ..., RecordIdentifierValueAsString => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMakerFeatureStoreRuntime::BatchGetRecordError object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorCode

=head1 DESCRIPTION

The error that has occurred when attempting to retrieve a batch of
Records.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ErrorCode => Str

The error code of an error that has occured when attempting to retrieve
a batch of Records. For more information on errors, see Errors
(https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors).


=head2 B<REQUIRED> ErrorMessage => Str

The error message of an error that has occured when attempting to
retrieve a record in the batch.


=head2 B<REQUIRED> FeatureGroupName => Str

The name of the feature group that the record belongs to.


=head2 B<REQUIRED> RecordIdentifierValueAsString => Str

The value for the C<RecordIdentifier> in string format of a Record from
a C<FeatureGroup> that is causing an error when attempting to be
retrieved.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMakerFeatureStoreRuntime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

