# Generated by default/object.tt
package Paws::AppRunner::Service;
  use Moose;
  has AutoScalingConfigurationSummary => (is => 'ro', isa => 'Paws::AppRunner::AutoScalingConfigurationSummary', required => 1);
  has CreatedAt => (is => 'ro', isa => 'Str', required => 1);
  has DeletedAt => (is => 'ro', isa => 'Str');
  has EncryptionConfiguration => (is => 'ro', isa => 'Paws::AppRunner::EncryptionConfiguration');
  has HealthCheckConfiguration => (is => 'ro', isa => 'Paws::AppRunner::HealthCheckConfiguration');
  has InstanceConfiguration => (is => 'ro', isa => 'Paws::AppRunner::InstanceConfiguration', required => 1);
  has ServiceArn => (is => 'ro', isa => 'Str', required => 1);
  has ServiceId => (is => 'ro', isa => 'Str', required => 1);
  has ServiceName => (is => 'ro', isa => 'Str', required => 1);
  has ServiceUrl => (is => 'ro', isa => 'Str', required => 1);
  has SourceConfiguration => (is => 'ro', isa => 'Paws::AppRunner::SourceConfiguration', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);
  has UpdatedAt => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::Service

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::Service object:

  $service_obj->Method(Att1 => { AutoScalingConfigurationSummary => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::Service object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoScalingConfigurationSummary

=head1 DESCRIPTION

Describes an AWS App Runner service. It can describe a service in any
state, including deleted services.

This type contains the full information about a service, including
configuration details. It's returned by the CreateService
(https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html),
DescribeService
(https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html),
and DeleteService
(https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html)
actions. A subset of this information is returned by the ListServices
(https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html)
action using the ServiceSummary
(https://docs.aws.amazon.com/apprunner/latest/api/API_ServiceSummary.html)
type.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AutoScalingConfigurationSummary => L<Paws::AppRunner::AutoScalingConfigurationSummary>

Summary information for the App Runner automatic scaling configuration
resource that's associated with this service.


=head2 B<REQUIRED> CreatedAt => Str

The time when the App Runner service was created. It's in the Unix time
stamp format.


=head2 DeletedAt => Str

The time when the App Runner service was deleted. It's in the Unix time
stamp format.


=head2 EncryptionConfiguration => L<Paws::AppRunner::EncryptionConfiguration>

The encryption key that App Runner uses to encrypt the service logs and
the copy of the source repository that App Runner maintains for the
service. It can be either a customer-provided encryption key or an AWS
managed CMK.


=head2 HealthCheckConfiguration => L<Paws::AppRunner::HealthCheckConfiguration>

The settings for the health check that App Runner performs to monitor
the health of this service.


=head2 B<REQUIRED> InstanceConfiguration => L<Paws::AppRunner::InstanceConfiguration>

The runtime configuration of instances (scaling units) of this service.


=head2 B<REQUIRED> ServiceArn => Str

The Amazon Resource Name (ARN) of this service.


=head2 B<REQUIRED> ServiceId => Str

An ID that App Runner generated for this service. It's unique within
the AWS Region.


=head2 B<REQUIRED> ServiceName => Str

The customer-provided service name.


=head2 B<REQUIRED> ServiceUrl => Str

A subdomain URL that App Runner generated for this service. You can use
this URL to access your service web application.


=head2 B<REQUIRED> SourceConfiguration => L<Paws::AppRunner::SourceConfiguration>

The source deployed to the App Runner service. It can be a code or an
image repository.


=head2 B<REQUIRED> Status => Str

The current state of the App Runner service. These particular values
mean the following.

=over

=item *

C<CREATE_FAILED> E<ndash> The service failed to create. To troubleshoot
this failure, read the failure events and logs, change any parameters
that need to be fixed, and retry the call to create the service.

The failed service isn't usable, and still counts towards your service
quota. When you're done analyzing the failure, delete the service.

=item *

C<DELETE_FAILED> E<ndash> The service failed to delete and can't be
successfully recovered. Retry the service deletion call to ensure that
all related resources are removed.

=back



=head2 B<REQUIRED> UpdatedAt => Str

The time when the App Runner service was last updated at. It's in the
Unix time stamp format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

