#!/usr/bin/perl -w
# based on fl16.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 63) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 256, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok($frame->stereo, "stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
 %                        ΀ۀ8Dۀ8DȀ|@s|@s.zhd.zhdxrxrj8yj8y99ws0ws0j늅j늅|gt|gtwsBwsBkvpkvpnkknkkxsVxsVk(e_k(e_p=v;~p=v;~xskqxskqkJTNkJTN11xsPxsPkkC>kkC>ؑϔؑx,s/x,s/k3-k3-|t|tx8sx8sk"k"okkl{okkl{xEsxEskΊkΊ                                                                                                                                                                                                                                                                                                               %                  AAlt~lt~vSpvSpfftSStSSvbpvbpfጇfጇq؏q؏vrp՘vrp՘g	slg	sl{r}{r}vp{vp{g2_Xg2_XkgBh,kgBh,vqTvqTgZKDgZKDm\ts~m\ts~vq,vq,g70g70)ɖ)ɖvq7vq7g#g#*'*'vqNvqNgь	gь	{r膶{rvqfvqfgglehhlehhvq~vq~hhmt~mt~vqlvqlhEՋhEՋψCCvqFvqFhlhl                                                                                                                                                                                                                                                                                                               %                   ՒՒtn#tn#b{b{1zp1zptn.tn.bbhbchbctnJtnJbڎbڎirW~`irW~`tngtngc	rjc	rjՓٚՓٚtnitnic8[Sc8[S''un;un;cfD<cfD<{ p{ pun
un
c-%c-%hcdhcdu1n؛u1n؛ccjr~mjr~muBnuBncc;;uTouTodd>@\>@\ueo*Yueo*YdJҍdJҍʇ{Gq {Gq uvoF-uvoF-dwdw                                                                                                                                                                                                                                                                                                               %                  0c]f^c]f^rkrk]2(]2(eo~eo~rk1rk1]
]
ЗzЗzrkRrkR]]z1z1sktbsktb^-ߐ^-ߐ։cz=mcz=ms#k-s#k-^dÐ^dÐd^z_d^z_s8ks8k^^fpZ~$fpZ~$sLkנsLkנ^А^Аiisaksak_sj_sjggsulXsulX_;XO_;XOzknCzknCsl8$sl8$_p>5_p>5eo_`eo_`slXslX_#_#gp~3gp~3slxslx_ِ	_ِ	                                                                                                                                                                                                                                                                                                               %                  A'åa'åapgpgW	W	ƣƣpg{pg{X X y0jYy0jYpgڧ<pgڧ<XAӓXAӓ_X[Y_X[YphphXXb"m~}b"m~}ph(ph(XX77qhOqhOYtiYtiHHq+hu@q+hu@Y?TJY?TJyfkyfkqChqChY~5+Y~5+`Y[`Y[q[hq[hYYcn}cn}qrh楈qrh楈YY99qiKqiKZ8ْZ8ْΦEܗEܗqi1qi1ZuZu                                                                                                                                                                                                                                                                                                               %                  EQE wfe wfencrfncrfPrfPrfYQRYQRncncQKL@QKL@\j}f\j}fn=cέn=cέQ'Q'\Ϫԑ\ϪnYcnYcQQnvd)=nvd)=R,ܖR,ܖЌx2g1x2g1ndVndVRvRvZRTBZRTBndndRR]j}{]j}{ndcndcS	nbS	nbҞҩ~Ҟҩ~nd۬nd۬SQJ>SQJ>BܛҭBܛoeoeS&S&RxpgRxpgoe2oe2SS\SU\SUo8e]Go8e]GT)ޕT)ޕ                                                                                                                                                                                                                                                                                                               %                  aV;f|V;f|j^.j^.IaSIaSk ^޵k ^޵Iu5&Iu5&?o?okB_kB_IΛ	IΛ	
vb
vbkc_H)kc_H)J&ݚJ&ݚTJILFTJILFk_}k_}J|J|Wf}Wf}k_~k_~JӚxJӚxrrk_)k_)K)\NK)\N浆k`k`K~1#K~1#wcwcl`Ml`MKӚKӚUoKMUoKMl(`.l(`.L'ݙL'ݙXg}Xg}lH`lH`L{L{EOEOlh`沉lh`沉LΙ|LΙ|                                                                                                                                                                                                                                                                                                               %                  qV)V)gyYEgyYE??u]Ou]OgYOgYO@Pş@PşL
@zBL
@zBgYygYy@@P%bY|zP%bY|zgY̾gY̾A_NA_NhZ
hZ
A,A,LYLYh<ZGLh<ZGLAA<ul^c<ul^chcZhcZBLȞBLȞMBuDMBuDhZhZBBQcF|QcF|hZ%hZ%CeTCeTʩ¸9ʩ¸9h[9h[9Cu4#Cu4#TTh[tch[tcCמCמu_pu_pi[i[D8ҝD8ҝ                                                                                                                                                                                                                                                                                                               %                   B47B47c\Rc\R5)VB5)VBGh\{Gh\{cRjcRj55ҲġҲġcScS6ޤ6ޤFFcSd}cSd}66as~X@as~X@dSdS7gS7gSDx779Dx779d@Sǔd@Sǔ7~,7~,I+^{I+^{dmT; dmT; 77ޚc~c~dTƮdTƮ8g8gȇEȇEdT;dT;8ۣ~k8ۣ~ksY~sY~dUdU9ND29ND2FS9|<FS9|<eUSYeUSY99J_|J_|eHUeHU:2Ӣ:2Ӣ                                                                                                                                                                                                                                                                                                               %                  I$II*I*^JF^JF((؈k؈k^K>պ^K>պ)(S;)(S;q6Pq6P^K0^K0)
)
9)-9)-_/KԦ_/KԦ*@Ǫ*@Ǫ?(W{:?(W{:_dL<_dL<*˪k*˪kh΢h΢_LӖ_LӖ+U>'+U>'ɤɤ_L_L+ݩ+ݩZqRuZqRu`M6҈`M6҈,f,f;,/;,/`5M`5M,q\,q\A-Y{`A-Y{``hM~`hM~-s/-s/⸕/⸕/`N+`N+--XX`N{w`N{w.}.}                                                                                                                                                                                                                                                                                                               %                  (nHinHiXBXB,6,6Y1BeY1Be}}3QP}z\3QP}z\YpBzYpBz;F+;F+YC+YC+ޱޱoZoZYC9YC9oJ$oJ$Z)CZ)C"T9"T9/Ub!/Ub!ZgDPZgDP5Qz5QzZD`ZD```ZEZEfLfLFahFah[Eq)[Eq)oKҚoK[XEޑ[XEޑ 6ɯ 6ɯ1 u#1 u#[F-[F- Я|c Я|c                                                                                                                                                                                                                                                                                                               %                  ,%QGyT%QGyTRf7Rf7ջtTջtTѯѯR8R8		ɽɽR8)R8)
U
Uk@Ok@OSA8nSA8nU6U6 ` `S9kS9kйй($Iy($IyS9S9zz1#ꌫ1#T:NBT:NB
G=
G=7q7qT`:T`:  lBKlBKT;/T;/ff#1#1T;!T;!o(
o(
*KCy*KCyU1<lU1<l%ͷ%ͷ̬9̬9Uw<zUw<zڷtVڷtV                                                                                                                                                                                                                                                                                                               %                  044J+w`J+w`mGmGhN4hN4K, K, 0000Kj,Kj,ČhČh?x\?x\K-K-xxݗݗL-L-UñÌUñÌr|r|Lh.Lh.0B0Bli7li7L.AL.A
²
²aTaTM/!kM/!kiGiGVAxVAxM`/M`/۱}ڭ}ڭM0&M0&pp)Tڅ)TN0N0d*d*Ai9LAi9LNU1("NU1("77                                                                                                                                                                                                                                                                                                               %                  M4MAIkAIk݂݂!3v!3vB5gB5gމЏcމЏciiBgBgߏ
ߏ
ᢋꢋB%eB%eό`ό`Ad)Ad)C^gC^gC ]jC ]j΋a΋a6>w?6>w?D" oD" o⺇<^<^D!wD!w͍e͍ey5͝y5D"*~D"*~e,de,dEA"EA"̔k̔kE#WE#Wzz8w8wF #F #q˝tq˝t                                                                                                                                                                                                                                                                                                               %                  8r:r:7cT7cTBޫwBޫw8	(8	(7
u"7
u"ttV_V_8M/8M/Ħ{GĦ{G%%88ܱܱ9(u9(u9393LL7Ъ7Ъ9S}9S}+۸ۆ+۸ۆ;y;y:V:VU%U%` ` :4:4|ڐ`|ڐ`ѧѧ:l:lˠˠ+}u+}u;i;il;l;ݥkݥk;ί;ίججmm<F}<F}MM                                                                                                                                                                                                                                                                                                               %                  <ϽZNZN+6fھ+6fھnRnR; ,; ,+@\+@\힣كsكs,F,F8'8'ܕܕ,֢,֢y=y=>b>b-RE-RE덧덻[6[6--XߩXݩݩ._jҘ._jҘn3n3޳t$޳t$.>A.>A釬MMßMMß/g /g a߭a^4)^4)/ Ο/ Οm3m3\[\[0iT0iT	现	U?U?0t0tVV                                                                                                                                                                                                                                                                                                               %                  Aqqnn}E}Eϱ[ϱ[~F ~F uߣuߣ:5:5v3v3TT%e%eʌ+ʌ+uuA	qA	q v vU̅UʫXʫX  HHXبXب!GZ!GZ99ĶUĶU!!ҊssYķY"xI"xI0
rh0
rh#x#x&+&+ܦ{"ܦ{"#f?#f?h&h&                                                                                                                                                                                                                                                                                                               %                  QEQwUwU`wG`wGQnQnLwLw
ɡf
ɡfSɕƕzSɕƕzT_T_
Ʀ
ƦU֔U֔j=oej=oeW瓘W瓘55AAYnYnk;ok;o..[I[IDN+DN+O(O(]&]&ђ]h]hdlWdlW^3^3sosoшш`͏I`͏Iw߉w߉ҟҟbdbd ; ;zӺzӺdl}3dl}3κOκO*Җ5*Җ5f5Mf5M                                                                                                                                                                                                                                                                                                               %                  I$^Y*^Y*KK22u<ڷlau<ڷlaثث!o鮍!o鮍,RÉ,RÉ^^#ѭo#ѭoռռ%جY%جYE
ĢE
Ģaәaә(B(Bga(5ga(52]t2]t*2,*2,}l}lQQ,\r,\rҹtҹtײ3ײ3.~g
.~g
--DD0Q0QFyFy z z2E2Ep3?p3?EE4ե44ե4ᅚmm6/6/                                                                                                                                                                                                                                                                                                               %                  M4ӛ77[[͏͏YZYZXQ#XQ#@@:Ml:MlT摙T摙8ʈ8ʈ4@F4@FSoSoɭFɭFNX iNX iKKTeTeKWKWDD)Ƹ)ƸY+Y+<<fyfy<uT<uT33ģ:ģ:>ys>ys##]b]bWȅj6Wȅj600%%""SS\͇\[[KK                                                                                                                                                                                                                                                                                                               %                  QEd-yd-y[[

'']]
eh
eh:_w:_w쀥쀱ŞgŞg^aB^aB44̅c̅c鄪鄂50"!50"!ͦd!ͦd!¯V¯Vf;f;晰!̧f>!̧f>hqThqT1{1{j4}j4}0㱶0MǜMǜkk::&2&24m4mǼxEּxEDDIohIohKfKf                                                                                                                                                                                                                                                                                                               %                  UUUUԅw&`ԅw&`
*ª
*ªNFJNFJ2q2qb,b,Q˖~Q˖~ۛۛ/
/
UR+UR+!S̙!S̭1-/1-/X֓	mX֓	mSZ7nSZ7ng3>g3>\ED\EDcaca5aM5aM__ˡKˡK
7p
7pc2֍Cc2֍CgţgŲW9W9f f 1$]1$];6;6jnjn\kY\kY=ش=m^/m^/gbygby:?:?ppHqHq楷|AN|ANtoto                                                                                                                                                                                                                                                                                                               %                  Ye̾2̾2 񈇓 񈇓
KƗ
KƗPP66ă66ăl4
l4
uuD,D,=P[=P[gg_t_tֹ,ֹ,CmCm tk tkNCNCkk}p}pp'p'L `}L `}kk|
!n|
!n뇏vtvt|Z]|Z]X/瘑X/srsrNvwNvwa%a%c
۔c
M9M9*2*2\\0A0A                                                                                                                                                                                                                                                                                                               %                  ]u!!!!Z㮤9Z㮤9 'b 'b<!U^<!U^\o\oŉyŉy^^궋ZZ>>`mj`mjo5o5Ш 0Ш 0b4YSb4YS.ؕ.d /ܤd /ܤCCN$SVN$SVee&&yygqgq8գ8Vl\Vl\iUũiUũKꄧK++ktTktT|J|J1J1Jl<l<α  `S/%W`S/%WnHnHn㳵n                                                                                                                                                                                                                                                                                                               %                  aоо)`)`KWKW55+dv+dv6{6{觞觞-g|-g|׸׸̯s
/s
/0jp0jpcʹcʹbO*bO*2FnD2FnD++HΤHΤ4nq׋4nq׋sq~sq~țț6mt 6mt "୦"୦ss8x@8x@(P(P*J*J:{vp:{vp-0T-0TPP<~<~3#3#/6μ/6>>8q8qҌHҌH@ǅ7@ǅ7= AW= AW                                                                                                                                                                                                                                                                                                               %                  YeYGGZ7Z7k*k*+n-+n-		r΄r΄o(FBo(FB]
]
xxցww7[A7[ADc+Dc+JVLJVLҤXښҤX[[  FlFl//ஒssHH!k!kssҭ'ҭ'
$;
$;*mM*mMߙRߙRt(t(q=2q=2jj,,⫳''`&c`&c408408±                                                                                                                                                                                                                                                                                                               %                  i@;@;G2G2bx@bx@KK塰"Ŭp"Ŭp$ܺQ$ܺQ;;1pӳ1p˼ס˼סO0O0~~hh⯵VyVy歈歈99R=R=в:в:c͘Kc͘KAAȤȤ}X3}X3|;|;MMewewsswJwJ!&L!&Lll⾹⾹dF?dF?Ȗ&Ȗ&:$:$WW̡̡rjrj                                                                                                                                                                                                                                                                                                               %                  m۬ުwުw^^Ǝ*Ǝ*V|V|b$N6b$N6ug0ug0e)Xe)X½2½2X01X01i>/8li>/8l

ֽ≝ֽ≝l4bl4bڳ^ڳ^˷˷o9.o9.>>sG? ɼsG? ɼ%%!s(j[!s(j[vDB vDB -Ҧ`-Ҧ`y4*y4*yIyI66p66pzszs}N}N>1>1mSꧯmSꧯG4G4||YgYgOӕSOӕS                                                                                                                                                                                                                                                                                                               %                  q*8b*8b ϻ ϻqt#[qt#[ffpp7'7'S+S+uuBB 2J} 2J}jNjNxx*
X*
XU.jU.jVVVV4ޣ'4ޣ'&&MeMe?ʝ?ʝtŋtŋ-}-}I%I%ިި##S2=S2=r(>r(>&̎&̎]@]@~\a
~\a
*˅*˅fOfO㳤)'㳤)'.{L.{Lp=p=                                                                                                                                                                                                                                                                                                               %                  ]u]QȋQȋ9>9>$$߯R7PR7P;;7rk7rkZK;ZK;c{N'c{N'2>2>p1p1MӊMӊ	y	y&¨&¨0}}0}}tMtM2]¢2]¢AA00>aН >aН BB{{Iޙ5Iޙ51O1O%Ò%ÒUГ"UГ"YnYnW,W,a<ya<y))33lчυlчυ                                                                                                                                                                                                                                                                                                               %                  ywtwtrrǤ|3|3EHEH!'!'ss`t`t'5/ߢ'5/ߢgښgښےے,8Q,8Q++(q}(q}1@1@,̬,̬RR7&IJ7&IJ++AA<Q;<Q;
9 q
9 qAZhݣAZhݣº>º>GbyGbyn]n]ҾNҾNLzjXLzjX"ª"ªҗҗQsrQsr//]4Ճ]4ՃV{MV{M=%i=%i                                                                                                                                                                                                                                                                                                               %                  }ߠ률륊77(28-(28-ė>ė>0Af0Af8؞8؞``ZKݕDZKݕDIQIQƞU՞UZ#@Z#@8i`<8i`<._̤._jdHjdH߾ƏD߾ƏDGi䔪Giz}"z}"ދދYsYs'y'y;x;x}N˶}N˚JJ?$ɿ?$ɼ((zuDfzuDf㐊㐊ߝXߝXؚ8ؚ8ʯkʯkꣶgꣶg'zd'zd                                                                                                                                                                                                                                                                                                               %                    uu))llBq3Bq355330w0wAU/AU/mm{1պ{1պMSMSڦ8{旦8{=I=IsX1sX1xx&G&Gxd9%xd9%|ևӐ|ևӐ*C*Cooߛ 6ߛ 6TT,z,zßßTdۗTdۗa}a}źfyźfy˹՘˹՘"CÖ"CÖK]fK]f||)ڱ#)ڱ#)d)d]]0d@"0d@"<X<X                                                                                                                                                                                                                                                                                                               %                  aaWGWGPjvPjve'&e'&䷷V䷷V" ձ" ձ||hUhU+<
O+<
OҒқૣૣ44ZĩZ($($<%ӓr<%ӓrHMȝJHMȝJE-2E-2HͣHͣ+j-+j-M@QM@Q77]Θޔ]ΘV;Mc=V;Mc=1S1SuI+uI+^[V^[V^f^fƸ8%>8%>fhi,fhi,-d΢-d΢6fw6fwouJouJBʚ$Bʚ$}XL{\}XL{\wBwBXlXl                                                                                                                                                                                                                                                                                                               %                  (OI˱OI˱20~20~WW)9)9<{L<{L"˩"˩.r.rFǟH!FǟH!==;G;GQRQRWԋDWԋDGMGM[n*[n*qnqnѽѽddFzqFzq\m\mn޸n޸ܤ'䤤'^͐{^͐{xroxro		^*^*33LL٩%*%*
1%
1%		Ѡ<ۍѠ<ۍ44

FF++#r'#r'                                                                                                                                                                                                                                                                                                               %                  874u[74u[##Ee*Ee*=Q,=Q,0K0Kc9ڄ4c9ڄ4
 o
 o;y_;y_ttwqEwqEGj	WGj	W55RRS%eDS%eDQNlZQNlZ_P/Fw_P/Fw$˪ƾ$˪ƾMꏚMꏚj@Xj@Xxзxзzx zx vS(vS(|f|feded7ҟT7ҟTޅU
ᦅU
ᦌwwV8|<V8|<hhљљsz]sz]Q~)Q~)){){]]                                                                                                                                                                                                                                                                                                               %                  $I$iN=iN=qqtt8䏹8䏹6
6
0x0xÛddS~ЉS~Љ`=C`=ComomwwȅnVȅnVA2A2}旙}?H>?H>-I(-I(վggee9^ױ9^ױ*è*è͟͟FsiDFsiDy y P׿cP׿cUU'`A'`A5l5la[a[J J uRuRncncl_l_
~
~{1Ɯ{1ƜFUFU                                                                                                                                                                                                                                                                                                               %                  eYePsPswywyGڏ+Gڏ+	M	M݈NҹNҹq~6q~6>:y >:y #v#v..U^nU^n&է&rLrL::99aa---L--L-*_*_ByByQBQBBi:Bi:j
fj
fܿܿ$\-$\-7.7.ӢӢttQ1fQ1f쵗ǶǶO,O,#<#<,j	,j	                                                                                                                                                                                                                                                                                                               %                  i[² [² [[ƿƿY(ˍY(ˍ`ƥ>`ƥ>x
x
!ru!ruD(D(+s9+s9 ?ק ?קuquq֐b=֐b=W]SW]Sc=c=$¹$¹&z&z``МtSМtS8ch8chQQI{I{6ꞗ`6ꞗ`tt[҂[҂dQdQ7(<7(<o;ߎIo;ߎIkk禦禦55Ð΄Ð΄

Œ&Ա:&Ա:xBgxBg                                                                                                                                                                                                                                                                                                               %                  yUU<<ܾIͶIͶ9,9,ꇑ#ꇑ#(ְ(ְܰsDܰsD$Q$Q33IIII11kAkAlόzlόz)S)S轥HϥHϋɋ>BtŲ>BtŲި߽ި߽||Tԗ&Tԗ&ū1)ū1)ߎj;j;MQχFMQχFcc~!5~!5}}xx##;eς;eς9898*<*<g g <굼<(
 (
                                                                                                                                                                                                                                                                                                                %                  ((Yy_Yy_?&&?&&!c!cq]ܿfq]ܿfՠqMqMU^U^!1!1-ui-uiGG44%%eVeVf}f}"~"~awaw%%)) 5 5OaOaۭCۭC7>7>ߞߞObέObέΌΌεεgSgS88ʈ)
ʈ)
^Ӱ#^Ӱ#O܃O܃?h:?h:𲙧𲏎OEOE                                                                                                                                                                                                                                                                                                               %                  iiejejפ応פ応xuxuԼ,,_ҙ_ҙЬЬē##C:HC:H^)I^)IEN,sgEN,sg2t2t9٭9zm˕$zm˕$NNppk<>k<>mиmиGGܫ}ވy}ވyY!ԇY!ԇ|[|[D-D-ƗƗZCZCĎ[Ď[+ݞL+ݞLE]]E]]ooq5&q5&٭neneVЫrVЫrfŶfŶTǝT

	Oޞ	Oޞ                                                                                                                                                                                                                                                                                                               %                  xx鿯+鿯+3C3CxҨZxҨZ$S$S=!=!]q#,]q#,[[N=#N=#*]*]%&%&bУbУəməmC;uQC;uQȱȱ캫ƌHƌHbbYÂYÂOLOL;7L;7LɁɁʰ֬ʰ֬k6k6
9
9UwUwҢYCҢYCh%kh%kss__$$ӻgӻg.@.@mm                                                                                                                                                                                                                                                                                                               %                  뮺&%A&%A
OX
OXj=Pj=PA`NA`N;eʰ;eʰu0u0z۶zcc+ݛ+ݛIݗIݗI{I{g3g3u#u#J J 
A
Ata͐ta͐Vq8Vq8gg׎׎vޛvޛ+i
+i
[[RުRުP0
P0
O\O\x}`9{x}`9{Z
ƼZ
G5G5--QtFs9QtFs96#d6#dii                                                                                                                                                                                                                                                                                                               %                  ,,[o[oҽhҽhVuMVuMDD`u``u`a#a#.?.?BܨKBܨK7b7bX:NX:N\#s\#sABAB犽犽))iiiiQAQA-/-/ʔXʔXввe:e:CZ^CZ^yr3yr3C/C/;;i_wi_wtE۔tE۔2H2HsMsMBkBkݵqݵqssii!XK!XK                                                                                                                                                                                                                                                                                                               %                  mm#4#4ovov㰷㰷bwbwssp.Op.OfRg}fRg}Go+хGo+хۣ؈ۣ؈)ӕ)ӕtztzU}U}oFoF謧5Q5Q'rX'rX9u!9u!-ԩ-ԩ꺞&[&[P'P' ~sX ~sXBJBJ֣9֣9UՓUՓӜӜ V VY(fcY(fcXXÊ쥢Ê쥢{Jq{JqF'*F'*ɬ+ɬ+DDpopoɁɁ&$s&$s""                                                                                                                                                                                                                                                                                                               %                   v:81 v:81//G2jG2jAsмAsм[x7[x7o,o,
>H
>H;;;;qqqqrRrRҚҚ ׽R ׽RWW//H9H9G-DG-D䐻䐻0@0@ISIS䐠J
J
h/h/o*o*=Ȼ=ȻXXְ'ְ'})k})k1(1(\\;;ʙʙ                                                                                                                                                                                                                                                                                                               %                  ǨǨ.p.p櫧櫧 O( O(yxyxɧxɧxZǌNZǌN}dy"}dy"yy@YJ@YJ#잦#잦MUtMUt		mQ.mQ.IID0D0%Ľ%Ľddͼ!!DD뽌GGsOEsOEOMo=OMo=R:bR:b&&$!&&$!O+O+ЗЗ~z~z_<_<ʼʼl!xl!x 
 
ڋڱuȕuȕc˂<;c˂<;KK                                                                                                                                                                                                                                                                                                               %                  00EEC:C:4Fn4Fnnvwnvwqvqv'Jo'JoiiaWaW

تyتyMY}VMY}V՟IG՟IG{h{hҴᠣbXᠣbXq/j޶q/jݝkݝkԗ_ԗ_U
PU
PU+	nU+	nBĭBWW饃  yÜyÜ܉{R܉{R//`R߸`R߸-(HG-(HG[S[SGGFyFyĵ@嵁@aUaU$;`$;`55ΝkAΝkA                                                                                                                                                                                                                                                                                                               %                  qq& & 
]
]	4	4͌Yf͌Yfpb';pb';,tџ,tџ``|4|4?Ө?ӨooF!F!66~
c=H~
c=H''\\۷\\۷
Xƞ
Xƞ]U]U6䌫6䌫eeUrUr$/C$/C__sF¯sF¯"s! "s! 51׈51׈]=Q]=Qqޖ qޖ ;ա;h_h__j_joo_oo_q\q\ɪ`9x`9xo<&o<&                                                                                                                                                                                                                                                                                                               %                  ,kXCkXC:
˶:
˶II3BE3BEī䓫3`3` L L0l
0l
_ Е_ Е@@P:żP:ŗjjݞݞ##uu00׽U׽UVVq_!oq_!oYeYe$n$nPPw}=uw}=ui+i+P_IP_I䦝䦝՚p˚p$`Ɋ$`Ɋc!؋c!؋//6q16q1; a; a:]+:]+JJB;B;                                                                                                                                                                                                                                                                                                               %                  <Z̓EZ̓Ec,c,TəTə,,**9Ս**9Ս[פ[פٓٓ[Ӯ[ttCCDyDyO
῀O
˒uv#˒uv#ϥPϥP6_G6_GLWȘLWȘ
gY
gYH;H;*µ*µbʸXbʸX>e>e	Г	Г-F-Frxrxmm8Qf8Qfaahрhэ¬¬gsgs 0 0ODOD&ۣ&ۉae(qae(qXT
XT
                                                                                                                                                                                                                                                                                                               %                  4M4  \\UUڨw͜ڨw+d3+d3		:<:<D΢tD΢t-_-_F̀F99q1*q1*&&;ь;ьұ^ұ^a	@a	@?Tm?Tm_ϖ_ϖxIxIO?O?dzVdzV((Jd=Jd=߿߿͖hh¸}¸}c)Oc)OڊKڊK&u&uC=fC=fჱCAჱCAo o Շ͇                                                                                                                                                                                                                                                                                                               %                  u]uj+:j+:XKXKc>ǲc>ǲ/'!/'!||TT""KDCKDCmm&G&GR(R(M8M8/P/Puw%uw%mBmBu3u3		zfpzfp: : Ku̠cKu̠cШwҸШwÍo}Ío}=<=<}}ϝGϝG2e2eЛ:Q9:Q9\F\F4+4+L&DSoL&DSozRszRs,,Ig+8Ig+8o#Яo#Ё#Ր#Ր                                                                                                                                                                                                                                                                                                               %                  m;^	;^	uKuK!e:!e:pTpTw+Ǉw+Ǉ:)	:)	C^C^tdtdTT~[~[4?k4?k^ϤC^ϤC&e&e=+z=+zGGݕ`Q{`Q{0f0fᖘ,ᖘ,輶᱌輶᱌ҘҘs#Ts#TTTMxMxg0Dg0DN
KN
KlCElCE.	ޜ.	ޜܖiuܖiu6%-6%-ʫʫ22)S)S~~                                                                                                                                                                                                                                                                                                               %                  }Mx09Mx09zqPnzqPnVÿ`DVÿ`D"M`"M`3ft3ftIIYvsYvsMoҊ3MoҊ3uZuZkqkq^aС^anunuQg׌Qg׌==Z|] Z|] DƹDƹhl4hl47979x+x+**Is2<Is2<TZ\TZ\==7	7	'''ӑ>'ӑ>aalElELzOLzO^,=^,=F6F6aGaGc/c/UU                                                                                                                                                                                                                                                                                                               %                  88!߷!߷,,l]l]?Z?Z

<<eeYKlYKlRRȳ̰ȳ  @@99  ղFղF,/;,/;ӴӴ䚓䚓Dƭ]Dƭ]JJע1?ˢ1?˟VğVhhҕҕnJnJ! ! ٞZoZo׸׸AIAI'Ƽ0'Ƽ0PϫPϫییk"z k"z `@`@                                                                                                                                                                                                                                                                                                               %                  yyϺϺ??sߩsߩ%pz%pz1iJJ1iJJHHޖJޖJ"p"p͉J͉JZyTZyT-B8-B8,܅m,܅mrrs s ύ|ˈI|ˈI:6Q:6QL[L[VVDB:DB:5ɯ5ɯ<<ҧɽNQɽNQ
}5
}5LnbLnbH 1H 1M됵M됵B3զcB3զchʒhʒeCeCf膞lf膞l4Hj4Hj5Æ~5Æ~]]  {rW{rWAesAes                                                                                                                                                                                                                                                                                                               %                  뮺j
j
,6,6%_@%_@7Ѡ7ѠŜײŜײ͵̢6͵̢6
̰
̰,˱,˱l4l4QQtäYtäYdj
dj
sA̗sA̗YY5Hk5Hk/G/G""?'?'Мͼѯ<ͼѯ<E\E\aq|҅aq|҅⯳˄⯳euOeuOU|uuU|uu=3=35z5z*M*MƠbƠbvdZvdZơơ8!8!/BX/BX5Ӕ5Ӕ                                                                                                                                                                                                                                                                                                               %                  e:e:T4;T4;l/ߢl/ߢնA9iA9iw+w+pn$pn$rۢrۢUU䧽:͜䧽:͜_d_dMMbDrbDrssg?g?Z켊nZ켊nlPlP.s.s3A<3A<DlՆDlՆ99v[v[bZCbZC`θ`θm[Ģm[Ģ%%@f@f)y,8ߺ)y,8܄܄)o)o޴5ѭ޴5ѭƱƱڔڔWE1WE177                                                                                                                                                                                                                                                                                                               %                  <<.g.gv	v	ڬ{04Ѥ{04sۼFsۼF;گ>;گ>d(Jd(J$V$V;.;.璄4r4r$${&{&ԈԈ,/κ,/κc c ӤfӤfKS[KS[٫y2٫y2Ħ<Ħ<1Ňt1ŇtXVXV߷ֈco߷ֈco8+8+LwK߂LwK߂"*"*/O`/O`՚՚XuyXuy))XXZ!s/JZ!s/JꜵF17F17Y(EQY(EQ^^                                                                                                                                                                                                                                                                                                               %                  }}))c삏c삏8?:?8?:?[[s13s13'[|'[|xx*$Fj*$Fj]YZ.]YZ.ۀۀbA[bA[ΰ_Aΰ_A'
p'
p'a'aMϵMϵqqY5Y5DPDP~n`~n`j0{=j0{=--
ͅG
ͅG@@CꚂ*CꚂ*QvQvZdZdۇVaBۇVaB>QE>QE{Ewҥ{Ewҥ,,ҁ9j9jhhEEpΥp                                                                                                                                                                                                                                                                                                               %                  ǧ	Cǧ	Crr..;
s;
sht>ht>!l!l˭N˭N950ި950ިhXphhXph4@4@ƤƤ7Vݛ7Vݛ
l
l藩藩߃߃|G͕|G͕**TS"TS"II__@
th@
th}}9~	9~	?_?_88q$q$G1G1UVUV00SBsSBsIsܼIsܼooVVNN                                                                                                                                                                                                                                                                                                              
