use Test::More tests => 20000;
use Unicode::SetAutomaton;
use strict;
use warnings;
use Set::IntSpan;
use Encode;

# Unicode 5.1.0 gc = Ll
my $set = Set::IntSpan->new([
[0x000061, 0x00007a],
[0x0000aa, 0x0000aa],
[0x0000b5, 0x0000b5],
[0x0000ba, 0x0000ba],
[0x0000df, 0x0000f6],
[0x0000f8, 0x0000ff],
[0x000101, 0x000101],
[0x000103, 0x000103],
[0x000105, 0x000105],
[0x000107, 0x000107],
[0x000109, 0x000109],
[0x00010b, 0x00010b],
[0x00010d, 0x00010d],
[0x00010f, 0x00010f],
[0x000111, 0x000111],
[0x000113, 0x000113],
[0x000115, 0x000115],
[0x000117, 0x000117],
[0x000119, 0x000119],
[0x00011b, 0x00011b],
[0x00011d, 0x00011d],
[0x00011f, 0x00011f],
[0x000121, 0x000121],
[0x000123, 0x000123],
[0x000125, 0x000125],
[0x000127, 0x000127],
[0x000129, 0x000129],
[0x00012b, 0x00012b],
[0x00012d, 0x00012d],
[0x00012f, 0x00012f],
[0x000131, 0x000131],
[0x000133, 0x000133],
[0x000135, 0x000135],
[0x000137, 0x000138],
[0x00013a, 0x00013a],
[0x00013c, 0x00013c],
[0x00013e, 0x00013e],
[0x000140, 0x000140],
[0x000142, 0x000142],
[0x000144, 0x000144],
[0x000146, 0x000146],
[0x000148, 0x000149],
[0x00014b, 0x00014b],
[0x00014d, 0x00014d],
[0x00014f, 0x00014f],
[0x000151, 0x000151],
[0x000153, 0x000153],
[0x000155, 0x000155],
[0x000157, 0x000157],
[0x000159, 0x000159],
[0x00015b, 0x00015b],
[0x00015d, 0x00015d],
[0x00015f, 0x00015f],
[0x000161, 0x000161],
[0x000163, 0x000163],
[0x000165, 0x000165],
[0x000167, 0x000167],
[0x000169, 0x000169],
[0x00016b, 0x00016b],
[0x00016d, 0x00016d],
[0x00016f, 0x00016f],
[0x000171, 0x000171],
[0x000173, 0x000173],
[0x000175, 0x000175],
[0x000177, 0x000177],
[0x00017a, 0x00017a],
[0x00017c, 0x00017c],
[0x00017e, 0x000180],
[0x000183, 0x000183],
[0x000185, 0x000185],
[0x000188, 0x000188],
[0x00018c, 0x00018d],
[0x000192, 0x000192],
[0x000195, 0x000195],
[0x000199, 0x00019b],
[0x00019e, 0x00019e],
[0x0001a1, 0x0001a1],
[0x0001a3, 0x0001a3],
[0x0001a5, 0x0001a5],
[0x0001a8, 0x0001a8],
[0x0001aa, 0x0001ab],
[0x0001ad, 0x0001ad],
[0x0001b0, 0x0001b0],
[0x0001b4, 0x0001b4],
[0x0001b6, 0x0001b6],
[0x0001b9, 0x0001ba],
[0x0001bd, 0x0001bf],
[0x0001c6, 0x0001c6],
[0x0001c9, 0x0001c9],
[0x0001cc, 0x0001cc],
[0x0001ce, 0x0001ce],
[0x0001d0, 0x0001d0],
[0x0001d2, 0x0001d2],
[0x0001d4, 0x0001d4],
[0x0001d6, 0x0001d6],
[0x0001d8, 0x0001d8],
[0x0001da, 0x0001da],
[0x0001dc, 0x0001dd],
[0x0001df, 0x0001df],
[0x0001e1, 0x0001e1],
[0x0001e3, 0x0001e3],
[0x0001e5, 0x0001e5],
[0x0001e7, 0x0001e7],
[0x0001e9, 0x0001e9],
[0x0001eb, 0x0001eb],
[0x0001ed, 0x0001ed],
[0x0001ef, 0x0001f0],
[0x0001f3, 0x0001f3],
[0x0001f5, 0x0001f5],
[0x0001f9, 0x0001f9],
[0x0001fb, 0x0001fb],
[0x0001fd, 0x0001fd],
[0x0001ff, 0x0001ff],
[0x000201, 0x000201],
[0x000203, 0x000203],
[0x000205, 0x000205],
[0x000207, 0x000207],
[0x000209, 0x000209],
[0x00020b, 0x00020b],
[0x00020d, 0x00020d],
[0x00020f, 0x00020f],
[0x000211, 0x000211],
[0x000213, 0x000213],
[0x000215, 0x000215],
[0x000217, 0x000217],
[0x000219, 0x000219],
[0x00021b, 0x00021b],
[0x00021d, 0x00021d],
[0x00021f, 0x00021f],
[0x000221, 0x000221],
[0x000223, 0x000223],
[0x000225, 0x000225],
[0x000227, 0x000227],
[0x000229, 0x000229],
[0x00022b, 0x00022b],
[0x00022d, 0x00022d],
[0x00022f, 0x00022f],
[0x000231, 0x000231],
[0x000233, 0x000239],
[0x00023c, 0x00023c],
[0x00023f, 0x000240],
[0x000242, 0x000242],
[0x000247, 0x000247],
[0x000249, 0x000249],
[0x00024b, 0x00024b],
[0x00024d, 0x00024d],
[0x00024f, 0x000293],
[0x000295, 0x0002af],
[0x000371, 0x000371],
[0x000373, 0x000373],
[0x000377, 0x000377],
[0x00037b, 0x00037d],
[0x000390, 0x000390],
[0x0003ac, 0x0003ce],
[0x0003d0, 0x0003d1],
[0x0003d5, 0x0003d7],
[0x0003d9, 0x0003d9],
[0x0003db, 0x0003db],
[0x0003dd, 0x0003dd],
[0x0003df, 0x0003df],
[0x0003e1, 0x0003e1],
[0x0003e3, 0x0003e3],
[0x0003e5, 0x0003e5],
[0x0003e7, 0x0003e7],
[0x0003e9, 0x0003e9],
[0x0003eb, 0x0003eb],
[0x0003ed, 0x0003ed],
[0x0003ef, 0x0003f3],
[0x0003f5, 0x0003f5],
[0x0003f8, 0x0003f8],
[0x0003fb, 0x0003fc],
[0x000430, 0x00045f],
[0x000461, 0x000461],
[0x000463, 0x000463],
[0x000465, 0x000465],
[0x000467, 0x000467],
[0x000469, 0x000469],
[0x00046b, 0x00046b],
[0x00046d, 0x00046d],
[0x00046f, 0x00046f],
[0x000471, 0x000471],
[0x000473, 0x000473],
[0x000475, 0x000475],
[0x000477, 0x000477],
[0x000479, 0x000479],
[0x00047b, 0x00047b],
[0x00047d, 0x00047d],
[0x00047f, 0x00047f],
[0x000481, 0x000481],
[0x00048b, 0x00048b],
[0x00048d, 0x00048d],
[0x00048f, 0x00048f],
[0x000491, 0x000491],
[0x000493, 0x000493],
[0x000495, 0x000495],
[0x000497, 0x000497],
[0x000499, 0x000499],
[0x00049b, 0x00049b],
[0x00049d, 0x00049d],
[0x00049f, 0x00049f],
[0x0004a1, 0x0004a1],
[0x0004a3, 0x0004a3],
[0x0004a5, 0x0004a5],
[0x0004a7, 0x0004a7],
[0x0004a9, 0x0004a9],
[0x0004ab, 0x0004ab],
[0x0004ad, 0x0004ad],
[0x0004af, 0x0004af],
[0x0004b1, 0x0004b1],
[0x0004b3, 0x0004b3],
[0x0004b5, 0x0004b5],
[0x0004b7, 0x0004b7],
[0x0004b9, 0x0004b9],
[0x0004bb, 0x0004bb],
[0x0004bd, 0x0004bd],
[0x0004bf, 0x0004bf],
[0x0004c2, 0x0004c2],
[0x0004c4, 0x0004c4],
[0x0004c6, 0x0004c6],
[0x0004c8, 0x0004c8],
[0x0004ca, 0x0004ca],
[0x0004cc, 0x0004cc],
[0x0004ce, 0x0004cf],
[0x0004d1, 0x0004d1],
[0x0004d3, 0x0004d3],
[0x0004d5, 0x0004d5],
[0x0004d7, 0x0004d7],
[0x0004d9, 0x0004d9],
[0x0004db, 0x0004db],
[0x0004dd, 0x0004dd],
[0x0004df, 0x0004df],
[0x0004e1, 0x0004e1],
[0x0004e3, 0x0004e3],
[0x0004e5, 0x0004e5],
[0x0004e7, 0x0004e7],
[0x0004e9, 0x0004e9],
[0x0004eb, 0x0004eb],
[0x0004ed, 0x0004ed],
[0x0004ef, 0x0004ef],
[0x0004f1, 0x0004f1],
[0x0004f3, 0x0004f3],
[0x0004f5, 0x0004f5],
[0x0004f7, 0x0004f7],
[0x0004f9, 0x0004f9],
[0x0004fb, 0x0004fb],
[0x0004fd, 0x0004fd],
[0x0004ff, 0x0004ff],
[0x000501, 0x000501],
[0x000503, 0x000503],
[0x000505, 0x000505],
[0x000507, 0x000507],
[0x000509, 0x000509],
[0x00050b, 0x00050b],
[0x00050d, 0x00050d],
[0x00050f, 0x00050f],
[0x000511, 0x000511],
[0x000513, 0x000513],
[0x000515, 0x000515],
[0x000517, 0x000517],
[0x000519, 0x000519],
[0x00051b, 0x00051b],
[0x00051d, 0x00051d],
[0x00051f, 0x00051f],
[0x000521, 0x000521],
[0x000523, 0x000523],
[0x000561, 0x000587],
[0x001d00, 0x001d2b],
[0x001d62, 0x001d77],
[0x001d79, 0x001d9a],
[0x001e01, 0x001e01],
[0x001e03, 0x001e03],
[0x001e05, 0x001e05],
[0x001e07, 0x001e07],
[0x001e09, 0x001e09],
[0x001e0b, 0x001e0b],
[0x001e0d, 0x001e0d],
[0x001e0f, 0x001e0f],
[0x001e11, 0x001e11],
[0x001e13, 0x001e13],
[0x001e15, 0x001e15],
[0x001e17, 0x001e17],
[0x001e19, 0x001e19],
[0x001e1b, 0x001e1b],
[0x001e1d, 0x001e1d],
[0x001e1f, 0x001e1f],
[0x001e21, 0x001e21],
[0x001e23, 0x001e23],
[0x001e25, 0x001e25],
[0x001e27, 0x001e27],
[0x001e29, 0x001e29],
[0x001e2b, 0x001e2b],
[0x001e2d, 0x001e2d],
[0x001e2f, 0x001e2f],
[0x001e31, 0x001e31],
[0x001e33, 0x001e33],
[0x001e35, 0x001e35],
[0x001e37, 0x001e37],
[0x001e39, 0x001e39],
[0x001e3b, 0x001e3b],
[0x001e3d, 0x001e3d],
[0x001e3f, 0x001e3f],
[0x001e41, 0x001e41],
[0x001e43, 0x001e43],
[0x001e45, 0x001e45],
[0x001e47, 0x001e47],
[0x001e49, 0x001e49],
[0x001e4b, 0x001e4b],
[0x001e4d, 0x001e4d],
[0x001e4f, 0x001e4f],
[0x001e51, 0x001e51],
[0x001e53, 0x001e53],
[0x001e55, 0x001e55],
[0x001e57, 0x001e57],
[0x001e59, 0x001e59],
[0x001e5b, 0x001e5b],
[0x001e5d, 0x001e5d],
[0x001e5f, 0x001e5f],
[0x001e61, 0x001e61],
[0x001e63, 0x001e63],
[0x001e65, 0x001e65],
[0x001e67, 0x001e67],
[0x001e69, 0x001e69],
[0x001e6b, 0x001e6b],
[0x001e6d, 0x001e6d],
[0x001e6f, 0x001e6f],
[0x001e71, 0x001e71],
[0x001e73, 0x001e73],
[0x001e75, 0x001e75],
[0x001e77, 0x001e77],
[0x001e79, 0x001e79],
[0x001e7b, 0x001e7b],
[0x001e7d, 0x001e7d],
[0x001e7f, 0x001e7f],
[0x001e81, 0x001e81],
[0x001e83, 0x001e83],
[0x001e85, 0x001e85],
[0x001e87, 0x001e87],
[0x001e89, 0x001e89],
[0x001e8b, 0x001e8b],
[0x001e8d, 0x001e8d],
[0x001e8f, 0x001e8f],
[0x001e91, 0x001e91],
[0x001e93, 0x001e93],
[0x001e95, 0x001e9d],
[0x001e9f, 0x001e9f],
[0x001ea1, 0x001ea1],
[0x001ea3, 0x001ea3],
[0x001ea5, 0x001ea5],
[0x001ea7, 0x001ea7],
[0x001ea9, 0x001ea9],
[0x001eab, 0x001eab],
[0x001ead, 0x001ead],
[0x001eaf, 0x001eaf],
[0x001eb1, 0x001eb1],
[0x001eb3, 0x001eb3],
[0x001eb5, 0x001eb5],
[0x001eb7, 0x001eb7],
[0x001eb9, 0x001eb9],
[0x001ebb, 0x001ebb],
[0x001ebd, 0x001ebd],
[0x001ebf, 0x001ebf],
[0x001ec1, 0x001ec1],
[0x001ec3, 0x001ec3],
[0x001ec5, 0x001ec5],
[0x001ec7, 0x001ec7],
[0x001ec9, 0x001ec9],
[0x001ecb, 0x001ecb],
[0x001ecd, 0x001ecd],
[0x001ecf, 0x001ecf],
[0x001ed1, 0x001ed1],
[0x001ed3, 0x001ed3],
[0x001ed5, 0x001ed5],
[0x001ed7, 0x001ed7],
[0x001ed9, 0x001ed9],
[0x001edb, 0x001edb],
[0x001edd, 0x001edd],
[0x001edf, 0x001edf],
[0x001ee1, 0x001ee1],
[0x001ee3, 0x001ee3],
[0x001ee5, 0x001ee5],
[0x001ee7, 0x001ee7],
[0x001ee9, 0x001ee9],
[0x001eeb, 0x001eeb],
[0x001eed, 0x001eed],
[0x001eef, 0x001eef],
[0x001ef1, 0x001ef1],
[0x001ef3, 0x001ef3],
[0x001ef5, 0x001ef5],
[0x001ef7, 0x001ef7],
[0x001ef9, 0x001ef9],
[0x001efb, 0x001efb],
[0x001efd, 0x001efd],
[0x001eff, 0x001f07],
[0x001f10, 0x001f15],
[0x001f20, 0x001f27],
[0x001f30, 0x001f37],
[0x001f40, 0x001f45],
[0x001f50, 0x001f57],
[0x001f60, 0x001f67],
[0x001f70, 0x001f7d],
[0x001f80, 0x001f87],
[0x001f90, 0x001f97],
[0x001fa0, 0x001fa7],
[0x001fb0, 0x001fb4],
[0x001fb6, 0x001fb7],
[0x001fbe, 0x001fbe],
[0x001fc2, 0x001fc4],
[0x001fc6, 0x001fc7],
[0x001fd0, 0x001fd3],
[0x001fd6, 0x001fd7],
[0x001fe0, 0x001fe7],
[0x001ff2, 0x001ff4],
[0x001ff6, 0x001ff7],
[0x002071, 0x002071],
[0x00207f, 0x00207f],
[0x00210a, 0x00210a],
[0x00210e, 0x00210f],
[0x002113, 0x002113],
[0x00212f, 0x00212f],
[0x002134, 0x002134],
[0x002139, 0x002139],
[0x00213c, 0x00213d],
[0x002146, 0x002149],
[0x00214e, 0x00214e],
[0x002184, 0x002184],
[0x002c30, 0x002c5e],
[0x002c61, 0x002c61],
[0x002c65, 0x002c66],
[0x002c68, 0x002c68],
[0x002c6a, 0x002c6a],
[0x002c6c, 0x002c6c],
[0x002c71, 0x002c71],
[0x002c73, 0x002c74],
[0x002c76, 0x002c7c],
[0x002c81, 0x002c81],
[0x002c83, 0x002c83],
[0x002c85, 0x002c85],
[0x002c87, 0x002c87],
[0x002c89, 0x002c89],
[0x002c8b, 0x002c8b],
[0x002c8d, 0x002c8d],
[0x002c8f, 0x002c8f],
[0x002c91, 0x002c91],
[0x002c93, 0x002c93],
[0x002c95, 0x002c95],
[0x002c97, 0x002c97],
[0x002c99, 0x002c99],
[0x002c9b, 0x002c9b],
[0x002c9d, 0x002c9d],
[0x002c9f, 0x002c9f],
[0x002ca1, 0x002ca1],
[0x002ca3, 0x002ca3],
[0x002ca5, 0x002ca5],
[0x002ca7, 0x002ca7],
[0x002ca9, 0x002ca9],
[0x002cab, 0x002cab],
[0x002cad, 0x002cad],
[0x002caf, 0x002caf],
[0x002cb1, 0x002cb1],
[0x002cb3, 0x002cb3],
[0x002cb5, 0x002cb5],
[0x002cb7, 0x002cb7],
[0x002cb9, 0x002cb9],
[0x002cbb, 0x002cbb],
[0x002cbd, 0x002cbd],
[0x002cbf, 0x002cbf],
[0x002cc1, 0x002cc1],
[0x002cc3, 0x002cc3],
[0x002cc5, 0x002cc5],
[0x002cc7, 0x002cc7],
[0x002cc9, 0x002cc9],
[0x002ccb, 0x002ccb],
[0x002ccd, 0x002ccd],
[0x002ccf, 0x002ccf],
[0x002cd1, 0x002cd1],
[0x002cd3, 0x002cd3],
[0x002cd5, 0x002cd5],
[0x002cd7, 0x002cd7],
[0x002cd9, 0x002cd9],
[0x002cdb, 0x002cdb],
[0x002cdd, 0x002cdd],
[0x002cdf, 0x002cdf],
[0x002ce1, 0x002ce1],
[0x002ce3, 0x002ce4],
[0x002d00, 0x002d25],
[0x00a641, 0x00a641],
[0x00a643, 0x00a643],
[0x00a645, 0x00a645],
[0x00a647, 0x00a647],
[0x00a649, 0x00a649],
[0x00a64b, 0x00a64b],
[0x00a64d, 0x00a64d],
[0x00a64f, 0x00a64f],
[0x00a651, 0x00a651],
[0x00a653, 0x00a653],
[0x00a655, 0x00a655],
[0x00a657, 0x00a657],
[0x00a659, 0x00a659],
[0x00a65b, 0x00a65b],
[0x00a65d, 0x00a65d],
[0x00a65f, 0x00a65f],
[0x00a663, 0x00a663],
[0x00a665, 0x00a665],
[0x00a667, 0x00a667],
[0x00a669, 0x00a669],
[0x00a66b, 0x00a66b],
[0x00a66d, 0x00a66d],
[0x00a681, 0x00a681],
[0x00a683, 0x00a683],
[0x00a685, 0x00a685],
[0x00a687, 0x00a687],
[0x00a689, 0x00a689],
[0x00a68b, 0x00a68b],
[0x00a68d, 0x00a68d],
[0x00a68f, 0x00a68f],
[0x00a691, 0x00a691],
[0x00a693, 0x00a693],
[0x00a695, 0x00a695],
[0x00a697, 0x00a697],
[0x00a723, 0x00a723],
[0x00a725, 0x00a725],
[0x00a727, 0x00a727],
[0x00a729, 0x00a729],
[0x00a72b, 0x00a72b],
[0x00a72d, 0x00a72d],
[0x00a72f, 0x00a731],
[0x00a733, 0x00a733],
[0x00a735, 0x00a735],
[0x00a737, 0x00a737],
[0x00a739, 0x00a739],
[0x00a73b, 0x00a73b],
[0x00a73d, 0x00a73d],
[0x00a73f, 0x00a73f],
[0x00a741, 0x00a741],
[0x00a743, 0x00a743],
[0x00a745, 0x00a745],
[0x00a747, 0x00a747],
[0x00a749, 0x00a749],
[0x00a74b, 0x00a74b],
[0x00a74d, 0x00a74d],
[0x00a74f, 0x00a74f],
[0x00a751, 0x00a751],
[0x00a753, 0x00a753],
[0x00a755, 0x00a755],
[0x00a757, 0x00a757],
[0x00a759, 0x00a759],
[0x00a75b, 0x00a75b],
[0x00a75d, 0x00a75d],
[0x00a75f, 0x00a75f],
[0x00a761, 0x00a761],
[0x00a763, 0x00a763],
[0x00a765, 0x00a765],
[0x00a767, 0x00a767],
[0x00a769, 0x00a769],
[0x00a76b, 0x00a76b],
[0x00a76d, 0x00a76d],
[0x00a76f, 0x00a76f],
[0x00a771, 0x00a778],
[0x00a77a, 0x00a77a],
[0x00a77c, 0x00a77c],
[0x00a77f, 0x00a77f],
[0x00a781, 0x00a781],
[0x00a783, 0x00a783],
[0x00a785, 0x00a785],
[0x00a787, 0x00a787],
[0x00a78c, 0x00a78c],
[0x00fb00, 0x00fb06],
[0x00fb13, 0x00fb17],
[0x00ff41, 0x00ff5a],
[0x010428, 0x01044f],
[0x01d41a, 0x01d433],
[0x01d44e, 0x01d454],
[0x01d456, 0x01d467],
[0x01d482, 0x01d49b],
[0x01d4b6, 0x01d4b9],
[0x01d4bb, 0x01d4bb],
[0x01d4bd, 0x01d4c3],
[0x01d4c5, 0x01d4cf],
[0x01d4ea, 0x01d503],
[0x01d51e, 0x01d537],
[0x01d552, 0x01d56b],
[0x01d586, 0x01d59f],
[0x01d5ba, 0x01d5d3],
[0x01d5ee, 0x01d607],
[0x01d622, 0x01d63b],
[0x01d656, 0x01d66f],
[0x01d68a, 0x01d6a5],
[0x01d6c2, 0x01d6da],
[0x01d6dc, 0x01d6e1],
[0x01d6fc, 0x01d714],
[0x01d716, 0x01d71b],
[0x01d736, 0x01d74e],
[0x01d750, 0x01d755],
[0x01d770, 0x01d788],
[0x01d78a, 0x01d78f],
[0x01d7aa, 0x01d7c2],
[0x01d7c4, 0x01d7c9],
[0x01d7cb, 0x01d7cb],
]);

my @in;

foreach my $span ($set->spans) {
  $in[$_] = 1 for $span->[0] .. $span->[1];
}

my $dfa = Unicode::SetAutomaton->new(classes => [$set]);
my ($r) = $dfa->as_expressions;
my $reg = qr/$r/;

my @rand;

while ($#rand < (20000 - 1)) {
  my $cp = int(rand(0x10FFFF + 1));
  next unless $cp >= 0xe000 or $cp < 0xd800;
  push @rand, $cp;
}

no warnings 'utf8';

foreach my $cp (@rand) {
  my $packed = pack "U", $cp;
  my $encoded = encode_utf8 $packed;
  my $result = $encoded =~ $reg;
  is(!$result, !$in[$cp], "CP $cp")
}
