
BEGIN {
  unless ($ENV{AUTHOR_TESTING}) {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit
  }
}

use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::NoTabs 0.15

use Test::More 0.88;
use Test::NoTabs;

my @files = (
    'bin/rfxcom-rx',
    'bin/rfxcom-tx',
    'bin/w800-rx',
    'lib/Device/RFXCOM.pod',
    'lib/Device/RFXCOM/Base.pm',
    'lib/Device/RFXCOM/Decoder.pm',
    'lib/Device/RFXCOM/Decoder/CM119.pm',
    'lib/Device/RFXCOM/Decoder/Digimax.pm',
    'lib/Device/RFXCOM/Decoder/Electrisave.pm',
    'lib/Device/RFXCOM/Decoder/HomeEasy.pm',
    'lib/Device/RFXCOM/Decoder/Oregon.pm',
    'lib/Device/RFXCOM/Decoder/OregonScale.pm',
    'lib/Device/RFXCOM/Decoder/RFXMeter.pm',
    'lib/Device/RFXCOM/Decoder/RFXSensor.pm',
    'lib/Device/RFXCOM/Decoder/Visonic.pm',
    'lib/Device/RFXCOM/Decoder/X10.pm',
    'lib/Device/RFXCOM/Decoder/X10Security.pm',
    'lib/Device/RFXCOM/Encoder.pm',
    'lib/Device/RFXCOM/Encoder/HomeEasy.pm',
    'lib/Device/RFXCOM/Encoder/X10.pm',
    'lib/Device/RFXCOM/RX.pm',
    'lib/Device/RFXCOM/Response.pm',
    'lib/Device/RFXCOM/Response/DateTime.pm',
    'lib/Device/RFXCOM/Response/HomeEasy.pm',
    'lib/Device/RFXCOM/Response/Security.pm',
    'lib/Device/RFXCOM/Response/Sensor.pm',
    'lib/Device/RFXCOM/Response/Thermostat.pm',
    'lib/Device/RFXCOM/Response/X10.pm',
    'lib/Device/RFXCOM/TX.pm',
    'lib/Device/W800.pm',
    't/01-rx.t',
    't/01-tx.t',
    't/02-checksum-tester.t',
    't/03-messages.t',
    't/04-w800.t',
    't/05-serial.t',
    't/Helpers.pm',
    't/author-critic.t',
    't/author-eol.t',
    't/author-no-tabs.t',
    't/author-pod-coverage.t',
    't/author-pod-no404s.t',
    't/author-pod-syntax.t',
    't/author-synopsis.t',
    't/lib/Device/SerialPort.pm',
    't/make-test',
    't/release-common_spelling.t',
    't/release-kwalitee.t',
    't/release-pod-linkcheck.t',
    't/rf/digimax-01-satisfied.txt',
    't/rf/digimax-02-call-for-heat.txt',
    't/rf/digimax-03-call-for-cooling.txt',
    't/rf/digimax-04-first-parity-error.txt',
    't/rf/digimax-05-second-parity-error.txt',
    't/rf/electrisave-01.txt',
    't/rf/electrisave-02-invalid-byte1.txt',
    't/rf/electrisave-03-invalid-byte9.txt',
    't/rf/electrisave-04-invalid-byte10.txt',
    't/rf/electrisave-05-low-battery.txt',
    't/rf/homeeasy-01-off.txt',
    't/rf/homeeasy-02-group-on.txt',
    't/rf/homeeasy-03-group-on-dup.txt',
    't/rf/homeeasy-04-preset.txt',
    't/rf/oregon-bthr918-01-bad-forecast.txt',
    't/rf/oregon-bthr918-01.txt',
    't/rf/oregon-bwr102-01.txt',
    't/rf/oregon-bwr102-02-invalid.txt',
    't/rf/oregon-bwr102-03-invalid.txt',
    't/rf/oregon-bwr102-04-invalid.txt',
    't/rf/oregon-device-test-01.txt',
    't/rf/oregon-gr101-01.txt',
    't/rf/oregon-gr101-02-invalid.txt',
    't/rf/oregon-pcr800-01.txt',
    't/rf/oregon-rgr918-01.txt',
    't/rf/oregon-rtgr328n-01-temphydro.txt',
    't/rf/oregon-rtgr328n-02-datetime.txt',
    't/rf/oregon-rtgr328n-03-invalid-checksum.txt',
    't/rf/oregon-rtgr328n-04-invalid-checksum-dt.txt',
    't/rf/oregon-rtgr328n-05-negativetemp.txt',
    't/rf/oregon-rtgr328n-06-low-battery.txt',
    't/rf/oregon-thgr228n-01-temphydro.txt',
    't/rf/oregon-thgr810-01.txt',
    't/rf/oregon-thr128-01-temp.txt',
    't/rf/oregon-thwr800-01.txt',
    't/rf/oregon-uv138-01.txt',
    't/rf/oregon-uv138-02-invalid-checksum.txt',
    't/rf/oregon-uv138-03-dangerous.txt',
    't/rf/oregon-uvn800-01.txt',
    't/rf/oregon-wgr918-01-wind.txt',
    't/rf/oregon-wtgr800-01-wind.txt',
    't/rf/oregon-wtgr800-02-temphydro.txt',
    't/rf/oregon-wtgr800-03-low-battery.txt',
    't/rf/owl-cm119-01.txt',
    't/rf/owl-cm119-02-unexpected-channel.txt',
    't/rf/owl-cm119-03-invalid.txt',
    't/rf/owl-cm119-04-non-cm119.txt',
    't/rf/owl-cm119-05-zero-channel.txt',
    't/rf/rfxmeter-01.txt',
    't/rf/rfxmeter-02-parity-error.txt',
    't/rf/rfxmeter-03-unsupported.txt',
    't/rf/rfxmeter-04-invalid.txt',
    't/rf/rfxsensor-01-humidity.txt',
    't/rf/rfxsensor-02-voltage.txt',
    't/rf/rfxsensor-03-humidity.txt',
    't/rf/rfxsensor-04-temp.txt',
    't/rf/rfxsensor-05-humidity.txt',
    't/rf/rfxsensor-06-unsupported-type.txt',
    't/rf/rfxsensor-07-low-battery.txt',
    't/rf/rfxsensor-08-error.txt',
    't/rf/rfxsensor-09-unknown-status.txt',
    't/rf/rfxsensor-10-negative-temp.txt',
    't/rf/rfxsensor-11-init.txt',
    't/rf/rfxsensor-12-init-slow.txt',
    't/rf/rfxsensor-13-sensor-info.txt',
    't/rf/rfxsensor-14-sensor-unknown.txt',
    't/rf/rfxsensor-15-sensor-bad-len.txt',
    't/rf/rfxsensor-16-bad-checksum.txt',
    't/rf/unknown-01-very-short.txt',
    't/rf/visonic-01-codesecure.txt',
    't/rf/visonic-02-powercode.txt',
    't/rf/visonic-03-powercode-secondary.txt',
    't/rf/visonic-04-powercode-parity-error.txt',
    't/rf/visonic-05-codesecure-invalid.txt',
    't/rf/visonic-06-codesecure-flags.txt',
    't/rf/x10-01-a11-on.txt',
    't/rf/x10-02-a11-on-dup.txt',
    't/rf/x10-03-a11-on-no-dup.txt',
    't/rf/x10-04-a11-off.txt',
    't/rf/x10-05-a11-bright.txt',
    't/rf/x10-06-a11-dim.txt',
    't/rf/x10-07-a-dim-no-unitcode.txt',
    't/rf/x10-08-non-x10.txt',
    't/rf/x10sec-01.txt',
    't/rf/x10sec-02-alert-tamper-min.txt',
    't/rf/x10sec-03-lowbat.txt',
    't/rf/x10sec-04-kr21-arm-away.txt',
    't/rf/x10sec-05-kr21-lights-on.txt',
    't/rf/x10sec-06-unsupported.txt',
    't/rf/x10sec-08-second-parity-error.txt'
);

notabs_ok($_) foreach @files;
done_testing;
