use 5.16.0;
use warnings 'all';

BEGIN {
    our $tests = 14;

    # chdir to t/
    $_ = $0;
    s~[^/\\]+$~~;
    chdir $_ if length;

    require './test.pm';
}


# Simple
pl_e 'Not Template Toolkit', 'Template q!Not [% x %][% a ?| q#havea# %][% b ?: $_ = q#haveb# %]!, x => "Template Toolkit"';


# Countertest
$_ = '[% no % ] {{markup} } <?pl_here ?> <?pl or there ? >';
pl '-o', 'Template', $_;


# Inject template string into pl without having huge commands.
{
    open my $fh, '<', 'pl.template';
    $ENV{pl_template} = slurp $fh;
}

$_ = q{pre<aha><?pl post?>
[% pre %] <aha>
prespace<abABcdefg> prespace 3 post

pre<12AB345fg><ABABCDEFG> midnospace
pre<12AB345fg> Ababcdefg midspace
pre<12AB345fg><ababcdefg> midnospace
};

pl '$_ = $ENV{pl_template}; %TEMPLATE = qw(a <aha> b <abABcdefg>); Template';
pl_e "$_\n", '$_ = $ENV{pl_template}; %TEMPLATE = qw(a <aha> b <abABcdefg>); template';
pl '%TEMPLATE = qw(a <aha> b <abABcdefg>); Template $ENV{pl_template}';
pl_e "$_\n", '%x = qw(a <aha> b <abABcdefg>); template $ENV{pl_template}, \%x';
pl 'Template $ENV{pl_template}, qw(a <aha> b <abABcdefg>)';

pl 'Template \"pl.template", qw(a <aha> b <abABcdefg>)';
# On Windows 3-arg open becomes ...\"<\", \"pl.template\" where < causes an error before pl starts???
pl 'open my $fh, "pl.template"; Template $fh, qw(a <aha> b <abABcdefg>)';


# Flow control
$ENV{pl_template} = q{<?pl x ! if( $_ lt 'b' ) {~?>
[% for %] <?pl~i ! for( my $i = 1; $i <= ($_ || 3); ++$i ) { ?> i <?pl | $i ?> <?pl~! } ?> endfor<?pl
list ! } elsif( $_ ) {~?>
foreach <?pl~list ! foreach( @$_ ) { ?> x {{<?pl:?>}} <?pl~! } ?> endforeach<?pl!~?>
<?pl x ! } else {~?> else <?pl :?><?pl!}?>};

$_ = q{[% for %] i 1 i 2 i 3 i 4 i 5 endfor};

pl 'Template $ENV{pl_template}, i => 5';
s/3\K.+5//;
pl 'Template $ENV{pl_template}';
pl_e 'foreach x {{a}} x {{b}} x {{c}} endforeach', 'Template $ENV{pl_template}, x => "c", list => [qw(a b c)]';
pl_e 'else c', 'Template $ENV{pl_template}, x => "c"';


# Nested templates
$_ = '1 2 3 4 5 6
 7
 8
 9
';
$_ .= tr/\n//dr;
pl '$_ = q{4 {{ z }} 6}; $t = q{1 <?pl x | ?> 9}; %T = (x => q{2 [% y| %] 8}, y => q{3 {{ | }} 7}, z => 5); t $t; T $t';

