#
# make sure v1 is hidden and same in threads.
#
use strict;
use warnings;
use Config;

BEGIN {
    unless ($Config{useithreads}) {
        print "1..0 # SKIP no ithreads\n";
        exit 0;
    }
}

use threads;
use threads::shared;
use Test::More;

use vars qw(@OPTS);

BEGIN {
    @OPTS = qw(:mac=unique);
    ok 1, 'began';
}

use UUID @OPTS;
ok 1, 'loaded';


my %seen = ();
share(%seen);

my $uu = UUID::uuid1();
ok 1, 'got something';
note $uu;

# 2d2281bc-b455-11ee-8325-5526d7fe9526
is substr($uu, 14, 1), '1', 'its v1';
is substr(unpack("B*", pack("H*", substr($uu, 19, 2))), 0, 2), '10', 'its dce';
is substr(unpack("B*", pack("H*", substr($uu, 24, 2))), 7, 1), '1', 'mcast set';

my $node = substr $uu, 24;
{ lock %seen; ++$seen{$node} }

# all same.
threads->create( \&doit, $_ )->join
    for 1..9;

sub doit {
    my ($i) = @_;
    ok 1, "thr $i";
    my $ut = UUID::uuid1();
    my $n  = substr $ut, 24;
    note $n;
    lock %seen;
    ok !exists($seen{$n}), "unique $i";
    ++$seen{$n};
}

done_testing;
