# Generated by default/object.tt
package Paws::Chime::ChannelModerator;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Paws::Chime::Identity');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has Moderator => (is => 'ro', isa => 'Paws::Chime::Identity');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelModerator

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelModerator object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Moderator => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelModerator object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The details of a channel moderator.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the moderator's channel.


=head2 CreatedBy => L<Paws::Chime::Identity>

The C<AppInstanceUser> who created the moderator.


=head2 CreatedTimestamp => Str

The time at which the moderator was created.


=head2 Moderator => L<Paws::Chime::Identity>

The moderator's data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

