/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Parser;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.SingleGuide;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;

public class DeterministicParser
extends Parser {
    private int parseCount;

    public DeterministicParser(DependencyParserConfig manager) throws MaltChainedException {
        super(manager);
        this.setManager(manager);
        this.initParserState(1);
        ((SingleMalt)manager).addRegistry(Algorithm.class, this);
        this.setGuide(new SingleGuide(manager, (GuideHistory)((Object)this.parserState.getHistory()), ClassifierGuide.GuideMode.CLASSIFY));
    }

    public DependencyStructure parse(DependencyStructure parseDependencyGraph) throws MaltChainedException {
        this.parserState.clear();
        this.parserState.initialize(parseDependencyGraph);
        this.currentParserConfiguration = this.parserState.getConfiguration();
        ++this.parseCount;
        if (this.diagnostics) {
            this.writeToDiaFile(this.parseCount + "");
        }
        while (!this.parserState.isTerminalState()) {
            GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
            if (action == null) {
                action = this.predict();
            } else if (this.diagnostics) {
                this.writeToDiaFile(" *");
            }
            if (this.diagnostics) {
                this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
            }
            this.parserState.apply(action);
        }
        this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        this.copyDynamicInput(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        parseDependencyGraph.linkAllTreesToRoot();
        if (this.diagnostics) {
            this.writeToDiaFile("\n");
        }
        return parseDependencyGraph;
    }

    private GuideUserAction predict() throws MaltChainedException {
        GuideUserAction currentAction = this.parserState.getHistory().getEmptyGuideUserAction();
        try {
            this.classifierGuide.predict((GuideDecision)((Object)currentAction));
            while (!this.parserState.permissible(currentAction)) {
                if (this.classifierGuide.predictFromKBestList((GuideDecision)((Object)currentAction))) continue;
                currentAction = this.getParserState().getTransitionSystem().defaultAction(this.parserState.getHistory(), this.currentParserConfiguration);
                break;
            }
        }
        catch (NullPointerException e) {
            throw new MaltChainedException("The guide cannot be found. ", e);
        }
        return currentAction;
    }

    public void terminate() throws MaltChainedException {
        if (this.diagnostics) {
            this.closeDiaWriter();
        }
    }
}

