/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.pdfread;

import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import java.util.List;

public class PDFPage
extends CompositeSegment<GenericSegment> {
    int rotation = 0;

    public PDFPage() {
    }

    public PDFPage(List<GenericSegment> items) {
        super(items);
    }

    public PDFPage(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
    }

    public PDFPage(float x1, float x2, float y1, float y2, List<GenericSegment> items) {
        super(x1, x2, y1, y2, items);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void reverseYCoordinatesPDF() {
        for (GenericSegment thisSegment : this.items) {
            float currentY1;
            if (thisSegment instanceof TextSegment) {
                currentY1 = thisSegment.getY1();
                float height = thisSegment.getHeight();
                float reversedY1 = super.getHeight() - currentY1;
                thisSegment.setY1(reversedY1);
                thisSegment.setY2(reversedY1 + height);
                continue;
            }
            currentY1 = thisSegment.getY1();
            float currentY2 = thisSegment.getY2();
            thisSegment.setY1(super.getHeight() - currentY2);
            thisSegment.setY2(super.getHeight() - currentY1);
        }
    }

    public void reverseYCoordinatesPNG() {
        for (GenericSegment thisSegment : this.items) {
            float currentY1 = thisSegment.getY1();
            float currentY2 = thisSegment.getY2();
            thisSegment.setY1(super.getHeight() - currentY2);
            thisSegment.setY2(super.getHeight() - currentY1);
        }
    }

    public void reverseXCoordinates() {
        for (GenericSegment thisSegment : this.items) {
            float currentX1 = thisSegment.getX1();
            float width = thisSegment.getWidth();
            float reversedX1 = super.getWidth() - currentX1;
            thisSegment.setX1(reversedX1);
            thisSegment.setX2(reversedX1 + width);
        }
    }

    public void normalizeCoordinates() {
        for (GenericSegment thisSegment : this.items) {
            thisSegment.setX1(thisSegment.getX1() - super.getX1());
            thisSegment.setX2(thisSegment.getX2() - super.getX1());
            thisSegment.setY1(thisSegment.getY1() - super.getY1());
            thisSegment.setY2(thisSegment.getY2() - super.getY1());
        }
        super.setX2(super.getX2() - super.getX1());
        super.setY2(super.getY2() - super.getY1());
        super.setX1(0.0f);
        super.setY1(0.0f);
    }
}

