#!/usr/bin/perl

package eBay::API::XML::DataType::StoreFontType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreFontType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreFontType

=head1 DESCRIPTION

Store font set.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreFontType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::StoreFontFaceCodeType;
use eBay::API::XML::DataType::Enum::StoreFontSizeCodeType;


my @gaProperties = ( [ 'DescColor', 'xs:string', '', '', '' ]
	, [ 'DescFace', 'ns:StoreFontFaceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontFaceCodeType', '' ]
	, [ 'DescSize', 'ns:StoreFontSizeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontSizeCodeType', '' ]
	, [ 'NameColor', 'xs:string', '', '', '' ]
	, [ 'NameFace', 'ns:StoreFontFaceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontFaceCodeType', '' ]
	, [ 'NameSize', 'ns:StoreFontSizeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontSizeCodeType', '' ]
	, [ 'TitleColor', 'xs:string', '', '', '' ]
	, [ 'TitleFace', 'ns:StoreFontFaceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontFaceCodeType', '' ]
	, [ 'TitleSize', 'ns:StoreFontSizeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreFontSizeCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDescColor()

Font color for the Store description. Specified in 6-digit Hex
format. For example: F6F6C9

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setDescColor {
  my $self = shift;
  $self->{'DescColor'} = shift
}

=head2 getDescColor()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getDescColor {
  my $self = shift;
  return $self->{'DescColor'};
}


=head2 setDescFace()

Font for the Store description.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontFaceCodeType'

=cut

sub setDescFace {
  my $self = shift;
  $self->{'DescFace'} = shift
}

=head2 getDescFace()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontFaceCodeType'

=cut

sub getDescFace {
  my $self = shift;
  return $self->{'DescFace'};
}


=head2 setDescSize()

Font size for the Store description.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontSizeCodeType'

=cut

sub setDescSize {
  my $self = shift;
  $self->{'DescSize'} = shift
}

=head2 getDescSize()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontSizeCodeType'

=cut

sub getDescSize {
  my $self = shift;
  return $self->{'DescSize'};
}


=head2 setNameColor()

Font color for the Store name. Specified in 6-digit Hex format.
For example: F6F6C9

MaxLength: 6

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setNameColor {
  my $self = shift;
  $self->{'NameColor'} = shift
}

=head2 getNameColor()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getNameColor {
  my $self = shift;
  return $self->{'NameColor'};
}


=head2 setNameFace()

Font for the Store name.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontFaceCodeType'

=cut

sub setNameFace {
  my $self = shift;
  $self->{'NameFace'} = shift
}

=head2 getNameFace()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontFaceCodeType'

=cut

sub getNameFace {
  my $self = shift;
  return $self->{'NameFace'};
}


=head2 setNameSize()

Font size for the Store name.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontSizeCodeType'

=cut

sub setNameSize {
  my $self = shift;
  $self->{'NameSize'} = shift
}

=head2 getNameSize()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontSizeCodeType'

=cut

sub getNameSize {
  my $self = shift;
  return $self->{'NameSize'};
}


=head2 setTitleColor()

Font color for the Store section title. Specified in 6-digit Hex
format. For example: F6F6C9

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setTitleColor {
  my $self = shift;
  $self->{'TitleColor'} = shift
}

=head2 getTitleColor()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTitleColor {
  my $self = shift;
  return $self->{'TitleColor'};
}


=head2 setTitleFace()

Font for the Store section title.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontFaceCodeType'

=cut

sub setTitleFace {
  my $self = shift;
  $self->{'TitleFace'} = shift
}

=head2 getTitleFace()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontFaceCodeType'

=cut

sub getTitleFace {
  my $self = shift;
  return $self->{'TitleFace'};
}


=head2 setTitleSize()

Font size for the Store section title.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontSizeCodeType'

=cut

sub setTitleSize {
  my $self = shift;
  $self->{'TitleSize'} = shift
}

=head2 getTitleSize()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontSizeCodeType'

=cut

sub getTitleSize {
  my $self = shift;
  return $self->{'TitleSize'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
