package Bio::Roary::JobRunner::Parallel;

# ABSTRACT: Use GNU Parallel


use Moose;
use File::Slurp;
use File::Temp qw/ tempfile /;

has 'commands_to_run' => ( is => 'ro', isa => 'ArrayRef', required => 1 );
has 'cpus'            => ( is => 'ro', isa => 'Int',      default => 1 );

sub run {
    my ($self) = @_;
    my ($fh, $filename) = tempfile();
    write_file( $fh, join("\n", @{ $self->commands_to_run }) ) ;
  
    my $parallel_command = "cat $filename | parallel -j ".$self->cpus;
    system($parallel_command);
    1;
}

sub _construct_dependancy_params
{
  my ($self) = @_;
  return '';
}

sub submit_dependancy_job {
    my ( $self,$command_to_run) = @_;
    system($command_to_run );
}

no Moose;
__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Bio::Roary::JobRunner::Parallel - Use GNU Parallel

=head1 VERSION

version 2.0.0

=head1 SYNOPSIS

 Execute a set of commands using GNU parallel
   use Bio::Roary::JobRunner::Parallel;
   
   my $obj = Bio::Roary::JobRunner::Local->new(
     commands_to_run   => ['ls', 'echo "abc"'],
     max_jobs => 4
   );
   $obj->run();

=head1 AUTHOR

Andrew J. Page <ap13@sanger.ac.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2013 by Wellcome Trust Sanger Institute.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
