package Promises6::EV::Deferred;
use Evo::Base 'Promises6::Deferred';
use EV;

# For demo only. Don't use it. Pure perl implementation
# is mush faster than even such fast EventLoop

my $ADDED    = 0;
my $BLOCKING = 0;

sub send_msg($self, @args) {
  $BLOCKING ||= !EV::depth;
  $ADDED++;

  my $w;
  $w = EV::timer 0, 0, sub {
    undef $w;
    $self->SUPER::send_msg(@args);

    # was blocking and no messages were placed
    do { $BLOCKING = 0; EV::break } if !--$ADDED && $BLOCKING;
  };

  EV::run if !EV::depth;
}

1;
