package main;
use Evo::Base -strict;
use Promises6 'deferred';
use Test::More tests => 6;
use Promises6 'promise';

my (@destroyed, @created);

my $bldr = Promises6::Builder->new(
  promise_class  => 'MyPromise',
  listener_class => 'MyListener',
  deferred_class => 'MyDeferred',
  resolver_class => 'MyResolver'
);

# return self promise
do: {
  my $d = $bldr->deferred;
  my $promise;
  $promise = $d->promise->then(sub {$promise});
  $d->resolve('val');
}

ok scalar @created;
is_deeply [sort @created], [sort @destroyed];

# return self promise's deferred
(@destroyed, @created) = ();
do: {
  my $d = $bldr->deferred;
  my $promise;
  $promise = $d->promise->then(sub { $promise->deferred });
  $d->resolve('val');
}
is_deeply [sort @created], [sort @destroyed];

# return self promise's deferred
(@destroyed, @created) = ();
do: {
  my ($d1, $d2) = ($bldr->deferred, $bldr->deferred);
  $d1->resolve($d1);
  $d2->resolve($d2->promise);
}
is_deeply [sort @created], [sort @destroyed];

# return thenable
do: {
  my $d = $bldr->deferred;
  my $promise;
  my $val;
  $d->promise->then(sub { Thenable->new() })->then(sub { $val = shift; });
  $d->resolve('');
  is $val, 'value', 'then was called';
}
is_deeply [sort @created], [sort @destroyed];

{

  package Thenable;
  use Evo::Base -base;
  sub then { shift; shift->('value') }

  package MyPromise;
  use Evo::Base 'Promises6::Promise';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }

  package MyResolver;
  use Evo::Base 'Promises6::Resolver';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }

  package MyListener;
  use Evo::Base 'Promises6::Listener';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }

  package MyDeferred;
  use Evo::Base 'Promises6::Deferred';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}


