package main;
use Evo::Base -strict;
use Test::More tests => 5;
use Promises6 qw(resolved deferred);

# thenable can call resolve several times by mistake, if reject immidiately rejects a promise,
# resolve can be called with other promise... so we have handle that case
my ($res, $F, $F2, $R);

# die
resolved('')->then(sub { Thenable->new })
  ->then(sub { $res = shift }, sub {fail});

ok !$res;
$F->(Thenable2->new);
ok !$res;

# already was called, so do nothing after second call
$F->('BAD');
ok !$res;

# already was called, so do nothing after second call
$R->('BAD');
ok !$res;

$F2->('ok');
is $res, 'ok', 'resolved';

{

  package Thenable;
  use Evo::Base -base;
  sub then { shift; ($F, $R) = @_ }

  package Thenable2;
  use Evo::Base -base;
  sub then { $F2 = $_[1] }

}
