package main;
use Evo::Base -strict;
use Test::More tests => 5;
use Promises6 qw(resolved deferred);

my ($res, $d_outer, $F);

# die
resolved('')->then(sub { Thenable->new })->then(undef, sub { $res = shift });
like $res, qr/FooE/, 'Right reason';

# call resolve with value and die
$res = undef;
resolved('s')->then(sub { ThenableFulDie->new })
  ->then(sub { $res = shift }, sub {fail});
is $res, 'thenable_val', 'right value';

# call reject with promise and die
$res = undef;
resolved('s')->then(sub { ThenableRejDie->new })
  ->then(sub {fail}, sub { $res = shift });
is $res, 'thenable_reason', 'right value';

# call resolve with promise and die, like in nb
$d_outer = deferred;
$res     = undef;
resolved('s')->then(sub { ThenableFulPromiseDie->new })
  ->then(sub { $res = shift }, sub {fail});
$d_outer->resolve('val');
is $res, 'val', 'Right value';

# call resolve with thenable and die, like in nb
$res = undef;
resolved('s')->then(sub { ThenableFulThenableDie->new })
  ->then(sub { $res = shift }, sub {fail});
$F->('thenable_nb');
is $res, 'thenable_nb', 'right value';


{

  package Thenable;
  use Evo::Base -base;
  sub then { die "FooE" }

  package ThenableRejDie;
  use Evo::Base -base;
  sub then { $_[2]->('thenable_reason'); die 'BadError' }

  package ThenableFulDie;
  use Evo::Base -base;
  sub then { $_[1]->('thenable_val'); die 'BadError' }

  # return a promise a die. If return value and die does nothing,
  # because promise will be immidiately fulfilled,
  # we need to track if returned  value is pending promise
  # it could return other thenable to.
  package ThenableFulPromiseDie;
  use Evo::Base -base;
  sub then { $_[1]->($d_outer->promise); die 'BadError' }

  package ThenableFulThenableDie;
  use Evo::Base -base;
  sub then { $_[1]->(ThenableFulNB->new); die 'BadError' }

  package ThenableFulNB;
  use Evo::Base -base;
  sub then { $F = $_[1]; }
}
