package main;
use Evo::Base -strict;
use Test::More tests => 2;
use Promises6 'deferred';

my $d;

$d = deferred;
$d->promise->then(sub { ThenableRetF->new })->then(sub($v) { is $v, 'value' });
$d->resolve(undef);

$d = deferred;
$d->promise->then(sub { ThenableRetR->new })
  ->then(undef, sub($r) { is $r, 'reason' });
$d->resolve(undef);

{

  package ThenableRetF;
  use Evo::Base -base;
  sub then($self, $f, $r) { $f->(ThenableFul->new) }

  package ThenableFul;
  use Evo::Base -base;
  sub then($self, $f, $r) { $f->('value') }

  package ThenableRetR;
  use Evo::Base -base;
  sub then($self, $f, $r) { $f->(ThenableRej->new) }

  package ThenableRej;
  use Evo::Base -base;
  sub then($self, $f, $r) { $r->('reason') }

}
