# This is a test for module Image::Quantize.

use warnings;
use strict;
use Test::More;
use FindBin;
use Image::Quantize::PNG;
use Image::PNG::Libpng ':all';
use Image::PNG::Const ':all';

my $iq = Image::Quantize::PNG->new ();
ok ($iq);
$iq->speed (10);

my $pngfile;

# Test reading and writing a file.

$pngfile = "$FindBin::Bin/dice.png";
my $dicew = 800;
my $diceh = 600;

my $pngin = read_png_file ($pngfile);
my $ihdr = $pngin->get_IHDR ();
is ($ihdr->{height}, $diceh);
is ($ihdr->{width}, $dicew);
is ($ihdr->{color_type}, PNG_COLOR_TYPE_RGBA, "Has RGBA colour type");

my $pngout;

$pngout = $iq->quantize ($pngin);
my $ihdrout = $pngout->get_IHDR ();
is ($ihdrout->{height}, $diceh);
is ($ihdrout->{width}, $dicew);
is ($ihdrout->{color_type}, PNG_COLOR_TYPE_PALETTE, "Got palette colour type");

my $outfile;

$outfile = "$FindBin::Bin/dice-output.png";

$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}

$pngfile = "$FindBin::Bin/flores.png";
$pngin = read_png_file ($pngfile);

$pngout = $iq->quantize ($pngin);
$outfile = "$FindBin::Bin/flores-output.png";
$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}


done_testing ();
