.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "Linux 3"
.TH Linux 3 "2006-12-09" "perl v5.8.4" "User Contributed Perl Documentation"
.SH "NAME"
Sys::Statistics::Linux \- Collect linux system statistics.
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.Vb 1
\&   use Sys::Statistics::Linux;
.Ve
.PP
.Vb 1
\&   my $lxs = new Sys::Statistics::Linux;
.Ve
.PP
.Vb 14
\&   $lxs\->set(
\&      SysInfo   => 1,
\&      CpuStats  => 1,
\&      ProcStats => 1,
\&      MemStats  => 1,
\&      PgSwStats => 1,
\&      NetStats  => 1,
\&      SockStats => 1,
\&      DiskStats => 1,
\&      DiskUsage => 1,
\&      LoadAVG   => 1,
\&      FileStats => 1,
\&      Processes => 1,
\&   );
.Ve
.PP
.Vb 1
\&   sleep 1;
.Ve
.PP
.Vb 1
\&   my $stat = $lxs\->get;
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
This module is the main package from the distribution Sys::Statistics::Linux and collects
different linux system informations like processor workload, memory usage, network and
disk statisitcs and other system informations. Refer to the documentation of the distribution
modules to get more informations about all possible statistics and system informations.
.SH "TECHNICAL NOTE"
.IX Header "TECHNICAL NOTE"
This distribution collects statistics by the virtual \fI/proc\fR filesystem (procfs) and is developed
on default vanilla kernels. It is tested on x86 hardware with the distributions SuSE (SuSE on s390
and s390x architecture as well), Red Hat, Debian, Asianux, Slackware and Mandrake on kernel versions
2.4 and 2.6 and should run on all linux kernels with a default vanilla kernel as well. It is possible
that this module doesn't run on all distributions if the procfs is too much modified.
.PP
Further it is necessary to run it as a user with the authorization to read the \fI/proc\fR filesystem.
.SH "DELTAS"
.IX Header "DELTAS"
The options \f(CW\*(C`CpuStats\*(C'\fR, \f(CW\*(C`ProcStats\*(C'\fR, \f(CW\*(C`PgSwStats\*(C'\fR, \f(CW\*(C`NetStats\*(C'\fR, \f(CW\*(C`DiskStats\*(C'\fR and \f(CW\*(C`Processes\*(C'\fR
are deltas, for this reason it's necessary to initialize the statistics first, before the data
be generated with \f(CW\*(C`get()\*(C'\fR. The statistics can be initialized with the methods \f(CW\*(C`new()\*(C'\fR, \f(CW\*(C`set()\*(C'\fR
and \f(CW\*(C`init()\*(C'\fR. Each option that is set to \s-1TRUE\s0 (1) will be initialized by the call of \f(CW\*(C`new()\*(C'\fR
or \f(CW\*(C`set()\*(C'\fR. The call of \f(CW\*(C`init()\*(C'\fR reinitialize all statistics that are set to 1. By the call
of \f(CW\*(C`get()\*(C'\fR the initial statistics will be updated automatically. Please refer the \s-1METHOD\s0 section
to get more information about the calls of \f(CW\*(C`new()\*(C'\fR, \f(CW\*(C`set()\*(C'\fR and \f(CW\*(C`get()\*(C'\fR.
.PP
Another exigence is that you need to sleep for while \- at least for one second \- before you
call \f(CW\*(C`get()\*(C'\fR if you want to get useful statistics. The options \f(CW\*(C`SysInfo\*(C'\fR, \f(CW\*(C`MemStats\*(C'\fR,
\&\f(CW\*(C`SockStats\*(C'\fR, \f(CW\*(C`DiskUsage\*(C'\fR, \f(CW\*(C`LoadAVG\*(C'\fR and \f(CW\*(C`FileStats\*(C'\fR are no deltas. If you need only one
of this informations you don't need to sleep before the call of \f(CW\*(C`get()\*(C'\fR.
.PP
The \f(CW\*(C`get()\*(C'\fR function collects all requested informations and returns a hash reference with the
statistics. The inital statistics will be updated. You can turn on and off options with \f(CW\*(C`set()\*(C'\fR.
.SH "OPTIONS"
.IX Header "OPTIONS"
All options are identical with the package names of the distribution. To activate the gathering
of statistics you have to set the options by the call of \f(CW\*(C`new()\*(C'\fR or \f(CW\*(C`set()\*(C'\fR. In addition you
can deactivate \- respectively delete \- statistics with \f(CW\*(C`set()\*(C'\fR and re-init all statistics with
\&\f(CW\*(C`init()\*(C'\fR.
.PP
The options must be set with a \s-1BOOLEAN\s0 value (1|0).
.PP
.Vb 2
\&   1 \- activate (initialize)
\&   0 \- deactivate (delete)
.Ve
.PP
To get more informations about each option refer the different modules of the distribution.
.PP
.Vb 12
\&   SysInfo     \-  Collect system informations             with L<Sys::Statistics::Linux::SysInfo>.
\&   CpuStats    \-  Collect cpu statistics                  with L<Sys::Statistics::Linux::CpuStats>.
\&   ProcStats   \-  Collect process statistics              with L<Sys::Statistics::Linux::ProcStats>.
\&   MemStats    \-  Collect memory statistics               with L<Sys::Statistics::Linux::MemStats>.
\&   PgSwStats   \-  Collect paging and swapping statistics  with L<Sys::Statistics::Linux::PgSwStats>.
\&   NetStats    \-  Collect net statistics                  with L<Sys::Statistics::Linux::NetStats>.
\&   SockStats   \-  Collect socket statistics               with L<Sys::Statistics::Linux::SockStats>.
\&   DiskStats   \-  Collect disk statistics                 with L<Sys::Statistics::Linux::DiskStats>.
\&   DiskUsage   \-  Collect the disk usage                  with L<Sys::Statistics::Linux::DiskUsage>.
\&   LoadAVG     \-  Collect the load average                with L<Sys::Statistics::Linux::LoadAVG>.
\&   FileStats   \-  Collect inode statistics                with L<Sys::Statistics::Linux::FileStats>.
\&   Processes   \-  Collect process statistics              with L<Sys::Statistics::Linux::Processes>.
.Ve
.SH "METHODS"
.IX Header "METHODS"
.Sh "\fInew()\fP"
.IX Subsection "new()"
Call \f(CW\*(C`new()\*(C'\fR to create a new Statistic object. Necessary statistics will be initialized.
.PP
Without options
.PP
.Vb 1
\&         my $lxs = new Sys::Statistics::Linux;
.Ve
.PP
Or with options
.PP
.Vb 1
\&         my $lxs = Sys::Statistics::Linux\->new(CpuStats => 1);
.Ve
.PP
Will do nothing
.PP
.Vb 1
\&         my $lxs = Sys::Statistics::Linux\->new(CpuStats => 0);
.Ve
.PP
It's possible to call \f(CW\*(C`new()\*(C'\fR with a hash reference of options.
.PP
.Vb 4
\&         my %options = (
\&            CpuStats => 1,
\&            MemStats => 1
\&         );
.Ve
.PP
.Vb 1
\&         my $lxs = Sys::Statistics::Linux\->new(\e%options);
.Ve
.Sh "\fIset()\fP"
.IX Subsection "set()"
Call \f(CW\*(C`set()\*(C'\fR to activate (initialize) or deactivate (delete) options.
.PP
.Vb 4
\&         $lxs\->set(
\&            CpuStats => 1, # activate
\&            SysInfo  => 0, # deactivate
\&         );
.Ve
.PP
It's possible to call \f(CW\*(C`set()\*(C'\fR with a hash reference of options.
.PP
.Vb 4
\&         my %options = (
\&            CpuStats => 1,
\&            MemStats => 1
\&         );
.Ve
.PP
.Vb 1
\&         $lxs\->set(\e%options);
.Ve
.PP
Activate options with \f(CW\*(C`set()\*(C'\fR will initialize necessary statistics.
.PP
.Vb 2
\&         $lxs\->set(CpuStats => 1); # initialize it
\&         $lxs\->set(CpuStats => 1); # initialize it again
.Ve
.Sh "\fIget()\fP"
.IX Subsection "get()"
Call \f(CW\*(C`get()\*(C'\fR to get the collected statistics. \f(CW\*(C`get()\*(C'\fR returns the statistics as a hash reference.
.PP
.Vb 1
\&         my $stats = $lxs\->get;
.Ve
.Sh "\fIinit()\fP"
.IX Subsection "init()"
The call of \f(CW\*(C`init()\*(C'\fR re-init all statistics that are necessary for deltas and if the option is set to 1.
.PP
.Vb 1
\&         $lxs\->init;
.Ve
.Sh "\fIsettime()\fP"
.IX Subsection "settime()"
Call \f(CW\*(C`settime()\*(C'\fR to define a \s-1POSIX\s0 formatted time stamp, generated with \fIlocaltime()\fR.
.PP
.Vb 1
\&         $lxs\->settime('%Y/%m/%d %H:%M:%S');
.Ve
.PP
To get more informations about the formats take a look at \f(CW\*(C`strftime()\*(C'\fR of \s-1POSIX\s0.pm
or the manpage \f(CWstrftime(3)\fR.
.Sh "\fIgettime()\fP"
.IX Subsection "gettime()"
\&\f(CW\*(C`gettime()\*(C'\fR returns a \s-1POSIX\s0 formatted time stamp, \f(CW@foo\fR in list and \f(CW$bar\fR in scalar context.
If the time format isn't set then the default format \*(L"%Y\-%m\-%d \f(CW%H:\fR%M:%S\*(R" will be set automatically.
You can also set a time format with \f(CW\*(C`gettime()\*(C'\fR.
.PP
.Vb 1
\&         my $date_time = $lxs\->gettime;
.Ve
.PP
Or
.PP
.Vb 1
\&         my ($date, $time) = $lxs\->gettime;
.Ve
.PP
Or
.PP
.Vb 1
\&         my ($date, $time) = $lxs\->gettime('%Y/%m/%d %H:%M:%S');
.Ve
.SH "EXAMPLES"
.IX Header "EXAMPLES"
A very simple perl script could looks like this:
.PP
.Vb 3
\&         use warnings;
\&         use strict;
\&         use Sys::Statistics::Linux;
.Ve
.PP
.Vb 4
\&         my $lxs = Sys::Statistics::Linux\->new( CpuStats => 1 );
\&         sleep(1);
\&         my $stats = $lxs\->get;
\&         my $cpu   = $stats\->{CpuStats}\->{cpu};
.Ve
.PP
.Vb 7
\&         print "Statistics for CpuStats (all)\en";
\&         print "  user      $cpu\->{user}\en";
\&         print "  nice      $cpu\->{nice}\en";
\&         print "  system    $cpu\->{system}\en";
\&         print "  idle      $cpu\->{idle}\en";
\&         print "  ioWait    $cpu\->{iowait}\en";
\&         print "  total     $cpu\->{total}\en";
.Ve
.PP
Example to collect network statistics with a nice output:
.PP
.Vb 3
\&         use warnings;
\&         use strict;
\&         use Sys::Statistics::Linux;
.Ve
.PP
.Vb 1
\&         $| = 1;
.Ve
.PP
.Vb 4
\&         my $header  = 20;
\&         my $average = 1;
\&         my $columns = 8;
\&         my $options = { NetStats => 1 };
.Ve
.PP
.Vb 4
\&         my @order = qw(
\&            rxbyt rxpcks rxerrs rxdrop rxfifo rxframe rxcompr rxmulti
\&            txbyt txpcks txerrs txdrop txfifo txcolls txcarr txcompr
\&         );
.Ve
.PP
.Vb 1
\&         my $lxs = Sys::Statistics::Linux\->new( $options );
.Ve
.PP
.Vb 1
\&         my $h = $header;
.Ve
.PP
.Vb 15
\&         while (1) {
\&            sleep($average);
\&            my $stats = $lxs\->get;
\&            if ($h == $header) {
\&               printf "%${columns}s", $_ for ('iface', @order);
\&               print "\en";
\&            }
\&            foreach my $device (keys %{$stats\->{NetStats}}) {
\&               my $dstat = $stats\->{NetStats}\->{$device};
\&               printf "%${columns}s", $device;
\&               printf "%${columns}s", $dstat\->{$_} for @order;
\&               print "\en";
\&            }
\&            $h = $header if \-\-$h == 0;
\&         }
.Ve
.PP
Activate and deactivate statistics:
.PP
.Vb 4
\&         use warnings;
\&         use strict;
\&         use Sys::Statistics::Linux;
\&         use Data::Dumper;
.Ve
.PP
.Vb 1
\&         my $lxs = new Sys::Statistics::Linux;
.Ve
.PP
.Vb 6
\&         # set the options
\&         $lxs\->set(
\&            SysInfo  => 1,
\&            CpuStats => 1,
\&            MemStats => 1
\&         );
.Ve
.PP
.Vb 2
\&         # sleep to get useful statistics for CpuStats
\&         sleep(1);
.Ve
.PP
.Vb 3
\&         # $stats contains SysInfo, CpuStats and MemStats
\&         my $stats = $lxs\->get;
\&         print Dumper($stats);
.Ve
.PP
.Vb 2
\&         # we deactivate CpuStats
\&         $lxs\->set(CpuStats => 0);
.Ve
.PP
.Vb 3
\&         # $stats contains SysInfo and MemStats
\&         $stats = $lxs\->get;
\&         print Dumper($stats);
.Ve
.PP
Set and get a time stamp:
.PP
.Vb 3
\&         use warnings;
\&         use strict;
\&         use Sys::Statistics::Linux;
.Ve
.PP
.Vb 3
\&         my $lxs = new Sys::Statistics::Linux;
\&         $lxs\->settime('%Y/%m/%d %H:%M:%S');
\&         print $lxs\->gettime, "\en";
.Ve
.PP
If you're not sure you can use the the \f(CW\*(C`Data::Dumper\*(C'\fR module to learn more about the hash structure:
.PP
.Vb 4
\&         use warnings;
\&         use strict;
\&         use Sys::Statistics::Linux;
\&         use Data::Dumper;
.Ve
.PP
.Vb 3
\&         my $lxs = Sys::Statistics::Linux\->new( CpuStats => 1 );
\&         sleep(1);
\&         my $stats = $lxs\->get;
.Ve
.PP
.Vb 1
\&         print Dumper($stats);
.Ve
.PP
Take a look into the the \fIexamples\fR directory of the distribution for some examples with a nice output. :\-)
.SH "EXPORTS"
.IX Header "EXPORTS"
No exports.
.SH "REPORTING BUGS"
.IX Header "REPORTING BUGS"
Please report all bugs to <jschulz.cpan(at)bloonix.de>.
.SH "AUTHOR"
.IX Header "AUTHOR"
Jonny Schulz <jschulz.cpan(at)bloonix.de>.
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
Copyright (c) 2006, 2007 by Jonny Schulz. All rights reserved.
.PP
This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.
