# pop3.py   
#coding=utf8

from wikitools import *
from hashlib import md5
import datetime
import poplib
import urllib
import imghdr
import shutil
import email 
import time
import re
import os

class MyMail:
    """ 
        function: Automatically submit mail to the knowledge base
          author: yekai@taobao.com
             gmt: 2013-02-28
    """
     
    def __init__(self, mailServer, loginName, loginPasswd, wikiServer, wikiUser, wikiPasswd):
        self.initProp()
         
        self.delList = {}
        self.tmpDir = '/tmp/email'
         
        self.wikiServer = wiki.Wiki(wikiServer)
        ret = self.wikiServer.login(wikiUser, wikiPasswd)
        print "myMail: wikiServer Login %s!" % (ret and 'SUCCED' or 'FAILED')
         
        self.mailServer = poplib.POP3_SSL(mailServer, 995)
        self.mailServer.user(loginName)
        self.mailServer.pass_(loginPasswd)
        print "myMail: %s!" % (self.mailServer.getwelcome())
         
    def quit(self):
        self.wikiServer.logout()
        self.mailServer.quit()
        print "myMail: quit at %s!\n" % (datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
         
    def initProp(self):
        self.uploads = {}
        self.inlines = {}
         
    def setProp(self, msgPart, uniFileName):
        propType = self.getContentType(msgPart.get("Content-Disposition"))
        propName = (propType == 'inline') and msgPart.get("Content-ID")[1:-1] or msgPart.get_filename()
         
        if propType == 'inline':
            self.inlines[propName] = uniFileName
        elif propType == 'attachment':
            self.uploads[propName] = uniFileName
         
    def dele(self, mailNo):
        try:
            self.mailServer.dele(mailNo)
        except Exception as e:
            print "myMail: delete eMail Failed, reason: ", e
         
    def getMailStat(self):
        mailNum, mailSize = self.mailServer.stat()
        print 'myMail: eMail number is %d and size is %d!' % (mailNum, mailSize)
        return mailNum, mailSize
         
    def getMessageFromString(self, mailNo):
        mailMsg = email.message_from_string("\n".join(self.mailServer.retr(mailNo+1)[1]))
        return mailMsg
         
    def getHeaderName(self, header, mailSubject): 
        header = email.Header.decode_header(header)
        if len(header) > 0 and len(header[0]) > 0:
            if self.getFileExists(header[0][0].strip()):
                prefixName = md5(mailSubject).hexdigest()
                fileName = "%s_%s" % (prefixName[:16], header[0][0].strip())
            else:
                fileName = header[0][0].strip()
            return fileName
        else:
            print "myMail: not found data from getHeaderName!"
            return None
         
    def getMailSubject(self, mailInfo, mailFrom): 
        subject = mailInfo.get("Subject")
        header = email.Header.decode_header(subject)
        if len(header) > 0 and len(header[0]) > 0:
            if self.getPageExists(header[0][0].strip()):
                domainName = self.getDomainName(mailFrom)
                mailSubject = "%s(%s)" % (header[0][0].strip(), domainName)
            else:
                mailSubject = header[0][0].strip()
            return mailSubject
        else:
            print "myMail: not found data from getMailSubject!"
            return None
         
    def getMailDate(self, mailInfo):
        myStamp = email.utils.mktime_tz(email.utils.parsedate_tz(mailInfo.get("Date")))
        return datetime.datetime.fromtimestamp(myStamp)
         
    def getMailFrom(self, mailInfo):
        return email.utils.parseaddr(mailInfo.get("From"))[1]
         
    def getMailTo(self, mailInfo):
        return email.utils.parseaddr(mailInfo.get("To"))[1]
          
    def getWikiContent(self, mailContent):
        mailContent = mailContent.replace('<meta http-equiv="Content-Type" content="text/html; charset=utf-8">', "")
         
        reContent = re.compile('<a(.*?)href="(.*?)"(.*?)>(.*?)</a>')
        reFind = reContent.findall(mailContent)
        reFind = sorted(set(reFind), key=reFind.index) #list distinct
        for myRow in reFind:
            reSearch = reContent.search(mailContent)
            if reSearch and len(reSearch.group()) > 0:
                mailContent = mailContent.replace(reSearch.group(), '[%s %s]' % (myRow[1], myRow[3]))
            else:
                print "getWikiContent: no data found!"
         
        mailContent = "%s <div>&nbsp;</div> [[category: askdba]]" % (mailContent)
        return mailContent
         
    def getContentType(self, contentDisposition):
        reSrc = re.compile('\s*(.*?);')
        srcRet = reSrc.findall(contentDisposition)
        if len(srcRet) > 0:
            return srcRet[0]
        return None
         
    def getDomainName(self, mailFrom):
        domain_ = mailFrom.split('@')
        return len(domain_) > 0 and domain_[0] or None
         
    def doPostMail(self, mailSubject, mailContent, mailFrom, mailDate, mailNo):
        try: 
            editPage = page.Page(site = self.wikiServer, title = mailSubject, namespace = 2)
            retMsg = editPage.edit(title = mailSubject, text = mailContent, skipmd5 = 1)
            if 'edit' in retMsg and retMsg['edit']['result'] == 'Success':
                print "myMail: submit eMail to wiki Succed!"
                self.delList[mailNo+1] = mailNo+1
            else:
                print "myMail: submit eMail to wiki Failed: %s!" % (mailSubject)
                print retMsg, "\n"
        except Exception as e:
            print "myMail: submit eMail to wiki Failed!, reasion: ", e
            print retMsg, "\n"
         
    def doWriteFile(self, strBuff, fileName):
        fp = open(os.path.join(self.tmpDir, fileName), 'wb')
        fp.write(strBuff)
        fp.close()
         
    def getPageExists(self, fileName):
        params = {"action": 'query', "titles": "%s" % (fileName)}
        request = api.APIRequest(self.wikiServer, params)
        retMsg = request.query()
        if retMsg['query']['pages'].has_key("-1"):
            return False
        else:
            return True
         
    def getFileExists(self, fileName):
        params = {"action": 'query', "titles": "文件:%s" % (fileName)}
        request = api.APIRequest(self.wikiServer, params)
        retMsg = request.query()
        if retMsg['query']['pages'].has_key("-1"):
            return False
        else:
            return True
         
    def doUploadFile(self, fileName):
        try:
            wf = wikifile.File(wiki=self.wikiServer, title=fileName)
            retMsg = wf.upload(fileobj = open(os.path.join(self.tmpDir, fileName)))
             
            retMsg = retMsg['upload']
            if retMsg['result'] == 'Success':
                print "myMail upload's file [%s] succed!" % (fileName)
            elif retMsg['result'] == 'Warning' and retMsg.has_key('warnings'):
                myRet = retMsg['warnings']
                if myRet.has_key('exists'):
                    print "myMail upload's file [%s] exists!" % (fileName)
                elif myRet.has_key('duplicate'):
                    fileName = myRet['duplicate'][0].encode("utf-8")
                    print "myMail upload's file [%s] duplicate!" % (fileName)
             
            return fileName
        except Exception as e:
            print "myMail: upload's file [%s] failed, reason: " % (fileName)
            print "   ", e, "\n"
         
        return None
         
    def addAttachInfo(self, wikiContent):
        if len(self.uploads) > 0:
            attMsg = ""
            for key, val in self.uploads.items():
                attMsg += attMsg == "" and "[[文件:%s]]" % (val) or " | [[文件:%s]]" % (val)
            wikiContent = "%s &nbsp;&nbsp; %s" % (attMsg, wikiContent)
             
        if len(self.inlines) > 0:
            reImg = re.compile("<img(.*?)>")
            imgRet = reImg.findall(wikiContent)
            for key, val in self.inlines.items():
                for myRow in imgRet:
                    if myRow.find(key) > 0:
                        srcStr = "<img%s>" % (myRow)
                        wikiContent = wikiContent.replace(srcStr, '[[Image:%s]]' % (val))
         
        return wikiContent
         
    def addNetworkImg(self, wikiContent):
        reImg = re.compile("<img(.*?)>")
        imgRet = reImg.findall(wikiContent)
        for myRow in imgRet:
            reSrc = re.compile('src="(.*?)"')
            srcRet = reSrc.findall(myRow)
            if len(srcRet) > 0 and srcRet[0].startswith('http'):
                fileName = md5(srcRet[0]).hexdigest()
                imgHandle = urllib.urlopen(url=srcRet[0])
                self.doWriteFile(imgHandle.read(), fileName)
                if fileName.find(".") < 0:
                    imgType = imghdr.what(self.tmpDir +"/" + fileName)
                    newName = "%s.%s" % (fileName, imgType)
                    shutil.move(self.tmpDir +"/" + fileName, self.tmpDir + "/" + newName)
                 
                fileName = self.doUploadFile(newName)
                if fileName:
                    wikiContent = wikiContent.replace("<img%s>" % (myRow), "[[Image:%s]]" % (fileName))
         
        return wikiContent
         
    def getMailContent(self, mailInfo, mailSubject, isDecode = True):
        for msg in mailInfo.walk():
            if msg.is_multipart() and msg.get_content_type().startswith('multipart/'):
                for part in msg.get_payload():
                    if part.get_content_type() == 'application/octet-stream':
                        attMsg = part.get_payload(decode=isDecode)
                        uniFileName = self.getHeaderName(part.get_filename(), mailSubject)
                        self.doWriteFile(attMsg, uniFileName)
                        fileName = self.doUploadFile(uniFileName)
                        if fileName:
                            self.setProp(part, fileName)
            elif not msg.is_multipart() and msg.get_content_type() == 'text/html':
                rowText = msg.get_payload(decode=isDecode)
                if rowText and len(rowText.strip()) > 0:
                    rowText = self.getWikiContent(rowText)
                    rowText = self.addAttachInfo(rowText)
                    rowText = self.addNetworkImg(rowText)
                return rowText
