=head1 NAME

PDL::Install::Files

=head1 DESCRIPTION

This module is a stub that contains some auxiliary routines useful for
inlining PDL-aware C code into PDL programs.  

It defines some auxiliary package variables and two routines that are not
normally called by users.

=head1 METHODS

=head2 deps

=for ref

Returns nothing -- stub for "Inline with => 'PDL'".

=head2 Inline

=for ref

Accepts a class and a lanaguage string.

If the language string is "C",  Inline returns a hash containing TYPEMAPS, INC, 
AUTO_INCLUDE, and BOOT information that are useful for autogenerated PDL-aware C 
code using "Inline with => 'PDL'".  The actual data are pulled from methods in 
C<PDL::Core::Dev>.  

If the language string is anything else, then it returns nothing.

=cut



package PDL::Install::Files;
# support ExtUtils::Depends
require PDL::Core::Dev;

$self = {
  'typemaps' => [ &PDL::Core::Dev::PDL_TYPEMAP ],
  'inc' => &PDL::Core::Dev::PDL_INCLUDE,
  'libs' => '',
  'deps' => [],
};
@deps = @{ $self->{deps} };
@typemaps = @{ $self->{typemaps} };
$libs = $self->{libs};
$inc = $self->{inc};
$CORE = undef;
foreach (@INC) {
  if ( -f "$_/PDL/Install/Files.pm") { $CORE = $_ . "/PDL/Install/"; last; }
}

sub deps { }
# support: use Inline with => 'PDL';

require Inline;

sub Inline {
  my ($class, $lang) = @_;
  return {} if $lang eq 'Pdlpp';
  return unless $lang eq 'C';
  unless($ENV{"PDL_Early_Inline"} // ($Inline::VERSION >= 0.68) ) {
      die "PDL::Inline: requires Inline version 0.68 or higher to make sense\n  (yours is $Inline::VERSION). You should upgrade Inline, \n   or else set \$ENV{PDL_Early_Inline} to a true value to ignore this message.\n";
  }
  +{
    TYPEMAPS      => [ &PDL::Core::Dev::PDL_TYPEMAP ],
    INC           => &PDL::Core::Dev::PDL_INCLUDE,
    AUTO_INCLUDE  => &PDL::Core::Dev::PDL_AUTO_INCLUDE,
    BOOT          => &PDL::Core::Dev::PDL_BOOT,
  };
}

1;
