use 5.14.0;
use strict;
use warnings;
use CairoX::Sweet::Standard;

our $VERSION = '0.0103'; # VERSION
# PODNAME: CairoX::Sweet::Color

class CairoX::Sweet::Color using Moose {

    foreach my $color (qw/red green blue/) {
        has $color => (
            is => 'ro',
            isa => NumUpToOne,
            required => 1,
        );
    }
    has opacity => (
        is => 'ro',
        default => 1,
        isa => NumUpToOne,
    );

    method color {
        return ($self->red, $self->green, $self->blue);
    }
    method color_with_opacity {
        return ($self->red, $self->green, $self->blue, $self->opacity);
    }
}

__END__

=pod

=encoding UTF-8

=head1 NAME

CairoX::Sweet::Color

=head1 VERSION

Version 0.0103, released 2015-01-11.

=head1 SOURCE

L<https://github.com/Csson/p5-CairoX-Sweet>

=head1 HOMEPAGE

L<https://metacpan.org/release/CairoX-Sweet>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
