use 5.14.0;
use strict;
use warnings;

package Map::Metro::Plugin::Map::Brescia;

our $VERSION = '0.1001'; # VERSION
# ABSTRACT: Map::Metro map for Brescia

use Moose;
with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-brescia.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Brescia - Map::Metro map for Brescia

=head1 VERSION

Version 0.1001, released 2015-01-28.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Brescia')->parse;

Or:

    $ map-metro.pl route Brescia Casazza Volta

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 Status

This map L<contains|Map::Metro::Plugin::Map::Brescia::Lines>:

=over 4

=item *

The single metro line [L<wikipedia|https://en.wikipedia.org/wiki/Brescia_Metro>]

=back

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Brescia/master/static/images/brescia.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Brescia/master/static/images/brescia.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

Source repository is at L<https://github.com/Csson/p5-Map-Metro-Brescia>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Map-Metro-Plugin-Map-Brescia>.

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
