=head1 NAME

Template::Plugin::Lingua::EN::Inflexion

=head1 ABSTRACT

Use L<Lingua::EN::Inflexion> from the Template Toolkit.

=head1 SYNOPSIS

    [%# In a template %]
    [% USE Lingua::EN::Inflexion %]

    And then later...

    [% inflect("<#:$x> <N:result> <V:was> found") %]

=head1 DESCRIPTION

L<Lingua::EN::Inflexion> is a great module for ensuring that the text
generated by your program doesn't contain grammatical horrors like
"1 error(s) found". In short, it will look at the number you give it
and produce output containing either the singular or plural versions
of words as appropriate.

The main interface to this module is through a subroutine called
C<inflect()>. This module makes it easy to use this subroutine in your
Template Toolkit files.

In Perl code, you would write something like this:

    use Lingua::EN::Inflect;

    # ... and later
    
    my @results = get_results($search);
    my $count   = scalar @results;

    print inflect("<#:$count> <N:result> <V:was> found.");

The TT version looks very similar:

    [% USE Lingua::EN::Inflect %]

    [% results = get_results(search) %]
    [% count   = results.size %]
    [% inflect("<#:$count> <N:result> <V:was> found.") %]

=head1 SUBROUTINES

=head2 inflect()

The TT version of the C<inflect()> subroutine is identical to
the Perl version, so please read the documentation for
L<Lingua::EN::Inflect> for more details.

=cut

package Template::Plugin::Lingua::EN::Inflexion;

our $VERSION = '0.0.1';

use parent 'Template::Plugin';

use Lingua::EN::Inflexion;

sub new {
  my ($class, $context) = @_;

  $context->stash->set(inflect => \&Lingua::EN::Inflexion::inflect);

  return bless { _CONTEXT => $context }, $class;
}

1;

=head1 AUTHOR

Dave Cross <dave@perlhacks.com>

=head1 COPYRIGHT AND LICENCE

Copyright (c) 2020, Magnum Solutions Ltd. All Rights Reserved.

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
