package Net::SSLLabs::Simulation;

use strict;
use warnings;
use Net::SSLLabs::SimClient();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    $self->{client} = Net::SSLLabs::SimClient->new( $self->{client} );
    return $self;
}

sub client {
    my ($self) = @_;
    return $self->{client};
}

sub errorCode {
    my ($self) = @_;
    return $self->{errorCode};
}

sub attempts {
    my ($self) = @_;
    return $self->{attempts};
}

sub protocolId {
    my ($self) = @_;
    return $self->{protocolId};
}

sub suiteId {
    my ($self) = @_;
    return $self->{suiteId};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Simulation - Simulation object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::Simulation> object, accepts a JSON object as it's parameter.

=head2 client

instance of L<Net::SSLLabs::SimClient|Net::SSLLabs::SimClient>.

=head2 errorCode

zero if handshake was successful, 1 if it was not.

=head2 attempts

always 1 with the current implementation.

=head2 protocolId

Negotiated protocol ID.

=head2 suiteId

Negotiated suite ID.

