use strict;
use Benchmark qw(cmpthese);
use blib;
use MeCab;
use Text::MeCab;

my @fields = qw(id surface feature length);
my $text = <<EOM;
ϤοͤȸƤǤ餳Ǥ⤿Ƚ񤯤̾Ǥʤ֤ߤθȤ⡢ˤȤäƼǤ롣ϤοͤεƤӵȤˡפȤʤ롣ɮ򼹤äƤ⿴ƱǤ롣褽褽ƬʸʤɤϤȤƤȤˤʤʤ
䤬Τ礤ˤʤäΤϳҤǤ롣λϤޤ㡹ǤäٲˤѤƳ˹Ԥäͧã餼褤ȤüäΤǡ¿ζ̤ơгݤˤ϶ι̤󡢻䤷Ȥ䤬Ҥ夤ƻȷФʤˡƤӴ󤻤ͧãϡޤ˹񸵤鵢Ȥäˤ줬µǤäƤäɤͧãϤ򿮤ʤäͧãϤͤƤ񸵤ˤƤ˴ޤʤ뺧򶯤Ƥϸν餤ȷ뺧ˤϤޤǯ᤮˴οͤʤäǲƵ٤ߤ٤Ȥ򡢤虜򤱤ζ᤯ͷǤΤǤ롣˸Ƥɤ褦̤򤷤ˤϤɤƤʬʤäɤº줬µǤȤϸǤ굢٤ϤǤäϤȤȤˤʤää褿ϰͼĤ줿
عμȤϤޤˤϤޤʬΤǳҤˤäƤ褷äƤ褤Ȥˤϡʬνɤαޤи򤷤ͧãΤ񻺲Ȥ©ҤǶԼͳΤʤˤǤäɤ⡢ععʤΤǯǯʤΤǡ٤ϻȤѤ⤷ʤääưͤܤäˤʤä̤˳湥ʽɤõݤ⤿ʤäΤǤ롣
ɤϳҤǤѤˤäͤΥ꡼ΤȤϥʤΤˤĹıۤʤм꤬Ϥʤä֤ǹԤäƤϼ줿ɤĿͤϤˤĤǤƤƤ˳ؤϤᤤΤǳˤϻϰ̤Ƥ
ؤϤ˽гݤŤ֤֤äδ֤̤ȴưزȡդˤۤɤԲͼ郎Ǥ뤫Ȼפۤɡ褿ˤǺξ夬ưƤϳ椬Τ褦˹ƬǤ㤴㤷Ƥ⤢äΤäͤͤ⤿ʤ⡢䤫ʷʿޤơξ˿٤äƤߤꡢɨƬȤǤƤķͲΤǤä
ϼ¤򤳤λδ֤˸դФΤǤ롣λߤˤϳ㲰󸮤äϤդȤ񤫤餽ΰ츮˹ԤƤĹëդ礭򹽤ƤͤȰäơƼͭ崹ϤƤʤҤˤϡҤȤ⤳Ʊ崹ȤäʤΤɬפʤΤǤäϤߡǵ©볰ˡǳꡢĤϤ椤Τ᤿ꡢ˹Ҥ仱¤ꤹΤǤ롣ʤˤʪޤ붲ϤäΤǡϳؤϤ뤿Ӥˤ㲰ذڤæƤˤƤ
EOM

sub mecab {
    my $mecab = MeCab::Tagger->new();
    for(my $node = $mecab->parseToNode($text);
        $node;
        $node = $node->{next}
    ) {
        for my $field (@fields) {
            $node->{$field};
        }
    }
}

sub text_mecab {
    my $mecab = Text::MeCab->new();
    for(my $node = $mecab->parse($text);
        $node;
        $node = $node->next
    ) {
        for my $field (@fields) {
            $node->$field();
        }
    }
}

cmpthese(1000, {
    mecab => \&mecab,
    text_mecab => \&text_mecab,
});