# @(#) test.pl - test script for testing the File::Repl module
#
# Author:
#      Dave Roberts
#
# Synopsis:
#      test.pl
#
# Version
#      $Source: D:/src/perl/File-Repl/RCS\\test.pl $
#      $Revision: 1.3 $
#      $State: Exp $
#
# Description:
#      <FULL DESCRIPTION>
#
# Options:
#
# Exit Status:
#
# Caveats/Warnings:
#
# See Also:
#
# Files:
#

# Start comments/code here - will not be processed into manual pages
#
#    Copyright  Dave Roberts  2000
#
# Revision history:
#      $Log: test.pl $
#      Revision 1.3  2001/06/19 09:44:08  Dave.Roberts
#      now tests file deletion (->Delete method) and calls New correctly
#      (-> New rather than ::New, or ::SetDefaults)
#      .,
#
#      Revision 1.2  2000/10/20 08:38:21  Dave.Roberts
#      Added RCS style header to test.pl
#
#******************************************************************************
#  Test script to test the File-repl package.
BEGIN {
  $! = 1; print " 1..20\n";
}
  #unless (eval "use Carp" ) {
  #  die "can't load Carp: $@\n";
  #}
use Carp;
use strict;
use File::Find;
use File::Compare;

#croak ("I need the strict module to run test.pl ($@)\n") unless (eval "use strict;");
#croak ("I need the File::Find module to run test.pl ($@)\n") unless (eval "use File::Find");
#croak ("I need the File::Compare module to run test.pl ($@)\n") unless (eval "use File::Compare");

# Declare variables
my ($tmp,$dira,$dirb,$loaded,$atarget,$btarget,@files,$hashref,$ref,
    $success,$testsok,@bfiles,$debug,@afiles,$tstfile,$tstfilea,
    $tstfileb,$result,$testsrun);

# Start of test 1 - does the module load ?
use File::Repl;


$loaded   = 1;
$testsok  = 1;
$testsrun = 1;
print "ok 1\n";
# End of test 1

# Create common variables for testing
$tmp        = $ENV{'TMP'} if $ENV{'TMP'};
$tmp        = $ENV{'TEMP'} if ( ! $tmp && $ENV{'TEMP'});
$dira       = $tmp . '/file-repl.tsta';
$dirb       = $tmp . '/file-repl.tstb';
$atarget    = $dira . '/a/b/c/d/e';
$btarget    = $dirb . '/a/b/c/d/e';
@files      = qw( foo.tst ABCDE.XYZ abcde.xyz bar.pl dummy.c );
$debug      = 0;
$result     = 0;

  my(%hash);
  %hash = (
     'dira',      $dira,
     'dirb',      $dirb,
     'age',       '10',
     verbose => 1,
  );
#--------------------------------------------------------------
# Call test subroutines...

&_t2;
&_t3;
&_t4;
&_t5;
&_t6;
&_t8;







#--------------------------------------------------------------
sub _t2 {
# Start of test 2
#   Just replicate files and directory structure
  &_s1($dira,@files);   # Create source and data directories

  $ref=File::Repl->New(\%hash);
  $ref->Update('.*','a>b',1);
  undef $ref;
# deem this successful if NO files have been replicated successfully from a to be
  $success = 1;
  @bfiles = @files;
  TEST2: foreach (@files) {
    if ( (&_s4($atarget . '/' . $_,  $btarget . '/' . $_)) == 2 ) {
      print "   file $_ did not replicate from $atarget to $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ replicated from $atarget to $btarget - not ok\n");
      $success = 0;
      last TEST2;
    }
  }
  if ( $success eq 1 ) {
    print "\nok 2\n";
    $testsok ++;
  }else{
    print "\nnot ok 2\n";
  }
  $testsrun ++;
}
# End of test 2

#--------------------------------------------------------------
sub _t3 {
# Start of test 3
#   Test the A>B option does not replicate if commit argument is set to 0
  $ref=File::Repl->New(\%hash);
  $ref->Update('.*','A>B',0);
  undef $ref;
# deem this successful if NO files have been replicated successfully from a to be
  $success = 1;
  TEST3: foreach (@files) {
    if ( (&_s4($atarget . '/' . $_,  $btarget . '/' . $_)) == 2 ) {
      print "   file $_ did not replicate from $atarget to $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ replicated from $atarget to $btarget - not ok\n");
      $success = 0;
      last TEST3;
    }
  }
  if ( $success eq 1 ) {
    print "\nok 3\n";
    $testsok ++;
  }else{
    print "\nnot ok 3\n";
  }
  $testsrun ++;
}
# End of test 3

#--------------------------------------------------------------
sub _t4 {
# Start of test 4
#   Test the A>B option does replicate all files if commit argument is set to 1
  $hashref = {
     'dira',      $dira,
     'dirb',      $dirb
  };
  $ref=File::Repl->New($hashref);
  $ref->Update('.*','A>B',1);
  undef $ref;
# deem this successful if ALL files have been replicated successfully from a to be
  $success = 1;
  TEST4: foreach (@files) {
    if ( (&_s4($atarget . '/' . $_,  $btarget . '/' . $_)) == 0 ) {
      print "   file $_ replicated from $atarget to $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ did not replicate from $atarget to $btarget - not ok\n");
      $success = 0;
      last TEST4;
    }
  }if ( $success eq 1 ) {
    print "\nok 4\n";
    $testsok ++;
  }else{
    print "\nnot ok 4\n";
  }
  $testsrun ++;
}
# End of test 4
#--------------------------------------------------------------
sub _t5 {
# Start of test 5
#   Test the a>b option does not replicate a file when the destination is newer
  @afiles = @files;
  $tstfile = pop @afiles;
  $tstfilea = $atarget . '/' . $tstfile;
  $tstfileb = $btarget . '/' . $tstfile;
  my($dev2,$ino2,$mode2,$nlink2,$uid2,$gid2,$rdev2,$size2,
    $atime,$mtime,$ctime2,$blksize2,$blocks2)
    = stat($tstfilea);

  print "   revising mtime on file $tstfileb from $mtime to" if $debug;
  $mtime = $mtime +10;
  print " $mtime \n" if $debug;
  utime ($atime,$mtime, $tstfileb);
  $hashref = {
     'dira',      $dira,
     'dirb',      $dirb
  };
  $ref=File::Repl->New($hashref);
  $ref->Update('.*','a>b',1);
  undef $ref;
# deem this successful if ALL files have been replicated successfully from a to be
  $success = 1;
  TEST5: foreach (@files) {
    $result = (&_s4($atarget . '/' . $_,  $btarget . '/' . $_));
    if ( $result == 0 ) {
      if ( $tstfile eq $_ ) {
        carp ("   file $_ was replicated from $atarget to $btarget - not ok\n");
        $success = 0;
        last TEST5;
      }else{
        print "   file $_ is identical in $atarget and $btarget - ok\n" if $debug;
        print "." unless $debug;
      }
    }elsif ( ($result == 5) && ( $tstfile eq $_ ) ) {
      print "   file $_ has not been replicated from $atarget to $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ did not replicate from $atarget to $btarget - not ok\n");
      $success = 0;
      last TEST5;
    }
  }
  if ( $success eq 1 ) {
    print "\nok 5\n";
    $testsok ++;
  }else{
    print "\nnot ok 5\n";
  }
  $testsrun ++;
}
# End of test 5
#--------------------------------------------------------------
sub _t6 {
# Start of test 6
#   Test the a>b option does replicate a file when the destination is older
#   This tests that the $tstfile from test 5, after the replica in $targetb is made
#   older than the original in $targeta, is replicated succesfully
    my($dev2,$ino2,$mode2,$nlink2,$uid2,$gid2,$rdev2,$size2,
    $atime,$mtime,$ctime2,$blksize2,$blocks2)
    = stat($tstfilea);

  print "   revising mtime on file $tstfileb from $mtime to" if $debug;
  $mtime = $mtime -20;
  print " $mtime \n" if $debug;
  utime ($atime,$mtime, $tstfileb);
  $hashref = {
     'dira',      $dira,
     'dirb',      $dirb
  };
  $ref=File::Repl->New($hashref);
  $ref->Update('.*','a>b',1);
  undef $ref;
# deem this successful if ALL files in a and b are identical
  $success = 1;
  TEST6: foreach (@files) {
    $result = (&_s4($atarget . '/' . $_,  $btarget . '/' . $_));
    if ( $result == 0 ) {
      print "   file $_ is identical in $atarget and $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ in $atarget to $btarget is different- not ok\n");
      $success = 0;
      last TEST6;
    }
  }
  if ( $success eq 1 ) {
    print "\nok 6\n";
    $testsok ++;
  }else{
    print "\nnot ok 6\n";
  }
  $testsrun ++;
}
# End of test 6
#--------------------------------------------------------------
sub _t7 {
# Start of test 7
#   Delete One file from dira and verify it is not deleted using the A>B  argument
  $hashref = (
     'dira',      $dira,
     'dirb',      $dirb
  );
  $ref=File::Repl->New($hashref);
  $ref->Update('.*','A>B',1);
  undef $ref;
# deem this successful if ALL files have been replicated successfully from a to be
  $success = 1;
  @afiles = @files;
  $tstfile = pop @afiles;
  $tstfile = $atarget . '/' . $tstfile;
  unlink $tstfile || carp ("Failed to delete $tstfile ($!)\n");


TEST7: foreach (@files) {
    if ( (&_s4($atarget . '/' . $_,  $btarget . '/' . $_)) == 0 ) {
      print "   file $_ replicated from $atarget to $btarget - ok\n" if $debug;
      print "." unless $debug;
    }else{
      carp ("   file $_ did not replicate from $atarget to $btarget - not ok\n");
      $success = 0;
      last TEST7;
    }
  }if ( $success eq 1 ) {
    print "\nok 7\n";
    $testsok ++;
  }else{
    print "\nnot ok 7\n";
  }
  $testsrun ++;
}
# End of test 7
#--------------------------------------------------------------
sub _t8 {
# Start of test 8
#   Test Delete method.  Delete one file from dira
  &_s1($dira,@files);   # Create source and data directories
  my($tfile) = "$atarget/bar.pl";
  $success = 0;
  if ( -f $tfile ){
#   for the test to succeed the test file must be installed, so set to 2
    $success = 2;
    #print "test file $tfile installed\n";
  }

  %hash = (
     dira       => $dira,
     dirb       => $dira,
     verbose    => 0,
  );
  $ref=File::Repl->New(\%hash);
  $ref->Delete('bar\.pl', 1);
  print "." unless $debug;
  if ( -f $tfile ){
    $success = 0;
    print "test file $tfile remains\n";
  }elsif( $success == 2) {
#   only get here if the file does not remain, but was installed
    $success = 1;
    print "test file deleted succesfully\n" if $debug;
  }
  print "failed to remove test file\n" unless ($success == 1);
  undef $ref;
# deem this successful if ALL files have been replicated successfully from a to be
  
  if ( $success eq 1 ) {
    print "\nok 8\n";
    $testsok ++;
  }else{
    print "\nnot ok 8\n";
  }
  $testsrun ++;
}
# End of test 8


# subs to delete and create the two test directory structures.
sub _s1 {
  my($now);
  _s3 ($dira) if -d $dira; 
  _s3 ($dirb) if -d $dirb;
  _s2 ($atarget);
  _s2 ($dirb);
  $now = time;
  foreach (@files) {
    my ($file) = $atarget . '/' . $_;
    open (A,">$file") || carp ("Unable to create file $file ($!) \n");
    printf A "#  Test File $_\n\n\n# End of Test File $_";
    utime $now, $now, $file;
    close A;
  }
}

# sub to test a directory tree exists, and if not to create it
sub _s2 {
  my($Dir) = @_;
  return if (-d $Dir); # Quit if the directory exists
  $Dir =~ /(.*)\/([^\/]*)/;
  my($parent,$dir) = ($1,$2);
  &_s2($parent) if (!-d $parent);  # Create the parent if it does not exist
  mkdir ($Dir, 0777) || carp ("Unable to create directory $Dir\n");
};

#  sub to delete a directory tree
sub _s3{
  my($root)=@_;
  my(@dirlist,$dir);
  find(\&_s3b,$root);
  find(\&_s3a,$root);
  while ( @dirlist ) {
    $dir = pop(@dirlist);
    rmdir($dir) || carp ("   -   unable to remove $dir ($!)\n");
  }
  # sub to list all directories in a directory tree
  sub _s3a {
    if ( -d ) {
      push (@dirlist,$File::Find::name);
    }
  }
  # sub to delete all files in a directory tree
  sub _s3b {
    if ( -f ) {
      unlink($File::Find::name) || carp ("   -   unable to remove $File::Find::name ($!)\n");
    }
  }
}

# sub to compare two files - return 0 for success
sub _s4 {
  my ($file1,$file2) = @_;
  my ($debug) = 0;
  print "testing $file1 and $file2\n" if $debug;
  unless ( -e $file1 ) {
    print "   $file1 does not exist ($!)\n" if $debug;
    return 1;
  }
  unless ( -e $file2 ) {
    print "   $file1 does not exist ($!)\n" if $debug;
    return 2;
  }
  if (compare($file1,$file2) != 0) {
    print "   files $file1 and $file2 are different\n" if $debug;
    return 3;
  }
  my($dev1,$ino1,$mode1,$nlink1,$uid1,$gid1,$rdev1,$size1,
    $atime1,$mtime1,$ctime1,$blksize1,$blocks1)
    = stat($file1);
  my($dev2,$ino2,$mode2,$nlink2,$uid2,$gid2,$rdev2,$size2,
    $atime2,$mtime2,$ctime2,$blksize2,$blocks2)
    = stat($file2);
  if ( $mtime1 != $mtime2) {
    if ( $debug ) {
      print "   files have different mtime's\n";
      printf "      %20s  %10d\n",$file1,$mtime1; 
      printf "      %20s  %10d\n",$file2,$mtime2;
    }
    if ( $mtime1 > $mtime2 ) {
      return 4;
    }else{
      return 5;
    }
  }
  return 0;
}
  


END {
  if ( $loaded ) {
    print "\n$testsok of $testsrun tests passed.\n";
  }else{
    print "not ok 1\n" unless $loaded;
    print "0 tests of $testsrun passed.\n";
    }
}
