# This file is auto-generated by the Perl DateTime Suite time zone
# code generator (0.01) This code generator comes with the
# DateTime::TimeZone module distribution in the tools/ directory
#
# Generated from Swift_Current.
#
# Do not edit this file directly.
#
package DateTime::TimeZone::America::Swift_Current;

use strict;

use Class::Singleton;
use DateTime::TimeZone;
use DateTime::TimeZone::OlsonDB;

@DateTime::TimeZone::America::Swift_Current::ISA = ( 'Class::Singleton', 'DateTime::TimeZone' );

my $spans =
[
  {
    'short_name' => 'LMT',
    'utc_end' => '60105481880',
    'utc_start' => DateTime::TimeZone::NEG_INFINITY,
    'local_end' => '60105456000',
    'is_dst' => 0,
    'offset' => -25880,
    'local_start' => '-inf'
  },
  {
    'short_name' => 'MT',
    'utc_end' => '60503619600',
    'utc_start' => '60105481880',
    'local_end' => '60503594400',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '60105456680'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '60520896000',
    'utc_start' => '60503619600',
    'local_end' => '60520874400',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '60503598000'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61255472400',
    'utc_start' => '60520896000',
    'local_end' => '61255447200',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '60520870800'
  },
  {
    'short_name' => 'MWT',
    'utc_end' => '61370294400',
    'utc_start' => '61255472400',
    'local_end' => '61370272800',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61255450800'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61388442000',
    'utc_start' => '61370294400',
    'local_end' => '61388416800',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61370269200'
  },
  {
    'short_name' => 'MT',
    'utc_end' => '61402957200',
    'utc_start' => '61388442000',
    'local_end' => '61402932000',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61388416800'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61419891600',
    'utc_start' => '61402957200',
    'local_end' => '61419866400',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61402932000'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61433193600',
    'utc_start' => '61419891600',
    'local_end' => '61433172000',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61419870000'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61451341200',
    'utc_start' => '61433193600',
    'local_end' => '61451316000',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61433168400'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61464643200',
    'utc_start' => '61451341200',
    'local_end' => '61464621600',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61451319600'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61482790800',
    'utc_start' => '61464643200',
    'local_end' => '61482765600',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61464618000'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61496092800',
    'utc_start' => '61482790800',
    'local_end' => '61496071200',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61482769200'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61504556400',
    'utc_start' => '61496092800',
    'local_end' => '61504531200',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61496067600'
  },
  {
    'short_name' => 'MT',
    'utc_end' => '61735597200',
    'utc_start' => '61504556400',
    'local_end' => '61735572000',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61504531200'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61751318400',
    'utc_start' => '61735597200',
    'local_end' => '61751296800',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61735575600'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61798496400',
    'utc_start' => '61751318400',
    'local_end' => '61798471200',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61751293200'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61814217600',
    'utc_start' => '61798496400',
    'local_end' => '61814196000',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61798474800'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61829946000',
    'utc_start' => '61814217600',
    'local_end' => '61829920800',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61814192400'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61843248000',
    'utc_start' => '61829946000',
    'local_end' => '61843226400',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61829924400'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '61862000400',
    'utc_start' => '61843248000',
    'local_end' => '61861975200',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61843222800'
  },
  {
    'short_name' => 'MDT',
    'utc_end' => '61874697600',
    'utc_start' => '61862000400',
    'local_end' => '61874676000',
    'is_dst' => 1,
    'offset' => -21600,
    'local_start' => '61861978800'
  },
  {
    'short_name' => 'MST',
    'utc_end' => '62209155600',
    'utc_start' => '61874697600',
    'local_end' => '62209130400',
    'is_dst' => 0,
    'offset' => -25200,
    'local_start' => '61874672400'
  }
]
;

my $max_year = 2013;

sub _new_instance
{
    return shift->_init( @_, spans => $spans );
}

my $rules = [
  bless( {
    'letter' => 'D',
    'on' => 'Sun>=1',
    'save' => '1:00',
    'to' => 'max',
    'from' => '1987',
    'in' => 'Apr',
    'at' => '2:00',
    'type' => undef,
    'offset' => 3600
  }, 'DateTime::TimeZone::OlsonDB::Rule' ),
  bless( {
    'letter' => 'S',
    'on' => 'lastSun',
    'save' => '0',
    'to' => 'max',
    'from' => '1974',
    'in' => 'Oct',
    'at' => '2:00',
    'type' => undef,
    'offset' => 0
  }, 'DateTime::TimeZone::OlsonDB::Rule' )
]
;
my $last_observance = bless( {
  'until' => undef,
  'format' => 'CST',
  'gmtoff' => '-6:00',
  'rules' => undef,
  'offset' => -21600,
  'start' => bless( {
    'local_rd_secs' => 7200,
    'local_rd_days' => 720013,
    'language' => bless( {
      'month_numbers' => {},
      'am_pm' => [
        'AM',
        'PM'
      ],
      'ordinal_suffixes' => [],
      'month_abbreviations' => [
        'Jan',
        'Feb',
        'Mar',
        'Apr',
        'May',
        'Jun',
        'Jul',
        'Aug',
        'Sep',
        'Oct',
        'Nov',
        'Dec'
      ],
      'day_abbreviations' => [
        'Mon',
        'Tue',
        'Wed',
        'Thu',
        'Fri',
        'Sat',
        'Sun'
      ],
      'month_names' => [
        'January',
        'February',
        'March',
        'April',
        'May',
        'June',
        'July',
        'August',
        'September',
        'October',
        'November',
        'December'
      ],
      'day_numbers' => {},
      'day_names' => [
        'Monday',
        'Tuesday',
        'Wednesday',
        'Thursday',
        'Friday',
        'Saturday',
        'Sunday'
      ]
    }, 'DateTime::Language::English' ),
    'tz' => bless( {}, 'DateTime::TimeZone::UTC' ),
    'utc_rd_secs' => 7200,
    'utc_rd_days' => 720013,
    'local_c' => {
      'hour' => 2,
      'minute' => 0,
      'second' => 0,
      'month' => 4,
      'day_of_year' => 121,
      'day_of_week' => 7,
      'day' => 30,
      'year' => 1972
    }
  }, 'DateTime' )
}, 'DateTime::TimeZone::OlsonDB::Observance' )
;

sub _generate_spans_until_match
{
    my $self = shift;
    my $dt = shift;

    my $generate_until_year = $dt->utc_year + 1;

    my @changes;
    foreach my $rule (@$rules)
    {
        foreach my $year ( $max_year .. $generate_until_year )
        {
            my $next = $rule->date_for_year( $year, -21600 );

            # don't bother with changes we've seen already
            next if $next->{utc}->utc_rd_as_seconds < $self->{max_span}{utc_end};

            push @changes,
                DateTime::TimeZone::OlsonDB::Change->new
                    ( start_date => $next->{local},
                      short_name =>
                      sprintf( $last_observance->format, $rule->letter ),
                      observance => $last_observance,
                      rule       => $rule,
                    );
        }
    }

    $max_year = $generate_until_year;
    my @sorted = sort { $a->start_date <=> $b->start_date } @changes;

    my $seconds = $dt->utc_rd_as_seconds;
    my $match;

    for ( my $x = 1; $x < @sorted; $x++ )
    {
        my $last_offset =
            $x == 1 ? $self->{max_span}{offset} : $changes[ $x - 2 ]->offset;

        my $span =
            DateTime::TimeZone::OlsonDB::Change::two_changes_as_span
                ( @sorted[ $x - 1, $x ], $last_offset );

        push @{ $self->{spans} }, $span;

        $match = $span
            if $seconds >= $span->{utc_start} && $seconds < $span->{utc_end};
    }

    return $match;
}


1;

