#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 140 => 'absPeakAudioFilePath' },
	'actionadvised' => { 47 => 0x2a },
	'activearea' => { 41 => 0xc68d },
	'addoriginaldecisiondata' => { 20 => 0x11, 21 => 0x13, 24 => 0x14 },
	'address' => { 61 => 'Address' },
	'adjustmentmode' => { 125 => 0x15 },
	'advancedraw' => { 94 => 0x76a43203 },
	'advisory' => { 138 => 'Advisory' },
	'ae_iso' => { 109 => 0x2 },
	'aeaperture' => { 109 => 0x1 },
	'aebbracketvalue' => { 17 => 0x11 },
	'aebsequence' => { 18 => 0x9, 19 => 0x9, 20 => 0x8, 21 => 0x9, 24 => 0x9, 25 => 0x7 },
	'aebxv' => { 109 => 0x4 },
	'aedump' => { 114 => 0x209 },
	'aeexposuretime' => { 109 => 0x0 },
	'aeextra' => { 109 => 0x7 },
	'aeflashtv' => { 109 => 0x5 },
	'aelock' => { 100 => 0x201 },
	'aeprogrammode' => { 109 => 0x6 },
	'aesetting' => { 1 => 0x21 },
	'aexv' => { 109 => 0x3 },
	'afareamode' => { 78 => 0x0 },
	'afareas' => { 100 => 0x304 },
	'afassist' => { 18 => 0x5, 25 => 0x5 },
	'afassistbeam' => { 20 => 0x4, 21 => 0x5, 22 => 0x4, 23 => 0x4, 24 => 0x5 },
	'afmode' => { 125 => 0x5 },
	'afpoint' => { 1 => 0x13, 37 => 0x18, 78 => 0x1 },
	'afpointactivationarea' => { 19 => 0x11, 24 => 0x11 },
	'afpointillumination' => { 19 => 0xa },
	'afpointregistration' => { 18 => 0x7 },
	'afpoints' => { 72 => 0x10 },
	'afpointselected' => { 114 => 0xe },
	'afpointselection' => { 19 => 0xb },
	'afpointselectionmethod' => { 20 => 0xc, 21 => 0xd, 24 => 0xd },
	'afpointspotmetering' => { 19 => 0xd },
	'afpointsused' => { 14 => [0x16,0x1a], 78 => 0x2, 114 => 0x3c },
	'afpointsused2' => { 17 => 0xe },
	'afpointsused5d' => { 0 => 0x38 },
	'afresponse' => { 84 => 0xad },
	'afsearch' => { 100 => 0x303 },
	'aiservotrackingsensitivity' => { 19 => 0x14 },
	'album' => { 140 => 'album' },
	'alreadyapplied' => { 130 => 'AlreadyApplied' },
	'alttapename' => { 140 => 'altTapeName' },
	'alttimecodetimeformat' => { 140 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 140 => 'altTimecodeTimeValue' },
	'antialiasstrength' => { 41 => 0xc632 },
	'aperturevalue' => { 41 => 0x9202, 104 => 0x1002, 133 => 'ApertureValue' },
	'applicationrecordversion' => { 47 => 0x0 },
	'armidentifier' => { 48 => 0x78 },
	'armversion' => { 48 => 0x7a },
	'artist' => { 41 => 0x13b, 107 => 'Artist', 137 => 'Artist', 140 => 'artist' },
	'asshotwhitexy' => { 41 => 0xc629 },
	'assistbuttonfunction' => { 18 => 0xd },
	'audio' => { 108 => 0x20 },
	'audiochanneltype' => { 140 => 'audioChannelType' },
	'audiocompression' => { 55 => 'Compression' },
	'audiocompressor' => { 140 => 'audioCompressor' },
	'audioduration' => { 47 => 0x99 },
	'audiomoddate' => { 140 => 'audioModDate' },
	'audiooutcue' => { 47 => 0x9a },
	'audiosamplerate' => { 140 => 'audioSampleRate' },
	'audiosampletype' => { 140 => 'audioSampleType' },
	'audiosamplingrate' => { 47 => 0x97 },
	'audiosamplingresolution' => { 47 => 0x98 },
	'audiotype' => { 47 => 0x96 },
	'author' => { 57 => 'Author', 107 => 'Author', 121 => 'Author', 135 => 'Author' },
	'authorsposition' => { 136 => 'AuthorsPosition' },
	'autoafpoint' => { 114 => 0xf },
	'autobracket' => { 125 => 0x19 },
	'autobracketing' => { 45 => 0x1100, 114 => 0x18 },
	'autobracketrelease' => { 84 => 0x8a },
	'autobrightness' => { 130 => 'AutoBrightness' },
	'autocontrast' => { 130 => 'AutoContrast' },
	'autoexposure' => { 130 => 'AutoExposure' },
	'autoexposurebracketing' => { 17 => 0x10 },
	'autofocus' => { 102 => 0x209 },
	'autoiso' => { 17 => 0x1, 38 => 0x3008 },
	'autorotate' => { 17 => 0x1b },
	'autoshadows' => { 130 => 'AutoShadows' },
	'auxiliarylens' => { 84 => 0x82 },
	'avvalue' => { 28 => 0x2 },
	'azimuth' => { 65 => 'Azimuth' },
	'baseiso' => { 17 => 0x2, 32 => 0x101c },
	'baselineexposure' => { 41 => 0xc62a },
	'baselinenoise' => { 41 => 0xc62b },
	'baselinesharpness' => { 41 => 0xc62c },
	'baseurl' => { 138 => 'BaseURL' },
	'batteryadbodyload' => { 110 => 0x3 },
	'batteryadbodynoload' => { 110 => 0x2 },
	'batteryadgripload' => { 110 => 0x5 },
	'batteryadgripnoload' => { 110 => 0x4 },
	'batterybodygripstates' => { 110 => 0x1 },
	'batterytype' => { 110 => 0x0 },
	'bayergreensplit' => { 41 => 0xc62d },
	'bayerpattern' => { 75 => 0x17 },
	'beatspliceparamsriseindecibel' => { 140 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 140 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 140 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 41 => 0xc65c },
	'bestshotmode' => { 38 => 0x3007 },
	'bitdepth' => { 62 => 'BitDepth', 75 => 0x11, 87 => 0x41 },
	'bitspercomponent' => { 49 => 0x87 },
	'bitspersample' => { 41 => 0x102, 137 => 'BitsPerSample' },
	'blacklevel' => { 104 => 0x1012 },
	'blackpoint' => { 114 => 0x200 },
	'bluebalance' => { 104 => 0x1018, 114 => 0x1b },
	'bluecurvelimits' => { 36 => 0x1fe },
	'bluecurvepoints' => { 36 => 0x1d4 },
	'bluehue' => { 130 => 'BlueHue' },
	'bluesaturation' => { 130 => 'BlueSaturation' },
	'blurwarning' => { 45 => 0x1300 },
	'bodyfirmwareversion' => { 101 => 0x104 },
	'bracketmode' => { 8 => 0x3 },
	'bracketsequence' => { 38 => 0x301d },
	'bracketshotnumber' => { 8 => 0x5 },
	'bracketstep' => { 70 => 0xe },
	'bracketvalue' => { 8 => 0x4 },
	'brightness' => { 41 => 0xfe53, 56 => 'Brightness', 70 => 0x2c, 130 => 'Brightness' },
	'brightnessadj' => { 36 => 0x114, 89 => 0x0 },
	'brightnessvalue' => { 41 => 0x9203, 104 => 0x1003, 133 => 'BrightnessValue' },
	'bulbduration' => { 17 => 0x18 },
	'burstmode' => { 51 => 0xa, 108 => 0x2a },
	'burstmode2' => { 51 => 0x18 },
	'bwfilter' => { 70 => 0x2a, 76 => 0x39 },
	'bwmode' => { 104 => 0x203 },
	'by-line' => { 47 => 0x50 },
	'by-linetitle' => { 47 => 0x55 },
	'calibrationilluminant1' => { 41 => 0xc65a },
	'calibrationilluminant2' => { 41 => 0xc65b },
	'cameraid' => { 104 => 0x209, 124 => 0x209 },
	'cameraiso' => { 1 => 0x10 },
	'cameraprofile' => { 130 => 'CameraProfile' },
	'cameraserialnumber' => { 41 => 0xc62f, 127 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 100 => 0x0 },
	'cameratemperature' => { 114 => 0x47 },
	'cameratype' => { 17 => 0x1a, 104 => 0x207 },
	'cameratype2' => { 101 => 0x100 },
	'canonexposuremode' => { 1 => 0x14 },
	'canonfiledescription' => { 32 => 0x805 },
	'canonfilelength' => { 11 => 0xe },
	'canonfirmwareversion' => { 11 => 0x7, 32 => 0x80b },
	'canonflashinfo' => { 32 => 0x1028 },
	'canonflashmode' => { 1 => 0x4 },
	'canonimageheight' => { 14 => 0x3 },
	'canonimageheightasshot' => { 14 => 0x5 },
	'canonimagesize' => { 1 => 0xa },
	'canonimagetype' => { 11 => 0x6, 32 => 0x815 },
	'canonimagewidth' => { 14 => 0x2 },
	'canonimagewidthasshot' => { 14 => 0x4 },
	'canonmodelid' => { 11 => 0x10 },
	'caption-abstract' => { 47 => 0x78 },
	'captionwriter' => { 136 => 'CaptionWriter' },
	'casioimagesize' => { 38 => 0x9 },
	'category' => { 47 => 0xf, 136 => 'Category' },
	'ccdisosensitivity' => { 38 => 0x3014 },
	'ccdscanmode' => { 104 => 0x1039 },
	'ccdsensitivity' => { 37 => 0x14, 88 => 0x6 },
	'celllength' => { 41 => 0x109 },
	'cellwidth' => { 41 => 0x108 },
	'certificate' => { 143 => 'Certificate' },
	'cfapattern' => { 41 => 0xa302 },
	'cfapatterncolumns' => { 133 => 'CFAPatternColumns' },
	'cfapatternrows' => { 133 => 'CFAPatternRows' },
	'cfapatternvalues' => { 133 => 'CFAPatternValues' },
	'channels' => { 55 => 'Channels' },
	'checkmark' => { 36 => 0x26a },
	'chromablurradius' => { 41 => 0xc631 },
	'chromaticaberrationb' => { 130 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 130 => 'ChromaticAberrationR' },
	'city' => { 47 => 0x5a, 61 => 'City', 136 => 'City' },
	'classifystate' => { 47 => 0xe1 },
	'codec' => { 69 => 'Codec' },
	'codedcharacterset' => { 48 => 0x5a },
	'coloraberrationcontrol' => { 94 => 0xc89224b },
	'coloradjustment' => { 125 => 0x14 },
	'coloradjustmentmode' => { 124 => 0x210 },
	'colorantsa' => { 144 => 'ColorantsA' },
	'colorantsb' => { 144 => 'ColorantsB' },
	'colorantsblack' => { 144 => 'ColorantsBlack' },
	'colorantsblue' => { 144 => 'ColorantsBlue' },
	'colorantscyan' => { 144 => 'ColorantsCyan' },
	'colorantsgreen' => { 144 => 'ColorantsGreen' },
	'colorantsl' => { 144 => 'ColorantsL' },
	'colorantsmagenta' => { 144 => 'ColorantsMagenta' },
	'colorantsmode' => { 144 => 'ColorantsMode' },
	'colorantsred' => { 144 => 'ColorantsRed' },
	'colorantsswatchname' => { 144 => 'ColorantsSwatchName' },
	'colorantstype' => { 144 => 'ColorantsType' },
	'colorantsyellow' => { 144 => 'ColorantsYellow' },
	'colorbalance' => { 56 => 'ColorBalance' },
	'colorbalance1' => { 84 => 0xc },
	'colorbalanceadj' => { 94 => 0x76a43202 },
	'colorbalanceblue' => { 70 => 0x1e },
	'colorbalancegreen' => { 70 => 0x1d },
	'colorbalancered' => { 70 => 0x1c },
	'colorbooster' => { 94 => 0x5f0e7d23 },
	'colorboostlevel' => { 90 => 0x1 },
	'colorboosttype' => { 90 => 0x0 },
	'colorclass' => { 116 => 0xde },
	'colorcontrol' => { 104 => 0x102b },
	'coloreffect' => { 108 => 0x28 },
	'colorfilter' => { 70 => 0x29, 76 => 0x38 },
	'colorgain' => { 87 => 0x51 },
	'colorhue' => { 6 => 0x2, 84 => 0x8d },
	'colormatrix' => { 7 => 0xa, 103 => 0x200, 104 => 0x1011 },
	'colormode' => { 38 => 0x3015, 45 => 0x1210, 51 => 0x66, 70 => 0x28, 73 => 0x16, 74 => 0x101, 76 => 0x7, 84 => 0x3, 88 => 0x4, 104 => 0x101, 108 => 0x32, 126 => 0xb029, 136 => 'ColorMode' },
	'colormoirereduction' => { 95 => 0x5 },
	'colornoisereduction' => { 130 => 'ColorNoiseReduction' },
	'colorplanes' => { 44 => 0x2 },
	'colorprofile' => { 70 => 0x33 },
	'colorrepresentation' => { 49 => 0x3c },
	'colorsequence' => { 49 => 0x41 },
	'colorspace' => { 6 => 0x3, 11 => 0xb4, 32 => 0x10b4, 41 => 0xa001, 62 => 'ColorSpace', 72 => 0x25, 84 => 0x1e, 100 => 0x507, 114 => 0x37, 125 => 0xb, 133 => 'ColorSpace' },
	'colortempasshot' => { 3 => 0x1d, 4 => 0x1c, 5 => 0x43 },
	'colortempauto' => { 3 => 0x22, 4 => 0x26, 5 => 0x48 },
	'colortempcloudy' => { 3 => 0x31, 4 => 0x35, 5 => 0x5c },
	'colortempcustom' => { 5 => 0x84 },
	'colortempcustom1' => { 3 => 0x45 },
	'colortempcustom2' => { 3 => 0x4a },
	'colortempdaylight' => { 3 => 0x27, 4 => 0x2b, 5 => 0x52 },
	'colortemperature' => { 7 => 0x9, 11 => 0xae, 16 => 0x9, 32 => 0x10ae, 56 => 'ColorTemperature', 71 => [0x6e,0x49], 72 => 0x3f, 73 => 0x5e, 74 => 0x10b, 76 => 0x3c },
	'colortempflash' => { 3 => 0x40, 4 => 0x49, 5 => 0x70 },
	'colortempfluorescent' => { 3 => 0x3b, 4 => 0x3f, 5 => 0x66 },
	'colortempkelvin' => { 4 => 0x44, 5 => 0x6b },
	'colortempmeasured' => { 5 => 0x4d },
	'colortemppc1' => { 4 => 0x94, 5 => 0x75 },
	'colortemppc2' => { 4 => 0x99, 5 => 0x7a },
	'colortemppc3' => { 4 => 0x9e, 5 => 0x7f },
	'colortempshade' => { 3 => 0x2c, 4 => 0x30, 5 => 0x57 },
	'colortemptungsten' => { 3 => 0x36, 4 => 0x3a, 5 => 0x61 },
	'colortempunknown' => { 4 => 0x21 },
	'colortempunknown10' => { 4 => 0x76 },
	'colortempunknown11' => { 4 => 0x7b },
	'colortempunknown12' => { 4 => 0x80 },
	'colortempunknown13' => { 4 => 0x85 },
	'colortempunknown14' => { 4 => 0x8a },
	'colortempunknown15' => { 4 => 0x8f },
	'colortempunknown16' => { 4 => 0xa3 },
	'colortempunknown2' => { 4 => 0x4e },
	'colortempunknown3' => { 4 => 0x53 },
	'colortempunknown4' => { 4 => 0x58 },
	'colortempunknown5' => { 4 => 0x5d },
	'colortempunknown6' => { 4 => 0x62 },
	'colortempunknown7' => { 4 => 0x67 },
	'colortempunknown8' => { 4 => 0x6c },
	'colortempunknown9' => { 4 => 0x71 },
	'colortone' => { 1 => 0x2a },
	'colortoneadj' => { 36 => 0x11e },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 42 => 'Comment', 57 => 'Comment', 107 => 'Comment' },
	'componentsconfiguration' => { 41 => 0x9101, 62 => 'Components', 133 => 'ComponentsConfiguration' },
	'componentversion' => { 32 => 0x80c },
	'composer' => { 140 => 'composer' },
	'compressedbitsperpixel' => { 41 => 0x9102, 133 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 74 => 0x40, 104 => 0x40 },
	'compression' => { 41 => 0x103, 137 => 'Compression' },
	'compressionfactor' => { 100 => 0x50d },
	'compressionratio' => { 62 => 'Compression', 104 => 0x1034 },
	'constrainedcropheight' => { 36 => 0x266, 116 => 0xd6 },
	'constrainedcropwidth' => { 36 => 0x262, 116 => 0xd5 },
	'contact' => { 47 => 0x76 },
	'contentlocationcode' => { 47 => 0x1a },
	'contentlocationname' => { 47 => 0x1b },
	'continuousdrive' => { 1 => 0x5 },
	'contrast' => { 1 => 0xd, 37 => 0xc, 38 => [0x3012,0x20], 41 => [0xa408,0xfe54], 45 => 0x1004, 56 => 'Contrast', 70 => 0x20, 71 => 0x31, 72 => 0x27, 73 => 0x19, 76 => 0x2, 104 => 0x1029, 108 => 0x2c, 114 => 0x20, 125 => 0xd, 130 => 'Contrast', 133 => 'Contrast' },
	'contrastadj' => { 36 => 0x115 },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 100 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributedmediaduration' => { 140 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 140 => 'contributedMediaManaged' },
	'contributedmediapath' => { 140 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 140 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 140 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 140 => 'contributedMediaWebStatement' },
	'contributor' => { 131 => 'contributor' },
	'contributors' => { 57 => 'Contributors' },
	'converter' => { 41 => 0xfe4d, 88 => 0xb },
	'copyright' => { 41 => 0x8298, 57 => 'Copyright', 107 => 'Copyright', 121 => 'Copyright', 137 => 'Copyright', 140 => 'copyright' },
	'copyrightflag' => { 119 => 0x40a },
	'copyrightnotice' => { 47 => 0x74 },
	'coringfilter' => { 104 => 0x102d },
	'country' => { 61 => 'Country', 136 => 'Country' },
	'country-primarylocationcode' => { 47 => 0x64 },
	'country-primarylocationname' => { 47 => 0x65 },
	'countrycode' => { 117 => 'CountryCode', 134 => 'CountryCode' },
	'coverage' => { 131 => 'coverage' },
	'crc32' => { 132 => 'crc32' },
	'createdate' => { 41 => 0x9004, 57 => 'CreateDate', 121 => 'CreationDate', 138 => 'CreateDate' },
	'creationdate' => { 135 => 'CreationDate' },
	'creationtime' => { 107 => 'Creation Time' },
	'creator' => { 121 => 'Creator', 131 => 'creator', 135 => 'Creator' },
	'creatorcontactinfociadrcity' => { 134 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 134 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 134 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 134 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 134 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 134 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 134 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 134 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 138 => 'CreatorTool' },
	'credit' => { 47 => 0x6e, 136 => 'Credit' },
	'creditlinereq' => { 142 => 'CreditLineReq' },
	'cropactive' => { 36 => 0x244 },
	'cropangle' => { 130 => 'CropAngle' },
	'cropaspectratio' => { 36 => 0x260 },
	'cropbottom' => { 44 => 0x9, 91 => 0x36, 116 => 0xdc, 130 => 'CropBottom' },
	'cropheight' => { 36 => 0x24c, 130 => 'CropHeight' },
	'crophispeed' => { 84 => 0x1b },
	'cropleft' => { 36 => 0x246, 44 => 0x6, 91 => 0x1e, 116 => 0xd9, 130 => 'CropLeft' },
	'cropoutputscale' => { 91 => 0xbe },
	'cropright' => { 44 => 0x8, 91 => 0x2e, 116 => 0xdb, 130 => 'CropRight' },
	'croprotation' => { 44 => 0xb },
	'croptop' => { 36 => 0x248, 44 => 0x7, 91 => 0x26, 116 => 0xda, 130 => 'CropTop' },
	'cropunits' => { 130 => 'CropUnits' },
	'cropwidth' => { 36 => 0x24a, 130 => 'CropWidth' },
	'curves' => { 94 => 0x76a43201 },
	'customrendered' => { 41 => 0xa401, 133 => 'CustomRendered' },
	'customsaturation' => { 100 => 0x503 },
	'd-lightinghq' => { 94 => 0x2175eb78 },
	'd-lightinghqselected' => { 94 => 0x6a6e36b6 },
	'd-lightinghs' => { 94 => 0xce5554aa },
	'd-lightinghsadjustment' => { 93 => 0x0 },
	'd-lightinghscolorboost' => { 92 => 0x2, 93 => 0x1 },
	'd-lightinghshighlight' => { 92 => 0x1 },
	'd-lightinghsshadow' => { 92 => 0x0 },
	'datacompressionmethod' => { 49 => 0x6e },
	'dataimprint' => { 70 => 0x34 },
	'date' => { 114 => 0x6, 131 => 'date' },
	'dateacquired' => { 127 => 'DateAcquired' },
	'datecreated' => { 47 => 0x37, 136 => 'DateCreated' },
	'datesent' => { 48 => 0x46 },
	'datetime' => { 137 => 'DateTime' },
	'datetimedigitized' => { 133 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 35 => 0x0, 41 => 0x9003, 57 => 'OriginalDate', 133 => 'DateTimeOriginal' },
	'datetimestamp' => { 51 => 0x64 },
	'declination' => { 65 => 'Declination' },
	'decposition' => { 70 => 0x32 },
	'defaultcroporigin' => { 41 => 0xc61f },
	'defaultcropsize' => { 41 => 0xc620 },
	'defaultscale' => { 41 => 0xc61e },
	'deletedimagecount' => { 84 => 0xa6 },
	'derivedfromdocumentid' => { 141 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 141 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 141 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 141 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 141 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 141 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 141 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 141 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 141 => 'DerivedFromVersionID' },
	'description' => { 107 => 'Description', 131 => 'description' },
	'destination' => { 48 => 0x5 },
	'destinationcity' => { 114 => 0x24 },
	'destinationcitycode' => { 114 => 0x1001 },
	'destinationdst' => { 114 => 0x26 },
	'developmentdynamicrange' => { 45 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 133 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 133 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 133 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 47 => 0x3e },
	'digitalcreationtime' => { 47 => 0x3f },
	'digitalgain' => { 16 => 0xb },
	'digitalgem' => { 82 => 0x0 },
	'digitalice' => { 87 => 0x100 },
	'digitalroc' => { 86 => 0x0 },
	'digitalzoom' => { 1 => 0xc, 37 => 0xa, 51 => 0x68, 56 => 'DigitalZoom', 70 => 0xc, 84 => 0x86, 88 => 0xa, 104 => 0x204, 114 => 0x1e, 124 => 0x204 },
	'digitalzoomon' => { 124 => 0x21b },
	'digitalzoomratio' => { 41 => 0xa404, 133 => 'DigitalZoomRatio' },
	'directory' => { 42 => 'Directory' },
	'disclaimer' => { 107 => 'Disclaimer' },
	'displayaperture' => { 1 => 0x23 },
	'displayedunitsx' => { 120 => 0x2 },
	'displayedunitsy' => { 120 => 0x6 },
	'distance1' => { 51 => 0x28 },
	'distance2' => { 51 => 0x2c },
	'distance3' => { 51 => 0x30 },
	'distance4' => { 51 => 0x34 },
	'distortioncorrection' => { 100 => 0x50b },
	'distortioncorrection2' => { 103 => 0x1011 },
	'dngbackwardversion' => { 41 => 0xc613 },
	'dnglensinfo' => { 41 => 0xc630 },
	'dngversion' => { 41 => 0xc612 },
	'document' => { 107 => 'Document' },
	'documenthistory' => { 47 => 0xe7 },
	'documentid' => { 141 => 'DocumentID' },
	'documentname' => { 41 => 0x10d },
	'documentnotes' => { 47 => 0xe6 },
	'dotrange' => { 41 => 0x150 },
	'drivemode' => { 70 => 0x6, 73 => 0x1e, 114 => 0x34, 125 => 0x3 },
	'duration' => { 55 => 'Duration', 69 => 'Duration', 140 => 'duration' },
	'dynamicrange' => { 45 => 0x1400 },
	'dynamicrangemax' => { 36 => 0x7c },
	'dynamicrangemin' => { 36 => 0x7a },
	'dynamicrangesetting' => { 45 => 0x1402 },
	'easymode' => { 1 => 0xb },
	'edgenoisereduction' => { 95 => 0x4 },
	'editorialupdate' => { 47 => 0x8 },
	'editstatus' => { 47 => 0x7, 117 => 'EditStatus' },
	'elevation' => { 65 => 'Elevation' },
	'email' => { 57 => 'EMail' },
	'engineer' => { 140 => 'engineer' },
	'enhancedarktones' => { 89 => 0x8 },
	'enhancement' => { 37 => 0x16, 38 => 0x3016 },
	'envelopenumber' => { 48 => 0x28 },
	'envelopepriority' => { 48 => 0x3c },
	'enveloperecordversion' => { 48 => 0x0 },
	'epsonimageheight' => { 104 => 0x20c },
	'epsonimagewidth' => { 104 => 0x20b },
	'epsonsoftware' => { 104 => 0x20d },
	'equipmentversion' => { 101 => 0x0 },
	'ettlii' => { 20 => 0xd, 21 => 0xe, 22 => 0x7, 23 => 0x7, 24 => 0xe },
	'excursiontolerance' => { 49 => 0x82 },
	'exifcamerainfo' => { 47 => 0xe8 },
	'exifimagelength' => { 41 => 0xa003, 133 => 'PixelYDimension' },
	'exifimagewidth' => { 41 => 0xa002, 133 => 'PixelXDimension' },
	'exifversion' => { 41 => 0x9000, 133 => 'ExifVersion' },
	'expirationdate' => { 47 => 0x25 },
	'expirationtime' => { 47 => 0x26 },
	'exposure' => { 41 => 0xfe51, 130 => 'Exposure' },
	'exposurebracketvalue' => { 84 => 0x19 },
	'exposurecompensation' => { 17 => 0x6, 28 => 0x0, 41 => 0x9204, 51 => 0x24, 56 => 'ExposureComp', 70 => 0xd, 71 => 0x53, 72 => 0x1e, 73 => 0x1, 104 => 0x1006, 114 => 0x16, 125 => 0xc, 133 => 'ExposureBiasValue' },
	'exposuredifference' => { 84 => 0xe },
	'exposureindex' => { 41 => 0xa215, 133 => 'ExposureIndex' },
	'exposurelevelincrements' => { 18 => 0x6, 19 => 0x6, 20 => 0x5, 21 => 0x6, 22 => 0x5, 23 => 0x5, 24 => 0x6, 25 => 0x4 },
	'exposuremode' => { 41 => 0xa402, 56 => 'ExposureMode', 70 => 0x1, 71 => 0xa, 72 => 0x0, 73 => 0x0, 100 => 0x200, 125 => 0x8, 133 => 'ExposureMode' },
	'exposureprogram' => { 41 => 0x8822, 133 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 17 => 0x16, 41 => 0x829a, 51 => 0x20, 53 => 0x38, 56 => 'ExposureTime', 70 => 0x9, 71 => 0x35, 72 => 0x48, 114 => 0x12, 133 => 'ExposureTime' },
	'exposurewarning' => { 45 => 0x1302 },
	'extender' => { 101 => 0x301 },
	'extenderfirmwareversion' => { 101 => 0x304 },
	'extendermagnification' => { 58 => 'Magnification' },
	'extendermake' => { 58 => 'Make' },
	'extendermodel' => { 58 => 'Model', 101 => 0x303 },
	'extenderserialnumber' => { 58 => 'SerialNumber', 101 => 0x302 },
	'externalflash' => { 102 => 0x1201 },
	'externalflashbounce' => { 104 => 0x1026 },
	'externalflashmode' => { 104 => 0x1028, 112 => 0x2 },
	'externalflashzoom' => { 104 => 0x1027 },
	'ffid' => { 132 => 'ffid' },
	'filedatarate' => { 140 => 'fileDataRate' },
	'fileformat' => { 30 => 0x0, 48 => 0x14 },
	'filemodifydate' => { 42 => 'FileModifyDate' },
	'filename' => { 42 => 'FileName' },
	'filenumber' => { 8 => 0x1, 11 => 0x8, 32 => 0x1817 },
	'filenumbermemory' => { 70 => 0x1a },
	'filesource' => { 41 => 0xa300, 45 => 0x8000, 133 => 'FileSource' },
	'fileversion' => { 48 => 0x16 },
	'fillflashautoreduction' => { 18 => 0xe, 19 => 0xe, 25 => 0xa },
	'fillorder' => { 41 => 0x10a },
	'filmmode' => { 45 => 0x1401 },
	'filmtype' => { 87 => 0x2 },
	'filter' => { 37 => 0x17, 38 => 0x3017 },
	'filtereffect' => { 8 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 19 => 0x1 },
	'firmware' => { 125 => 0x17, 128 => 'Firmware' },
	'firmwaredate' => { 38 => 0x2001 },
	'firmwareid' => { 75 => 0x0 },
	'firmwarerevision' => { 0 => 0xa4, 11 => 0x1e },
	'firmwareversion' => { 56 => 'FirmwareVersion', 84 => 0x1, 108 => 0x2 },
	'fixtureidentifier' => { 47 => 0x16 },
	'flash' => { 41 => 0x9209, 71 => 0x1f, 72 => 0x15 },
	'flashactivity' => { 1 => 0x1c },
	'flashadump' => { 114 => 0x20a },
	'flashbdump' => { 114 => 0x20b },
	'flashbias' => { 108 => 0x24 },
	'flashbits' => { 1 => 0x1d },
	'flashchargelevel' => { 104 => 0x1010 },
	'flashcompensation' => { 128 => 'FlashCompensation' },
	'flashdevice' => { 104 => 0x1005 },
	'flashdistance' => { 38 => 0x2034 },
	'flashenergy' => { 41 => 0xa20b, 133 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 84 => 0x18 },
	'flashexposurecomp' => { 17 => 0xf, 59 => 'ExposureComp', 70 => 0x23, 74 => 0x104, 84 => 0x12, 104 => 0x1023, 114 => 0x4d },
	'flashexposurecompensation' => { 100 => 0x401 },
	'flashfired' => { 51 => 0x5d, 59 => 'Fired', 70 => 0x14, 133 => 'FlashFired' },
	'flashfiring' => { 20 => 0x6, 21 => 0x7, 24 => 0x7 },
	'flashfirmwareversion' => { 101 => 0x1002 },
	'flashfunction' => { 133 => 'FlashFunction' },
	'flashguidenumber' => { 17 => 0xd, 29 => 0x0, 59 => 'GuideNumber' },
	'flashintensity' => { 37 => [0x19,0x5] },
	'flashmake' => { 59 => 'Make' },
	'flashmanufacturer' => { 127 => 'FlashManufacturer' },
	'flashmetering' => { 70 => 0x3f },
	'flashmode' => { 37 => 0x4, 51 => 0x5c, 59 => 'Mode', 70 => 0x2, 84 => 0x87, 100 => 0x400, 104 => 0x1004, 114 => 0xc, 122 => 0x20, 124 => 0x225, 133 => 'FlashMode' },
	'flashmodecode' => { 112 => 0x1 },
	'flashmodel' => { 59 => 'Model', 101 => 0x1001, 127 => 'FlashModel' },
	'flashpixversion' => { 41 => 0xa000, 133 => 'FlashpixVersion' },
	'flashredeyemode' => { 133 => 'FlashRedEyeMode' },
	'flashreturn' => { 133 => 'FlashReturn' },
	'flashserialnumber' => { 59 => 'SerialNumber', 101 => 0x1003 },
	'flashsetting' => { 84 => 0x8 },
	'flashstatus' => { 112 => 0x0 },
	'flashstrength' => { 45 => 0x1011 },
	'flashsyncspeedav' => { 18 => 0x3, 20 => 0x2, 21 => 0x3, 22 => 0x2, 23 => 0x2, 24 => 0x3, 25 => 0x6 },
	'flashthreshold' => { 29 => 0x1 },
	'flashtype' => { 59 => 'Type', 84 => 0x9, 101 => 0x1000 },
	'flickerreduce' => { 124 => 0x218 },
	'fliphorizontal' => { 94 => 0x76a43206 },
	'fnumber' => { 17 => 0x15, 41 => 0x829d, 51 => 0x1e, 53 => 0x3c, 63 => 'FNumber', 70 => 0xa, 71 => 0x36, 72 => 0x47, 114 => 0x13, 133 => 'FNumber' },
	'focallength' => { 0 => 0xa, 10 => 0x1, 38 => 0x1d, 41 => 0x920a, 63 => 'FocalLength', 70 => 0x12, 114 => 0x1d, 133 => 'FocalLength' },
	'focallengthin35mmformat' => { 41 => 0xa405, 133 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 101 => 0x103, 104 => 0x205 },
	'focalplaneresolutionunit' => { 41 => 0xa210, 133 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 41 => 0xa20e, 133 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 10 => 0x2 },
	'focalplaneyresolution' => { 41 => 0xa20f, 133 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 10 => 0x3 },
	'focaltype' => { 0 => 0x2d, 10 => 0x0 },
	'focalunits' => { 1 => 0x19 },
	'focus' => { 88 => 0x8 },
	'focusarea' => { 70 => 0x31 },
	'focuscontinuous' => { 1 => 0x20 },
	'focusdistance' => { 63 => 'FocusDistance', 70 => 0x13, 102 => 0x305 },
	'focusdistancelower' => { 17 => 0x14 },
	'focusdistanceupper' => { 17 => 0x13 },
	'focusinfoversion' => { 102 => 0x0 },
	'focusingscreen' => { 19 => 0x0, 24 => 0x0 },
	'focusmode' => { 1 => 0x7, 37 => 0x3, 38 => [0x3003,0xd], 45 => 0x1021, 51 => 0x38, 56 => 'FocusMode', 70 => 0x30, 72 => 0xe, 84 => 0x7, 100 => 0x301, 104 => 0x100b, 108 => 0x7, 114 => 0xd },
	'focuspixel' => { 45 => 0x1023 },
	'focusposition' => { 114 => 0x10 },
	'focusprocess' => { 100 => 0x302 },
	'focusrange' => { 1 => 0x12 },
	'focussetting' => { 125 => 0x6 },
	'focusstepcount' => { 104 => 0x100e },
	'focuswarning' => { 45 => 0x1301 },
	'foldername' => { 70 => 0x27 },
	'fontschildfontfiles' => { 144 => 'FontsChildFontFiles' },
	'fontscomposite' => { 144 => 'FontsComposite' },
	'fontsfontface' => { 144 => 'FontsFontFace' },
	'fontsfontfamily' => { 144 => 'FontsFontFamily' },
	'fontsfontfilename' => { 144 => 'FontsFontFileName' },
	'fontsfontname' => { 144 => 'FontsFontName' },
	'fontsfonttype' => { 144 => 'FontsFontType' },
	'fontsversionstring' => { 144 => 'FontsVersionString' },
	'for' => { 121 => 'For' },
	'format' => { 131 => 'format' },
	'framenum' => { 116 => 0xd7 },
	'framenumber' => { 45 => 0x8003, 114 => 0x29 },
	'freebytes' => { 32 => 0x1 },
	'freememorycardimages' => { 71 => [0x37,0x54], 72 => [0x2d,0x4a] },
	'fujiflashmode' => { 45 => 0x1010 },
	'fullsizeimage' => { 62 => 'data' },
	'fullsizeimagename' => { 62 => '1Name' },
	'fullsizeimagetype' => { 62 => '0Type' },
	'gaincontrol' => { 41 => 0xa407, 133 => 'GainControl' },
	'gamma' => { 41 => 0xa500 },
	'gammacompensatedvalue' => { 49 => 0x91 },
	'genre' => { 140 => 'genre' },
	'globalaltitude' => { 119 => 0x419 },
	'globalangle' => { 119 => 0x40d },
	'gpsaltitude' => { 46 => 0x6, 60 => 'Altitude', 133 => 'GPSAltitude' },
	'gpsaltituderef' => { 46 => 0x5, 133 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 46 => 0x1c, 133 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 46 => 0x1d },
	'gpsdatetime' => { 60 => 'DateTime' },
	'gpsdestbearing' => { 46 => 0x18, 60 => 'Bearing', 133 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 46 => 0x17, 133 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 46 => 0x1a, 60 => 'Distance', 133 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 46 => 0x19, 133 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 46 => 0x14, 133 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 46 => 0x13 },
	'gpsdestlongitude' => { 46 => 0x16, 133 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 46 => 0x15 },
	'gpsdifferential' => { 46 => 0x1e, 60 => 'Differential', 133 => 'GPSDifferential' },
	'gpsdop' => { 46 => 0xb, 133 => 'GPSDOP' },
	'gpsimgdirection' => { 46 => 0x11, 133 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 46 => 0x10, 133 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 46 => 0x2, 60 => 'Latitude', 133 => 'GPSLatitude' },
	'gpslatituderef' => { 46 => 0x1 },
	'gpslongitude' => { 46 => 0x4, 60 => 'Longitude', 133 => 'GPSLongitude' },
	'gpslongituderef' => { 46 => 0x3 },
	'gpsmapdatum' => { 46 => 0x12, 60 => 'Datum', 133 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 46 => 0xa, 60 => 'MeasureMode', 133 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 46 => 0x1b, 133 => 'GPSProcessingMethod' },
	'gpssatellites' => { 46 => 0x8, 60 => 'Satellites', 133 => 'GPSSatellites' },
	'gpsspeed' => { 46 => 0xd, 60 => 'Speed', 133 => 'GPSSpeed' },
	'gpsspeedref' => { 46 => 0xc, 133 => 'GPSSpeedRef' },
	'gpsstatus' => { 46 => 0x9, 133 => 'GPSStatus' },
	'gpstimestamp' => { 46 => 0x7, 133 => 'GPSTimeStamp' },
	'gpstrack' => { 46 => 0xf, 60 => 'Heading', 133 => 'GPSTrack' },
	'gpstrackref' => { 46 => 0xe, 133 => 'GPSTrackRef' },
	'gpsversionid' => { 46 => 0x0, 133 => 'GPSVersionID' },
	'gradation' => { 100 => 0x50f },
	'grayresponseunit' => { 41 => 0x122 },
	'greencurvelimits' => { 36 => 0x1c4 },
	'greencurvepoints' => { 36 => 0x19a },
	'greenhue' => { 130 => 'GreenHue' },
	'greensaturation' => { 130 => 'GreenSaturation' },
	'halftonehints' => { 41 => 0x141 },
	'hascrop' => { 130 => 'HasCrop' },
	'hassettings' => { 130 => 'HasSettings' },
	'headline' => { 47 => 0x69, 136 => 'Headline' },
	'highisonoisereduction' => { 84 => 0xb1 },
	'highlight' => { 125 => 0xf },
	'historyaction' => { 141 => 'HistoryAction' },
	'historyinstanceid' => { 141 => 'HistoryInstanceID' },
	'historyparameters' => { 141 => 'HistoryParameters' },
	'historysoftwareagent' => { 141 => 'HistorySoftwareAgent' },
	'historywhen' => { 141 => 'HistoryWhen' },
	'hometowncity' => { 114 => 0x23 },
	'hometowncitycode' => { 114 => 0x1000 },
	'hometowndst' => { 114 => 0x25 },
	'hostcomputer' => { 41 => 0x13c },
	'hue' => { 76 => 0x3b },
	'hueadjustment' => { 84 => 0x92 },
	'icc_profile' => { 42 => 'ICC_Profile' },
	'iccprofilename' => { 136 => 'ICCProfile' },
	'identifier' => { 131 => 'identifier', 138 => 'Identifier' },
	'imageadjustment' => { 84 => 0x80, 88 => 0x5 },
	'imageareaoffset' => { 114 => 0x38 },
	'imageauthentication' => { 84 => 0x20 },
	'imageboundary' => { 84 => 0x16 },
	'imagecount' => { 84 => 0xa5 },
	'imagedatasize' => { 84 => 0xa2 },
	'imagedescription' => { 41 => 0x10e, 137 => 'ImageDescription' },
	'imagedustoff' => { 94 => 0xfe443a45 },
	'imageheight' => { 41 => 0x101, 75 => 0xc, 137 => 'ImageLength' },
	'imagehistory' => { 41 => 0x9213 },
	'imagenumber' => { 0 => 0xd0, 41 => 0x9211, 56 => 'ImageNumber', 71 => 0xae, 72 => 0x5e, 128 => 'ImageNumber' },
	'imagenumber2' => { 72 => 0x62 },
	'imageoptimization' => { 84 => 0xa9 },
	'imageorientation' => { 47 => 0x83 },
	'imageprocessing' => { 84 => 0x1a },
	'imageprocessingversion' => { 103 => 0x0 },
	'imagequality' => { 56 => 'ImageQuality', 108 => 0x1 },
	'imagequality2' => { 100 => 0x603 },
	'imagesize' => { 62 => 'ImageSize' },
	'imagesourcedata' => { 41 => 0x935c },
	'imagestabilization' => { 1 => 0x22, 38 => 0x3020, 56 => 'ImageStabilization', 71 => 0xbd, 72 => 0x71, 73 => 0x87, 74 => [0x18,0x107,0x113], 84 => 0xac },
	'imagestabilizer' => { 108 => 0x1a },
	'imagetone' => { 114 => 0x4f },
	'imagetype' => { 47 => 0x82 },
	'imageuniqueid' => { 41 => 0xa420, 133 => 'ImageUniqueID' },
	'imagewidth' => { 41 => 0x100, 75 => 0xe, 137 => 'ImageWidth' },
	'infinitylensstep' => { 104 => 0x103b },
	'inkset' => { 41 => 0x14c },
	'instructions' => { 136 => 'Instructions' },
	'instrument' => { 140 => 'instrument' },
	'intellectualgenre' => { 134 => 'IntellectualGenre' },
	'interchangecolorspace' => { 49 => 0x40 },
	'internalflash' => { 70 => 0x2b, 102 => 0x1208 },
	'internalflashmagni' => { 112 => 0x3 },
	'internalserialnumber' => { 11 => 0x96, 45 => 0x10, 101 => 0x102, 108 => 0x25, 111 => 0x4 },
	'interopindex' => { 41 => 0x1 },
	'interopversion' => { 41 => 0x2 },
	'intervallength' => { 70 => 0x10 },
	'intervalmode' => { 70 => 0x26 },
	'intervalnumber' => { 70 => 0x11 },
	'introtime' => { 140 => 'introTime' },
	'iptc-naa' => { 41 => 0x83bb },
	'iptcbitspersample' => { 49 => 0x56 },
	'iptcimageheight' => { 49 => 0x1e },
	'iptcimagerotation' => { 49 => 0x66 },
	'iptcimagewidth' => { 49 => 0x14 },
	'iptcpicturenumber' => { 49 => 0xa },
	'iptcpixelheight' => { 49 => 0x32 },
	'iptcpixelwidth' => { 49 => 0x28 },
	'iso' => { 38 => 0x14, 41 => 0x8827, 51 => 0x60, 53 => 0x4e, 56 => 'ISO', 70 => 0x8, 84 => 0x2, 114 => 0x14, 133 => 'ISOSpeedRatings' },
	'isoexpansion' => { 20 => 0x7, 21 => 0x8, 24 => 0x8 },
	'isoselection' => { 84 => 0xf },
	'isosetting' => { 51 => 0x5e, 56 => 'ISOSetting', 70 => 0x24, 71 => 0x26, 72 => 0x1c, 76 => 0x6, 84 => 0x13, 122 => 0x27 },
	'isospeedexpansion' => { 19 => 0x3 },
	'isovalue' => { 104 => 0x1001 },
	'jobid' => { 47 => 0xb8 },
	'jobrefid' => { 139 => 'JobRefId' },
	'jobrefname' => { 139 => 'JobRefName' },
	'jobrefurl' => { 139 => 'JobRefUrl' },
	'jpgfromraw' => { 32 => 0x2007, 39 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 41 => [0x117,0x202] },
	'jpgfromrawstart' => { 41 => [0x111,0x201] },
	'key' => { 140 => 'key' },
	'keywords' => { 47 => 0x19, 57 => 'Keywords', 121 => 'Keywords', 135 => 'Keywords' },
	'kodakimageheight' => { 51 => 0xe, 52 => 0x70 },
	'kodakimagewidth' => { 51 => 0xc, 52 => 0x6c },
	'kodakmaker' => { 52 => 0x8 },
	'kodakmodel' => { 51 => 0x0, 52 => 0x28 },
	'label' => { 107 => 'Label', 138 => 'Label' },
	'language' => { 131 => 'language' },
	'languageidentifier' => { 47 => 0x87 },
	'lastfilenumber' => { 70 => 0x1b },
	'lastkeywordiptc' => { 127 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 127 => 'LastKeywordXMP' },
	'lasturl' => { 141 => 'LastURL' },
	'lcddisplayatpoweron' => { 23 => 0xa },
	'lcddisplayreturntoshoot' => { 24 => 0x12 },
	'lcdpanels' => { 19 => 0x8 },
	'lcheditor' => { 94 => 0x8ae85e },
	'lens' => { 41 => 0xfdea, 84 => 0x84, 125 => 0xa, 128 => 'Lens' },
	'lensafstopbutton' => { 18 => 0x11, 19 => 0x13, 20 => 0x10, 21 => 0x12, 24 => 0x13, 25 => 0x9 },
	'lenscoefficients' => { 113 => 0x4 },
	'lensdataversion' => { 83 => 0x0 },
	'lensdistortionparams' => { 104 => 0x206 },
	'lensfirmwareversion' => { 101 => 0x204 },
	'lensfstops' => { 83 => 0x7, 84 => 0x8b },
	'lensid' => { 74 => 0x10c },
	'lensidnumber' => { 83 => 0x6 },
	'lensinfo' => { 128 => 'LensInfo' },
	'lensmake' => { 63 => 'Make' },
	'lensmanufacturer' => { 127 => 'LensManufacturer' },
	'lensmodel' => { 63 => 'Model', 127 => 'LensModel' },
	'lensserialnumber' => { 63 => 'SerialNumber', 101 => 0x202 },
	'lenstemperature' => { 104 => 0x1008 },
	'lenstype' => { 0 => 0xd, 1 => 0x16, 11 => 0x95, 84 => 0x83, 101 => 0x201, 108 => 0x51, 113 => 0x0, 114 => 0x3f },
	'license' => { 129 => 'license' },
	'licensetype' => { 132 => 'licensetype' },
	'lightsource' => { 41 => 0x9208, 84 => 0x90, 133 => 'LightSource' },
	'lightsourcespecial' => { 124 => 0x21d },
	'linearresponselimit' => { 41 => 0xc62e },
	'localcaption' => { 47 => 0x79 },
	'localizedcameramodel' => { 41 => 0xc615 },
	'location' => { 134 => 'Location' },
	'logcomment' => { 140 => 'logComment' },
	'longexposurenoisereduction' => { 20 => 0x1, 21 => 0x2, 22 => 0x1, 23 => 0x1, 24 => 0x2, 25 => 0x1 },
	'longfocal' => { 0 => 0x14, 1 => 0x17 },
	'loop' => { 140 => 'loop' },
	'luminancesmoothing' => { 130 => 'LuminanceSmoothing' },
	'macro' => { 45 => 0x1020, 104 => 0x202, 122 => 0x21, 124 => 0x202 },
	'macromode' => { 1 => 0x1, 70 => 0xb, 100 => 0x300, 108 => 0x1c },
	'magnifiedview' => { 21 => 0x11, 23 => 0x9 },
	'make' => { 33 => 0x0, 41 => 0x10f, 56 => 'Make', 107 => 'Make', 137 => 'Make' },
	'makernote' => { 133 => 'MakerNote' },
	'makernotecanon' => { 40 => 'MakN', 41 => 0x927c },
	'makernotecasio' => { 40 => 'MakN', 41 => 0x927c },
	'makernotecasio2' => { 40 => 'MakN', 41 => 0x927c },
	'makernotefujifilm' => { 40 => 'MakN', 41 => 0x927c },
	'makernotejvc' => { 40 => 'MakN', 41 => 0x927c },
	'makernotejvctext' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak1a' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak1b' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak2' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak3' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak4' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak5' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak6a' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodak6b' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekodakunknown' => { 40 => 'MakN', 41 => 0x927c },
	'makernotekyocera' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteleica' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteminolta' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteminolta2' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteminolta3' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteminolta4' => { 40 => 'MakN', 41 => 0x927c },
	'makernotenikon' => { 40 => 'MakN', 41 => 0x927c },
	'makernotenikon2' => { 40 => 'MakN', 41 => 0x927c },
	'makernotenikon3' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteoffset' => { 124 => 0xff },
	'makernoteolympus' => { 40 => 'MakN', 41 => 0x927c },
	'makernotepanasonic' => { 40 => 'MakN', 41 => 0x927c },
	'makernotepanasonic2' => { 40 => 'MakN', 41 => 0x927c },
	'makernotepentax' => { 40 => 'MakN', 41 => 0x927c },
	'makernotericoh' => { 40 => 'MakN', 41 => 0x927c },
	'makernotericohtext' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesafety' => { 41 => 0xc635 },
	'makernotesanyo' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesanyoc4' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesanyopatch' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesigma' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesony' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesonysr2' => { 40 => 'MakN', 41 => 0x927c },
	'makernotesonysrf' => { 40 => 'MakN', 41 => 0x927c },
	'makernotetype' => { 123 => 0x1 },
	'makernoteunknown' => { 40 => 'MakN', 41 => 0x927c },
	'makernoteversion' => { 74 => 0x0, 104 => 0x0, 123 => 0x2 },
	'managedfromdocumentid' => { 141 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 141 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 141 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 141 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 141 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 141 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 141 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 141 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 141 => 'ManagedFromVersionID' },
	'manager' => { 141 => 'Manager' },
	'managervariant' => { 141 => 'ManagerVariant' },
	'manageto' => { 141 => 'ManageTo' },
	'manageui' => { 141 => 'ManageUI' },
	'manualflash' => { 102 => 0x1209 },
	'manualfocusdistance' => { 84 => 0x85, 104 => 0x100c, 124 => 0x223 },
	'manualtv' => { 19 => 0x5 },
	'manufacturedate' => { 111 => 0x1 },
	'marked' => { 143 => 'Marked' },
	'markerscomment' => { 140 => 'markersComment' },
	'markersduration' => { 140 => 'markersDuration' },
	'markerslocation' => { 140 => 'markersLocation' },
	'markersname' => { 140 => 'markersName' },
	'markersstarttime' => { 140 => 'markersStartTime' },
	'markerstarget' => { 140 => 'markersTarget' },
	'markerstype' => { 140 => 'markersType' },
	'maskedareas' => { 41 => 0xc68e },
	'masterdocumentid' => { 47 => 0xb9 },
	'mastergain' => { 87 => 0x50 },
	'maxaperture' => { 1 => 0x1a, 63 => 'MaxAperture', 70 => 0x17 },
	'maxapertureatcurrentfocal' => { 101 => 0x20a },
	'maxapertureatmaxfocal' => { 45 => 0x1407, 63 => 'MaxApertureAtMaxFocal', 83 => 0xb, 101 => 0x206 },
	'maxapertureatminfocal' => { 45 => 0x1406, 83 => 0xa },
	'maxaperturevalue' => { 41 => 0x9205, 133 => 'MaxApertureValue' },
	'maxfocallength' => { 45 => 0x1405, 63 => 'MaxFocalLength', 83 => 0x9, 101 => 0x208 },
	'maximumdensityrange' => { 49 => 0x8c },
	'maxpagesizeh' => { 144 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 144 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 144 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 41 => 0x119 },
	'mcuversion' => { 83 => 0xc },
	'md5digest' => { 64 => 'zmd5' },
	'measuredev' => { 17 => 0x3, 32 => 0x1814, 56 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 18 => 0xb, 20 => 0xa, 21 => 0xb, 24 => 0xb },
	'menubuttonreturn' => { 25 => 0xb },
	'metadatadate' => { 138 => 'MetadataDate' },
	'metadatamoddate' => { 140 => 'metadataModDate' },
	'meteringmode' => { 1 => 0x11, 41 => 0x9207, 51 => 0x1c, 70 => 0x7, 71 => 0x25, 100 => 0x202, 114 => 0x17, 125 => 0x9, 133 => 'MeteringMode' },
	'mieversion' => { 64 => '0Vers' },
	'minaperture' => { 1 => 0x1b, 63 => 'MinAperture' },
	'minfocallength' => { 45 => 0x1404, 63 => 'MinFocalLength', 83 => 0x8, 101 => 0x207 },
	'minoltadate' => { 70 => 0x15 },
	'minoltaimagesize' => { 70 => 0x4, 71 => 0xc, 72 => 0x2, 74 => 0x103 },
	'minoltamodelid' => { 70 => 0x25 },
	'minoltaquality' => { 70 => 0x5, 71 => 0xd, 72 => 0x3, 74 => [0x102,0x103], 104 => [0x102,0x103] },
	'minoltatime' => { 70 => 0x16 },
	'minsamplevalue' => { 41 => 0x118 },
	'mirrorlockup' => { 18 => 0xc, 19 => 0xc, 20 => 0xb, 21 => 0xc, 22 => 0x6, 23 => 0x6, 24 => 0xc, 25 => 0x3 },
	'moddate' => { 135 => 'ModDate' },
	'model' => { 33 => 0x6, 41 => 0x110, 56 => 'Model', 107 => 'Model', 137 => 'Model' },
	'modelrevision' => { 111 => 0x2 },
	'modifiedcolortemp' => { 12 => 0x9 },
	'modifieddigitalgain' => { 12 => 0xb },
	'modifiedparamflag' => { 9 => 0x1 },
	'modifiedpicturestyle' => { 12 => 0xa },
	'modifiedsaturation' => { 100 => 0x504 },
	'modifiedsensorbluelevel' => { 12 => 0x5 },
	'modifiedsensorredlevel' => { 12 => 0x4 },
	'modifiedsharpness' => { 12 => 0x2 },
	'modifiedsharpnessfreq' => { 12 => 0x3 },
	'modifiedtonecurve' => { 12 => 0x1 },
	'modifiedwhitebalance' => { 12 => 0x8 },
	'modifiedwhitebalanceblue' => { 12 => 0x7 },
	'modifiedwhitebalancered' => { 12 => 0x6 },
	'modifydate' => { 41 => 0x132, 57 => 'ModifyDate', 106 => 'tIME', 121 => 'ModDate', 138 => 'ModifyDate' },
	'moirefilter' => { 41 => 0xfe58 },
	'monochromecontrast' => { 36 => 0x2ee },
	'monochromefiltereffect' => { 36 => 0x2ea },
	'monochromelinear' => { 36 => 0x2f0 },
	'monochromesharpness' => { 36 => 0x2f2 },
	'monochrometoningeffect' => { 36 => 0x2ec },
	'monthdaycreated' => { 51 => 0x12, 53 => 0xe },
	'multisample' => { 87 => 0x40 },
	'nativedigest' => { 133 => 'NativeDigest', 137 => 'NativeDigest' },
	'ndfilter' => { 17 => 0x1c },
	'nearlensstep' => { 104 => 0x103c },
	'newsphotoversion' => { 49 => 0x0 },
	'nickname' => { 138 => 'Nickname' },
	'nikoncaptureversion' => { 84 => 0xe09 },
	'noisereduction' => { 8 => 0x8, 71 => 0xb0, 72 => 0x60, 73 => 0x3f, 84 => 0x95, 94 => 0x753dcbc0, 100 => 0x50a, 104 => 0x103a, 108 => 0x2d, 114 => 0x49 },
	'noisereduction2' => { 103 => 0x1010 },
	'noisereductionintensity' => { 95 => 0x9 },
	'noisereductionmethod' => { 95 => 0x11 },
	'noisereductionsharpness' => { 95 => 0xd },
	'npages' => { 144 => 'NPages' },
	'nullrecord' => { 32 => 0x0 },
	'numafpoints' => { 14 => 0x1 },
	'numberofbeats' => { 140 => 'numberOfBeats' },
	'numindexentries' => { 49 => 0x54 },
	'objectattributereference' => { 47 => 0x4 },
	'objectcycle' => { 47 => 0x4b },
	'objectdistance' => { 37 => 0x6, 38 => 0x2022 },
	'objectname' => { 47 => 0x5 },
	'objectpreviewdata' => { 47 => 0xca },
	'objectpreviewfileformat' => { 47 => 0xc8 },
	'objectpreviewfileversion' => { 47 => 0xc9 },
	'objecttypereference' => { 47 => 0x3 },
	'oecfcolumns' => { 133 => 'OECFColumns' },
	'oecfnames' => { 133 => 'OECFNames' },
	'oecfrows' => { 133 => 'OECFRows' },
	'oecfvalues' => { 133 => 'OECFValues' },
	'offsetschema' => { 41 => 0xea1d },
	'oldsubfiletype' => { 41 => 0xff },
	'olympusimageheight' => { 104 => 0x102f },
	'olympusimageheight2' => { 103 => 0x615 },
	'olympusimagewidth' => { 104 => 0x102e },
	'olympusimagewidth2' => { 103 => 0x614 },
	'onetouchwb' => { 104 => 0x302 },
	'opticalzoom' => { 53 => 0x1e, 63 => 'OpticalZoom' },
	'opticalzoomcode' => { 17 => 0xa },
	'opticalzoomon' => { 124 => 0x219 },
	'ordernumber' => { 45 => 0x8002 },
	'orientation' => { 41 => 0x112, 137 => 'Orientation' },
	'originaldecisiondata' => { 11 => 0x83 },
	'originalfilename' => { 32 => 0x816, 54 => 0x20 },
	'originalimageheight' => { 44 => 0x1 },
	'originalimagewidth' => { 44 => 0x0 },
	'originalrawfiledata' => { 41 => 0xc68c },
	'originalrawfilename' => { 41 => 0xc68b },
	'originaltransmissionreference' => { 47 => 0x67 },
	'originatingprogram' => { 47 => 0x41 },
	'os' => { 132 => 'os' },
	'outcue' => { 140 => 'outCue' },
	'outputheight' => { 91 => 0xce },
	'outputheightinches' => { 91 => 0x96 },
	'outputpixels' => { 91 => 0xd6 },
	'outputresolution' => { 91 => 0xb6 },
	'outputwidth' => { 91 => 0xc6 },
	'outputwidthinches' => { 91 => 0x8e },
	'owner' => { 143 => 'Owner' },
	'ownerid' => { 47 => 0xbc },
	'ownername' => { 11 => 0x9, 32 => 0x810, 41 => 0xfde8, 56 => 'OwnerName', 128 => 'OwnerName' },
	'pagename' => { 41 => 0x11d },
	'pagenumber' => { 41 => 0x129 },
	'panoramadirection' => { 13 => 0x5 },
	'panoramaframe' => { 13 => 0x2 },
	'panoramamode' => { 51 => 0x3c, 100 => 0x601 },
	'pdfversion' => { 135 => 'PDFVersion' },
	'pentaximagesize' => { 114 => 0x9 },
	'pentaxmode' => { 114 => 0x1 },
	'pentaxmodelid' => { 111 => 0x0, 114 => 0x5 },
	'pentaxversion' => { 114 => 0x0 },
	'pf0customfuncregistration' => { 27 => 0x1 },
	'pf10retainprogramshift' => { 27 => 0xb },
	'pf13drivepriority' => { 27 => 0xe },
	'pf14disablefocussearch' => { 27 => 0xf },
	'pf15disableafassistbeam' => { 27 => 0x10 },
	'pf16autofocuspointshoot' => { 27 => 0x11 },
	'pf17disableafpointsel' => { 27 => 0x12 },
	'pf18enableautoafpointsel' => { 27 => 0x13 },
	'pf19continuousshootspeed' => { 27 => 0x14 },
	'pf19shootingspeedhigh' => { 26 => 0xa },
	'pf19shootingspeedlow' => { 26 => 0x9 },
	'pf1disableshootingmodes' => { 27 => 0x2 },
	'pf1value' => { 26 => 0x1 },
	'pf20limitcontinousshots' => { 27 => 0x15 },
	'pf20maxcontinousshots' => { 26 => 0xb },
	'pf21enablequietoperation' => { 27 => 0x16 },
	'pf23felocktime' => { 26 => 0xd },
	'pf23postreleasetime' => { 26 => 0xe },
	'pf23settimerlengths' => { 27 => 0x18 },
	'pf23shutterbuttontime' => { 26 => 0xc },
	'pf24lightlcdduringbulb' => { 27 => 0x19 },
	'pf25aemode' => { 26 => 0xf },
	'pf25afmode' => { 26 => 0x12 },
	'pf25afpointsel' => { 26 => 0x13 },
	'pf25colormatrix' => { 26 => 0x17 },
	'pf25defaultclearsettings' => { 27 => 0x1a },
	'pf25drivemode' => { 26 => 0x11 },
	'pf25imagesize' => { 26 => 0x14 },
	'pf25meteringmode' => { 26 => 0x10 },
	'pf25parameters' => { 26 => 0x16 },
	'pf25wbmode' => { 26 => 0x15 },
	'pf26shortenreleaselag' => { 27 => 0x1b },
	'pf27reversedialrotation' => { 27 => 0x1c },
	'pf27value' => { 26 => 0x18 },
	'pf28noquickdialexpcomp' => { 27 => 0x1d },
	'pf29quickdialswitchoff' => { 27 => 0x1e },
	'pf2disablemeteringmodes' => { 27 => 0x3 },
	'pf2value' => { 26 => 0x2 },
	'pf30enlargementmode' => { 27 => 0x1f },
	'pf31originaldecisiondata' => { 27 => 0x20 },
	'pf3manualexposuremetering' => { 27 => 0x4 },
	'pf3value' => { 26 => 0x3 },
	'pf4exposuretimelimits' => { 27 => 0x5 },
	'pf4exposuretimemax' => { 26 => 0x5 },
	'pf4exposuretimemin' => { 26 => 0x4 },
	'pf5aperturelimits' => { 27 => 0x6 },
	'pf5aperturemax' => { 26 => 0x7 },
	'pf5aperturemin' => { 26 => 0x6 },
	'pf6presetshootingmodes' => { 27 => 0x7 },
	'pf7bracketcontinuousshoot' => { 27 => 0x8 },
	'pf8bracketshots' => { 26 => 0x8 },
	'pf8setbracketshots' => { 27 => 0x9 },
	'pf9changebracketsequence' => { 27 => 0xa },
	'phonenumber' => { 57 => 'Phone' },
	'photoeffect' => { 1 => 0x28 },
	'photoeffects' => { 94 => 0xab5eca5e },
	'photoeffectsblue' => { 96 => 0x8 },
	'photoeffectsgreen' => { 96 => 0x6 },
	'photoeffectsred' => { 96 => 0x4 },
	'photoeffectstype' => { 96 => 0x0 },
	'photometricinterpretation' => { 41 => 0x106, 137 => 'PhotometricInterpretation' },
	'photoshopquality' => { 118 => 0x0 },
	'pictinfo' => { 124 => 0x208 },
	'picturemode' => { 45 => 0x1031, 100 => 0x520, 114 => [0xb,0x33] },
	'picturemodebwfilter' => { 100 => 0x525 },
	'picturemodecontrast' => { 100 => 0x523 },
	'picturemodehue' => { 100 => 0x522 },
	'picturemodesaturation' => { 100 => 0x521 },
	'picturemodesharpness' => { 100 => 0x524 },
	'picturemodetone' => { 100 => 0x526 },
	'picturestyle' => { 0 => 0x6c, 16 => 0xa, 36 => 0x27a },
	'planarconfiguration' => { 41 => 0x11c, 137 => 'PlanarConfiguration' },
	'platenames' => { 144 => 'PlateNames' },
	'pngwarning' => { 107 => 'Warning' },
	'postalcode' => { 61 => 'PostalCode' },
	'precaptureframes' => { 104 => 0x300 },
	'predictor' => { 41 => 0x13d },
	'prefs' => { 117 => 'Prefs' },
	'preservedfilename' => { 141 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 15 => 0x6 },
	'previewfocalplaneyresolution' => { 15 => 0x8 },
	'previewimage' => { 38 => 0x2000, 39 => 'PreviewImage', 40 => 'MakN', 41 => 0x927c, 43 => 0x4, 66 => 'data', 74 => 0x81, 104 => 0x280 },
	'previewimagedata' => { 114 => 0x2000 },
	'previewimageheight' => { 15 => 0x4 },
	'previewimagelength' => { 15 => 0x2, 38 => 0x3, 41 => [0x117,0x202], 74 => 0x89, 85 => 0x202, 100 => 0x102, 104 => 0x1037, 114 => 0x3, 122 => 0x1e },
	'previewimagename' => { 66 => '1Name' },
	'previewimagesize' => { 38 => 0x2, 66 => 'ImageSize', 114 => 0x2 },
	'previewimagestart' => { 15 => 0x5, 38 => 0x4, 41 => [0x111,0x201], 74 => 0x88, 85 => 0x201, 100 => 0x101, 104 => 0x1036, 114 => 0x4, 122 => 0x1c },
	'previewimagetype' => { 66 => '0Type' },
	'previewimagevalid' => { 100 => 0x100, 104 => 0x1035 },
	'previewimagewidth' => { 15 => 0x3 },
	'previewquality' => { 15 => 0x1 },
	'primarychromaticities' => { 41 => 0x13f, 137 => 'PrimaryChromaticities' },
	'printim' => { 41 => 0xc4a5 },
	'processingsoftware' => { 41 => 0xb },
	'producer' => { 135 => 'Producer' },
	'productid' => { 48 => 0x32 },
	'programmode' => { 76 => 0x5 },
	'programshift' => { 84 => 0xd },
	'programversion' => { 47 => 0x46 },
	'projectrefpath' => { 140 => 'projectRefPath' },
	'projectreftype' => { 140 => 'projectRefType' },
	'province-state' => { 47 => 0x5f },
	'publisher' => { 131 => 'publisher' },
	'pulldown' => { 140 => 'pullDown' },
	'quality' => { 1 => 0x3, 37 => 0x2, 38 => 0x3002, 45 => 0x1000, 51 => 0x9, 84 => 0x4, 88 => 0x3, 104 => 0x201, 114 => 0x8, 125 => 0x16 },
	'qualitymode' => { 38 => 0x8 },
	'quantizationmethod' => { 49 => 0x78 },
	'quickshot' => { 124 => 0x213 },
	'rasterizedcaption' => { 47 => 0x7d },
	'rating' => { 41 => 0x4746, 116 => 0xdf, 132 => 'rating', 138 => 'Rating' },
	'ratingpercent' => { 41 => 0x4749, 127 => 'Rating' },
	'rawandjpgrecording' => { 18 => 0x8 },
	'rawbrightnessadj' => { 36 => 0x38 },
	'rawcoloradj' => { 36 => 0x2e },
	'rawcolortoneadj' => { 36 => 0x290 },
	'rawcontrastadj' => { 36 => 0x294 },
	'rawcropbottom' => { 116 => 0xd4 },
	'rawcropleft' => { 116 => 0xd1 },
	'rawcropright' => { 116 => 0xd3 },
	'rawcroptop' => { 116 => 0xd2 },
	'rawcustomsaturation' => { 36 => 0x30 },
	'rawcustomtone' => { 36 => 0x34 },
	'rawdatauniqueid' => { 41 => 0xc65d },
	'rawdepth' => { 75 => 0x10 },
	'rawdevcolorspace' => { 105 => 0x108 },
	'rawdevcontrastvalue' => { 105 => 0x106 },
	'rawdeveditstatus' => { 105 => 0x10b },
	'rawdevengine' => { 105 => 0x109 },
	'rawdevexposurebiasvalue' => { 105 => 0x100 },
	'rawdevgraypoint' => { 105 => 0x103 },
	'rawdevmemorycoloremphasis' => { 105 => 0x105 },
	'rawdevnoisereduction' => { 105 => 0x10a },
	'rawdevsaturationemphasis' => { 105 => 0x104 },
	'rawdevsettings' => { 105 => 0x10c },
	'rawdevsharpnessvalue' => { 105 => 0x107 },
	'rawdevversion' => { 105 => 0x0 },
	'rawdevwbfineadjustment' => { 105 => 0x102 },
	'rawdevwhitebalancevalue' => { 105 => 0x101 },
	'rawfile' => { 41 => 0xfe4c },
	'rawfilename' => { 130 => 'RawFileName' },
	'rawhighlightpoint' => { 36 => 0x29a },
	'rawimagecenter' => { 84 => 0x99 },
	'rawimagesize' => { 114 => 0x39 },
	'rawjpgheight' => { 34 => 0x4 },
	'rawjpgquality' => { 8 => 0x6, 34 => 0x1 },
	'rawjpgsize' => { 8 => 0x7, 34 => 0x2 },
	'rawjpgwidth' => { 34 => 0x3 },
	'rawlinear' => { 36 => 0x296 },
	'rawsaturationadj' => { 36 => 0x292 },
	'rawshadowpoint' => { 36 => 0x29c },
	'rawsharpnessadj' => { 36 => 0x298 },
	'recordid' => { 32 => 0x1804 },
	'recordingmode' => { 37 => 0x1 },
	'recordmode' => { 1 => 0x9, 38 => 0x3000 },
	'recordshutterrelease' => { 124 => 0x217 },
	'redbalance' => { 104 => 0x1017, 114 => 0x1c },
	'redcurvelimits' => { 36 => 0x18a },
	'redcurvepoints' => { 36 => 0x160 },
	'redeyecorrection' => { 97 => 0x0 },
	'redhue' => { 130 => 'RedHue' },
	'redsaturation' => { 130 => 'RedSaturation' },
	'referenceblackwhite' => { 41 => 0x214, 137 => 'ReferenceBlackWhite' },
	'referencedate' => { 47 => 0x2f },
	'referencenumber' => { 47 => 0x32 },
	'references' => { 57 => 'References' },
	'referenceservice' => { 47 => 0x2d },
	'relatedaudiofile' => { 55 => 'data' },
	'relatedaudiofilename' => { 55 => '1Name' },
	'relatedaudiofiletype' => { 55 => '0Type' },
	'relatedimagefileformat' => { 41 => 0x1000 },
	'relatedimagelength' => { 41 => 0x1002 },
	'relatedimagewidth' => { 41 => 0x1001 },
	'relatedsoundfile' => { 41 => 0xa004, 133 => 'RelatedSoundFile' },
	'relatedvideofile' => { 69 => 'data' },
	'relatedvideofilename' => { 69 => '1Name' },
	'relatedvideofiletype' => { 69 => '0Type' },
	'relation' => { 131 => 'relation' },
	'relativepeakaudiofilepath' => { 140 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 140 => 'relativeTimestamp' },
	'releasedate' => { 47 => 0x1e, 140 => 'releaseDate' },
	'releasesetting' => { 32 => 0x1016 },
	'releasetime' => { 47 => 0x23 },
	'renditionclass' => { 141 => 'RenditionClass' },
	'renditionofdocumentid' => { 141 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 141 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 141 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 141 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 141 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 141 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 141 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 141 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 141 => 'RenditionOfVersionID' },
	'renditionparams' => { 141 => 'RenditionParams' },
	'resampleparamsquality' => { 140 => 'resampleParamsQuality' },
	'resaved' => { 124 => 0x21e },
	'resolution' => { 62 => 'Resolution' },
	'resolutionmode' => { 125 => 0x4 },
	'resolutionunit' => { 41 => 0x128, 50 => 0x2, 137 => 'ResolutionUnit' },
	'reuseallowed' => { 142 => 'ReuseAllowed' },
	'revision' => { 132 => 'revision' },
	'rgbcurvelimits' => { 36 => 0x238 },
	'rgbcurvepoints' => { 36 => 0x20e },
	'ricohdate' => { 122 => 0x6 },
	'ricohimageheight' => { 122 => 0x2 },
	'ricohimagewidth' => { 122 => 0x0 },
	'rightascension' => { 65 => 'RightAscension' },
	'rights' => { 131 => 'rights' },
	'romoperationmode' => { 32 => 0x80d },
	'rotation' => { 31 => 0x3, 36 => 0x26e, 44 => 0x4, 65 => 'Rotation', 71 => 0x50, 72 => 0x46, 73 => 0x5a, 94 => 0x76a43207, 108 => 0x30, 116 => 0xd8 },
	'routing' => { 121 => 'Routing' },
	'rowsperstrip' => { 41 => 0x116 },
	'safetyshiftinavortv' => { 18 => 0x10, 19 => 0x10, 20 => 0xf, 21 => 0x10, 24 => 0x10 },
	'samplebits' => { 55 => 'SampleBits' },
	'samplerate' => { 55 => 'SampleRate' },
	'samplesperpixel' => { 41 => 0x115, 137 => 'SamplesPerPixel' },
	'samplestructure' => { 49 => 0x5a },
	'sanyoquality' => { 124 => 0x201 },
	'sanyothumbnail' => { 124 => 0x100 },
	'saturation' => { 1 => 0xe, 6 => 0x1, 37 => 0xd, 38 => [0x3013,0x1f], 41 => [0xa409,0xfe55], 45 => 0x1003, 56 => 'Saturation', 70 => 0x1f, 71 => 0x32, 72 => 0x28, 73 => 0x1a, 76 => 0x1, 84 => [0x94,0xaa], 114 => 0x1f, 122 => 0x28, 125 => 0x10, 130 => 'Saturation', 133 => 'Saturation' },
	'saturationadj' => { 36 => 0x116 },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 141 => 'SaveID' },
	'scaledresolution' => { 91 => 0x9e },
	'scaletype' => { 140 => 'scaleType' },
	'scanningdirection' => { 49 => 0x64 },
	'scene' => { 134 => 'Scene', 140 => 'scene' },
	'scenecapturetype' => { 41 => 0xa406, 133 => 'SceneCaptureType' },
	'scenemode' => { 74 => 0x100, 84 => 0x8f, 100 => 0x509 },
	'sceneselect' => { 124 => 0x21f },
	'scenetype' => { 41 => 0xa301, 133 => 'SceneType' },
	'securityclassification' => { 41 => 0x9212 },
	'self-timer' => { 1 => 0x2 },
	'self-timer2' => { 17 => 0x1d },
	'selftimer' => { 38 => 0x3001, 108 => 0x2e, 124 => 0x214 },
	'selftimermode' => { 41 => 0x882b },
	'selftimertime' => { 32 => 0x1806 },
	'seminfo' => { 41 => 0x8546 },
	'sensingmethod' => { 41 => 0xa217, 133 => 'SensingMethod' },
	'sensorbluelevel' => { 16 => 0x5 },
	'sensorcleaning' => { 25 => 0xd },
	'sensorheight' => { 75 => 0x8 },
	'sensorpixelsize' => { 84 => 0x9a },
	'sensorredlevel' => { 16 => 0x4 },
	'sensorsize' => { 56 => 'SensorSize' },
	'sensortemperature' => { 102 => 0x1500, 104 => 0x1007 },
	'sensorwidth' => { 75 => 0xa },
	'sequence' => { 100 => 0x600 },
	'sequencenumber' => { 17 => 0x9, 38 => 0x301c, 45 => 0x1101, 51 => 0x1d, 108 => 0x2b },
	'sequenceshotinterval' => { 124 => 0x224 },
	'sequentialshot' => { 124 => 0x20e },
	'serialnumber' => { 11 => 0xc, 32 => 0x180b, 41 => 0xfde9, 56 => 'SerialNumber', 84 => 0xa0, 101 => 0x101, 104 => [0x404,0x101a], 125 => 0x2, 128 => 'SerialNumber' },
	'serialnumberformat' => { 11 => 0x15, 32 => 0x183b },
	'serviceidentifier' => { 48 => 0x1e },
	'setbuttoncrosskeysfunc' => { 22 => 0x0, 23 => 0x0 },
	'setbuttonfunction' => { 18 => 0x1, 25 => 0xc },
	'setfunctionwhenshooting' => { 20 => 0x0, 21 => 0x1, 24 => 0x1 },
	'shadingcompensation' => { 100 => 0x50c },
	'shadingcompensation2' => { 103 => 0x1012 },
	'shadow' => { 125 => 0xe },
	'shadows' => { 41 => 0xfe52, 130 => 'Shadows' },
	'shadowscale' => { 41 => 0xc633 },
	'shadowtint' => { 130 => 'ShadowTint' },
	'shakereduction' => { 115 => 0x1 },
	'sharpness' => { 1 => 0xf, 16 => 0x2, 37 => 0xb, 38 => [0x3011,0x21], 41 => [0xa40a,0xfe56], 45 => 0x1001, 51 => 0x6b, 53 => 0x37, 56 => 'Sharpness', 70 => 0x21, 71 => 0x30, 72 => 0x26, 73 => 0x18, 76 => 0x3, 84 => 0x6, 104 => 0x100f, 114 => 0x21, 122 => 0x22, 123 => 0x1003, 125 => 0x11, 130 => 'Sharpness', 133 => 'Sharpness' },
	'sharpnessfactor' => { 104 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 16 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 100 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 56 => 'ShootingMode', 84 => 0x89, 108 => 0x1f },
	'shortdescription' => { 132 => 'shortdescription' },
	'shortdocumentid' => { 47 => 0xba },
	'shortfocal' => { 0 => 0x12, 1 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shotdate' => { 140 => 'shotDate' },
	'shotlocation' => { 140 => 'shotLocation' },
	'shotname' => { 140 => 'shotName' },
	'shutter-aelock' => { 18 => 0x4, 20 => 0x3, 21 => 0x4, 22 => 0x3, 23 => 0x3, 24 => 0x4, 25 => 0x2 },
	'shutteraelbutton' => { 19 => 0x4 },
	'shuttercount' => { 8 => 0x1 },
	'shuttercurtainsync' => { 18 => 0xf, 19 => 0xf, 20 => 0xe, 21 => 0xf, 22 => 0x8, 23 => 0x8, 24 => 0xf, 25 => 0x8 },
	'shuttermode' => { 51 => 0x1b },
	'shutterreleasemethod' => { 32 => 0x1010 },
	'shutterreleasenocfcard' => { 18 => 0x2, 19 => 0x2, 25 => 0xf },
	'shutterreleasetiming' => { 32 => 0x1011 },
	'shutterspeedvalue' => { 41 => 0x9201, 104 => 0x1000, 133 => 'ShutterSpeedValue' },
	'similarityindex' => { 47 => 0xe4 },
	'slowshutter' => { 17 => 0x8 },
	'slowsync' => { 45 => 0x1030 },
	'smoothingparameter1' => { 103 => 0x300 },
	'smoothingparameter2' => { 103 => 0x310 },
	'smoothingthreshold2' => { 103 => 0x610 },
	'smoothingthresholds' => { 103 => 0x600 },
	'smoothness' => { 41 => 0xfe57 },
	'software' => { 41 => 0x131, 57 => 'Software', 107 => 'Software', 125 => 0x18, 137 => 'Software' },
	'softwareversion' => { 124 => 0x207 },
	'source' => { 47 => 0x73, 107 => 'Source', 131 => 'source', 132 => 'source', 136 => 'Source' },
	'sourceresolution' => { 91 => 0xae },
	'spatialfrequencyresponsecolumns' => { 133 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 133 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 133 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 133 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 140 => 'speakerPlacement' },
	'specialinstructions' => { 47 => 0x28 },
	'specialmode' => { 104 => 0x200, 124 => 0x200 },
	'spectralsensitivity' => { 41 => 0x8824, 133 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 70 => 0x2d },
	'spotfocuspointy' => { 70 => 0x2e },
	'spotmode' => { 108 => 0xf },
	'sr_swstoswrtime' => { 115 => 0x2 },
	'srresult' => { 115 => 0x0 },
	'starttimecodetimeformat' => { 140 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 140 => 'startTimecodeTimeValue' },
	'state' => { 61 => 'State', 136 => 'State' },
	'storagemethod' => { 75 => 0x12 },
	'straightenangle' => { 94 => 0x2fc08431 },
	'stretchmode' => { 140 => 'stretchMode' },
	'sub-location' => { 47 => 0x5c },
	'subfiledata' => { 64 => 'data' },
	'subfiledirectory' => { 64 => '1Directory' },
	'subfilemimetype' => { 64 => '2MIME' },
	'subfilename' => { 64 => '1Name' },
	'subfileresource' => { 64 => 'rsrc' },
	'subfiletype' => { 41 => 0xfe, 64 => '0Type' },
	'subject' => { 121 => 'Subject', 131 => 'subject', 135 => 'Subject' },
	'subjectarea' => { 133 => 'SubjectArea' },
	'subjectcode' => { 134 => 'SubjectCode' },
	'subjectdistance' => { 41 => 0x9206, 51 => 0x3e, 133 => 'SubjectDistance' },
	'subjectdistancerange' => { 41 => 0xa40c, 133 => 'SubjectDistanceRange' },
	'subjectlocation' => { 41 => [0x9214,0xa214], 133 => 'SubjectLocation' },
	'subjectprogram' => { 70 => 0x22 },
	'subjectreference' => { 47 => 0xc },
	'subsectime' => { 41 => 0x9290 },
	'subsectimedigitized' => { 41 => 0x9292 },
	'subsectimeoriginal' => { 41 => 0x9291 },
	'superimposeddisplay' => { 18 => 0xa, 20 => 0x9, 21 => 0xa, 24 => 0xa, 25 => 0xe },
	'supplementalcategories' => { 47 => 0x14, 136 => 'SupplementalCategories' },
	'supplementaltype' => { 49 => 0x37 },
	'switchtoregisteredafpoint' => { 19 => 0x12 },
	'tagged' => { 116 => 0xdd },
	'tapename' => { 140 => 'tapeName' },
	'targetaperture' => { 17 => 0x4 },
	'targetcompressionratio' => { 30 => 0x1 },
	'targetdistancesetting' => { 32 => 0x1807 },
	'targetexposuretime' => { 17 => 0x5 },
	'targetimagetype' => { 32 => 0x100a },
	'temperature' => { 130 => 'Temperature' },
	'tempo' => { 140 => 'tempo' },
	'thresholding' => { 41 => 0x107 },
	'thumbnailfilename' => { 32 => 0x817 },
	'thumbnailimage' => { 32 => 0x2008, 39 => 'ThumbnailImage', 43 => 0x3, 67 => 'data', 104 => 0x100 },
	'thumbnailimagename' => { 67 => '1Name' },
	'thumbnailimagesize' => { 67 => 'ImageSize' },
	'thumbnailimagetype' => { 67 => '0Type' },
	'thumbnaillength' => { 41 => 0x202 },
	'thumbnailoffset' => { 41 => 0x201 },
	'thumbnailsformat' => { 138 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 138 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 138 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 138 => 'ThumbnailsWidth' },
	'tilelength' => { 41 => 0x143 },
	'tilewidth' => { 41 => 0x142 },
	'time' => { 114 => 0x7 },
	'timecreated' => { 47 => 0x3c, 51 => 0x14, 53 => 0x10, 117 => 'TimeCreated' },
	'timescaleparamsframeoverlappingpercentage' => { 140 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 140 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 140 => 'timeScaleParamsQuality' },
	'timesent' => { 48 => 0x50 },
	'timesignature' => { 140 => 'timeSignature' },
	'timestamp' => { 0 => 0x11c, 107 => 'TimeStamp' },
	'timezone' => { 38 => 0x3006 },
	'timezonecode' => { 35 => 0x1 },
	'timezoneinfo' => { 35 => 0x2 },
	'timezoneoffset' => { 41 => 0x882a },
	'tint' => { 130 => 'Tint' },
	'title' => { 57 => 'Title', 107 => 'Title', 121 => 'Title', 131 => 'title', 135 => 'Title' },
	'tonecomp' => { 84 => 0x81 },
	'tonecurve' => { 16 => 0x1, 114 => 0x402, 130 => 'ToneCurve' },
	'tonecurveactive' => { 36 => 0x110 },
	'tonecurvename' => { 130 => 'ToneCurveName' },
	'tonecurveproperty' => { 36 => 0x3c },
	'tonecurves' => { 114 => 0x403 },
	'toningeffect' => { 8 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 51 => 0x62 },
	'tracknumber' => { 140 => 'trackNumber' },
	'trailersignature' => { 64 => 'zmie' },
	'transferfunction' => { 137 => 'TransferFunction' },
	'transmissionreference' => { 136 => 'TransmissionReference' },
	'travelday' => { 108 => 0x36 },
	'ttl_da_adown' => { 112 => 0x5 },
	'ttl_da_aup' => { 112 => 0x4 },
	'ttl_da_bdown' => { 112 => 0x7 },
	'ttl_da_bup' => { 112 => 0x6 },
	'tvvalue' => { 28 => 0x1 },
	'type' => { 131 => 'type' },
	'uniquecameramodel' => { 41 => 0xc614 },
	'uniquedocumentid' => { 47 => 0xbb },
	'uniqueobjectname' => { 48 => 0x64 },
	'unsharp1color' => { 98 => 0x13 },
	'unsharp1halowidth' => { 98 => 0x19 },
	'unsharp1intensity' => { 98 => 0x17 },
	'unsharp1threshold' => { 98 => 0x1b },
	'unsharp2color' => { 98 => 0x2e },
	'unsharp2halowidth' => { 98 => 0x34 },
	'unsharp2intensity' => { 98 => 0x32 },
	'unsharp2threshold' => { 98 => 0x36 },
	'unsharp3color' => { 98 => 0x49 },
	'unsharp3halowidth' => { 98 => 0x4f },
	'unsharp3intensity' => { 98 => 0x4d },
	'unsharp3threshold' => { 98 => 0x51 },
	'unsharp4color' => { 98 => 0x64 },
	'unsharp4halowidth' => { 98 => 0x6a },
	'unsharp4intensity' => { 98 => 0x68 },
	'unsharp4threshold' => { 98 => 0x6c },
	'unsharpcount' => { 98 => 0x0 },
	'unsharpmask' => { 94 => 0x76a43200 },
	'urgency' => { 47 => 0xa, 136 => 'Urgency' },
	'url' => { 57 => 'URL', 107 => 'URL', 119 => 0x40b },
	'usageterms' => { 143 => 'UsageTerms' },
	'usercomment' => { 32 => 0x805, 41 => 0x9286, 133 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 19 => 0x7 },
	'utmeasting' => { 68 => 'Easting' },
	'utmmapdatum' => { 68 => 'Datum' },
	'utmnorthing' => { 68 => 'Northing' },
	'utmzone' => { 68 => 'Zone' },
	'validbits' => { 103 => 0x611, 104 => 0x102c },
	'variousmodes' => { 51 => 0x26 },
	'variousmodes2' => { 51 => 0x3a },
	'variprogram' => { 84 => 0xab },
	'version' => { 45 => 0x0, 121 => 'Version', 130 => 'Version' },
	'versionid' => { 141 => 'VersionID' },
	'versionscomments' => { 141 => 'VersionsComments' },
	'versionseventaction' => { 141 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 141 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 141 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 141 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 141 => 'VersionsEventWhen' },
	'versionsmodifier' => { 141 => 'VersionsModifier' },
	'versionsmodifydate' => { 141 => 'VersionsModifyDate' },
	'versionsversion' => { 141 => 'VersionsVersion' },
	'videoalphamode' => { 140 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 140 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 140 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 140 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 140 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 140 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 140 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 140 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 140 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 140 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 140 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 140 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 140 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 140 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 140 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 140 => 'videoColorSpace' },
	'videocompressor' => { 140 => 'videoCompressor' },
	'videofieldorder' => { 140 => 'videoFieldOrder' },
	'videoframerate' => { 140 => 'videoFrameRate' },
	'videoframesizeh' => { 140 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 140 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 140 => 'videoFrameSizeW' },
	'videomoddate' => { 140 => 'videoModDate' },
	'videopixelaspectratio' => { 140 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 140 => 'videoPixelDepth' },
	'vignetteamount' => { 130 => 'VignetteAmount' },
	'vignettecontrol' => { 94 => 0x76a43205 },
	'vignettecontrolintensity' => { 94 => 0xac6bd5c0 },
	'vignettemidpoint' => { 130 => 'VignetteMidpoint' },
	'voicememo' => { 124 => 0x216 },
	'wb_rbgglevels' => { 79 => 0x0 },
	'wb_rblevels' => { 103 => 0x100 },
	'wb_rgbglevels' => { 81 => 0x0 },
	'wb_rggblevels' => { 80 => 0x0 },
	'wb_rggblevelsasshot' => { 3 => 0x19, 4 => 0x18, 5 => 0x3f },
	'wb_rggblevelsauto' => { 2 => 0x0, 3 => 0x1e, 4 => 0x22, 5 => 0x44 },
	'wb_rggblevelscloud' => { 114 => 0x20f },
	'wb_rggblevelscloudy' => { 2 => 0xc, 3 => 0x2d, 4 => 0x31, 5 => 0x58 },
	'wb_rggblevelscustom' => { 2 => 0x1c, 5 => 0x80 },
	'wb_rggblevelscustom1' => { 3 => 0x41 },
	'wb_rggblevelscustom2' => { 3 => 0x46 },
	'wb_rggblevelsdaylight' => { 2 => 0x4, 3 => 0x23, 4 => 0x27, 5 => 0x4e, 114 => 0x20d },
	'wb_rggblevelsflash' => { 2 => 0x18, 3 => 0x3c, 4 => 0x45, 5 => 0x6c, 114 => 0x214 },
	'wb_rggblevelsfluorescent' => { 2 => 0x14, 3 => 0x37, 4 => 0x3b, 5 => 0x62 },
	'wb_rggblevelsfluorescentd' => { 114 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 114 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 114 => 0x213 },
	'wb_rggblevelskelvin' => { 2 => 0x20, 4 => 0x40, 5 => 0x67 },
	'wb_rggblevelsmeasured' => { 5 => 0x49 },
	'wb_rggblevelspc1' => { 4 => 0x90, 5 => 0x71 },
	'wb_rggblevelspc2' => { 4 => 0x95, 5 => 0x76 },
	'wb_rggblevelspc3' => { 4 => 0x9a, 5 => 0x7b },
	'wb_rggblevelsshade' => { 2 => 0x8, 3 => 0x28, 4 => 0x2c, 5 => 0x53, 114 => 0x20e },
	'wb_rggblevelstungsten' => { 2 => 0x10, 3 => 0x32, 4 => 0x36, 5 => 0x5d, 114 => 0x210 },
	'wb_rggblevelsunknown' => { 4 => 0x1d },
	'wb_rggblevelsunknown10' => { 4 => 0x72 },
	'wb_rggblevelsunknown11' => { 4 => 0x77 },
	'wb_rggblevelsunknown12' => { 4 => 0x7c },
	'wb_rggblevelsunknown13' => { 4 => 0x81 },
	'wb_rggblevelsunknown14' => { 4 => 0x86 },
	'wb_rggblevelsunknown15' => { 4 => 0x8b },
	'wb_rggblevelsunknown16' => { 4 => 0x9f },
	'wb_rggblevelsunknown2' => { 4 => 0x4a },
	'wb_rggblevelsunknown3' => { 4 => 0x4f },
	'wb_rggblevelsunknown4' => { 4 => 0x54 },
	'wb_rggblevelsunknown5' => { 4 => 0x59 },
	'wb_rggblevelsunknown6' => { 4 => 0x5e },
	'wb_rggblevelsunknown7' => { 4 => 0x63 },
	'wb_rggblevelsunknown8' => { 4 => 0x68 },
	'wb_rggblevelsunknown9' => { 4 => 0x6d },
	'wbadjbluebalance' => { 99 => 0x8 },
	'wbadjcolortemp' => { 36 => 0x1a },
	'wbadjlighting' => { 99 => 0x15 },
	'wbadjmode' => { 99 => 0x10 },
	'wbadjredbalance' => { 99 => 0x0 },
	'wbadjrgblevels' => { 36 => 0x8 },
	'wbadjtemperature' => { 99 => 0x18 },
	'wbbracketmode' => { 8 => 0x9 },
	'wbbracketvalueab' => { 8 => 0xc },
	'wbbracketvaluegm' => { 8 => 0xd },
	'wbfinetuneactive' => { 36 => 0x24 },
	'wbfinetunesaturation' => { 36 => 0x28 },
	'wbfinetunetone' => { 36 => 0x2c },
	'wblevels' => { 77 => 0x4 },
	'wbmode' => { 76 => 0x4, 104 => 0x1015 },
	'wbscale' => { 77 => 0x0 },
	'wbshiftab' => { 16 => 0xc },
	'wbshiftgm' => { 16 => 0xd },
	'webstatement' => { 143 => 'WebStatement' },
	'whitebalance' => { 16 => 0x8, 17 => 0x7, 37 => 0x7, 38 => [0x19,0x2012], 41 => [0xa403,0xfe4e], 45 => 0x1002, 51 => 0x40, 70 => 0x3, 71 => 0xe, 72 => 0x4, 73 => 0xb, 84 => 0x5, 88 => 0x7, 108 => 0x3, 114 => 0x19, 122 => 0x26, 125 => 0x7, 130 => 'WhiteBalance', 133 => 'WhiteBalance' },
	'whitebalance2' => { 100 => 0x500 },
	'whitebalanceadj' => { 36 => 0x18, 94 => 0x76a43204 },
	'whitebalancebias' => { 38 => 0x2011, 108 => 0x23 },
	'whitebalanceblue' => { 16 => 0x7 },
	'whitebalancebracket' => { 100 => 0x502 },
	'whitebalancefinetune' => { 84 => 0xb },
	'whitebalancemode' => { 114 => 0x1a },
	'whitebalancered' => { 16 => 0x6 },
	'whitebalancetemperature' => { 100 => 0x501 },
	'whitepoint' => { 41 => 0x13e, 114 => 0x201, 137 => 'WhitePoint' },
	'widefocuszone' => { 70 => 0x2f },
	'widerange' => { 124 => 0x20f },
	'workcolorspace' => { 36 => 0x270 },
	'worldtimelocation' => { 114 => 0x22 },
	'writer-editor' => { 47 => 0x7a },
	'x3filllight' => { 125 => 0x12 },
	'xmp' => { 42 => 'XMP' },
	'xpauthor' => { 41 => 0x9c9d },
	'xpcomment' => { 41 => 0x9c9c },
	'xpkeywords' => { 41 => 0x9c9e },
	'xposition' => { 41 => 0x11e },
	'xpsubject' => { 41 => 0x9c9f },
	'xptitle' => { 41 => 0x9c9b },
	'xresolution' => { 41 => 0x11a, 50 => 0x3, 120 => 0x0, 137 => 'XResolution' },
	'xyresolution' => { 44 => 0x3 },
	'ycbcrcoefficients' => { 41 => 0x211, 137 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 41 => 0x213, 137 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 41 => 0x212, 137 => 'YCbCrSubSampling' },
	'yearcreated' => { 51 => 0x10, 53 => 0xc },
	'yposition' => { 41 => 0x11f },
	'yresolution' => { 41 => 0x11b, 50 => 0x5, 120 => 0x4, 137 => 'YResolution' },
	'zonematching' => { 74 => 0x10a, 76 => 0x3a },
	'zonematchingon' => { 72 => 0x75 },
	'zoomsourcewidth' => { 1 => 0x24 },
	'zoomstepcount' => { 102 => 0x300, 104 => 0x100d },
	'zoomtargetwidth' => { 1 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'abstract' => 1,
	'adobe' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afaperture' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afpointsused1d' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationnotes' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blacklevel2' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'camerainfo' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canoncamerainfo' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonvrd' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmcontrast' => 1,
	'cmexposurecompensation' => 1,
	'cmhue' => 1,
	'cmmflags' => 1,
	'cmsaturation' => 1,
	'cmsharpness' => 1,
	'cmwhitebalance' => 1,
	'cmwhitebalancecomp' => 1,
	'cmwhitebalancegraypoint' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringvalues' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'dinf' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'dynamicrangeoptimizer' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'finalimageheight' => 1,
	'finalimagewidth' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'http-equiv' => 1,
	'huesetting' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kbytesize' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikon0x0091' => 1,
	'nikon0x0091encrypted' => 1,
	'nikon0x0091version' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicrawversion' => 1,
	'paragraphs' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'people' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdevelopment' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resolutionunits' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationsetting' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validpixeldepth' => 1,
	'vary' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoformat' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vr_0x66' => 1,
	'vr_0x82' => 1,
	'vrdversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_bluelevel' => 1,
	'wb_grbglevels' => 1,
	'wb_greenlevel' => 1,
	'wb_rblevelsauto' => 1,
	'wb_rblevelscloudy' => 1,
	'wb_rblevelscoolwhitefluor' => 1,
	'wb_rblevelsdaylightfluor' => 1,
	'wb_rblevelsdaywhitefluor' => 1,
	'wb_rblevelseveningsunlight' => 1,
	'wb_rblevelsfineweather' => 1,
	'wb_rblevelsshade' => 1,
	'wb_rblevelstungsten' => 1,
	'wb_rblevelsused' => 1,
	'wb_rblevelswhitefluorescent' => 1,
	'wb_redlevel' => 1,
	'wbadjdata' => 1,
	'whitebalancecomp' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2007, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
