#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.07';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkII_2',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraInfoA55',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::mwg_coll',
	'Image::ExifTool::XMP::mwg_kw',
	'Image::ExifTool::XMP::mwg_rs',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 79 => 0x69 },
	'about' => { 312 => 'about' },
	'abspeakaudiofilepath' => { 318 => 'absPeakAudioFilePath' },
	'accessorytype' => { 226 => 0x53 },
	'actionadvised' => { 93 => 0x2a },
	'activearea' => { 86 => 0xc68d },
	'actived-lighting' => { 163 => 0x22, 191 => 0x24 },
	'actived-lightingmode' => { 191 => 0x25 },
	'addaspectratioinfo' => { 60 => 0x80e },
	'additionalmodelinformation' => { 302 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 60 => 0x80f, 61 => 0x11, 62 => 0x13, 65 => 0x14 },
	'address' => { 119 => 'Address' },
	'adjustmentmode' => { 274 => 0x15 },
	'adultcontentwarning' => { 308 => 'AdultContentWarning', 311 => 'adultContentWarning' },
	'advancedraw' => { 193 => 0x76a43203 },
	'advancedscenemode' => { 226 => 0x3d },
	'advisory' => { 316 => 'Advisory' },
	'ae_iso' => { 229 => 0x2 },
	'aeaperture' => { 229 => 0x1 },
	'aebautocancel' => { 60 => 0x104 },
	'aebbracketvalue' => { 55 => 0x11 },
	'aebsequence' => { 60 => 0x105 },
	'aebsequenceautocancel' => { 58 => 0x9, 59 => 0x9, 61 => 0x8, 62 => 0x9, 65 => 0x9, 66 => 0x7 },
	'aebshotcount' => { 60 => 0x106 },
	'aebxv' => { 229 => 0x4 },
	'aeexposuretime' => { 229 => 0x0 },
	'aelbutton' => { 135 => 0x45 },
	'aelexposureindicator' => { 135 => 0x51 },
	'aelock' => { 135 => 0x5b, 201 => '4.2', 205 => '4.2', 207 => 0x201, 250 => 0x48 },
	'aelockbutton' => { 200 => '16.1', 201 => '4.1', 202 => '15.1', 203 => '30.1', 204 => '16.1', 205 => '4.1', 206 => '17.1' },
	'aelockbuttonplusdials' => { 200 => '16.2', 203 => '32.1' },
	'aelockformb-d80' => { 206 => '3.1' },
	'aemaxaperture' => { 229 => 0x9 },
	'aemaxaperture2' => { 229 => 0xa },
	'aemeteringmode' => { 229 => 0xc },
	'aemeteringsegments' => { 250 => 0x209 },
	'aemicroadjustment' => { 60 => 0x111 },
	'aeminaperture' => { 229 => 0xb },
	'aeminexposuretime' => { 229 => 0x5 },
	'aeprogrammode' => { 229 => 0x6 },
	'aesetting' => { 25 => 0x21 },
	'aexv' => { 229 => 0x3 },
	'af-cpriorityselection' => { 200 => '1.1', 203 => '1.1', 204 => '0.1' },
	'af-onformb-d10' => { 200 => '3.3', 203 => '3.2' },
	'af-onformb-d11' => { 204 => '2.2' },
	'af-spriorityselection' => { 200 => '1.2', 203 => '1.2', 204 => '0.2' },
	'afactivation' => { 200 => '2.1', 203 => '2.1' },
	'afadjustment' => { 250 => 0x72 },
	'afandmeteringbuttons' => { 60 => 0x701 },
	'afaperture' => { 159 => 0x5, 160 => 0x5 },
	'afareaheight' => { 142 => 0x1a },
	'afareaillumination' => { 135 => 0x4b, 205 => '15.3' },
	'afareamode' => { 135 => 0xe, 141 => 0x0, 142 => 0x5, 226 => 0xf, 276 => 0x11, 277 => 0x11, 278 => 0x24 },
	'afareamodesetting' => { 201 => '11.1', 202 => '0.1', 205 => '16.1', 206 => '2.1' },
	'afareas' => { 207 => 0x304 },
	'afareawidth' => { 142 => 0x18 },
	'afareaxposition' => { 142 => 0x14 },
	'afareayposition' => { 142 => 0x16 },
	'afassist' => { 58 => 0x5, 66 => 0x5, 135 => 0x48, 200 => '2.5', 201 => '0.2', 202 => '0.2', 203 => '2.4', 204 => '1.4', 205 => '0.2', 206 => '2.3' },
	'afassistbeam' => { 60 => 0x50e, 61 => 0x4, 62 => 0x5, 63 => 0x4, 64 => 0x4, 65 => 0x5 },
	'afassistlamp' => { 226 => 0x31 },
	'afdefocus' => { 230 => 0x6 },
	'afduringliveview' => { 60 => 0x511 },
	'affinetune' => { 143 => 0x0, 207 => 0x306 },
	'affinetuneadj' => { 143 => 0x2, 171 => 0x2d1, 172 => 0x2dc, 207 => 0x307 },
	'affinetuneindex' => { 143 => 0x1 },
	'afilluminator' => { 276 => 0x29, 283 => 0xb044 },
	'afimageheight' => { 142 => 0x12 },
	'afimagewidth' => { 142 => 0x10 },
	'afintegrationtime' => { 230 => 0x7 },
	'afmicroadjmode' => { 1 => 0x1 },
	'afmicroadjustment' => { 60 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 83 => 0x3009, 274 => 0x5, 283 => 0xb043 },
	'afonaelockbuttonswitch' => { 60 => 0x702 },
	'afonbutton' => { 200 => '3.1' },
	'afpoint' => { 25 => 0x13, 82 => 0x18, 141 => 0x1, 210 => 0x308, 274 => 0x1f },
	'afpointactivationarea' => { 59 => 0x11, 65 => 0x11 },
	'afpointareaexpansion' => { 60 => 0x508 },
	'afpointautoselection' => { 60 => 0x50b },
	'afpointbrightness' => { 60 => 0x50d, 200 => '2.4' },
	'afpointdisplayduringfocus' => { 60 => 0x50c },
	'afpointillumination' => { 59 => 0xa, 200 => '2.3', 203 => '2.3', 204 => '1.3', 206 => '2.4' },
	'afpointmode' => { 234 => 0x3 },
	'afpointposition' => { 83 => 0x2021, 226 => 0x4d },
	'afpointregistration' => { 58 => 0x7 },
	'afpoints' => { 134 => 0x10 },
	'afpointselected' => { 207 => 0x305, 250 => 0xe },
	'afpointselected2' => { 234 => 0x4 },
	'afpointselection' => { 59 => 0xb, 200 => '1.3', 203 => '1.3' },
	'afpointselectionmethod' => { 60 => 0x50f, 61 => 0xc, 62 => 0xd, 65 => 0xd },
	'afpointsinfocus' => { 55 => 0xe, 141 => 0x2, 230 => 0xb, 250 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 15 => 0x38 },
	'afpointspotmetering' => { 59 => 0xd },
	'afpointsunknown1' => { 230 => 0x0 },
	'afpointsunknown2' => { 230 => 0x2 },
	'afpointsused' => { 142 => 0x8 },
	'afpredictor' => { 230 => 0x4 },
	'afresponse' => { 163 => 0xad },
	'afresult' => { 212 => 0x1038 },
	'afsearch' => { 207 => 0x303 },
	'afwithshutter' => { 276 => 0x2a },
	'aggregationtype' => { 309 => 'aggregationType' },
	'agreement' => { 311 => 'agreement' },
	'aiservocontinuousshooting' => { 59 => 0x15 },
	'aiservoimagepriority' => { 60 => 0x503 },
	'aiservotrackingmethod' => { 60 => 0x504 },
	'aiservotrackingsensitivity' => { 59 => 0x14, 60 => 0x502 },
	'album' => { 318 => 'album' },
	'alreadyapplied' => { 295 => 'AlreadyApplied' },
	'alternatetitle' => { 309 => 'alternateTitle' },
	'alttapename' => { 318 => 'altTapeName' },
	'alttimecode' => { 318 => 'altTimecode' },
	'alttimecodetimeformat' => { 318 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 318 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 318 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 262 => 0x14 },
	'ambienttemperaturefahrenheit' => { 262 => 0x13 },
	'analogbalance' => { 86 => 0xc627 },
	'angleadj' => { 79 => 0x8b },
	'anti-blur' => { 283 => 0xb04b },
	'antialiasstrength' => { 86 => 0xc632 },
	'aperturerange' => { 60 => 0x10d },
	'apertureringuse' => { 234 => '1.4' },
	'aperturevalue' => { 69 => 0x2, 86 => 0x9202, 212 => 0x1002, 299 => 'ApertureValue' },
	'applekeywords' => { 216 => 'AAPL:Keywords' },
	'applicationnotes' => { 86 => 0x2bc, 228 => 0x2bc },
	'applicationrecordversion' => { 93 => 0x0 },
	'applyshootingmeteringmode' => { 60 => 0x10e },
	'approved' => { 300 => 'Approved' },
	'approvedby' => { 300 => 'ApprovedBy' },
	'approximatefnumber' => { 222 => 0x313, 227 => 0x3406 },
	'approximatefocusdistance' => { 292 => 'ApproximateFocusDistance' },
	'armidentifier' => { 94 => 0x78 },
	'armversion' => { 94 => 0x7a },
	'artfilter' => { 207 => 0x529 },
	'artfiltereffect' => { 207 => 0x52f },
	'artist' => { 86 => 0x13b, 218 => 'Artist', 250 => 0x22e, 314 => 'Artist', 318 => 'artist' },
	'artworkcopyrightnotice' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 302 => 'ArtworkOrObject' },
	'artworksource' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 302 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 211 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 211 => 0x1112, 250 => 0x80, 276 => 0x55 },
	'asshoticcprofile' => { 86 => 0xc68f },
	'asshotneutral' => { 86 => 0xc628 },
	'asshotpreprofilematrix' => { 86 => 0xc690 },
	'asshotprofilename' => { 86 => 0xc6f6 },
	'asshotwhitexy' => { 86 => 0xc629 },
	'assignbktbutton' => { 200 => '4.2' },
	'assignfuncbutton' => { 60 => 0x70b },
	'assistbuttonfunction' => { 58 => 0xd },
	'attributionname' => { 293 => 'attributionName' },
	'attributionurl' => { 293 => 'attributionURL' },
	'audio' => { 226 => 0x20 },
	'audiobitrate' => { 47 => 0x6c },
	'audiochannels' => { 47 => 0x70 },
	'audiochanneltype' => { 318 => 'audioChannelType' },
	'audiocompression' => { 113 => 'Compression' },
	'audiocompressor' => { 318 => 'audioCompressor' },
	'audioduration' => { 93 => 0x99 },
	'audiomoddate' => { 318 => 'audioModDate' },
	'audiooutcue' => { 93 => 0x9a },
	'audiosamplerate' => { 47 => 0x6e, 318 => 'audioSampleRate' },
	'audiosampletype' => { 318 => 'audioSampleType' },
	'audiosamplingrate' => { 93 => 0x97 },
	'audiosamplingresolution' => { 93 => 0x98 },
	'audiotype' => { 93 => 0x96 },
	'author' => { 115 => 'Author', 216 => 'Author', 218 => 'Author', 261 => 'Author', 291 => 'author', 306 => 'Author', 316 => 'Author' },
	'authorsposition' => { 307 => 'AuthorsPosition' },
	'autoaperture' => { 243 => '0.1' },
	'autobracket' => { 274 => 0x19 },
	'autobracketing' => { 90 => 0x1100, 250 => 0x18 },
	'autobracketmodem' => { 200 => '21.2', 203 => '26.2' },
	'autobracketorder' => { 135 => 0x43, 200 => '21.3', 203 => '26.3', 204 => '12.2', 205 => '2.2', 206 => '13.2' },
	'autobracketset' => { 200 => '21.1', 202 => '11.1', 203 => '26.1', 204 => '12.1', 205 => '2.1', 206 => '13.1' },
	'autobrightness' => { 295 => 'AutoBrightness' },
	'autocontrast' => { 295 => 'AutoContrast' },
	'autodistortioncontrol' => { 150 => 0x4 },
	'autodynamicrange' => { 90 => 0x140b },
	'autoexposure' => { 295 => 'AutoExposure' },
	'autoexposurebracketing' => { 55 => 0x10 },
	'autofocus' => { 210 => 0x209 },
	'autofp' => { 205 => '7.3', 206 => '31.4' },
	'autohdr' => { 278 => 0x2d },
	'autohdrlevel' => { 278 => 0x2e },
	'autoiso' => { 55 => 0x1, 83 => 0x3008, 201 => '1.1', 205 => '1.1' },
	'autoisomax' => { 201 => '1.2', 205 => '1.2' },
	'autoisominshutterspeed' => { 201 => '1.3', 205 => '1.3' },
	'autolightingoptimizer' => { 12 => 0xbe, 13 => 0xbf, 16 => 0xbf, 43 => 0x2, 60 => 0x204, 79 => 0x6f },
	'autolightingoptimizeron' => { 79 => 0x6e },
	'autoredeye' => { 193 => 0xfe28a44f },
	'autorotate' => { 55 => 0x1b },
	'autoshadows' => { 295 => 'AutoShadows' },
	'auxiliarylens' => { 163 => 0x82 },
	'avaperturesetting' => { 234 => 0x13 },
	'avsettingwithoutlens' => { 60 => 0x707 },
	'azimuth' => { 123 => 'Azimuth' },
	'babyage' => { 226 => [0x8010,0x33] },
	'babyname' => { 226 => 0x66 },
	'backgroundalpha' => { 313 => 'bgalpha' },
	'baseexposurecompensation' => { 234 => 0x15 },
	'baseiso' => { 55 => 0x2, 73 => 0x101c, 227 => 0x312a },
	'baselineexposure' => { 86 => 0xc62a },
	'baselinenoise' => { 86 => 0xc62b },
	'baselinesharpness' => { 86 => 0xc62c },
	'baseurl' => { 316 => 'BaseURL' },
	'batterylevel' => { 135 => 0x60 },
	'batteryorder' => { 200 => '12.5', 203 => '13.2', 204 => '2.1' },
	'batteryvoltage' => { 262 => 0x2a },
	'bayergreensplit' => { 86 => 0xc62d },
	'bayerpattern' => { 97 => 0xf902, 138 => 0x17 },
	'beatspliceparams' => { 318 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 318 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 318 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 318 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 318 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 318 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 200 => '13.1', 201 => '0.1', 202 => '2.1', 203 => '10.1', 205 => '0.1', 206 => '4.1' },
	'beeppitch' => { 204 => '3.1' },
	'beepvolume' => { 204 => '4.5' },
	'bestqualityscale' => { 86 => 0xc65c },
	'bestshotmode' => { 83 => 0x3007 },
	'bitdepth' => { 120 => 'BitDepth', 138 => 0x11, 168 => 0x41 },
	'bitspercomponent' => { 95 => 0x87 },
	'bitspersample' => { 86 => 0x102, 314 => 'BitsPerSample' },
	'blacklevel' => { 86 => 0xc61a, 212 => 0x1012 },
	'blacklevel2' => { 211 => 0x600, 215 => 0x600 },
	'blacklevelrepeatdim' => { 86 => 0xc619 },
	'blackpoint' => { 250 => 0x200 },
	'bleachbypasstoning' => { 250 => 0x7f },
	'bluebalance' => { 149 => 0x271, 212 => 0x1018, 228 => 0x12, 250 => 0x1b },
	'bluecurvelimits' => { 78 => 0x1fe },
	'bluecurvepoints' => { 78 => 0x1d4 },
	'bluehue' => { 295 => 'BlueHue' },
	'bluesaturation' => { 295 => 'BlueSaturation' },
	'blurcontrol' => { 250 => 0x82 },
	'blurwarning' => { 90 => 0x1300 },
	'bodybatteryadload' => { 232 => 0x3 },
	'bodybatteryadnoload' => { 232 => 0x2 },
	'bodybatterystate' => { 232 => '1.1' },
	'bodybatteryvoltage1' => { 232 => 0x2 },
	'bodybatteryvoltage2' => { 232 => 0x4 },
	'bodybatteryvoltage3' => { 232 => 0x6 },
	'bodybatteryvoltage4' => { 232 => 0x8 },
	'bodyfirmware' => { 267 => 0x0 },
	'bodyfirmwareversion' => { 208 => 0x104, 209 => 0x100, 212 => 0x104 },
	'bodyserialnumber' => { 267 => 0x10 },
	'bracketmode' => { 39 => 0x3 },
	'bracketsequence' => { 83 => 0x301d },
	'bracketshotnumber' => { 39 => 0x5, 234 => 0x9 },
	'bracketstep' => { 132 => 0xe },
	'bracketvalue' => { 39 => 0x4 },
	'brightness' => { 86 => 0xfe53, 114 => 'Brightness', 132 => 0x2c, 165 => 0x34, 262 => 0x25, 276 => 0x22, 283 => 0x2007, 295 => 'Brightness' },
	'brightnessadj' => { 78 => 0x114, 186 => 0x0, 196 => 0x2d, 286 => 0x8018 },
	'brightnessvalue' => { 86 => 0x9203, 212 => 0x1003, 299 => 'BrightnessValue' },
	'bulbduration' => { 55 => 0x18 },
	'burstmode' => { 100 => 0xa, 226 => 0x2a },
	'burstmode2' => { 100 => 0x18 },
	'burstshot' => { 274 => 0x34 },
	'buttonfunctioncontroloff' => { 60 => 0x70a },
	'bwfilter' => { 132 => 0x2a, 139 => 0x39 },
	'bwmode' => { 212 => 0x203 },
	'by-line' => { 93 => 0x50 },
	'by-linetitle' => { 93 => 0x55 },
	'bytecount' => { 309 => 'byteCount' },
	'calibration' => { 274 => [0x24,0x30] },
	'calibrationilluminant1' => { 86 => 0xc65a },
	'calibrationilluminant2' => { 86 => 0xc65b },
	'cameraangle' => { 318 => 'cameraAngle' },
	'cameracalibration1' => { 86 => 0xc623 },
	'cameracalibration2' => { 86 => 0xc624 },
	'cameracalibrationsig' => { 86 => 0xc6f3 },
	'cameracolorcalibration01' => { 27 => 0x0, 33 => 0xba },
	'cameracolorcalibration02' => { 27 => 0x4, 33 => 0xbf },
	'cameracolorcalibration03' => { 27 => 0x8, 33 => 0xc4 },
	'cameracolorcalibration04' => { 27 => 0xc, 33 => 0xc9 },
	'cameracolorcalibration05' => { 27 => 0x10, 33 => 0xce },
	'cameracolorcalibration06' => { 27 => 0x14, 33 => 0xd3 },
	'cameracolorcalibration07' => { 27 => 0x18, 33 => 0xd8 },
	'cameracolorcalibration08' => { 27 => 0x1c, 33 => 0xdd },
	'cameracolorcalibration09' => { 27 => 0x20, 33 => 0xe2 },
	'cameracolorcalibration10' => { 27 => 0x24, 33 => 0xe7 },
	'cameracolorcalibration11' => { 27 => 0x28, 33 => 0xec },
	'cameracolorcalibration12' => { 27 => 0x2c, 33 => 0xf1 },
	'cameracolorcalibration13' => { 27 => 0x30, 33 => 0xf6 },
	'cameracolorcalibration14' => { 27 => 0x34, 33 => 0xfb },
	'cameracolorcalibration15' => { 27 => 0x38, 33 => 0x100 },
	'cameraid' => { 212 => 0x209, 273 => 0x209 },
	'cameraiso' => { 25 => 0x10 },
	'cameralabel' => { 318 => 'cameraLabel' },
	'cameramodel' => { 318 => 'cameraModel' },
	'cameramove' => { 318 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 7 => 0x30, 9 => 0x35, 10 => 0x30, 11 => 0x30, 12 => 0x31, 13 => 0x31, 14 => 0x35, 15 => 0x27, 16 => 0x31, 18 => 0x38, 19 => 0x36, 21 => 0x11, 252 => 0x1 },
	'cameraowner' => { 101 => 0xc353 },
	'cameraparameters' => { 212 => 0x2050 },
	'cameraprofile' => { 295 => 'CameraProfile' },
	'cameraprofiledigest' => { 295 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 86 => 0xc62f, 131 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 207 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 7 => 0x18, 9 => 0x19, 10 => 0x18, 11 => 0x18, 12 => 0x19, 13 => 0x19, 14 => 0x19, 15 => 0x17, 16 => 0x19, 18 => 0x19, 19 => 0x19, 20 => 0x19, 22 => [0x87,0x91], 23 => [0x99,0x9f,0xa4,0xa8,0x105], 24 => [0x64,0x1d2,0x1f7,0x1fa,0x47,0x53,0x5b,0x5c], 55 => 0xc, 222 => 0x320, 227 => 0x3402, 250 => 0x47, 271 => 0x43 },
	'cameratemperature2' => { 253 => 0xc },
	'cameratemperature3' => { 253 => 0xe },
	'cameratemperature4' => { 253 => 0x14 },
	'cameratemperature5' => { 253 => 0x16 },
	'cameratype' => { 55 => 0x1a, 212 => 0x207 },
	'cameratype2' => { 208 => 0x100 },
	'canonexposuremode' => { 25 => 0x14 },
	'canonfiledescription' => { 73 => 0x805 },
	'canonfilelength' => { 44 => 0xe },
	'canonfirmwareversion' => { 44 => 0x7, 73 => 0x80b },
	'canonflashinfo' => { 73 => 0x1028 },
	'canonflashmode' => { 25 => 0x4 },
	'canonimagesize' => { 6 => 0x39, 25 => 0xa },
	'canonimagetype' => { 44 => 0x6, 73 => 0x815 },
	'canonmodelid' => { 44 => 0x10, 73 => 0x1834 },
	'canonvrd' => { 87 => 'CanonVRD' },
	'caption' => { 291 => 'caption' },
	'caption-abstract' => { 93 => 0x78 },
	'captionsauthornames' => { 298 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 298 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 307 => 'CaptionWriter' },
	'captureframerate' => { 83 => 0x4001 },
	'cardshutterlock' => { 135 => 0x49 },
	'casioimagesize' => { 83 => 0x9 },
	'catalogsets' => { 93 => 0xff, 290 => 'CatalogSets' },
	'categories' => { 44 => 0x23, 291 => 'categories' },
	'category' => { 93 => 0xf, 307 => 'Category' },
	'ccdboardversion' => { 222 => 0x331 },
	'ccdscanmode' => { 212 => 0x1039 },
	'ccdsensitivity' => { 183 => 0x6 },
	'ccdversion' => { 222 => 0x330 },
	'cellglobalid' => { 294 => 'cgi' },
	'celllength' => { 86 => 0x109 },
	'cellr' => { 294 => 'r' },
	'celltowerid' => { 294 => 'cellid' },
	'cellwidth' => { 86 => 0x108 },
	'centerafarea' => { 205 => '15.1' },
	'centerfocuspoint' => { 206 => '2.2' },
	'centerweightedareasize' => { 200 => '7.1', 203 => '5.1', 204 => '7.1', 205 => '6.3', 206 => '8.1' },
	'certificate' => { 322 => 'Certificate' },
	'cfapattern' => { 86 => 0xa302, 299 => 'CFAPattern' },
	'cfapatterncolumns' => { 299 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 299 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 299 => [\'CFAPattern','CFAPatternValues'] },
	'channel' => { 309 => 'channel' },
	'channels' => { 113 => 'Channels' },
	'checkmark' => { 78 => 0x26a },
	'checkmark2' => { 79 => 0x8e },
	'childfontfiles' => { 323 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 200 => '10.3' },
	'chromablurradius' => { 86 => 0xc631 },
	'chromaticaberration' => { 79 => 0x66 },
	'chromaticaberrationb' => { 295 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 79 => 0x6b },
	'chromaticaberrationcorrection' => { 242 => 0x1 },
	'chromaticaberrationon' => { 79 => 0x62 },
	'chromaticaberrationr' => { 295 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 79 => 0x6a },
	'chrominancenoisereduction' => { 79 => 0x5e, 274 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 79 => 0x60 },
	'city' => { 93 => 0x5a, 119 => 'City', 226 => 0x6d, 307 => 'City' },
	'clarity' => { 295 => 'Clarity' },
	'classifystate' => { 93 => 0xe1 },
	'client' => { 318 => 'client' },
	'clientname' => { 300 => 'ClientName' },
	'clmodeshootingspeed' => { 200 => '10.2', 203 => '11.2', 204 => '10.2', 206 => '11.1' },
	'cmcontrast' => { 215 => 0x2022 },
	'cmexposurecompensation' => { 215 => 0x2000 },
	'cmhue' => { 215 => 0x2021 },
	'cmsaturation' => { 215 => 0x2020 },
	'cmsharpness' => { 215 => 0x2023 },
	'cmwhitebalance' => { 215 => 0x2001 },
	'cmwhitebalancecomp' => { 215 => 0x2002 },
	'cmwhitebalancegraypoint' => { 215 => 0x2010 },
	'codec' => { 127 => 'Codec' },
	'codedcharacterset' => { 94 => 0x5a },
	'collectionname' => { 303 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 303 => 'Collections' },
	'collectionuri' => { 303 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 193 => 0xc89224b },
	'coloradjustment' => { 274 => 0x14 },
	'coloradjustmentmode' => { 273 => 0x210 },
	'coloranta' => { 323 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 323 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 323 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 323 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 323 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 323 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 323 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 323 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 323 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 323 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 323 => 'Colorants' },
	'colorantswatchname' => { 323 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 323 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 323 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 323 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 114 => 'ColorBalance' },
	'colorbalanceadj' => { 193 => 0x76a43202 },
	'colorbalanceblue' => { 132 => 0x1e },
	'colorbalancegreen' => { 132 => 0x1d },
	'colorbalancered' => { 132 => 0x1c },
	'colorblur' => { 79 => 0x65 },
	'colorbooster' => { 193 => 0x5f0e7d23 },
	'colorboostlevel' => { 187 => 0x1 },
	'colorboosttype' => { 187 => 0x0 },
	'colorclass' => { 256 => 0xde },
	'colorcompensationfilter' => { 135 => [0x3a,0x5f], 136 => 0x111, 283 => 0xb022 },
	'colorcontrol' => { 212 => 0x102b },
	'colorcorrection' => { 286 => 0x8015 },
	'colordataversion' => { 31 => 0x0, 32 => 0x0, 34 => 0x0 },
	'coloreffect' => { 226 => 0x28 },
	'colorfilter' => { 82 => 0x17, 83 => 0x3017, 132 => 0x29, 139 => [0x38,0x4d,0x4f], 255 => 0x17 },
	'colorgain' => { 168 => 0x51 },
	'colorhue' => { 163 => 0x8d },
	'colorimetricreference' => { 86 => 0xc6bf },
	'colorlabel' => { 298 => 'ColorLabel' },
	'colormatrix' => { 211 => 0x200, 212 => 0x1011, 271 => 0xa030 },
	'colormatrix1' => { 86 => 0xc621 },
	'colormatrix2' => { 86 => 0xc622, 215 => 0x200 },
	'colormatrixa' => { 250 => 0x203 },
	'colormatrixadobergb' => { 271 => 0xa032 },
	'colormatrixb' => { 250 => 0x204 },
	'colormatrixnumber' => { 212 => 0x1019 },
	'colormatrixsrgb' => { 271 => 0xa031 },
	'colormode' => { 83 => 0x3015, 90 => 0x1210, 100 => 0x66, 132 => 0x28, 135 => 0x16, 136 => 0x101, 139 => 0x7, 163 => 0x3, 183 => 0x4, 226 => 0x32, 274 => 0x2c, 283 => 0xb029, 307 => 'ColorMode' },
	'colormoirereduction' => { 194 => 0x15 },
	'colormoirereductionmode' => { 194 => 0x5 },
	'colornoisereduction' => { 286 => 0x8029, 295 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 295 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 194 => 0x18 },
	'colornoisereductionsharpness' => { 194 => 0x1c },
	'colorplanes' => { 89 => 0x2 },
	'colorprofile' => { 132 => 0x33 },
	'colorrepresentation' => { 95 => 0x3c },
	'colorreproduction' => { 283 => 0xb020 },
	'colorsequence' => { 95 => 0x41 },
	'colorspace' => { 35 => 0x3, 44 => 0xb4, 73 => 0x10b4, 86 => 0xa001, 120 => 'ColorSpace', 133 => 0x2f, 134 => 0x25, 135 => 0x17, 163 => 0x1e, 207 => 0x507, 250 => 0x37, 271 => 0xa011, 274 => 0xb, 299 => 'ColorSpace' },
	'colortempasshot' => { 28 => 0x4, 29 => 0x1d, 30 => 0x26, 31 => 0x43, 34 => 0x43 },
	'colortempauto' => { 28 => 0x9, 29 => 0x22, 30 => 0x1c, 31 => 0x48, 34 => 0x48 },
	'colortempcloudy' => { 28 => 0x22, 29 => 0x31, 30 => 0x35, 31 => 0x5c, 34 => 0x75 },
	'colortempcustom' => { 31 => 0x84 },
	'colortempcustom1' => { 29 => 0x45 },
	'colortempcustom2' => { 29 => 0x4a },
	'colortempdaylight' => { 28 => 0x18, 29 => 0x27, 30 => 0x2b, 31 => 0x52, 34 => 0x6b },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0x37, 7 => 0x62, 8 => 0x37, 9 => [0x7b,0x7c], 10 => 0x73, 11 => 0x73, 12 => 0x77, 13 => 0x73, 14 => 0x7c, 15 => 0x58, 16 => 0x73, 18 => 0x7f, 19 => 0x7d, 21 => 0x57, 44 => 0xae, 53 => 0x9, 73 => 0x10ae, 90 => 0x1005, 98 => 0x846, 114 => 'ColorTemperature', 133 => [0x6e,0x49], 134 => 0x3f, 135 => [0x39,0x5e], 136 => 0x10b, 139 => [0x3c,0x4c,0x4e], 222 => 0x321, 250 => 0x50, 283 => 0xb021, 295 => 'Temperature' },
	'colortemperatureadj' => { 286 => 0x8013 },
	'colortemperaturebg' => { 212 => 0x1013 },
	'colortemperaturerg' => { 212 => 0x1014 },
	'colortemperaturesetting' => { 135 => 0x25 },
	'colortempflash' => { 28 => 0x36, 29 => 0x40, 30 => 0x49, 31 => 0x70, 34 => 0x89 },
	'colortempflashdata' => { 31 => 0x24a },
	'colortempfluorescent' => { 28 => 0x2c, 29 => 0x3b, 30 => 0x3f, 31 => 0x66, 34 => 0x7f },
	'colortempkelvin' => { 28 => 0x31, 30 => 0x44, 31 => 0x6b, 34 => 0x84 },
	'colortempmeasured' => { 28 => 0xe, 31 => 0x4d, 34 => 0x4d },
	'colortemppc1' => { 30 => 0x94, 31 => 0x75 },
	'colortemppc2' => { 30 => 0x99, 31 => 0x7a },
	'colortemppc3' => { 30 => 0x9e, 31 => 0x7f },
	'colortempshade' => { 28 => 0x1d, 29 => 0x2c, 30 => 0x30, 31 => 0x57, 34 => 0x70 },
	'colortemptungsten' => { 28 => 0x27, 29 => 0x36, 30 => 0x3a, 31 => 0x61, 34 => 0x7a },
	'colortempunknown' => { 28 => 0x13, 30 => 0x21, 34 => 0x52 },
	'colortempunknown10' => { 28 => 0x63, 30 => 0x76, 34 => 0xa2 },
	'colortempunknown11' => { 28 => 0x68, 30 => 0x7b, 34 => 0xa7 },
	'colortempunknown12' => { 28 => 0x6d, 30 => 0x80, 34 => 0xac },
	'colortempunknown13' => { 28 => 0x72, 30 => 0x85, 34 => 0xb1 },
	'colortempunknown14' => { 30 => 0x8a, 34 => 0xb6 },
	'colortempunknown15' => { 30 => 0x8f, 34 => 0xbb },
	'colortempunknown16' => { 30 => 0xa3 },
	'colortempunknown2' => { 28 => 0x3b, 30 => 0x4e, 34 => 0x57 },
	'colortempunknown3' => { 28 => 0x40, 30 => 0x53, 34 => 0x5c },
	'colortempunknown4' => { 28 => 0x45, 30 => 0x58, 34 => 0x61 },
	'colortempunknown5' => { 28 => 0x4a, 30 => 0x5d, 34 => 0x66 },
	'colortempunknown6' => { 28 => 0x4f, 30 => 0x62, 34 => 0x8e },
	'colortempunknown7' => { 28 => 0x54, 30 => 0x67, 34 => 0x93 },
	'colortempunknown8' => { 28 => 0x59, 30 => 0x6c, 34 => 0x98 },
	'colortempunknown9' => { 28 => 0x5e, 30 => 0x71, 34 => 0x9d },
	'colortone' => { 6 => 0x6f, 8 => 0x77, 25 => 0x2a, 35 => 0x2 },
	'colortoneadj' => { 78 => 0x11e },
	'colortonefaithful' => { 15 => 0x107, 49 => 0x6c, 50 => 0x6c },
	'colortonelandscape' => { 15 => 0x105, 49 => 0x3c, 50 => 0x3c },
	'colortonemonochrome' => { 49 => 0x84, 50 => 0x84 },
	'colortoneneutral' => { 15 => 0x106, 49 => 0x54, 50 => 0x54 },
	'colortoneportrait' => { 15 => 0x104, 49 => 0x24, 50 => 0x24 },
	'colortonestandard' => { 15 => 0x103, 49 => 0xc, 50 => 0xc },
	'colortoneunknown' => { 50 => 0x9c },
	'colortoneuserdef1' => { 15 => 0x109, 49 => 0x9c, 50 => 0xb4 },
	'colortoneuserdef2' => { 15 => 0x10a, 49 => 0xb4, 50 => 0xcc },
	'colortoneuserdef3' => { 15 => 0x10b, 49 => 0xcc, 50 => 0xe4 },
	'commanddials' => { 205 => '5.1' },
	'commanddialsaperturesetting' => { 200 => '17.3', 203 => '33.3', 204 => '17.3' },
	'commanddialschangemainsub' => { 200 => '17.2', 203 => '33.2', 204 => '17.2' },
	'commanddialsmenuandplayback' => { 200 => '17.4', 203 => '33.4', 204 => '17.4' },
	'commanddialsreverserotation' => { 200 => '17.1', 202 => '16.2', 203 => '33.1', 204 => '17.1', 206 => '18.1' },
	'commanderchannel' => { 205 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 205 => '13.1' },
	'commandergroupa_ttlcomp' => { 206 => '32.1' },
	'commandergroupamanualoutput' => { 205 => '13.2' },
	'commandergroupamode' => { 205 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 205 => '14.1' },
	'commandergroupb_ttlcomp' => { 206 => '33.1' },
	'commandergroupbmanualoutput' => { 205 => '14.2' },
	'commandergroupbmode' => { 205 => '11.3' },
	'commanderinternalflash' => { 205 => '11.1' },
	'commanderinternalmanualoutput' => { 205 => '12.2' },
	'commanderinternalttlchannel' => { 203 => '18.2' },
	'commanderinternalttlcomp' => { 205 => '12.1', 206 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 203 => '20.1', 204 => '26.1' },
	'commanderinternalttlcompgroupa' => { 203 => '21.1', 204 => '27.1' },
	'commanderinternalttlcompgroupb' => { 203 => '22.1', 204 => '28.1' },
	'comment' => { 0 => 0x2, 87 => 'Comment', 115 => 'Comment', 218 => 'Comment' },
	'complianceprofile' => { 309 => 'complianceProfile' },
	'componentsconfiguration' => { 86 => 0x9101, 120 => 'Components', 299 => 'ComponentsConfiguration' },
	'componentversion' => { 73 => 0x80c },
	'composer' => { 318 => 'composer' },
	'compositionadjust' => { 249 => '0.1' },
	'compositionadjustrotation' => { 249 => 0x7 },
	'compositionadjustx' => { 249 => 0x5 },
	'compositionadjusty' => { 249 => 0x6 },
	'compressedbitsperpixel' => { 86 => 0x9102, 299 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 136 => 0x40, 212 => 0x40 },
	'compression' => { 86 => 0x103, 314 => 'Compression' },
	'compressionfactor' => { 207 => 0x50d },
	'compressionratio' => { 120 => 'Compression', 212 => 0x1034 },
	'constrainedcropheight' => { 78 => 0x266, 256 => 0xd6 },
	'constrainedcropwidth' => { 78 => 0x262, 256 => 0xd5 },
	'contact' => { 93 => 0x76 },
	'contentlocationcode' => { 93 => 0x1a },
	'contentlocationname' => { 93 => 0x1b },
	'continuousbracketing' => { 135 => 0x20 },
	'continuousdrive' => { 25 => 0x5 },
	'continuousshootingspeed' => { 60 => 0x610 },
	'continuousshotlimit' => { 60 => 0x611 },
	'contrast' => { 6 => 0x73, 8 => 0x75, 25 => 0xd, 82 => 0xc, 83 => [0x3012,0x20], 86 => [0xa408,0xfe54], 90 => [0x1004,0x1006], 114 => 'Contrast', 132 => 0x20, 133 => 0x31, 134 => 0x27, 135 => 0x19, 139 => 0x2, 165 => 0x33, 212 => 0x1029, 226 => 0x39, 227 => 0x300a, 250 => 0x20, 255 => 0xc, 262 => 0x24, 274 => 0xd, 276 => 0x1d, 277 => 0x1a, 283 => 0x2004, 295 => 'Contrast', 299 => 'Contrast' },
	'contrastadj' => { 78 => 0x115, 196 => 0x2c, 286 => 0x8017 },
	'contrastcurve' => { 163 => 0x8c },
	'contrastdetectaf' => { 142 => 0x4 },
	'contrastdetectafarea' => { 250 => 0x231 },
	'contrastdetectafinfocus' => { 142 => 0x1c },
	'contrastfaithful' => { 15 => 0xec, 49 => 0x60, 50 => 0x60 },
	'contrasthighlight' => { 250 => 0x6d },
	'contrasthighlightshadowadj' => { 250 => 0x6f },
	'contrastlandscape' => { 15 => 0xea, 49 => 0x30, 50 => 0x30 },
	'contrastmode' => { 226 => 0x2c },
	'contrastmonochrome' => { 15 => 0xed, 49 => 0x78, 50 => 0x78 },
	'contrastneutral' => { 15 => 0xeb, 49 => 0x48, 50 => 0x48 },
	'contrastportrait' => { 15 => 0xe9, 49 => 0x18, 50 => 0x18 },
	'contrastsetting' => { 207 => 0x505, 215 => 0x1012 },
	'contrastshadow' => { 250 => 0x6e },
	'contraststandard' => { 15 => 0xe8, 49 => 0x0, 50 => 0x0 },
	'contrastunknown' => { 50 => 0x90 },
	'contrastuserdef1' => { 15 => 0xee, 49 => 0x90, 50 => 0xa8 },
	'contrastuserdef2' => { 15 => 0xef, 49 => 0xa8, 50 => 0xc0 },
	'contrastuserdef3' => { 15 => 0xf0, 49 => 0xc0, 50 => 0xd8 },
	'contributedmedia' => { 318 => 'contributedMedia' },
	'contributedmediaduration' => { 318 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 318 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 318 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 318 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 318 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 318 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 318 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 318 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 318 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 318 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 296 => 'contributor' },
	'contributors' => { 115 => 'Contributors' },
	'controldialset' => { 135 => 0x46 },
	'controlledvocabularyterm' => { 302 => 'CVterm' },
	'controllerboardversion' => { 222 => 0x332 },
	'controlmode' => { 55 => 0x12 },
	'conversionlens' => { 226 => 0x35 },
	'converter' => { 86 => 0xfe4d, 183 => 0xb, 295 => 'Converter' },
	'converttograyscale' => { 295 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 86 => 0x8298, 115 => 'Copyright', 218 => 'Copyright', 250 => 0x22f, 261 => 'Copyright', 306 => 'Copyright', 309 => 'copyright', 311 => 'copyright', 314 => 'Copyright', 318 => 'copyright' },
	'copyrightflag' => { 259 => 0x40a },
	'copyrightnotice' => { 93 => 0x74 },
	'copyrightowner' => { 308 => 'CopyrightOwner' },
	'copyrightownerid' => { 308 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 308 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 308 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 308 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 308 => 'CopyrightStatus' },
	'coringfilter' => { 211 => 0x310, 212 => 0x102d, 215 => 0x310 },
	'coringvalues' => { 211 => 0x311, 215 => 0x311 },
	'corporateentity' => { 309 => 'corporateEntity' },
	'country' => { 119 => 'Country', 226 => 0x69, 307 => 'Country' },
	'country-primarylocationcode' => { 93 => 0x64 },
	'country-primarylocationname' => { 93 => 0x65 },
	'countrycode' => { 162 => 0x5, 257 => 'CountryCode', 301 => 'CountryCode' },
	'coverage' => { 296 => 'coverage' },
	'coverdate' => { 309 => 'coverDate' },
	'coverdisplaydate' => { 309 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 250 => 0x28 },
	'crc32' => { 297 => 'crc32' },
	'createdate' => { 86 => 0x9004, 115 => 'CreateDate', 216 => 'CreationDate', 218 => 'create-date', 261 => 'CreationDate', 316 => 'CreateDate' },
	'creationdate' => { 306 => 'CreationDate', 309 => 'creationDate' },
	'creationtime' => { 218 => 'Creation Time' },
	'creativestyle' => { 276 => 0x1a, 277 => 0x18 },
	'creativestylewaschanged' => { 286 => 0x8001 },
	'creator' => { 216 => 'Creator', 261 => 'Creator', 296 => 'creator', 306 => 'Creator' },
	'creatoraddress' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 301 => 'CreatorContactInfo' },
	'creatorcountry' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 316 => 'CreatorTool' },
	'creatorworkemail' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 301 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 93 => 0x6e, 307 => 'Credit' },
	'creditline' => { 311 => 'creditLine' },
	'creditlinereq' => { 321 => 'CreditLineReq' },
	'creditlinerequired' => { 308 => 'CreditLineRequired' },
	'cropactive' => { 78 => 0x244 },
	'cropangle' => { 295 => 'CropAngle' },
	'cropaspectratio' => { 78 => 0x260 },
	'cropbottom' => { 89 => 0x9, 188 => 0x36, 256 => 0xdc, 295 => 'CropBottom' },
	'cropbottommargin' => { 36 => 0x3 },
	'cropconstraintowarp' => { 295 => 'CropConstrainToWarp' },
	'cropheight' => { 78 => 0x24c, 211 => 0x615, 215 => 0x615, 295 => 'CropHeight' },
	'crophispeed' => { 163 => 0x1b },
	'cropleft' => { 78 => 0x246, 89 => 0x6, 188 => 0x1e, 211 => 0x612, 215 => 0x612, 256 => 0xd9, 295 => 'CropLeft' },
	'cropleftmargin' => { 36 => 0x0 },
	'cropoutputheight' => { 188 => 0xce },
	'cropoutputheightinches' => { 188 => 0x96 },
	'cropoutputpixels' => { 188 => 0xd6 },
	'cropoutputresolution' => { 188 => 0xb6 },
	'cropoutputscale' => { 188 => 0xbe },
	'cropoutputwidth' => { 188 => 0xc6 },
	'cropoutputwidthinches' => { 188 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 89 => 0x8, 188 => 0x2e, 256 => 0xdb, 295 => 'CropRight' },
	'croprightmargin' => { 36 => 0x1 },
	'croprotation' => { 89 => 0xb },
	'cropscaledresolution' => { 188 => 0x9e },
	'cropsourceresolution' => { 188 => 0xae },
	'croptop' => { 78 => 0x248, 89 => 0x7, 188 => 0x26, 211 => 0x613, 215 => 0x613, 256 => 0xda, 295 => 'CropTop' },
	'croptopmargin' => { 36 => 0x2 },
	'cropunit' => { 295 => 'CropUnit' },
	'cropunits' => { 295 => 'CropUnits' },
	'cropwidth' => { 78 => 0x24a, 211 => 0x614, 215 => 0x614, 295 => 'CropWidth' },
	'crossprocess' => { 250 => 0x7b },
	'crossprocessparams' => { 250 => 0x235 },
	'currenticcprofile' => { 86 => 0xc691 },
	'currentpreprofilematrix' => { 86 => 0xc692 },
	'currentversion' => { 286 => 0xd000 },
	'curves' => { 193 => 0x76a43201 },
	'custom1' => { 308 => 'Custom1' },
	'custom10' => { 308 => 'Custom10' },
	'custom2' => { 308 => 'Custom2' },
	'custom3' => { 308 => 'Custom3' },
	'custom4' => { 308 => 'Custom4' },
	'custom5' => { 308 => 'Custom5' },
	'custom6' => { 308 => 'Custom6' },
	'custom7' => { 308 => 'Custom7' },
	'custom8' => { 308 => 'Custom8' },
	'custom9' => { 308 => 'Custom9' },
	'customcontrast' => { 79 => 0x4e },
	'customcontrols' => { 60 => 0x70c },
	'customlinear' => { 79 => 0x4f },
	'customoutputhighlightpoint' => { 79 => 0x53 },
	'customoutputshadowpoint' => { 79 => 0x54 },
	'custompicturestylefilename' => { 44 => 0x4010 },
	'customrawhighlight' => { 79 => 0x7c },
	'customrawhighlightpoint' => { 79 => 0x51 },
	'customrawshadow' => { 79 => 0x85 },
	'customrawshadowpoint' => { 79 => 0x52 },
	'customrendered' => { 86 => 0xa401, 299 => 'CustomRendered' },
	'customsaturation' => { 207 => 0x503 },
	'customsettingsalldefault' => { 200 => '0.2', 203 => '0.2' },
	'customsettingsbank' => { 200 => '0.1', 203 => '0.1' },
	'customsharpness' => { 79 => 0x50 },
	'customwbbluelevel' => { 135 => 0x36 },
	'customwberror' => { 135 => 0x37 },
	'customwbgreenlevel' => { 135 => 0x35 },
	'customwbredlevel' => { 135 => 0x34 },
	'customwbsetting' => { 135 => 0x26 },
	'd-lightinghq' => { 193 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 189 => 0x2 },
	'd-lightinghqhighlight' => { 189 => 0x1 },
	'd-lightinghqselected' => { 193 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 189 => 0x0 },
	'd-lightinghs' => { 193 => 0xce5554aa },
	'd-lightinghsadjustment' => { 190 => 0x0 },
	'd-lightinghscolorboost' => { 190 => 0x1 },
	'd-rangeoptimizerhighlight' => { 286 => 0x8024 },
	'd-rangeoptimizermode' => { 286 => 0x8022 },
	'd-rangeoptimizershadow' => { 286 => 0x802d },
	'd-rangeoptimizervalue' => { 286 => 0x8023 },
	'datacompressionmethod' => { 95 => 0x6e },
	'dataimprint' => { 132 => 0x34 },
	'date' => { 250 => 0x6, 296 => 'date' },
	'dateacquired' => { 131 => 'DateAcquired' },
	'datecreated' => { 93 => 0x37, 307 => 'DateCreated' },
	'datedisplayformat' => { 185 => 0x3 },
	'dateimprint' => { 202 => '4.2' },
	'daterecieved' => { 309 => 'dateRecieved' },
	'datesent' => { 94 => 0x46 },
	'datestampmode' => { 44 => 0x1c },
	'datetime' => { 291 => 'datetime', 314 => 'DateTime' },
	'datetimedigitized' => { 299 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 76 => 0x0, 86 => 0x9003, 112 => 0x14, 115 => 'OriginalDate', 262 => 0xb, 299 => 'DateTimeOriginal' },
	'datetimestamp' => { 100 => 0x64 },
	'daylightsavings' => { 185 => 0x2 },
	'declination' => { 123 => 'Declination' },
	'decposition' => { 132 => 0x32 },
	'defaultcroporigin' => { 86 => 0xc61f },
	'defaultcropsize' => { 86 => 0xc620 },
	'defaultscale' => { 86 => 0xc61e },
	'defringe' => { 295 => 'Defringe' },
	'deletedimagecount' => { 163 => 0xa6, 169 => 0x6e },
	'derivedfrom' => { 319 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 319 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 319 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 319 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 319 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 319 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 319 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 319 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 319 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 319 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 319 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 319 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 319 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 319 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 319 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 319 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 319 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 319 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 218 => 'Description', 296 => 'description', 316 => 'Description' },
	'destination' => { 94 => 0x5 },
	'destinationcity' => { 250 => 0x24, 254 => 0x3 },
	'destinationcitycode' => { 255 => 0x1001 },
	'destinationdst' => { 250 => 0x26, 254 => '0.3' },
	'developmentdynamicrange' => { 90 => 0x1403 },
	'devicesettingdescription' => { 299 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 299 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 299 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 299 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 60 => 0x706 },
	'digitalcreationdate' => { 93 => 0x3e },
	'digitalcreationtime' => { 93 => 0x3f },
	'digitaldeehighlightadj' => { 168 => 0x202 },
	'digitaldeeshadowadj' => { 168 => 0x200 },
	'digitaldeethreshold' => { 168 => 0x201 },
	'digitalfilter01' => { 240 => 0x5 },
	'digitalfilter02' => { 240 => 0x16 },
	'digitalfilter03' => { 240 => 0x27 },
	'digitalfilter04' => { 240 => 0x38 },
	'digitalfilter05' => { 240 => 0x49 },
	'digitalfilter06' => { 240 => 0x5a },
	'digitalfilter07' => { 240 => 0x6b },
	'digitalfilter08' => { 240 => 0x7c },
	'digitalfilter09' => { 240 => 0x8d },
	'digitalfilter10' => { 240 => 0x9e },
	'digitalfilter11' => { 240 => 0xaf },
	'digitalfilter12' => { 240 => 0xc0 },
	'digitalfilter13' => { 240 => 0xd1 },
	'digitalfilter14' => { 240 => 0xe2 },
	'digitalfilter15' => { 240 => 0xf3 },
	'digitalfilter16' => { 240 => 0x104 },
	'digitalfilter17' => { 240 => 0x115 },
	'digitalfilter18' => { 240 => 0x126 },
	'digitalfilter19' => { 240 => 0x137 },
	'digitalfilter20' => { 240 => 0x148 },
	'digitalgain' => { 53 => 0xb },
	'digitalgem' => { 156 => 0x0 },
	'digitalice' => { 168 => 0x100 },
	'digitalimageguid' => { 302 => 'DigImageGUID' },
	'digitalroc' => { 167 => 0x0 },
	'digitalsourcefiletype' => { 302 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 302 => 'DigitalSourceType' },
	'digitalzoom' => { 25 => 0xc, 82 => 0xa, 100 => 0x68, 114 => 'DigitalZoom', 132 => 0xc, 163 => 0x86, 183 => 0xa, 212 => 0x204, 250 => 0x1e, 255 => 0xa, 273 => 0x204 },
	'digitalzoomon' => { 273 => 0x21b },
	'digitalzoomratio' => { 86 => 0xa404, 299 => 'DigitalZoomRatio' },
	'director' => { 318 => 'director' },
	'directorphotography' => { 318 => 'directorPhotography' },
	'directory' => { 87 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 7 => 0x17e, 9 => [0x233,0x238], 10 => 0x13f, 11 => 0x133, 12 => 0x1df, 13 => [0x1a3,0x1a7], 14 => 0x1f0, 17 => 0x49, 18 => 0x1e7, 19 => 0x1e5, 21 => 0x1d3 },
	'directorynumber' => { 152 => 0x6 },
	'disclaimer' => { 218 => 'Disclaimer' },
	'displayallafpoints' => { 60 => 0x514 },
	'displayaperture' => { 25 => 0x23 },
	'displayedunitsx' => { 260 => 0x2 },
	'displayedunitsy' => { 260 => 0x6 },
	'distance1' => { 100 => 0x28 },
	'distance2' => { 100 => 0x2c },
	'distance3' => { 100 => 0x30 },
	'distance4' => { 100 => 0x34 },
	'distortioncontrol' => { 169 => 0x10 },
	'distortioncorrection' => { 79 => 0x67, 207 => 0x50b, 242 => 0x0, 283 => 0x2013 },
	'distortioncorrection2' => { 211 => 0x1011 },
	'distortioncorrectionon' => { 79 => 0x63 },
	'distributor' => { 309 => 'distributor' },
	'dmcomment' => { 318 => 'comment' },
	'dngbackwardversion' => { 86 => 0xc613 },
	'dnglensinfo' => { 86 => 0xc630 },
	'dngversion' => { 86 => 0xc612 },
	'document' => { 218 => 'Document' },
	'documentancestorid' => { 307 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 307 => 'DocumentAncestors' },
	'documenthistory' => { 93 => 0xe7 },
	'documentid' => { 319 => 'DocumentID' },
	'documentname' => { 86 => 0x10d },
	'documentnotes' => { 93 => 0xe6 },
	'doi' => { 309 => 'doi' },
	'dotrange' => { 86 => 0x150 },
	'dpp' => { 291 => 'dpp' },
	'drivemode' => { 83 => 0x3103, 132 => 0x6, 135 => 0x1e, 207 => 0x600, 250 => 0x34, 274 => 0x3, 276 => 0x4 },
	'drivemode2' => { 135 => 0xa, 234 => 0x7 },
	'dspfirmwareversion' => { 250 => 0x27 },
	'duration' => { 47 => 0x6a, 113 => 'Duration', 127 => 'Duration', 318 => 'duration' },
	'durationscale' => { 318 => [\'duration','durationScale'] },
	'durationvalue' => { 318 => [\'duration','durationValue'] },
	'dustremovaldata' => { 44 => 0x97 },
	'dynamicafarea' => { 200 => '1.4', 203 => '1.4' },
	'dynamicrange' => { 90 => 0x1400 },
	'dynamicrangeexpansion' => { 250 => 0x69 },
	'dynamicrangemax' => { 78 => 0x7c },
	'dynamicrangemin' => { 78 => 0x7a },
	'dynamicrangeoptimizer' => { 135 => 0x15, 283 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 276 => 0x19, 277 => 0x17, 278 => 0xd },
	'dynamicrangeoptimizermode' => { 276 => 0x18, 277 => 0x16 },
	'dynamicrangeoptimizersetting' => { 135 => 0x27, 278 => 0xc },
	'dynamicrangesetting' => { 90 => 0x1402 },
	'e-dialinprogram' => { 234 => '1.3' },
	'easyexposurecomp' => { 206 => '6.1' },
	'easyexposurecompensation' => { 200 => '6.4', 203 => '4.4', 204 => '5.2' },
	'easymode' => { 25 => 0xb },
	'edgenoisereduction' => { 194 => 0x4, 286 => 0x8028 },
	'edition' => { 309 => 'edition' },
	'editorialupdate' => { 93 => 0x8 },
	'editstatus' => { 93 => 0x7, 257 => 'EditStatus' },
	'editversionname' => { 193 => 0x3d136244 },
	'effectivelv' => { 250 => 0x2d },
	'effectivemaxaperture' => { 159 => 0x12, 160 => 0x13 },
	'eissn' => { 309 => 'eIssn' },
	'elevation' => { 123 => 'Elevation' },
	'email' => { 115 => 'EMail' },
	'embargodate' => { 309 => 'embargoDate', 311 => 'embargoDate' },
	'encryptionkey' => { 271 => 0xa020 },
	'endingpage' => { 309 => 'endingPage' },
	'enduser' => { 308 => 'EndUser' },
	'enduserid' => { 308 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 308 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 318 => 'engineer' },
	'enhancedarktones' => { 186 => 0x8 },
	'enhancement' => { 82 => 0x16, 83 => 0x3016 },
	'enhancer' => { 211 => 0x300 },
	'enhancervalues' => { 211 => 0x301 },
	'envelopenumber' => { 94 => 0x28 },
	'envelopepriority' => { 94 => 0x3c },
	'enveloperecordversion' => { 94 => 0x0 },
	'epsonimageheight' => { 212 => 0x20c },
	'epsonimagewidth' => { 212 => 0x20b },
	'epsonsoftware' => { 212 => 0x20d },
	'equipmentinstitution' => { 288 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 288 => 'EquipmentManufacturer' },
	'equipmentversion' => { 208 => 0x0 },
	'ettlii' => { 60 => 0x304, 61 => 0xd, 62 => 0xe, 63 => 0x7, 64 => 0x7, 65 => 0xe },
	'event' => { 290 => 'Event', 302 => 'Event', 309 => 'event' },
	'eventnumber' => { 262 => 0x9 },
	'evsteps' => { 234 => '1.2', 236 => 0x0 },
	'evstepsize' => { 202 => '5.1', 205 => '0.7' },
	'exclusivityenddate' => { 311 => 'exclusivityEndDate' },
	'excursiontolerance' => { 95 => 0x82 },
	'exif' => { 87 => 'EXIF' },
	'exifbyteorder' => { 87 => 'ExifByteOrder' },
	'exifcamerainfo' => { 93 => 0xe8 },
	'exifimageheight' => { 86 => 0xa003, 299 => 'PixelYDimension' },
	'exifimagewidth' => { 86 => 0xa002, 299 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 87 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 86 => 0x9000, 299 => 'ExifVersion' },
	'exitpupilposition' => { 159 => 0x4, 160 => 0x4 },
	'expirationdate' => { 93 => 0x25, 309 => 'expirationDate', 311 => 'expirationDate' },
	'expirationtime' => { 93 => 0x26 },
	'exposure' => { 86 => 0xfe51, 295 => 'Exposure' },
	'exposureadj' => { 191 => 0x0 },
	'exposureadj2' => { 191 => 0x12 },
	'exposureadjust' => { 274 => 0xc },
	'exposurebracketingindicatorlast' => { 135 => 0x52 },
	'exposurebracketstepsize' => { 234 => 0x8 },
	'exposurebracketvalue' => { 163 => 0x19 },
	'exposurecompensation' => { 55 => 0x6, 69 => 0x0, 86 => 0x9204, 100 => 0x24, 114 => 'ExposureComp', 132 => 0xd, 133 => 0x53, 134 => 0x1e, 212 => 0x1006, 250 => 0x16, 271 => 0xa013, 274 => [0xc,0x35,0x4d], 299 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 135 => 0x47 },
	'exposurecompensationsetting' => { 135 => 0x1 },
	'exposurecompstepsize' => { 200 => '6.3', 203 => '4.3' },
	'exposurecontrolstep' => { 204 => '6.1' },
	'exposurecontrolstepsize' => { 200 => '6.2', 203 => '4.2', 206 => '7.1' },
	'exposuredelaymode' => { 200 => '10.1', 202 => '9.1', 203 => '10.4', 204 => '10.1', 205 => '6.4', 206 => '11.2' },
	'exposuredifference' => { 163 => 0xe },
	'exposureindex' => { 86 => 0xa215, 299 => 'ExposureIndex' },
	'exposureindicator' => { 135 => 0x50 },
	'exposurelevelincrements' => { 58 => 0x6, 59 => 0x6, 60 => 0x101, 61 => 0x5, 62 => 0x6, 63 => 0x5, 64 => 0x5, 65 => 0x6, 66 => 0x4, 276 => 0x58 },
	'exposuremode' => { 86 => 0xa402, 114 => 'ExposureMode', 132 => 0x1, 133 => 0xa, 134 => 0x0, 135 => 0x0, 207 => 0x200, 224 => 0x40d, 274 => 0x8, 283 => 0xb041, 299 => 'ExposureMode' },
	'exposuremodeinmanual' => { 60 => 0x10b },
	'exposureprogram' => { 86 => 0x8822, 276 => 0x3c, 277 => 0x3c, 299 => 'ExposureProgram' },
	'exposureshift' => { 207 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 22 => 0x6, 23 => 0x7, 55 => 0x16, 86 => 0x829a, 97 => 0xfd05, 100 => 0x20, 102 => 0xfa24, 104 => 0xf104, 107 => 0x12, 109 => 0x38, 112 => 0x10, 114 => 'ExposureTime', 132 => 0x9, 133 => 0x35, 134 => 0x48, 135 => 0x8, 250 => 0x12, 271 => 0xa018, 274 => [0x32,0x4a], 299 => 'ExposureTime' },
	'exposuretime2' => { 274 => [0x33,0x4b] },
	'exposuretuning' => { 163 => 0x1c },
	'exposurevalue' => { 98 => 0x3 },
	'exposurewarning' => { 90 => 0x1302 },
	'exrauto' => { 90 => 0x1033 },
	'exrmode' => { 90 => 0x1034 },
	'extendedwbdetect' => { 207 => 0x902 },
	'extender' => { 208 => 0x301 },
	'extenderfirmwareversion' => { 208 => 0x304 },
	'extendermagnification' => { 116 => 'Magnification' },
	'extendermake' => { 116 => 'Make' },
	'extendermodel' => { 116 => 'Model', 208 => 0x303 },
	'extenderserialnumber' => { 116 => 'SerialNumber', 208 => 0x302 },
	'externalflash' => { 210 => 0x1201 },
	'externalflashae1' => { 212 => 0x101f },
	'externalflashae1_0' => { 212 => 0x101b },
	'externalflashae2' => { 212 => 0x1020 },
	'externalflashae2_0' => { 212 => 0x101c },
	'externalflashbounce' => { 210 => 0x1204, 212 => 0x1026, 241 => 0x1a },
	'externalflashexposurecomp' => { 163 => 0x17, 241 => 0x19 },
	'externalflashfirmware' => { 153 => 0x6, 154 => 0x6, 155 => 0x6 },
	'externalflashflags' => { 153 => 0x8, 154 => 0x8, 155 => 0x8 },
	'externalflashguidenumber' => { 210 => 0x1203, 241 => '24.1' },
	'externalflashgvalue' => { 212 => 0x1025 },
	'externalflashmode' => { 212 => 0x1028, 241 => 0x2 },
	'externalflashzoom' => { 210 => 0x1205, 212 => 0x1027 },
	'externalsensorbrightnessvalue' => { 222 => 0x311, 227 => 0x3408 },
	'eyestartaf' => { 135 => 0x40 },
	'face10position' => { 80 => 0x3f4, 81 => 0x1ec, 151 => 0x28, 238 => 0x12 },
	'face10size' => { 239 => 0x12 },
	'face11position' => { 151 => 0x2c, 238 => 0x14 },
	'face11size' => { 239 => 0x14 },
	'face12position' => { 151 => 0x30, 238 => 0x16 },
	'face12size' => { 239 => 0x16 },
	'face13position' => { 238 => 0x18 },
	'face13size' => { 239 => 0x18 },
	'face14position' => { 238 => 0x1a },
	'face14size' => { 239 => 0x1a },
	'face15position' => { 238 => 0x1c },
	'face15size' => { 239 => 0x1c },
	'face16position' => { 238 => 0x1e },
	'face16size' => { 239 => 0x1e },
	'face17position' => { 238 => 0x20 },
	'face17size' => { 239 => 0x20 },
	'face18position' => { 238 => 0x22 },
	'face18size' => { 239 => 0x22 },
	'face19position' => { 238 => 0x24 },
	'face19size' => { 239 => 0x24 },
	'face1position' => { 37 => 0x8, 80 => 0xd, 81 => 0x18, 151 => 0x4, 220 => 0x1, 238 => 0x0, 263 => 0xbc, 280 => 0x0, 281 => 0x0 },
	'face1size' => { 239 => 0x0 },
	'face20position' => { 238 => 0x26 },
	'face20size' => { 239 => 0x26 },
	'face21position' => { 238 => 0x28 },
	'face21size' => { 239 => 0x28 },
	'face22position' => { 238 => 0x2a },
	'face22size' => { 239 => 0x2a },
	'face23position' => { 238 => 0x2c },
	'face23size' => { 239 => 0x2c },
	'face24position' => { 238 => 0x2e },
	'face24size' => { 239 => 0x2e },
	'face25position' => { 238 => 0x30 },
	'face25size' => { 239 => 0x30 },
	'face26position' => { 238 => 0x32 },
	'face26size' => { 239 => 0x32 },
	'face27position' => { 238 => 0x34 },
	'face27size' => { 239 => 0x34 },
	'face28position' => { 238 => 0x36 },
	'face28size' => { 239 => 0x36 },
	'face29position' => { 238 => 0x38 },
	'face29size' => { 239 => 0x38 },
	'face2position' => { 37 => 0xa, 80 => 0x7c, 81 => 0x4c, 151 => 0x8, 220 => 0x5, 238 => 0x2, 263 => 0xc8, 280 => 0x20, 281 => 0x25 },
	'face2size' => { 239 => 0x2 },
	'face30position' => { 238 => 0x3a },
	'face30size' => { 239 => 0x3a },
	'face31position' => { 238 => 0x3c },
	'face31size' => { 239 => 0x3c },
	'face32position' => { 238 => 0x3e },
	'face32size' => { 239 => 0x3e },
	'face3position' => { 37 => 0xc, 80 => 0xeb, 81 => 0x80, 151 => 0xc, 220 => 0x9, 238 => 0x4, 263 => 0xd4, 280 => 0x40, 281 => 0x4a },
	'face3size' => { 239 => 0x4 },
	'face4position' => { 37 => 0xe, 80 => 0x15a, 81 => 0xb4, 151 => 0x10, 220 => 0xd, 238 => 0x6, 263 => 0xe0, 280 => 0x60, 281 => 0x6f },
	'face4size' => { 239 => 0x6 },
	'face5position' => { 37 => 0x10, 80 => 0x1c9, 81 => 0xe8, 151 => 0x14, 220 => 0x11, 238 => 0x8, 263 => 0xec, 280 => 0x80, 281 => 0x94 },
	'face5size' => { 239 => 0x8 },
	'face6position' => { 37 => 0x12, 80 => 0x238, 81 => 0x11c, 151 => 0x18, 238 => 0xa, 263 => 0xf8, 280 => 0xa0, 281 => 0xb9 },
	'face6size' => { 239 => 0xa },
	'face7position' => { 37 => 0x14, 80 => 0x2a7, 81 => 0x150, 151 => 0x1c, 238 => 0xc, 263 => 0x104, 280 => 0xc0, 281 => 0xde },
	'face7size' => { 239 => 0xc },
	'face8position' => { 37 => 0x16, 80 => 0x316, 81 => 0x184, 151 => 0x20, 238 => 0xe, 263 => 0x110, 280 => 0xe0, 281 => 0x103 },
	'face8size' => { 239 => 0xe },
	'face9position' => { 37 => 0x18, 80 => 0x385, 81 => 0x1b8, 151 => 0x24, 238 => 0x10 },
	'face9size' => { 239 => 0x10 },
	'facedetect' => { 250 => 0x76 },
	'facedetectarea' => { 211 => 0x1201 },
	'facedetectframecrop' => { 211 => 0x1207 },
	'facedetectframesize' => { 37 => 0x3, 80 => 0x1, 81 => 0x4, 151 => 0x1, 211 => 0x1203, 250 => 0x77, 263 => 0xb6 },
	'faceinfounknown' => { 83 => 0x2089 },
	'faceorientation' => { 81 => 0x8 },
	'faceposition' => { 237 => 0x2, 272 => 0x4 },
	'facepositions' => { 90 => 0x4103 },
	'facesdetected' => { 37 => 0x2, 38 => 0x2, 80 => 0x0, 81 => 0x2, 83 => 0x211c, 90 => 0x4100, 151 => 0x3, 211 => 0x1200, 226 => 0x3f, 237 => 0x0, 263 => 0xb5, 272 => 0x0, 285 => 0x30 },
	'facesrecognized' => { 221 => 0x0 },
	'facewidth' => { 38 => 0x1 },
	'faithfuloutputhighlightpoint' => { 79 => 0x38 },
	'faithfuloutputshadowpoint' => { 79 => 0x39 },
	'faithfulrawcolortone' => { 79 => 0x31 },
	'faithfulrawcontrast' => { 79 => 0x33 },
	'faithfulrawhighlight' => { 79 => 0x79 },
	'faithfulrawhighlightpoint' => { 79 => 0x36 },
	'faithfulrawlinear' => { 79 => 0x34 },
	'faithfulrawsaturation' => { 79 => 0x32 },
	'faithfulrawshadow' => { 79 => 0x82 },
	'faithfulrawshadowpoint' => { 79 => 0x37 },
	'faithfulrawsharpness' => { 79 => 0x35 },
	'femicroadjustment' => { 60 => 0x110 },
	'ffid' => { 297 => 'ffid' },
	'fieldcount' => { 212 => 0x103f },
	'filedatarate' => { 318 => 'fileDataRate' },
	'fileformat' => { 71 => 0x0, 94 => 0x14, 274 => [0x22,0x26], 283 => 0xb000 },
	'fileindex' => { 4 => 0x143, 7 => 0x172, 9 => [0x227,0x22c], 10 => 0x133, 11 => 0x13f, 12 => 0x1d3, 13 => [0x197,0x19b], 14 => 0x1e4, 17 => 0x3d, 18 => 0x1db, 19 => 0x1d9, 21 => 0x1c7 },
	'filemodifydate' => { 87 => 'FileModifyDate' },
	'filename' => { 87 => 'FileName' },
	'filenameasdelivered' => { 308 => 'FileNameAsDelivered' },
	'filenumber' => { 39 => 0x1, 44 => 0x8, 73 => 0x1817, 84 => 'FileNumber', 152 => 0x8 },
	'filenumbermemory' => { 132 => 0x1a },
	'filenumbersequence' => { 200 => '12.2', 202 => '3.1', 203 => '11.1', 204 => '4.3', 206 => '5.2' },
	'filesource' => { 86 => 0xa300, 90 => 0x8000, 299 => 'FileSource' },
	'fileversion' => { 94 => 0x16 },
	'fillflashautoreduction' => { 58 => 0xe, 59 => 0xe, 66 => 0xa },
	'filllight' => { 295 => 'FillLight' },
	'fillorder' => { 86 => 0x10a },
	'filmmode' => { 90 => 0x1401, 224 => 0x412, 226 => 0x42 },
	'filmtype' => { 168 => 0x2 },
	'filtereffect' => { 39 => 0xe, 165 => 0x37 },
	'filtereffectfaithful' => { 49 => 0x70, 50 => 0x70 },
	'filtereffectlandscape' => { 49 => 0x40, 50 => 0x40 },
	'filtereffectmonochrome' => { 15 => 0xff, 49 => 0x88, 50 => 0x88 },
	'filtereffectneutral' => { 49 => 0x58, 50 => 0x58 },
	'filtereffectportrait' => { 49 => 0x28, 50 => 0x28 },
	'filtereffectstandard' => { 49 => 0x10, 50 => 0x10 },
	'filtereffectunknown' => { 50 => 0xa0 },
	'filtereffectuserdef1' => { 49 => 0xa0, 50 => 0xb8 },
	'filtereffectuserdef2' => { 49 => 0xb8, 50 => 0xd0 },
	'filtereffectuserdef3' => { 49 => 0xd0, 50 => 0xe8 },
	'finderdisplayduringexposure' => { 59 => 0x1 },
	'finesharpness' => { 250 => 0x70 },
	'finetuneoptcenterweighted' => { 200 => '7.2', 206 => '9.1' },
	'finetuneoptmatrixmetering' => { 200 => '8.1', 203 => '6.1', 206 => '8.2' },
	'finetuneoptspotmetering' => { 200 => '8.2', 203 => '6.2', 206 => '9.2' },
	'firmware' => { 212 => 0x405, 274 => [0x17,0x3b,0x57], 292 => 'Firmware' },
	'firmwaredate' => { 82 => 0x15, 83 => 0x2001, 262 => 0x4 },
	'firmwareid' => { 138 => 0x0 },
	'firmwarename' => { 271 => 0xa001 },
	'firmwarerevision' => { 15 => 0xa4, 44 => 0x1e, 264 => 0x0 },
	'firmwarerevision2' => { 264 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 7 => 0x136, 10 => 0xff, 11 => 0x107, 98 => 0xce5, 112 => 0x57, 114 => 'FirmwareVersion', 226 => 0x2, 227 => 0x3109, 250 => 0x230, 266 => 0x2 },
	'firstpublicationdate' => { 308 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 93 => 0x16 },
	'flash' => { 84 => 'Flash', 86 => 0x9209, 133 => 0x1f, 134 => 0x15, 299 => 'Flash' },
	'flashactivity' => { 25 => 0x1c },
	'flashbatterylevel' => { 31 => 0x249 },
	'flashbias' => { 226 => 0x24 },
	'flashbits' => { 25 => 0x1d },
	'flashbuttonfunction' => { 60 => 0x70e },
	'flashchargelevel' => { 212 => 0x1010 },
	'flashcolorfilter' => { 155 => 0x10 },
	'flashcommandermode' => { 153 => '9.1', 154 => '9.1', 155 => '9.1' },
	'flashcompensation' => { 153 => 0xa, 154 => 0xa, 155 => 0xa, 292 => 'FlashCompensation' },
	'flashcontrolbuilt-in' => { 203 => '16.1', 204 => '23.1' },
	'flashcontrolmode' => { 153 => '9.2', 154 => '9.2', 155 => '9.2', 207 => 0x404 },
	'flashdefault' => { 135 => 0x42 },
	'flashdevice' => { 212 => 0x1005 },
	'flashdistance' => { 83 => 0x2034 },
	'flashenergy' => { 86 => 0xa20b, 299 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 163 => 0x18 },
	'flashexposurecomp' => { 55 => 0xf, 90 => 0x1011, 117 => 'ExposureComp', 132 => 0x23, 136 => 0x104, 163 => 0x12, 207 => 0x401, 212 => 0x1023, 250 => 0x4d, 274 => [0x3a,0x56], 283 => 0x104 },
	'flashexposurecompset' => { 229 => 0xe },
	'flashexposurecompsetting' => { 135 => 0x10 },
	'flashexposureindicator' => { 135 => 0x54 },
	'flashexposureindicatorlast' => { 135 => 0x56 },
	'flashexposureindicatornext' => { 135 => 0x55 },
	'flashexposurelock' => { 39 => 0x19 },
	'flashfired' => { 100 => 0x5d, 117 => 'Fired', 132 => 0x14, 181 => '590.3', 226 => 0x8007, 299 => [\'Flash','FlashFired'] },
	'flashfiring' => { 60 => 0x306, 61 => 0x6, 62 => 0x7, 65 => 0x7 },
	'flashfirmwareversion' => { 208 => 0x1002 },
	'flashfocallength' => { 153 => 0xb, 154 => 0xc, 155 => 0xc },
	'flashfunction' => { 299 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 153 => 0xe, 154 => 0xf, 155 => 0xf },
	'flashgroupacompensation' => { 153 => 0x11, 154 => 0x12, 155 => 0x13 },
	'flashgroupacontrolmode' => { 153 => 0xf, 154 => '16.1', 155 => '17.1' },
	'flashgroupaoutput' => { 153 => 0x11, 154 => 0x12, 155 => 0x13 },
	'flashgroupbcompensation' => { 153 => 0x12, 154 => 0x13, 155 => 0x14 },
	'flashgroupbcontrolmode' => { 153 => 0x10, 154 => '17.1', 155 => '18.1' },
	'flashgroupboutput' => { 153 => 0x12, 154 => 0x13, 155 => 0x14 },
	'flashgroupccompensation' => { 154 => 0x14, 155 => 0x15 },
	'flashgroupccontrolmode' => { 154 => '17.2', 155 => '18.2' },
	'flashgroupcoutput' => { 154 => 0x14, 155 => 0x15 },
	'flashguidenumber' => { 55 => 0xd, 70 => 0x0, 117 => 'GuideNumber' },
	'flashintensity' => { 82 => [0x19,0x5], 207 => 0x405 },
	'flashlevel' => { 201 => 0x9, 283 => 0xb048 },
	'flashmake' => { 117 => 'Make' },
	'flashmanufacturer' => { 131 => 'FlashManufacturer' },
	'flashmetering' => { 132 => 0x3f, 135 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 16 => 0x15, 18 => 0x15, 20 => 0x15 },
	'flashmeteringsegments' => { 250 => 0x20a },
	'flashmode' => { 82 => 0x4, 100 => 0x5c, 117 => 'Mode', 132 => 0x2, 133 => 0x20, 134 => 0x16, 135 => 0xf, 163 => 0x87, 207 => 0x400, 212 => 0x1004, 250 => 0xc, 255 => 0x4, 265 => 0x20, 273 => 0x225, 276 => 0x23, 277 => 0x23, 299 => [\'Flash','FlashMode'] },
	'flashmodel' => { 117 => 'Model', 131 => 'FlashModel', 208 => 0x1001 },
	'flashoptions' => { 234 => 0x2 },
	'flashoptions2' => { 234 => 0x10 },
	'flashoutput' => { 31 => 0x248, 55 => 0x21, 153 => 0xa, 154 => 0xa, 155 => 0xa },
	'flashpixversion' => { 86 => 0xa000, 299 => 'FlashpixVersion' },
	'flashredeyemode' => { 299 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 207 => 0x403 },
	'flashreturn' => { 299 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 117 => 'SerialNumber', 208 => 0x1003 },
	'flashsetting' => { 163 => 0x8 },
	'flashshutterspeed' => { 200 => '20.2', 203 => '15.2', 204 => '22.2', 205 => '7.2', 206 => '23.1' },
	'flashsource' => { 153 => 0x4, 154 => 0x4, 155 => 0x4 },
	'flashstatus' => { 241 => 0x0 },
	'flashsyncspeed' => { 200 => '20.1', 203 => '15.1', 204 => '22.1' },
	'flashsyncspeedav' => { 58 => 0x3, 60 => 0x10f, 61 => 0x2, 62 => 0x3, 63 => 0x2, 64 => 0x2, 65 => 0x3, 66 => 0x6 },
	'flashthreshold' => { 70 => 0x1 },
	'flashtype' => { 117 => 'Type', 135 => 0x59, 163 => 0x9, 208 => 0x1000 },
	'flashwarning' => { 204 => '30.1', 205 => '7.1', 206 => '31.1', 226 => 0x62 },
	'flickerreduce' => { 273 => 0x218 },
	'fliphorizontal' => { 193 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 7 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 22 => 0x5, 23 => 0x6, 55 => 0x15, 86 => 0x829d, 97 => 0xfd04, 100 => 0x1e, 102 => 0xfa23, 104 => 0xf103, 107 => 0x13, 109 => 0x3c, 112 => 0xc, 121 => 'FNumber', 132 => 0xa, 133 => 0x36, 134 => 0x47, 135 => 0x9, 250 => 0x13, 271 => 0xa019, 274 => [0x31,0x49], 299 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x9, 7 => 0x1d, 8 => 0x9, 9 => 0x1e, 10 => 0x1d, 11 => 0x1d, 12 => 0x1e, 13 => 0x1e, 14 => 0x1e, 15 => 0x28, 16 => 0x1e, 18 => 0x1e, 19 => 0x1e, 20 => 0x1e, 41 => 0x1, 83 => 0x1d, 86 => 0x920a, 107 => 0x1d, 121 => 'FocalLength', 132 => 0x12, 159 => 0xa, 160 => 0xb, 243 => 0x9, 250 => 0x1d, 299 => 'FocalLength' },
	'focallengthin35mmformat' => { 86 => 0xa405, 271 => 0xa01a, 299 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 208 => 0x103, 212 => 0x205 },
	'focalplaneresolutionunit' => { 86 => 0xa210, 299 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 86 => 0xa20e, 299 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 41 => 0x2 },
	'focalplanexunknown' => { 41 => 0x2 },
	'focalplaneyresolution' => { 86 => 0xa20f, 299 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 41 => 0x3 },
	'focalplaneyunknown' => { 41 => 0x3 },
	'focaltype' => { 6 => 0x2d, 41 => 0x0 },
	'focalunits' => { 25 => 0x19 },
	'focus' => { 183 => 0x8 },
	'focusarea' => { 132 => 0x31 },
	'focusareaselection' => { 205 => '15.2' },
	'focuscontinuous' => { 25 => 0x20 },
	'focusdisplayaiservoandmf' => { 60 => 0x515 },
	'focusdistance' => { 121 => 'FocusDistance', 132 => 0x13, 137 => 0x49bb, 159 => 0x9, 160 => 0xa, 210 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 7 => 0x45, 9 => 0x56, 10 => 0x45, 11 => 0x45, 12 => 0x52, 13 => 0x52, 14 => 0x56, 16 => 0x52, 18 => 0x59, 19 => 0x57, 21 => 0x32, 55 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 7 => 0x43, 9 => 0x54, 10 => 0x43, 11 => 0x43, 12 => 0x50, 13 => 0x50, 14 => 0x54, 16 => 0x50, 18 => 0x57, 19 => 0x55, 21 => 0x30, 55 => 0x13 },
	'focusholdbutton' => { 135 => 0x44 },
	'focusinfoversion' => { 210 => 0x0 },
	'focusingscreen' => { 59 => 0x0, 60 => 0x80b, 65 => 0x0 },
	'focusmode' => { 25 => 0x7, 82 => 0x3, 83 => [0x3003,0xd], 90 => 0x1021, 100 => 0x38, 114 => 'FocusMode', 132 => 0x30, 134 => 0xe, 135 => 0xc, 163 => 0x7, 207 => 0x301, 212 => 0x100b, 226 => 0x7, 250 => 0xd, 255 => 0x3, 275 => 0x1d, 276 => 0x10, 277 => 0x10, 283 => 0xb042 },
	'focusmode2' => { 234 => '3.1' },
	'focusmodesetting' => { 201 => '10.1' },
	'focusmodeswitch' => { 135 => 0x58 },
	'focuspixel' => { 90 => 0x1023 },
	'focuspointwrap' => { 200 => '2.2', 203 => '2.2', 204 => '1.2', 206 => '2.5' },
	'focusposition' => { 159 => 0x8, 160 => 0x8, 250 => 0x10, 282 => 0x9bb },
	'focusprocess' => { 207 => 0x302 },
	'focusrange' => { 25 => 0x12, 212 => 0x100a },
	'focussetting' => { 274 => 0x6 },
	'focusstepcount' => { 210 => 0x301, 212 => 0x100e },
	'focusstepinfinity' => { 210 => 0x303, 212 => 0x103b },
	'focusstepnear' => { 210 => 0x304, 212 => 0x103c },
	'focustrackinglockon' => { 200 => ['1.5','4.1'], 203 => '3.1', 204 => '0.4' },
	'focuswarning' => { 90 => 0x1301 },
	'foldername' => { 132 => 0x27 },
	'fontcomposite' => { 323 => [\'Fonts','FontsComposite'] },
	'fontface' => { 323 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 323 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 323 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 323 => [\'Fonts','FontsFontName'] },
	'fonts' => { 323 => 'Fonts' },
	'fonttype' => { 323 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 323 => [\'Fonts','FontsVersionString'] },
	'for' => { 261 => 'For' },
	'format' => { 296 => 'format', 316 => 'Format' },
	'forwardlock' => { 313 => 'forwardlock' },
	'forwardmatrix1' => { 86 => 0xc714 },
	'forwardmatrix2' => { 86 => 0xc715 },
	'framecount' => { 47 => [0x2,0x4] },
	'framenum' => { 256 => 0xd7 },
	'framenumber' => { 90 => 0x8003, 250 => 0x29 },
	'framerate' => { 47 => [0x1,0x6] },
	'freebytes' => { 73 => 0x1 },
	'freememorycardimages' => { 133 => [0x37,0x54], 134 => [0x2d,0x4a], 135 => 0x32 },
	'fujiflashmode' => { 90 => 0x1010 },
	'fullimagesize' => { 283 => 0xb02b },
	'fullsizeimage' => { 120 => 'data' },
	'fullsizeimagename' => { 120 => '1Name' },
	'fullsizeimagetype' => { 120 => '0Type' },
	'funcbutton' => { 200 => ['14.1','15.1'], 203 => '28.1', 204 => '13.1', 206 => '14.1' },
	'funcbuttonplusdials' => { 200 => ['14.2','15.2'], 203 => '31.1' },
	'functionbutton' => { 205 => '5.2' },
	'gainbase' => { 211 => 0x610 },
	'gaincontrol' => { 86 => 0xa407, 299 => 'GainControl' },
	'gamma' => { 86 => 0xa500 },
	'gammacompensatedvalue' => { 95 => 0x91 },
	'geimagesize' => { 90 => 0x1304 },
	'gemake' => { 91 => 0x300 },
	'gemodel' => { 91 => 0x207 },
	'genre' => { 309 => 'genre', 318 => 'genre' },
	'geography' => { 310 => 'geography' },
	'geosync' => { 87 => 'Geosync' },
	'geotag' => { 87 => 'Geotag' },
	'geotime' => { 87 => 'Geotime' },
	'globalaltitude' => { 259 => 0x419 },
	'globalangle' => { 259 => 0x40d },
	'good' => { 318 => 'good' },
	'gpsaltitude' => { 92 => 0x6, 118 => 'Altitude', 299 => 'GPSAltitude' },
	'gpsaltituderef' => { 92 => 0x5, 299 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 92 => 0x1c, 299 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 92 => 0x1d },
	'gpsdatetime' => { 118 => 'DateTime', 299 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 92 => 0x18, 118 => 'Bearing', 299 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 92 => 0x17, 299 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 92 => 0x1a, 118 => 'Distance', 299 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 92 => 0x19, 299 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 92 => 0x14, 299 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 92 => 0x13 },
	'gpsdestlongitude' => { 92 => 0x16, 299 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 92 => 0x15 },
	'gpsdifferential' => { 92 => 0x1e, 118 => 'Differential', 299 => 'GPSDifferential' },
	'gpsdop' => { 92 => 0xb, 299 => 'GPSDOP' },
	'gpshpositioningerror' => { 92 => 0x1f },
	'gpsimgdirection' => { 92 => 0x11, 299 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 92 => 0x10, 299 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 92 => 0x2, 118 => 'Latitude', 299 => 'GPSLatitude' },
	'gpslatituderef' => { 92 => 0x1 },
	'gpslongitude' => { 92 => 0x4, 118 => 'Longitude', 299 => 'GPSLongitude' },
	'gpslongituderef' => { 92 => 0x3 },
	'gpsmapdatum' => { 92 => 0x12, 118 => 'Datum', 299 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 92 => 0xa, 118 => 'MeasureMode', 299 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 92 => 0x1b, 299 => 'GPSProcessingMethod' },
	'gpssatellites' => { 92 => 0x8, 118 => 'Satellites', 299 => 'GPSSatellites' },
	'gpsspeed' => { 92 => 0xd, 118 => 'Speed', 299 => 'GPSSpeed' },
	'gpsspeedref' => { 92 => 0xc, 299 => 'GPSSpeedRef' },
	'gpsstatus' => { 92 => 0x9, 299 => 'GPSStatus' },
	'gpstimestamp' => { 92 => 0x7 },
	'gpstrack' => { 92 => 0xf, 118 => 'Heading', 299 => 'GPSTrack' },
	'gpstrackref' => { 92 => 0xe, 299 => 'GPSTrackRef' },
	'gpsversionid' => { 92 => 0x0, 299 => 'GPSVersionID' },
	'gradation' => { 207 => 0x50f },
	'gradientbasedcorractive' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrcontrast' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrections' => { 295 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrhue' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrmaskcenterweight' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrsaturation' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrsharpness' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrwhat' => { 295 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 295 => 'GrainAmount' },
	'grainfrequency' => { 295 => 'GrainFrequency' },
	'grainsize' => { 295 => 'GrainSize' },
	'graymixeraqua' => { 295 => 'GrayMixerAqua' },
	'graymixerblue' => { 295 => 'GrayMixerBlue' },
	'graymixergreen' => { 295 => 'GrayMixerGreen' },
	'graymixermagenta' => { 295 => 'GrayMixerMagenta' },
	'graymixerorange' => { 295 => 'GrayMixerOrange' },
	'graymixerpurple' => { 295 => 'GrayMixerPurple' },
	'graymixerred' => { 295 => 'GrayMixerRed' },
	'graymixeryellow' => { 295 => 'GrayMixerYellow' },
	'graypoint' => { 286 => 0x8021 },
	'grayresponseunit' => { 86 => 0x122 },
	'greencurvelimits' => { 78 => 0x1c4 },
	'greencurvepoints' => { 78 => 0x19a },
	'greenhue' => { 295 => 'GreenHue' },
	'greensaturation' => { 295 => 'GreenSaturation' },
	'griddisplay' => { 200 => '13.3', 202 => '2.2', 203 => '10.5', 204 => '3.4', 205 => '6.1', 206 => '4.2' },
	'gripbatteryadload' => { 232 => 0x5 },
	'gripbatteryadnoload' => { 232 => 0x4 },
	'gripbatterystate' => { 232 => '1.2' },
	'halftonehints' => { 86 => 0x141 },
	'hasalternative' => { 309 => 'hasAlternative' },
	'hascorrection' => { 309 => 'hasCorrection' },
	'hascrop' => { 295 => 'HasCrop' },
	'hasextendedxmp' => { 320 => 'HasExtendedXMP' },
	'haspreviousversion' => { 309 => 'hasPreviousVersion' },
	'hassettings' => { 295 => 'HasSettings' },
	'hastranslation' => { 309 => 'hasTranslation' },
	'hdr' => { 283 => 0x200a },
	'headline' => { 93 => 0x69, 307 => 'Headline' },
	'hierarchicalkeywords' => { 304 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 304 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 304 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 304 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 304 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 304 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 304 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 289 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 12 => 0xbc, 13 => 0xbd, 16 => 0xbd, 21 => 0xa5, 60 => 0x202, 90 => 0x100e, 163 => 0xb1, 250 => 0x71, 276 => 0x2c, 283 => 0x2009 },
	'highlight' => { 274 => 0xf },
	'highlightcolordistortreduct' => { 286 => 0x8026 },
	'highlightprotection' => { 192 => 0x6 },
	'highlightrecovery' => { 295 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 12 => 0x7, 13 => 0x7, 14 => 0x7, 16 => 0x7, 18 => 0x7, 20 => 0x7, 60 => 0x203 },
	'highlowkeyadj' => { 250 => 0x6c },
	'highspeedsync' => { 135 => 0x5 },
	'histogramxml' => { 193 => 0x83a1a25 },
	'history' => { 307 => 'History', 319 => 'History' },
	'historyaction' => { 319 => [\'History','HistoryAction'] },
	'historychanged' => { 319 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 319 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 319 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 319 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 319 => [\'History','HistoryWhen'] },
	'hometowncity' => { 83 => 0x3006, 250 => 0x23, 254 => 0x2 },
	'hometowncitycode' => { 255 => 0x1000 },
	'hometowndst' => { 250 => 0x25, 254 => '0.2' },
	'hostcomputer' => { 86 => 0x13c },
	'hue' => { 139 => 0x3b, 250 => 0x67 },
	'hueadj' => { 196 => 0x2f, 286 => 0x8019 },
	'hueadjustment' => { 133 => 0x4a, 134 => 0x40, 163 => 0x92, 165 => 0x36 },
	'hueadjustmentaqua' => { 295 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 295 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 295 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 295 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 295 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 295 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 295 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 295 => 'HueAdjustmentYellow' },
	'huesetting' => { 215 => 0x1011 },
	'icc_profile' => { 87 => 'ICC_Profile' },
	'iccprofilename' => { 307 => 'ICCProfile' },
	'idccreativestyle' => { 286 => 0x8000 },
	'idcpreviewlength' => { 286 => 0x202 },
	'idcpreviewstart' => { 286 => 0x201 },
	'identifier' => { 296 => 'identifier', 316 => 'Identifier' },
	'illumination' => { 205 => '0.5' },
	'imageadjustment' => { 163 => 0x80, 183 => 0x5 },
	'imagealterationconstraints' => { 308 => 'ImageAlterationConstraints' },
	'imagearea' => { 173 => 0x10, 176 => 0x10 },
	'imageareaoffset' => { 250 => 0x38 },
	'imageauthentication' => { 163 => 0x20 },
	'imageboundary' => { 163 => 0x16 },
	'imagecount' => { 163 => 0xa5 },
	'imagecreator' => { 308 => 'ImageCreator' },
	'imagecreatorid' => { 308 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 308 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 308 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 163 => 0xa2 },
	'imagedescription' => { 86 => 0x10e, 314 => 'ImageDescription' },
	'imageduplicationconstraints' => { 308 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 193 => 0xfe443a45 },
	'imageeditcount' => { 250 => 0x41 },
	'imageediting' => { 250 => 0x32 },
	'imagefileconstraints' => { 308 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 308 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 308 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 86 => 0x101, 138 => 0xc, 314 => 'ImageLength' },
	'imagehistory' => { 86 => 0x9213 },
	'imageidnumber' => { 222 => 0x340 },
	'imagenumber' => { 15 => 0xd0, 86 => 0x9211, 114 => 'ImageNumber', 133 => 0xae, 134 => 0x5e, 292 => 'ImageNumber' },
	'imagenumber2' => { 134 => 0x62 },
	'imageoptimization' => { 163 => 0xa9 },
	'imageorientation' => { 93 => 0x83 },
	'imageprocessing' => { 163 => 0x1a },
	'imageprocessingversion' => { 211 => 0x0 },
	'imagequality' => { 114 => 'ImageQuality', 175 => '723.2', 176 => '732.2', 181 => '708.1', 226 => 0x1 },
	'imagequality2' => { 207 => 0x603 },
	'imagereview' => { 201 => '0.4', 205 => '0.4' },
	'imagereviewtime' => { 201 => '2.1', 202 => '19.1', 203 => '9.2', 204 => '20.1', 206 => '21.2' },
	'imagesize' => { 120 => 'ImageSize' },
	'imagesizerestriction' => { 311 => 'imageSizeRestriction' },
	'imagesourcedata' => { 86 => 0x935c },
	'imagestabilization' => { 25 => 0x22, 83 => 0x3020, 114 => 'ImageStabilization', 133 => 0xbd, 134 => 0x71, 135 => 0x57, 136 => [0x18,0x107,0x113], 163 => 0xac, 207 => 0x604, 210 => 0x1600, 226 => 0x1a, 276 => 0x3d, 283 => 0xb026 },
	'imagestyle' => { 276 => 0x2d },
	'imagesupplier' => { 308 => 'ImageSupplier' },
	'imagesupplierid' => { 308 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 308 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 308 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 250 => 0x4f },
	'imagetype' => { 93 => 0x82, 308 => 'ImageType' },
	'imageuniqueid' => { 44 => 0x28, 86 => 0xa420, 299 => 'ImageUniqueID' },
	'imagewidth' => { 86 => 0x100, 138 => 0xe, 314 => 'ImageWidth' },
	'incrementaltemperature' => { 295 => 'IncrementalTemperature' },
	'incrementaltint' => { 295 => 'IncrementalTint' },
	'industry' => { 309 => 'industry', 310 => 'industry' },
	'infobuttonwhenshooting' => { 60 => 0x409 },
	'infraredilluminator' => { 262 => 0x28 },
	'ingredients' => { 319 => 'Ingredients' },
	'ingredientsalternatepaths' => { 319 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 319 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 319 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 319 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 319 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 319 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 319 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 319 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 319 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 319 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 319 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 319 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 319 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 319 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 319 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 319 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 319 => [\'Ingredients','IngredientsVersionID'] },
	'initialzoomliveview' => { 200 => '4.4' },
	'initialzoomsetting' => { 200 => '9.3', 203 => '27.3' },
	'inkset' => { 86 => 0x14c },
	'instanceid' => { 319 => 'InstanceID' },
	'instantplaybacksetup' => { 135 => 0x3e },
	'instantplaybacktime' => { 135 => 0x3d },
	'instructions' => { 307 => 'Instructions' },
	'instrument' => { 318 => 'instrument' },
	'intellectualgenre' => { 301 => 'IntellectualGenre' },
	'intelligentauto' => { 283 => 0xb052 },
	'intelligentd-range' => { 226 => 0x79 },
	'intelligentexposure' => { 226 => 0x5d },
	'intelligentresolution' => { 226 => 0x70 },
	'interchangecolorspace' => { 95 => 0x40 },
	'internalflash' => { 132 => 0x2b, 200 => '23.1', 201 => '8.1', 202 => '22.1', 205 => '8.1', 206 => '24.1', 210 => 0x1208 },
	'internalflashae1' => { 212 => 0x1021 },
	'internalflashae1_0' => { 212 => 0x101d },
	'internalflashae2' => { 212 => 0x1022 },
	'internalflashae2_0' => { 212 => 0x101e },
	'internalflashmode' => { 241 => 0x1 },
	'internalflashstrength' => { 241 => 0x3 },
	'internalflashtable' => { 212 => 0x1024 },
	'internalserialnumber' => { 44 => 0x96, 54 => 0x9, 90 => 0x10, 137 => 0x49dc, 208 => 0x102, 226 => 0x25, 233 => 0x4, 266 => 0x5 },
	'interopindex' => { 86 => 0x1 },
	'interopversion' => { 86 => 0x2 },
	'intervallength' => { 132 => 0x10 },
	'intervalmode' => { 132 => 0x26 },
	'intervalnumber' => { 132 => 0x11 },
	'introtime' => { 318 => 'introTime' },
	'introtimescale' => { 318 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 318 => [\'introTime','introTimeValue'] },
	'iptc-naa' => { 86 => 0x83bb, 228 => 0x83bb },
	'iptcbitspersample' => { 95 => 0x56 },
	'iptcdigest' => { 259 => 0x425 },
	'iptcimageheight' => { 95 => 0x1e },
	'iptcimagerotation' => { 95 => 0x66 },
	'iptcimagewidth' => { 95 => 0x14 },
	'iptclastedited' => { 302 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 95 => 0xa },
	'iptcpixelheight' => { 95 => 0x32 },
	'iptcpixelwidth' => { 95 => 0x28 },
	'isbn' => { 309 => 'isbn' },
	'iscorrectionof' => { 309 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 79 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x75, 7 => 0x6, 8 => 0x79, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 22 => 0x0, 23 => 0x1, 82 => 0x14, 83 => [0x3014,0x14], 86 => 0x8827, 97 => 0xfd06, 98 => 0x1784, 100 => 0x60, 102 => [0xfa2e,0xfa46], 103 => [0x27,0x28], 104 => 0xf105, 107 => 0x14, 109 => 0x4e, 112 => 0x34, 114 => 'ISO', 132 => 0x8, 157 => 0x0, 163 => 0x2, 228 => 0x17, 250 => 0x14, 255 => 0x14, 271 => 0xa014, 299 => 'ISOSpeedRatings' },
	'iso2' => { 157 => 0x6, 170 => 0x265, 171 => 0x25c, 172 => 0x265, 173 => 0x221, 174 => 0x25d, 175 => 0x256, 176 => 0x25d, 178 => 0x2b5, 179 => 0x265, 182 => 0x2b5 },
	'isoauto' => { 234 => '14.4' },
	'isoautoparameters' => { 250 => 0x7a },
	'isodisplay' => { 202 => '2.3', 204 => '3.3', 206 => '4.3' },
	'isoexpansion' => { 60 => 0x103, 61 => 0x7, 62 => 0x8, 65 => 0x8, 157 => 0x4 },
	'isoexpansion2' => { 157 => 0xa },
	'isofloor' => { 234 => 0x6 },
	'isoselection' => { 163 => 0xf },
	'isosensitivitystep' => { 204 => '6.2' },
	'isosetting' => { 100 => 0x5e, 114 => 'ISOSetting', 132 => 0x24, 133 => 0x26, 134 => 0x1c, 135 => 0x13, 139 => 0x6, 163 => 0x13, 234 => '17.3', 265 => 0x27, 276 => 0x16, 277 => 0x14, 278 => 0x2 },
	'isospeed' => { 86 => 0x8833 },
	'isospeedexpansion' => { 59 => 0x3 },
	'isospeedincrements' => { 60 => 0x102 },
	'isospeedlatitudeyyy' => { 86 => 0x8834 },
	'isospeedlatitudezzz' => { 86 => 0x8835 },
	'isospeedrange' => { 60 => 0x103 },
	'isostepsize' => { 200 => '6.1', 203 => '4.1' },
	'isovalue' => { 212 => 0x1001 },
	'issn' => { 309 => 'issn' },
	'issueidentifier' => { 309 => 'issueIdentifier' },
	'issuename' => { 309 => 'issueName' },
	'istranslationof' => { 309 => 'isTranslationOf' },
	'jobid' => { 93 => 0xb8 },
	'jobname' => { 300 => 'JobName' },
	'jobref' => { 317 => 'JobRef' },
	'jobrefid' => { 317 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 317 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 317 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 300 => 'JobStatus' },
	'jpegquality' => { 6 => 0x66, 227 => 0x3034 },
	'jpegsize' => { 227 => 0x303a },
	'jpgfromraw' => { 73 => 0x2007, 84 => 'JpgFromRaw', 228 => 0x2e },
	'jpgfromrawlength' => { 86 => [0x117,0x202] },
	'jpgfromrawstart' => { 86 => [0x111,0x201] },
	'jpgrecordedpixels' => { 234 => '14.1' },
	'key' => { 318 => 'key' },
	'keyword' => { 309 => 'keyword' },
	'keywordinfo' => { 304 => 'Keywords' },
	'keywords' => { 93 => 0x19, 115 => 'Keywords', 216 => 'Keywords', 261 => 'Keywords', 291 => 'keywords', 306 => 'Keywords', 316 => 'Keywords' },
	'killdate' => { 309 => 'killDate' },
	'kodakimageheight' => { 97 => 0xf908, 100 => 0xe, 102 => [0xfa1e,0xfa52], 108 => 0x70 },
	'kodakimagewidth' => { 97 => 0xf907, 100 => 0xc, 102 => [0xfa1d,0xfa51], 108 => 0x6c },
	'kodakinfotype' => { 97 => 0xfa00 },
	'kodakmaker' => { 108 => 0x8 },
	'kodakmodel' => { 100 => 0x0, 108 => 0x28 },
	'label' => { 218 => 'Label', 316 => 'Label' },
	'landmark' => { 226 => 0x6f },
	'landscapeoutputhighlightpoint' => { 79 => 0x26 },
	'landscapeoutputshadowpoint' => { 79 => 0x27 },
	'landscaperawcolortone' => { 79 => 0x1f },
	'landscaperawcontrast' => { 79 => 0x21 },
	'landscaperawhighlight' => { 79 => 0x77 },
	'landscaperawhighlightpoint' => { 79 => 0x24 },
	'landscaperawlinear' => { 79 => 0x22 },
	'landscaperawsaturation' => { 79 => 0x20 },
	'landscaperawshadow' => { 79 => 0x80 },
	'landscaperawshadowpoint' => { 79 => 0x25 },
	'landscaperawsharpness' => { 79 => 0x23 },
	'language' => { 296 => 'language' },
	'languageidentifier' => { 93 => 0x87 },
	'lastfilenumber' => { 132 => 0x1b },
	'lastkeywordiptc' => { 131 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 131 => 'LastKeywordXMP' },
	'lasturl' => { 319 => 'LastURL' },
	'lateralchromaticaberration' => { 283 => 0x2012 },
	'lc1' => { 243 => 0x2 },
	'lc10' => { 243 => 0xb },
	'lc11' => { 243 => 0xc },
	'lc12' => { 243 => 0xd },
	'lc14' => { 243 => 0xf },
	'lc15' => { 243 => 0x10 },
	'lc2' => { 243 => 0x3 },
	'lc3' => { 243 => 0x4 },
	'lc4' => { 243 => 0x5 },
	'lc5' => { 243 => 0x6 },
	'lc6' => { 243 => 0x7 },
	'lc7' => { 243 => 0x8 },
	'lcddisplayatpoweron' => { 60 => 0x811, 64 => 0xa },
	'lcddisplayreturntoshoot' => { 65 => 0x12 },
	'lcdillumination' => { 200 => '17.5', 203 => '10.3', 204 => '4.2', 206 => '5.4' },
	'lcdilluminationduringbulb' => { 60 => 0x408 },
	'lcdpanels' => { 59 => 0x8 },
	'lcheditor' => { 193 => 0x8ae85e },
	'legacyiptcdigest' => { 307 => 'LegacyIPTCDigest' },
	'lens' => { 86 => 0xfdea, 163 => 0x84, 292 => 'Lens' },
	'lensafstopbutton' => { 58 => 0x11, 59 => 0x13, 60 => 0x506, 61 => 0x10, 62 => 0x12, 65 => 0x13, 66 => 0x9 },
	'lensaperturerange' => { 274 => [0x30,0x48] },
	'lensdistortionparams' => { 212 => 0x206 },
	'lensdrivenoaf' => { 60 => 0x505 },
	'lensfirmware' => { 267 => 0x20, 271 => 0xa004 },
	'lensfirmwareversion' => { 208 => 0x204 },
	'lensfocalrange' => { 274 => 0xa },
	'lensfstops' => { 158 => 0x7, 159 => 0xc, 160 => 0xd, 163 => 0x8b, 243 => '0.3' },
	'lensid' => { 292 => 'LensID' },
	'lensidnumber' => { 158 => 0x6, 159 => 0xb, 160 => 0xc },
	'lensinfo' => { 86 => 0xa432, 248 => 0x2a, 292 => 'LensInfo' },
	'lenskind' => { 243 => 0x1 },
	'lensmake' => { 86 => 0xa433, 121 => 'Make' },
	'lensmanualdistortionamount' => { 295 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 131 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 10 => 0x92b, 11 => 0x933, 44 => 0x95, 86 => 0xa434, 121 => 'Model', 131 => 'LensModel', 161 => 0x18a, 208 => 0x203, 248 => 0xc },
	'lensprofilechromaticaberrationscale' => { 295 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 295 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 295 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 295 => 'LensProfileEnable' },
	'lensprofilefilename' => { 295 => 'LensProfileFilename' },
	'lensprofilename' => { 295 => 'LensProfileName' },
	'lensprofilesetup' => { 295 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 295 => 'LensProfileVignettingScale' },
	'lensproperties' => { 208 => 0x20b },
	'lensserialnumber' => { 42 => 0x0, 86 => 0xa435, 121 => 'SerialNumber', 208 => 0x202, 226 => 0x52, 267 => 0x30 },
	'lensshutterlock' => { 135 => 0x4a },
	'lensspec' => { 283 => 0xb02a },
	'lenstemperature' => { 212 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0xc, 7 => 0x111, 8 => 0xc, 9 => [0x14e,0x14f], 10 => 0xd6, 11 => 0xde, 12 => 0xf6, 13 => 0xea, 14 => 0xff, 15 => [0xc,0x97], 16 => 0xe6, 18 => 0xea, 19 => 0xe8, 21 => 0xee, 25 => 0x16, 136 => 0x10c, 163 => 0x83, 208 => 0x201, 219 => 0x16, 222 => 0x310, 225 => 0x303, 226 => 0x51, 227 => 0x3405, 244 => 0x0, 245 => 0x0, 246 => 0x1, 247 => 0x1, 250 => 0x3f, 271 => 0xa003, 283 => 0xb027 },
	'levelgaugepitch' => { 207 => 0x904 },
	'levelgaugeroll' => { 207 => 0x903 },
	'levelorientation' => { 249 => 0x0 },
	'license' => { 293 => 'license' },
	'licensee' => { 308 => 'Licensee' },
	'licenseeid' => { 308 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 308 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 308 => 'LicenseeImageNotes' },
	'licenseename' => { 308 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 308 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 308 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 308 => 'LicenseeTransactionID' },
	'licenseid' => { 308 => 'LicenseID' },
	'licensestartdate' => { 308 => 'LicenseStartDate' },
	'licensetransactiondate' => { 308 => 'LicenseTransactionDate' },
	'licensetype' => { 297 => 'licensetype' },
	'licensor' => { 308 => 'Licensor' },
	'licensorcity' => { 308 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 308 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 308 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 308 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 308 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 308 => 'LicensorImageID' },
	'licensorname' => { 308 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 308 => 'LicensorNotes' },
	'licensorpostalcode' => { 308 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 308 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 308 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 308 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 308 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 308 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 308 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 308 => 'LicensorTransactionID' },
	'licensorurl' => { 308 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 212 => 0x1009 },
	'lightingmode' => { 83 => 0x302a },
	'lightreading' => { 250 => 0x15 },
	'lightsource' => { 86 => 0x9208, 163 => 0x90, 215 => 0x1000, 299 => 'LightSource' },
	'lightsourcespecial' => { 273 => 0x21d },
	'lightswitch' => { 206 => '0.1' },
	'lightvaluecenter' => { 212 => 0x103d },
	'lightvalueperiphery' => { 212 => 0x103e },
	'linearizationtable' => { 86 => 0xc618 },
	'linearresponselimit' => { 86 => 0xc62e },
	'linkaetoafpoint' => { 234 => '14.2' },
	'liveviewaf' => { 202 => '32.1', 206 => '34.1' },
	'liveviewafareamode' => { 204 => '34.1' },
	'liveviewafmode' => { 204 => '34.2' },
	'liveviewexposuresimulation' => { 60 => 0x810 },
	'liveviewmonitorofftime' => { 204 => '20.2' },
	'liveviewshooting' => { 39 => 0x13 },
	'localafareapoint' => { 135 => 0xd, 275 => 0x1c, 276 => 0x12, 277 => 0x12 },
	'localcaption' => { 93 => 0x79 },
	'localizedcameramodel' => { 86 => 0xc615 },
	'locallocationname' => { 271 => 0x30 },
	'location' => { 162 => 0x9, 226 => 0x67, 290 => 'Location', 301 => 'Location', 309 => 'location' },
	'locationareacode' => { 294 => 'lac' },
	'locationcreated' => { 302 => 'LocationCreated' },
	'locationcreatedcity' => { 302 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 302 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 302 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 302 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 302 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 302 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 162 => 0x0 },
	'locationname' => { 271 => 0x31 },
	'locationshown' => { 302 => 'LocationShown' },
	'locationshowncity' => { 302 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 302 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 302 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 302 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 302 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 302 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 60 => 0x709 },
	'logcomment' => { 318 => 'logComment' },
	'longexposurenoisereduction' => { 60 => 0x201, 61 => 0x1, 62 => 0x2, 63 => 0x1, 64 => 0x1, 65 => 0x2, 66 => 0x1, 276 => 0x2b, 283 => [0xb04e,0x2008] },
	'longexposurenoisereduction2' => { 39 => 0x8 },
	'longfocal' => { 4 => 0xe6, 5 => 0x10, 6 => 0x13, 7 => 0x115, 8 => 0x13, 9 => [0x152,0x153], 10 => 0xda, 12 => 0xfa, 13 => 0xee, 14 => 0x103, 15 => 0x95, 16 => 0xea, 18 => 0xee, 19 => 0xec, 21 => 0xf2, 25 => 0x17 },
	'loop' => { 318 => 'loop' },
	'luminanceadjustmentaqua' => { 295 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 295 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 295 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 295 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 295 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 295 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 295 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 295 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 78 => 0x150 },
	'luminancecurvepoints' => { 78 => 0x126 },
	'luminancenoisereduction' => { 79 => 0x5f, 274 => 0x1b },
	'luminancenoisereductioncontrast' => { 295 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 295 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 79 => 0x6d },
	'luminancesmoothing' => { 295 => 'LuminanceSmoothing' },
	'm16cversion' => { 222 => 0x333 },
	'macro' => { 90 => 0x1020, 91 => 0x202, 212 => 0x202, 265 => 0x21, 273 => 0x202, 283 => 0xb040 },
	'macromagnification' => { 4 => 0x1b, 7 => 0x1b, 10 => 0x1b, 11 => 0x1b, 15 => 0x1b, 16 => 0x1b, 39 => 0x10 },
	'macromode' => { 25 => 0x1, 132 => 0xb, 207 => 0x300, 226 => 0x1c },
	'magicfilter' => { 207 => 0x52c },
	'magnifiedview' => { 62 => 0x11, 64 => 0x9 },
	'maindialexposurecomp' => { 205 => '0.6' },
	'make' => { 74 => 0x0, 86 => 0x10f, 114 => 'Make', 218 => 'Make', 228 => 0x10f, 314 => 'Make' },
	'makernote' => { 299 => 'MakerNote' },
	'makernotecanon' => { 85 => 'MakN', 86 => 0x927c },
	'makernotecasio' => { 85 => 'MakN', 86 => 0x927c },
	'makernotecasio2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotefujifilm' => { 85 => 'MakN', 86 => 0x927c },
	'makernotege' => { 85 => 'MakN', 86 => 0x927c },
	'makernotege2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehasselblad' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp6' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteisl' => { 85 => 'MakN', 86 => 0x927c },
	'makernotejvc' => { 85 => 'MakN', 86 => 0x927c },
	'makernotejvctext' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak10' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak1a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak1b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak5' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak6a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak6b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak7' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak8a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak8b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak9' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodakunknown' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekyocera' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica2' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica3' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica4' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica5' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica6' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta2' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon3' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteoffset' => { 273 => 0xff },
	'makernoteolympus' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteolympus2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepanasonic' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepanasonic2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax5' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax6' => { 85 => 'MakN', 86 => 0x927c },
	'makernotephaseone' => { 85 => 'MakN', 86 => 0x927c },
	'makernotereconyx' => { 85 => 'MakN', 86 => 0x927c },
	'makernotericoh' => { 85 => 'MakN', 86 => 0x927c },
	'makernotericohtext' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesafety' => { 86 => 0xc635 },
	'makernotesamsung1a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesamsung1b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesamsung2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyo' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyoc4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyopatch' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesigma' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesonyericsson' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesonysrf' => { 85 => 'MakN', 86 => 0x927c },
	'makernotetype' => { 266 => 0x1 },
	'makernoteunknown' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteunknowntext' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteversion' => { 136 => 0x0, 163 => 0x1, 212 => 0x0, 226 => 0x8000, 270 => 0x0, 271 => 0x1, 274 => [0x1d,0x1f], 279 => 0x2000 },
	'managedfrom' => { 319 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 319 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 319 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 319 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 319 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 319 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 319 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 319 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 319 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 319 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 319 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 319 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 319 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 319 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 319 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 319 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 319 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 319 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 319 => 'Manager' },
	'managervariant' => { 319 => 'ManagerVariant' },
	'manageto' => { 319 => 'ManageTo' },
	'manageui' => { 319 => 'ManageUI' },
	'manifest' => { 319 => 'Manifest' },
	'manifestlinkform' => { 319 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 319 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 319 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 319 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 319 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 319 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 319 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 319 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 319 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 319 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 319 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 319 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 319 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 319 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 319 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 319 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 319 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 319 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 319 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 319 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 319 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 319 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 207 => 0x900 },
	'manometerreading' => { 207 => 0x901 },
	'manualafpointselectpattern' => { 60 => 0x513 },
	'manualexposuretime' => { 135 => 0x6 },
	'manualflash' => { 210 => 0x1209 },
	'manualflashoutput' => { 25 => 0x29, 201 => '8.2', 202 => '22.2', 203 => '16.2', 204 => '23.2', 205 => '8.2', 206 => '24.2' },
	'manualflashstrength' => { 207 => 0x406 },
	'manualfnumber' => { 135 => 0x7 },
	'manualfocusdistance' => { 163 => 0x85, 212 => 0x100c, 273 => 0x223 },
	'manualtv' => { 59 => 0x5, 60 => 0x705 },
	'manufacturedate' => { 233 => 0x1 },
	'manufacturedate1' => { 268 => 0x4 },
	'manufacturedate2' => { 268 => 0x5 },
	'marked' => { 306 => 'Marked', 322 => 'Marked' },
	'markers' => { 318 => 'markers' },
	'markerscomment' => { 318 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 318 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 318 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 318 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 318 => [\'markers','markersCuePointType'] },
	'markersduration' => { 318 => [\'markers','markersDuration'] },
	'markerslocation' => { 318 => [\'markers','markersLocation'] },
	'markersname' => { 318 => [\'markers','markersName'] },
	'markersprobability' => { 318 => [\'markers','markersProbability'] },
	'markersspeaker' => { 318 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 318 => [\'markers','markersStartTime'] },
	'markerstarget' => { 318 => [\'markers','markersTarget'] },
	'markerstype' => { 318 => [\'markers','markersType'] },
	'maskedareas' => { 86 => 0xc68e },
	'masterdocumentid' => { 93 => 0xb9 },
	'mastergain' => { 168 => 0x50 },
	'maxaperture' => { 25 => 0x1a, 104 => 0x6103, 121 => 'MaxAperture', 132 => 0x17, 243 => '14.1' },
	'maxapertureatcurrentfocal' => { 208 => 0x20a },
	'maxapertureatmaxfocal' => { 90 => 0x1407, 121 => 'MaxApertureAtMaxFocal', 158 => 0xb, 159 => 0x10, 160 => 0x11, 208 => 0x206 },
	'maxapertureatminfocal' => { 90 => 0x1406, 158 => 0xa, 159 => 0xf, 160 => 0x10, 208 => 0x205 },
	'maxaperturevalue' => { 86 => 0x9205, 299 => 'MaxApertureValue' },
	'maxavailheight' => { 302 => 'MaxAvailHeight' },
	'maxavailwidth' => { 302 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 200 => 0xb, 203 => 0xc, 204 => 0xb },
	'maxfaces' => { 211 => 0x1202 },
	'maxfocallength' => { 90 => 0x1405, 121 => 'MaxFocalLength', 158 => 0x9, 159 => 0xe, 160 => 0xf, 208 => 0x208 },
	'maximumdensityrange' => { 95 => 0x8c },
	'maxpagesize' => { 323 => 'MaxPageSize' },
	'maxpagesizeh' => { 323 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 323 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 323 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 86 => 0x119 },
	'maxstorage' => { 313 => 'maxstorage' },
	'mb-d10batteries' => { 200 => '12.6' },
	'mb-d10batterytype' => { 203 => '13.3' },
	'mb-d11batterytype' => { 204 => '2.3' },
	'mb-d80batteries' => { 205 => '6.5' },
	'mb-d80batterytype' => { 206 => '3.2' },
	'mcuversion' => { 158 => 0xc, 159 => 0x11, 160 => 0x12 },
	'md5digest' => { 122 => 'zmd5' },
	'measuredev' => { 20 => 0x9, 55 => 0x3, 73 => 0x1814, 114 => 'MeasuredEV' },
	'measuredev2' => { 9 => 0x8, 20 => 0x8, 55 => 0x17 },
	'measuredev3' => { 9 => 0x9 },
	'measuredlv' => { 222 => 0x312, 227 => 0x3407 },
	'measuredrggb' => { 45 => 0x1 },
	'measuredrggbdata' => { 31 => 0x287 },
	'mediaconstraints' => { 308 => 'MediaConstraints' },
	'mediasummarycode' => { 308 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 58 => 0xb, 61 => 0xa, 62 => 0xb, 65 => 0xb },
	'menubuttonreturn' => { 66 => 0xb },
	'menumonitorofftime' => { 203 => '8.2', 204 => '21.1', 206 => '22.1' },
	'metadatadate' => { 316 => 'MetadataDate' },
	'metadatamoddate' => { 318 => 'metadataModDate' },
	'metering' => { 201 => '6.1' },
	'meteringmode' => { 25 => 0x11, 86 => 0x9207, 100 => 0x1c, 132 => 0x7, 133 => 0x25, 135 => 0x12, 207 => 0x202, 250 => 0x17, 274 => 0x9, 276 => 0x15, 277 => 0x13, 299 => 'MeteringMode' },
	'meteringmode2' => { 234 => '2.1' },
	'meteringmode3' => { 234 => '16.1' },
	'meteringoffscaleindicator' => { 135 => 0x53 },
	'meteringtime' => { 200 => '22.2', 201 => '3.2', 202 => '17.1', 203 => '7.3', 204 => '18.1', 205 => '3.2', 206 => '19.1' },
	'mieversion' => { 122 => '0Vers' },
	'minaperture' => { 25 => 0x1b, 121 => 'MinAperture', 243 => '0.2' },
	'minfocallength' => { 90 => 0x1404, 121 => 'MinFocalLength', 158 => 0x8, 159 => 0xd, 160 => 0xe, 208 => 0x207 },
	'minoltadate' => { 132 => 0x15 },
	'minoltaimagesize' => { 132 => 0x4, 133 => 0xc, 134 => 0x2, 136 => 0x103 },
	'minoltamodelid' => { 132 => 0x25 },
	'minoltaquality' => { 132 => 0x5, 133 => 0xd, 134 => 0x3, 136 => [0x102,0x103] },
	'minoltatime' => { 132 => 0x16 },
	'minormodelagedisclosure' => { 308 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 86 => 0x118 },
	'mirrorlockup' => { 58 => 0xc, 59 => 0xc, 60 => 0x60f, 61 => 0xb, 62 => 0xc, 63 => 0x6, 64 => 0x6, 65 => 0xc, 66 => 0x3 },
	'mobilecountrycode' => { 294 => 'mcc' },
	'mobilenetworkcode' => { 294 => 'mnc' },
	'moddate' => { 218 => 'modify-date', 306 => 'ModDate' },
	'model' => { 74 => 0x6, 86 => 0x110, 114 => 'Model', 218 => 'Model', 228 => 0x110, 314 => 'Model' },
	'modelage' => { 302 => 'ModelAge' },
	'modelingflash' => { 200 => '21.4', 203 => '26.4', 204 => '30.2', 205 => '7.4', 206 => '31.3' },
	'modelreleaseid' => { 308 => 'ModelReleaseID' },
	'modelreleasestatus' => { 308 => 'ModelReleaseStatus' },
	'modificationdate' => { 309 => 'modificationDate' },
	'modifiedcolortemp' => { 46 => 0x9 },
	'modifieddigitalgain' => { 46 => 0xb },
	'modifiedparamflag' => { 40 => 0x1 },
	'modifiedpicturestyle' => { 46 => 0xa },
	'modifiedsaturation' => { 207 => 0x504 },
	'modifiedsensorbluelevel' => { 46 => 0x5 },
	'modifiedsensorredlevel' => { 46 => 0x4 },
	'modifiedsharpness' => { 46 => 0x2 },
	'modifiedsharpnessfreq' => { 46 => 0x3 },
	'modifiedtonecurve' => { 46 => 0x1 },
	'modifiedwhitebalance' => { 46 => 0x8 },
	'modifiedwhitebalanceblue' => { 46 => 0x7 },
	'modifiedwhitebalancered' => { 46 => 0x6 },
	'modifydate' => { 86 => 0x132, 115 => 'ModifyDate', 216 => 'ModDate', 217 => 'tIME', 261 => 'ModDate', 316 => 'ModifyDate' },
	'moirefilter' => { 86 => 0xfe58, 295 => 'MoireFilter' },
	'monitordisplayoff' => { 135 => 0x4c },
	'monitorofftime' => { 200 => '18.2', 201 => '3.1', 205 => '3.1' },
	'monochromecontrast' => { 79 => 0x3c },
	'monochromefiltereffect' => { 79 => 0x3a, 250 => 0x73 },
	'monochromelinear' => { 79 => 0x3d },
	'monochromeoutputhighlightpoint' => { 79 => 0x41 },
	'monochromeoutputshadowpoint' => { 79 => 0x42 },
	'monochromerawhighlight' => { 79 => 0x7a },
	'monochromerawhighlightpoint' => { 79 => 0x3f },
	'monochromerawshadow' => { 79 => 0x83 },
	'monochromerawshadowpoint' => { 79 => 0x40 },
	'monochromesharpness' => { 79 => 0x3e },
	'monochrometoning' => { 250 => 0x74 },
	'monochrometoningeffect' => { 79 => 0x3b },
	'monthdaycreated' => { 100 => 0x12, 109 => 0xe },
	'moonphase' => { 262 => 0x12 },
	'morepermissions' => { 293 => 'morePermissions' },
	'motionsensitivity' => { 262 => 0x29 },
	'multiburstimageheight' => { 283 => 0x1002 },
	'multiburstimagewidth' => { 283 => 0x1001 },
	'multiburstmode' => { 283 => 0x1000 },
	'multicontrollerwhilemetering' => { 60 => 0x517 },
	'multiexposureautogain' => { 164 => 0x3 },
	'multiexposuremode' => { 164 => 0x1 },
	'multiexposureshots' => { 164 => 0x2 },
	'multiframenoisereduction' => { 278 => 0x35, 283 => 0x200b },
	'multipleexposuremode' => { 211 => 0x101c },
	'multipleexposureset' => { 234 => '10.1' },
	'multisample' => { 168 => 0x40 },
	'multiselector' => { 200 => '9.4', 203 => '27.4' },
	'multiselectorliveview' => { 200 => '4.3' },
	'multiselectorplaybackmode' => { 200 => ['13.5','9.2'], 203 => '27.2' },
	'multiselectorshootmode' => { 200 => '9.1', 203 => '27.1' },
	'mycolormode' => { 48 => 0x2 },
	'nativedigest' => { 299 => 'NativeDigest', 314 => 'NativeDigest' },
	'ncdfileinfo' => { 98 => 0x414 },
	'ndfilter' => { 55 => 0x1c },
	'nefbitdepth' => { 163 => 0xe22 },
	'nefcompression' => { 163 => 0x93 },
	'neflinearizationtable' => { 163 => 0x96 },
	'neutraldensityfilter' => { 250 => 0x88 },
	'neutraloutputhighlightpoint' => { 79 => 0x2f },
	'neutraloutputshadowpoint' => { 79 => 0x30 },
	'neutralrawcolortone' => { 79 => 0x28 },
	'neutralrawcontrast' => { 79 => 0x2a },
	'neutralrawhighlight' => { 79 => 0x78 },
	'neutralrawhighlightpoint' => { 79 => 0x2d },
	'neutralrawlinear' => { 79 => 0x2b },
	'neutralrawsaturation' => { 79 => 0x29 },
	'neutralrawshadow' => { 79 => 0x81 },
	'neutralrawshadowpoint' => { 79 => 0x2e },
	'neutralrawsharpness' => { 79 => 0x2c },
	'newsphotoversion' => { 95 => 0x0 },
	'nickname' => { 316 => 'Nickname' },
	'nikoncapturedata' => { 163 => 0xe01 },
	'nikoncaptureeditversions' => { 163 => 0xe13 },
	'nikoncaptureoutput' => { 163 => 0xe1e },
	'nikoncaptureversion' => { 163 => 0xe09 },
	'nikoniccprofile' => { 163 => 0xe1d },
	'nikonimagesize' => { 175 => '723.1', 176 => '732.1', 181 => 0x2c4 },
	'noisefilter' => { 207 => 0x527 },
	'noisereduction' => { 90 => 0x100b, 133 => 0xb0, 134 => 0x60, 135 => 0x3f, 163 => 0x95, 193 => 0x753dcbc0, 194 => 0x17, 207 => 0x50a, 212 => 0x103a, 226 => 0x2d, 250 => 0x49, 268 => 0x2a },
	'noisereduction2' => { 211 => 0x1010 },
	'noisereductionapplied' => { 86 => 0xc6f7 },
	'noisereductionintensity' => { 194 => 0x9 },
	'noisereductionmethod' => { 194 => 0x11 },
	'noisereductionmode' => { 286 => 0x801e },
	'noisereductionsharpness' => { 194 => 0xd },
	'noisereductionvalue' => { 286 => 0x8027 },
	'nomemorycard' => { 200 => '22.1', 201 => '0.3', 202 => '2.4', 203 => '33.7', 204 => '3.2', 205 => '0.3', 206 => '4.5' },
	'nominalmaxaperture' => { 243 => 0xa },
	'nominalminaperture' => { 243 => '10.1' },
	'notes' => { 287 => 'Notes', 291 => 'notes' },
	'npages' => { 323 => 'NPages' },
	'nrwdata' => { 163 => 0x14 },
	'nullrecord' => { 73 => 0x0 },
	'number' => { 309 => 'number' },
	'numberofbeats' => { 318 => 'numberOfBeats' },
	'numberoffocuspoints' => { 204 => '0.3' },
	'numfacepositions' => { 220 => 0x0 },
	'numindexentries' => { 95 => 0x54 },
	'object' => { 309 => 'object' },
	'objectattributereference' => { 93 => 0x4 },
	'objectcycle' => { 93 => 0x4b },
	'objectdistance' => { 82 => 0x6, 83 => 0x2022 },
	'objectname' => { 93 => 0x5 },
	'objectpreviewdata' => { 93 => 0xca },
	'objectpreviewfileformat' => { 93 => 0xc8 },
	'objectpreviewfileversion' => { 93 => 0xc9 },
	'objecttypereference' => { 93 => 0x3 },
	'oecfcolumns' => { 299 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 299 => [\'OECF','OECFNames'] },
	'oecfrows' => { 299 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 299 => [\'OECF','OECFValues'] },
	'offsetschema' => { 86 => 0xea1d },
	'okbutton' => { 204 => '15.1', 206 => '16.1' },
	'oldsubfiletype' => { 86 => 0xff },
	'olympusimageheight' => { 212 => 0x102f },
	'olympusimagewidth' => { 212 => 0x102e },
	'onetouchwb' => { 212 => 0x302 },
	'opticalzoom' => { 102 => 0xfa3d, 104 => [0x6006,0xf006], 105 => 0x1000, 106 => 0xf, 109 => 0x1e, 121 => 'OpticalZoom' },
	'opticalzoomcode' => { 55 => 0xa },
	'opticalzoommode' => { 226 => 0x34 },
	'opticalzoomon' => { 273 => 0x219 },
	'optionenddate' => { 311 => 'optionEndDate' },
	'opto-electricconvfactor' => { 299 => 'OECF' },
	'ordernumber' => { 90 => 0x8002 },
	'organisationinimagecode' => { 302 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 302 => 'OrganisationInImageName' },
	'organization' => { 309 => 'organization' },
	'orientation' => { 86 => 0x112, 228 => 0x112, 314 => 'Orientation' },
	'orientationlinkedafpoint' => { 60 => 0x516 },
	'originaldecisiondata' => { 84 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 44 => 0x83 },
	'originaldirectory' => { 224 => 0x408 },
	'originaldocumentid' => { 319 => 'OriginalDocumentID' },
	'originalfilename' => { 73 => 0x816, 98 => 0x3e9, 110 => 0x20, 224 => 0x407 },
	'originalimageheight' => { 56 => 0xc, 89 => 0x1 },
	'originalimagewidth' => { 56 => 0xb, 89 => 0x0 },
	'originalrawfiledata' => { 86 => 0xc68c },
	'originalrawfiledigest' => { 86 => 0xc71d },
	'originalrawfilename' => { 86 => 0xc68b },
	'originaltransmissionreference' => { 93 => 0x67 },
	'originatingprogram' => { 93 => 0x41 },
	'originplatform' => { 309 => 'originPlatform' },
	'os' => { 297 => 'os' },
	'otherconditions' => { 308 => 'OtherConditions' },
	'otherconstraints' => { 308 => 'OtherConstraints' },
	'otherimageinfo' => { 308 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 308 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 308 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 308 => 'OtherLicenseRequirements' },
	'outcue' => { 318 => 'outCue' },
	'outcuescale' => { 318 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 318 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 144 => 0x3 },
	'outputimagewidth' => { 144 => 0x2 },
	'outputresolution' => { 144 => 0x4 },
	'owner' => { 322 => 'Owner' },
	'ownerid' => { 93 => 0xbc },
	'ownername' => { 11 => 0x10f, 44 => 0x9, 73 => 0x810, 86 => [0xa430,0xfde8], 114 => 'OwnerName', 292 => 'OwnerName' },
	'padding' => { 86 => 0xea1c },
	'pageimage' => { 316 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 316 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 316 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 316 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 316 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 316 => 'PageInfo' },
	'pagename' => { 86 => 0x11d },
	'pagenumber' => { 86 => 0x129 },
	'pagerange' => { 309 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 295 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectioncontrast' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectionexposure' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionhue' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionmaskcenterweight' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionsaturation' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionsharpness' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectionwhat' => { 295 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 226 => 0x26 },
	'panasonicimageheight' => { 226 => 0x4c },
	'panasonicimagewidth' => { 226 => 0x4b },
	'panasonicrawversion' => { 228 => 0x1 },
	'panasonictitle' => { 86 => 0xc6d2 },
	'panasonictitle2' => { 86 => 0xc6d3 },
	'panoramacropbottom' => { 284 => 0x7 },
	'panoramacropleft' => { 284 => 0x4 },
	'panoramacropright' => { 284 => 0x6 },
	'panoramacroptop' => { 284 => 0x5 },
	'panoramadirection' => { 51 => 0x5, 284 => 0x3 },
	'panoramaframeheight' => { 284 => 0x9 },
	'panoramaframenumber' => { 51 => 0x2 },
	'panoramaframewidth' => { 284 => 0x8 },
	'panoramafullheight' => { 284 => 0x2 },
	'panoramafullwidth' => { 284 => 0x1 },
	'panoramamode' => { 100 => 0x3c, 207 => 0x601 },
	'panoramasourceheight' => { 284 => 0xb },
	'panoramasourcewidth' => { 284 => 0xa },
	'panoramicstitchcameramotion' => { 129 => 'PanoramicStitchCameraMotion', 130 => 0x1 },
	'panoramicstitchmaptype' => { 129 => 'PanoramicStitchMapType', 130 => 0x2 },
	'panoramicstitchphi0' => { 129 => 'PanoramicStitchPhi0', 130 => 0x5 },
	'panoramicstitchphi1' => { 129 => 'PanoramicStitchPhi1', 130 => 0x6 },
	'panoramicstitchtheta0' => { 129 => 'PanoramicStitchTheta0', 130 => 0x3 },
	'panoramicstitchtheta1' => { 129 => 'PanoramicStitchTheta1', 130 => 0x4 },
	'panoramicstitchversion' => { 130 => 0x0 },
	'pantry' => { 319 => 'Pantry' },
	'parallax' => { 90 => 0xb211 },
	'parametricdarks' => { 295 => 'ParametricDarks' },
	'parametrichighlights' => { 295 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 295 => 'ParametricHighlightSplit' },
	'parametriclights' => { 295 => 'ParametricLights' },
	'parametricmidtonesplit' => { 295 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 295 => 'ParametricShadows' },
	'parametricshadowsplit' => { 295 => 'ParametricShadowSplit' },
	'patientbirthdate' => { 288 => 'PatientDOB' },
	'patientid' => { 288 => 'PatientID' },
	'patientname' => { 288 => 'PatientName' },
	'patientsex' => { 288 => 'PatientSex' },
	'pdfversion' => { 306 => 'PDFVersion' },
	'pentaximagesize' => { 250 => 0x9 },
	'pentaxmodelid' => { 233 => 0x0, 250 => 0x5 },
	'pentaxmodeltype' => { 250 => 0x1 },
	'pentaxversion' => { 250 => 0x0 },
	'people' => { 290 => 'People' },
	'peripheralillumcentralradius' => { 286 => 0x8030 },
	'peripheralillumcentralvalue' => { 286 => 0x8031 },
	'peripheralillumination' => { 79 => 0x68 },
	'peripheralilluminationon' => { 79 => 0x64 },
	'peripheralillumperiphvalue' => { 286 => 0x8032 },
	'peripherallighting' => { 56 => 0x2 },
	'peripherallightingsetting' => { 57 => 0x5 },
	'peripherallightingvalue' => { 56 => 0x6 },
	'permissions' => { 311 => 'permissions' },
	'person' => { 309 => 'person' },
	'personinimage' => { 302 => 'PersonInImage' },
	'perspectivehorizontal' => { 295 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 295 => 'PerspectiveRotate' },
	'perspectivescale' => { 295 => 'PerspectiveScale' },
	'perspectivevertical' => { 295 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 68 => 0x1 },
	'pf10retainprogramshift' => { 68 => 0xb },
	'pf13drivepriority' => { 68 => 0xe },
	'pf14disablefocussearch' => { 68 => 0xf },
	'pf15disableafassistbeam' => { 68 => 0x10 },
	'pf16autofocuspointshoot' => { 68 => 0x11 },
	'pf17disableafpointsel' => { 68 => 0x12 },
	'pf18enableautoafpointsel' => { 68 => 0x13 },
	'pf19continuousshootspeed' => { 68 => 0x14 },
	'pf19shootingspeedhigh' => { 67 => 0xa },
	'pf19shootingspeedlow' => { 67 => 0x9 },
	'pf1disableshootingmodes' => { 68 => 0x2 },
	'pf1value' => { 67 => 0x1 },
	'pf20limitcontinousshots' => { 68 => 0x15 },
	'pf20maxcontinousshots' => { 67 => 0xb },
	'pf21enablequietoperation' => { 68 => 0x16 },
	'pf23felocktime' => { 67 => 0xd },
	'pf23postreleasetime' => { 67 => 0xe },
	'pf23settimerlengths' => { 68 => 0x18 },
	'pf23shutterbuttontime' => { 67 => 0xc },
	'pf24lightlcdduringbulb' => { 68 => 0x19 },
	'pf25aemode' => { 67 => 0xf },
	'pf25afmode' => { 67 => 0x12 },
	'pf25afpointsel' => { 67 => 0x13 },
	'pf25colormatrix' => { 67 => 0x17 },
	'pf25defaultclearsettings' => { 68 => 0x1a },
	'pf25drivemode' => { 67 => 0x11 },
	'pf25imagesize' => { 67 => 0x14 },
	'pf25meteringmode' => { 67 => 0x10 },
	'pf25parameters' => { 67 => 0x16 },
	'pf25wbmode' => { 67 => 0x15 },
	'pf26shortenreleaselag' => { 68 => 0x1b },
	'pf27reversedialrotation' => { 68 => 0x1c },
	'pf27value' => { 67 => 0x18 },
	'pf28noquickdialexpcomp' => { 68 => 0x1d },
	'pf29quickdialswitchoff' => { 68 => 0x1e },
	'pf2disablemeteringmodes' => { 68 => 0x3 },
	'pf2value' => { 67 => 0x2 },
	'pf30enlargementmode' => { 68 => 0x1f },
	'pf31originaldecisiondata' => { 68 => 0x20 },
	'pf3manualexposuremetering' => { 68 => 0x4 },
	'pf3value' => { 67 => 0x3 },
	'pf4exposuretimelimits' => { 68 => 0x5 },
	'pf4exposuretimemax' => { 67 => 0x5 },
	'pf4exposuretimemin' => { 67 => 0x4 },
	'pf5aperturelimits' => { 68 => 0x6 },
	'pf5aperturemax' => { 67 => 0x7 },
	'pf5aperturemin' => { 67 => 0x6 },
	'pf6presetshootingmodes' => { 68 => 0x7 },
	'pf7bracketcontinuousshoot' => { 68 => 0x8 },
	'pf8bracketshots' => { 67 => 0x8 },
	'pf8setbracketshots' => { 68 => 0x9 },
	'pf9changebracketsequence' => { 68 => 0xa },
	'phasedetectaf' => { 142 => 0x6 },
	'phonenumber' => { 115 => 'Phone' },
	'photoeffect' => { 25 => 0x28 },
	'photoeffecthistoryxml' => { 193 => 0xe9651831 },
	'photoeffects' => { 193 => 0xab5eca5e },
	'photoeffectsblue' => { 195 => 0x8 },
	'photoeffectsgreen' => { 195 => 0x6 },
	'photoeffectsred' => { 195 => 0x4 },
	'photoeffectstype' => { 195 => 0x0 },
	'photoinfoplayback' => { 200 => '17.6', 203 => '33.6' },
	'photometricinterpretation' => { 86 => 0x106, 314 => 'PhotometricInterpretation' },
	'photoshopquality' => { 258 => 0x0 },
	'picklabel' => { 298 => 'PickLabel' },
	'pictinfo' => { 273 => 0x208 },
	'picturecontrol' => { 193 => 0xe2173c47 },
	'picturecontrolactive' => { 196 => 0x0 },
	'picturecontroladjust' => { 165 => 0x30 },
	'picturecontrolbase' => { 165 => 0x18 },
	'picturecontroldata' => { 163 => [0xbd,0x23] },
	'picturecontrolmode' => { 196 => 0x13 },
	'picturecontrolname' => { 165 => 0x4 },
	'picturecontrolquickadjust' => { 165 => 0x31 },
	'picturefinish' => { 133 => 0x71 },
	'picturemode' => { 90 => 0x1031, 207 => 0x520, 250 => [0xb,0x33], 274 => 0x3d },
	'picturemode2' => { 234 => 0x0 },
	'picturemodebwfilter' => { 207 => 0x525 },
	'picturemodecontrast' => { 207 => 0x523 },
	'picturemodeeffect' => { 207 => 0x52d },
	'picturemodehue' => { 207 => 0x522 },
	'picturemodesaturation' => { 207 => 0x521 },
	'picturemodesharpness' => { 207 => 0x524 },
	'picturemodetone' => { 207 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0x6c, 7 => 0x86, 8 => 0x73, 12 => 0xab, 13 => 0xa7, 14 => 0xb0, 15 => 0x6c, 16 => 0xa7, 18 => 0xb3, 53 => 0xa, 79 => 0x2 },
	'picturewizard' => { 271 => 0x21 },
	'picturewizardcolor' => { 269 => 0x1 },
	'picturewizardcontrast' => { 269 => 0x4 },
	'picturewizardmode' => { 269 => 0x0 },
	'picturewizardsaturation' => { 269 => 0x2 },
	'picturewizardsharpness' => { 269 => 0x3 },
	'pitchangle' => { 249 => 0x2 },
	'planarconfiguration' => { 86 => 0x11c, 314 => 'PlanarConfiguration' },
	'platenames' => { 323 => 'PlateNames' },
	'playbackmenustime' => { 202 => '20.1' },
	'playbackmonitorofftime' => { 203 => '8.1', 204 => '35.1', 206 => '21.1' },
	'playdisplay' => { 135 => 0x4e },
	'plusversion' => { 308 => 'Version' },
	'pngwarning' => { 218 => 'Warning' },
	'portraitoutputhighlightpoint' => { 79 => 0x1d },
	'portraitoutputshadowpoint' => { 79 => 0x1e },
	'portraitrawcolortone' => { 79 => 0x16 },
	'portraitrawcontrast' => { 79 => 0x18 },
	'portraitrawhighlight' => { 79 => 0x76 },
	'portraitrawhighlightpoint' => { 79 => 0x1b },
	'portraitrawlinear' => { 79 => 0x19 },
	'portraitrawsaturation' => { 79 => 0x17 },
	'portraitrawshadow' => { 79 => 0x7f },
	'portraitrawshadowpoint' => { 79 => 0x1c },
	'portraitrawsharpness' => { 79 => 0x1a },
	'portraitrefiner' => { 83 => 0x302b },
	'postalcode' => { 119 => 'PostalCode' },
	'postcropvignetteamount' => { 295 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 295 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 295 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 295 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 295 => 'PostCropVignetteStyle' },
	'powersource' => { 232 => '0.1' },
	'poweruptime' => { 163 => 0xb6 },
	'precaptureframes' => { 212 => 0x300 },
	'predictor' => { 86 => 0x13d },
	'preflashreturnstrength' => { 176 => 0x28a },
	'prefs' => { 93 => 0xdd, 257 => 'Prefs' },
	'preservedfilename' => { 319 => 'PreservedFileName' },
	'presetwhitebalance' => { 135 => 0x24, 286 => 0x8002 },
	'presetwhitebalanceadj' => { 286 => 0x8014 },
	'previewapplicationname' => { 86 => 0xc716 },
	'previewapplicationversion' => { 86 => 0xc717 },
	'previewbutton' => { 200 => ['14.1','15.1'], 203 => '29.1', 204 => '14.1' },
	'previewbuttonplusdials' => { 200 => ['14.2','15.2'], 203 => '31.2' },
	'previewcolorspace' => { 86 => 0xc71a },
	'previewcropbottom' => { 256 => 0xef },
	'previewcropleft' => { 256 => 0xec },
	'previewcropright' => { 256 => 0xee },
	'previewcroptop' => { 256 => 0xed },
	'previewdatetime' => { 86 => 0xc71b },
	'previewheight' => { 102 => 0xfa58 },
	'previewimage' => { 83 => 0x2000, 84 => 'PreviewImage', 87 => 'PreviewImage', 88 => 0x4, 124 => 'data', 136 => 0x81, 212 => 0x280, 225 => 0x300, 283 => 0x2001 },
	'previewimageborders' => { 250 => 0x3e },
	'previewimageheight' => { 52 => 0x4 },
	'previewimagelength' => { 52 => 0x2, 83 => 0x3, 86 => [0x117,0x202], 136 => 0x89, 166 => 0x202, 207 => 0x102, 212 => 0x1037, 250 => 0x3, 265 => 0x1e, 270 => 0x3, 274 => [0x1b,0x1d], 279 => 0x202 },
	'previewimagename' => { 124 => '1Name' },
	'previewimagesize' => { 83 => 0x2, 107 => 0x2, 124 => 'ImageSize', 250 => 0x2, 274 => 0x1c, 283 => 0xb02c },
	'previewimagestart' => { 52 => 0x5, 83 => 0x4, 86 => [0x111,0x201], 136 => 0x88, 166 => 0x201, 207 => 0x101, 212 => 0x1036, 250 => 0x4, 265 => 0x1c, 270 => 0x2, 274 => [0x1a,0x1c], 279 => 0x201 },
	'previewimagetype' => { 124 => '0Type' },
	'previewimagevalid' => { 207 => 0x100, 212 => 0x1035 },
	'previewimagewidth' => { 52 => 0x3 },
	'previewquality' => { 52 => 0x1 },
	'previewsettingsdigest' => { 86 => 0xc719 },
	'previewsettingsname' => { 86 => 0xc718 },
	'previewwidth' => { 102 => 0xfa57 },
	'primaryafpoint' => { 142 => 0x7 },
	'primarychromaticities' => { 86 => 0x13f, 314 => 'PrimaryChromaticities' },
	'printim' => { 86 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 135 => 0x1d, 276 => 0x28 },
	'privatertkinfo' => { 289 => 'privateRTKInfo' },
	'processingsoftware' => { 86 => 0xb },
	'processversion' => { 295 => 'ProcessVersion' },
	'producer' => { 216 => 'Producer', 306 => 'Producer' },
	'productid' => { 94 => 0x32 },
	'productioncode' => { 233 => 0x2 },
	'productorserviceconstraints' => { 308 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 86 => 0xc6f4 },
	'profilecopyright' => { 86 => 0xc6fe },
	'profileembedpolicy' => { 86 => 0xc6fd },
	'profilehuesatmapdata1' => { 86 => 0xc6fa },
	'profilehuesatmapdata2' => { 86 => 0xc6fb },
	'profilehuesatmapdims' => { 86 => 0xc6f9 },
	'profilelooktabledata' => { 86 => 0xc726 },
	'profilelooktabledims' => { 86 => 0xc725 },
	'profilename' => { 86 => 0xc6f8 },
	'profiletonecurve' => { 86 => 0xc6fc },
	'programiso' => { 226 => 0x3c },
	'programline' => { 234 => '1.1' },
	'programmode' => { 139 => 0x5 },
	'programshift' => { 163 => 0xd },
	'programversion' => { 93 => 0x46 },
	'projectname' => { 318 => 'projectName' },
	'projectref' => { 318 => 'projectRef' },
	'projectrefpath' => { 318 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 318 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 308 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 308 => 'PropertyReleaseStatus' },
	'province-state' => { 93 => 0x5f },
	'publicationdate' => { 309 => 'publicationDate' },
	'publicationname' => { 309 => 'publicationName' },
	'publisher' => { 296 => 'publisher' },
	'pulldown' => { 318 => 'pullDown' },
	'quality' => { 0 => 0x1, 25 => 0x3, 82 => 0x2, 83 => 0x3002, 90 => 0x1000, 100 => 0x9, 163 => 0x4, 183 => 0x3, 212 => 0x201, 222 => 0x300, 250 => 0x8, 255 => 0x2, 274 => 0x16, 276 => 0x56, 283 => [0x102,0xb047] },
	'qualitymode' => { 83 => 0x8 },
	'quantizationmethod' => { 95 => 0x78 },
	'quickadjust' => { 196 => 0x2a },
	'quickcontroldialinmeter' => { 60 => 0x703 },
	'quickshot' => { 273 => 0x213 },
	'rangefinder' => { 202 => '4.1' },
	'rasterizedcaption' => { 93 => 0x7d },
	'rating' => { 86 => 0x4746, 256 => 0xdf, 291 => 'rating', 297 => 'rating', 316 => 'Rating' },
	'ratingpercent' => { 86 => 0x4749, 131 => 'Rating' },
	'rawandjpgrecording' => { 58 => 0x8, 136 => 0x109, 234 => 0xd },
	'rawbrightnessadj' => { 78 => 0x38 },
	'rawcoloradj' => { 78 => 0x2e },
	'rawcropbottom' => { 256 => 0xd4 },
	'rawcropleft' => { 256 => 0xd1 },
	'rawcropright' => { 256 => 0xd3 },
	'rawcroptop' => { 256 => 0xd2 },
	'rawcustomsaturation' => { 78 => 0x30 },
	'rawcustomtone' => { 78 => 0x34 },
	'rawdatauniqueid' => { 86 => 0xc65d },
	'rawdepth' => { 138 => 0x10 },
	'rawdevautogradation' => { 214 => 0x119 },
	'rawdevcolorspace' => { 213 => 0x108, 214 => 0x109 },
	'rawdevcontrastvalue' => { 213 => 0x106, 214 => 0x105 },
	'rawdeveditstatus' => { 213 => 0x10b },
	'rawdevengine' => { 213 => 0x109, 214 => 0x10b },
	'rawdevexposurebiasvalue' => { 213 => 0x100, 214 => 0x100 },
	'rawdevgradation' => { 214 => 0x112 },
	'rawdevgraypoint' => { 213 => 0x103, 214 => 0x104 },
	'rawdevmemorycoloremphasis' => { 213 => 0x105, 214 => 0x108 },
	'rawdevnoisereduction' => { 213 => 0x10a, 214 => 0x10a },
	'rawdevpicturemode' => { 214 => 0x10c },
	'rawdevpm_bwfilter' => { 214 => 0x110 },
	'rawdevpmcontrast' => { 214 => 0x10e },
	'rawdevpmnoisefilter' => { 214 => 0x120 },
	'rawdevpmpicturetone' => { 214 => 0x111 },
	'rawdevpmsaturation' => { 214 => 0x10d },
	'rawdevpmsharpness' => { 214 => 0x10f },
	'rawdevsaturation3' => { 214 => 0x113 },
	'rawdevsaturationemphasis' => { 213 => 0x104, 214 => 0x107 },
	'rawdevsettings' => { 213 => 0x10c },
	'rawdevsharpnessvalue' => { 213 => 0x107, 214 => 0x106 },
	'rawdevversion' => { 213 => 0x0, 214 => 0x0 },
	'rawdevwbfineadjustment' => { 213 => 0x102, 214 => 0x103 },
	'rawdevwhitebalance' => { 214 => 0x101 },
	'rawdevwhitebalancevalue' => { 213 => 0x101, 214 => 0x102 },
	'rawfile' => { 86 => 0xfe4c },
	'rawfilename' => { 295 => 'RawFileName' },
	'rawimagecenter' => { 163 => 0x99 },
	'rawimagedigest' => { 86 => 0xc71c },
	'rawimagesize' => { 250 => 0x39 },
	'rawinfoversion' => { 215 => 0x0 },
	'rawjpgheight' => { 75 => 0x4 },
	'rawjpgquality' => { 39 => 0x6, 75 => 0x1 },
	'rawjpgsize' => { 39 => 0x7, 75 => 0x2 },
	'rawjpgwidth' => { 75 => 0x3 },
	'rawmeasuredrggb' => { 30 => 0x26a, 32 => 0x280, 34 => 0x194 },
	'rawrppused' => { 291 => 'rawrppused' },
	'reardisplay' => { 200 => '12.3' },
	'recognizedface1age' => { 221 => 0x20 },
	'recognizedface1name' => { 221 => 0x4 },
	'recognizedface1position' => { 221 => 0x18 },
	'recognizedface2age' => { 221 => 0x50 },
	'recognizedface2name' => { 221 => 0x34 },
	'recognizedface2position' => { 221 => 0x48 },
	'recognizedface3age' => { 221 => 0x80 },
	'recognizedface3name' => { 221 => 0x64 },
	'recognizedface3position' => { 221 => 0x78 },
	'recognizedfaceflags' => { 226 => 0x63 },
	'recommendedexposureindex' => { 86 => 0x8832 },
	'recorddisplay' => { 135 => 0x4d },
	'recordid' => { 73 => 0x1804 },
	'recordingmode' => { 82 => 0x1, 255 => 0x1 },
	'recordmode' => { 25 => 0x9, 83 => 0x3000 },
	'recordshutterrelease' => { 273 => 0x217 },
	'redbalance' => { 149 => 0x270, 212 => 0x1017, 228 => 0x11, 250 => 0x1c },
	'redcurvelimits' => { 78 => 0x18a },
	'redcurvepoints' => { 78 => 0x160 },
	'redeyecorrection' => { 197 => 0x0 },
	'redeyeinfo' => { 295 => 'RedEyeInfo' },
	'redeyereduction' => { 135 => 0x41 },
	'redhue' => { 295 => 'RedHue' },
	'redsaturation' => { 295 => 'RedSaturation' },
	'reductionmatrix1' => { 86 => 0xc625 },
	'reductionmatrix2' => { 86 => 0xc626 },
	'referenceblackwhite' => { 86 => 0x214, 314 => 'ReferenceBlackWhite' },
	'referencedate' => { 93 => 0x2f },
	'referencenumber' => { 93 => 0x32 },
	'references' => { 115 => 'References' },
	'referenceservice' => { 93 => 0x2d },
	'regionappliedtodimensions' => { 305 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 305 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 305 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 305 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 305 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 305 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 305 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 305 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 305 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 305 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 305 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 305 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 308 => 'RegionConstraints' },
	'regiondescription' => { 305 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 305 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 305 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 305 => 'Regions' },
	'regioninfomp' => { 128 => 'RegionInfo' },
	'regioninfompregions' => { 128 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 305 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 305 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 128 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionrectangle' => { 128 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 305 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 305 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 302 => 'RegistryId' },
	'registryitemid' => { 302 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 302 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 113 => 'data' },
	'relatedaudiofilename' => { 113 => '1Name' },
	'relatedaudiofiletype' => { 113 => '0Type' },
	'relatedimagefileformat' => { 86 => 0x1000 },
	'relatedimageheight' => { 86 => 0x1002 },
	'relatedimagewidth' => { 86 => 0x1001 },
	'relatedsoundfile' => { 86 => 0xa004, 299 => 'RelatedSoundFile' },
	'relatedvideofile' => { 127 => 'data' },
	'relatedvideofilename' => { 127 => '1Name' },
	'relatedvideofiletype' => { 127 => '0Type' },
	'relation' => { 296 => 'relation' },
	'relativepeakaudiofilepath' => { 318 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 318 => 'relativeTimestamp' },
	'relativetimestampscale' => { 318 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 318 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 200 => '17.8', 203 => '33.8', 204 => '17.6' },
	'releasedate' => { 93 => 0x1e, 318 => 'releaseDate' },
	'releasemode' => { 83 => 0x3001, 283 => 0xb049 },
	'releasesetting' => { 73 => 0x1016 },
	'releasetime' => { 93 => 0x23 },
	'remoteonduration' => { 201 => '3.4', 202 => '17.2', 204 => '18.2', 205 => '4.3', 206 => '19.2' },
	'renditionclass' => { 319 => 'RenditionClass' },
	'renditionof' => { 319 => 'RenditionOf' },
	'renditionofalternatepaths' => { 319 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 319 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 319 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 319 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 319 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 319 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 319 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 319 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 319 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 319 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 319 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 319 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 319 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 319 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 319 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 319 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 319 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 319 => 'RenditionParams' },
	'repeatingflashcount' => { 153 => 0xd, 154 => 0xe, 155 => 0xe, 203 => '17.2', 204 => '24.2', 205 => '9.2', 206 => '25.2' },
	'repeatingflashoutput' => { 203 => '17.1', 204 => '24.1', 205 => '9.1', 206 => '25.1' },
	'repeatingflashrate' => { 153 => 0xc, 154 => 0xd, 155 => 0xd, 203 => '18.1', 204 => '25.1', 205 => '10.1', 206 => '26.1' },
	'resampleparams' => { 318 => 'resampleParams' },
	'resampleparamsquality' => { 318 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 273 => 0x21e },
	'resolution' => { 120 => 'Resolution' },
	'resolutionmode' => { 274 => 0x4 },
	'resolutionunit' => { 86 => 0x128, 96 => 0x2, 314 => 'ResolutionUnit' },
	'restrictions' => { 311 => 'restrictions' },
	'retouchhistory' => { 163 => 0x9e },
	'retouchinfo' => { 295 => 'RetouchInfo' },
	'reuse' => { 308 => 'Reuse' },
	'reuseallowed' => { 321 => 'ReuseAllowed' },
	'reuseprohibited' => { 311 => 'reuseProhibited' },
	'reverseindicators' => { 200 => '12.1', 202 => '4.3', 203 => '33.5', 204 => '5.1', 206 => '6.2' },
	'revision' => { 297 => 'revision' },
	'rgbcurvelimits' => { 78 => 0x238 },
	'rgbcurvepoints' => { 78 => 0x20e },
	'ricohdate' => { 265 => 0x6 },
	'ricohimageheight' => { 265 => 0x2 },
	'ricohimagewidth' => { 265 => 0x0 },
	'rightascension' => { 123 => 'RightAscension' },
	'rights' => { 296 => 'rights' },
	'rightsagent' => { 309 => 'rightsAgent', 311 => 'rightsAgent' },
	'rightsowner' => { 311 => 'rightsOwner' },
	'rollangle' => { 249 => 0x1 },
	'romoperationmode' => { 73 => 0x80d },
	'rotation' => { 22 => 0x17, 23 => 0x18, 72 => 0x3, 78 => 0x26e, 89 => 0x4, 123 => 'Rotation', 133 => [0x65,0x50], 134 => 0x46, 135 => 0x5a, 181 => '590.1', 193 => 0x76a43207, 226 => 0x30, 234 => '17.2', 256 => 0xd8, 276 => 0x3f, 277 => 0x3f },
	'routedto' => { 300 => 'RoutedTo' },
	'routing' => { 261 => 'Routing' },
	'routingnotes' => { 300 => 'RoutingNotes' },
	'rowsperstrip' => { 86 => 0x116 },
	'rpp' => { 291 => 'rpp' },
	'safetyshift' => { 60 => 0x108 },
	'safetyshiftinavortv' => { 58 => 0x10, 59 => 0x10, 61 => 0xf, 62 => 0x10, 65 => 0x10 },
	'samplebits' => { 113 => 'SampleBits' },
	'samplerate' => { 113 => 'SampleRate' },
	'samplesperpixel' => { 86 => 0x115, 314 => 'SamplesPerPixel' },
	'samplestructure' => { 95 => 0x5a },
	'sanyoquality' => { 273 => 0x201 },
	'sanyothumbnail' => { 273 => 0x100 },
	'saturation' => { 6 => 0x6e, 8 => 0x76, 25 => 0xe, 35 => 0x1, 82 => 0xd, 83 => [0x3013,0x1f], 86 => [0xa409,0xfe55], 90 => 0x1003, 114 => 'Saturation', 132 => 0x1f, 133 => 0x32, 134 => 0x28, 135 => 0x1a, 139 => 0x1, 163 => [0x94,0xaa], 165 => 0x35, 226 => 0x40, 227 => 0x300d, 250 => 0x1f, 255 => 0xd, 262 => 0x27, 265 => 0x28, 274 => 0x10, 276 => 0x1e, 277 => 0x1b, 283 => 0x2005, 295 => 'Saturation', 299 => 'Saturation' },
	'saturationadj' => { 78 => 0x116, 192 => 0x1, 196 => 0x2e, 286 => 0x8016 },
	'saturationadjustmentaqua' => { 295 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 295 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 295 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 295 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 295 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 295 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 295 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 295 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 15 => 0xfe, 49 => 0x68, 50 => 0x68 },
	'saturationlandscape' => { 15 => 0xfc, 49 => 0x38, 50 => 0x38 },
	'saturationmonochrome' => { 49 => 0x80, 50 => 0x80 },
	'saturationneutral' => { 15 => 0xfd, 49 => 0x50, 50 => 0x50 },
	'saturationportrait' => { 15 => 0xfb, 49 => 0x20, 50 => 0x20 },
	'saturationsetting' => { 215 => 0x1010 },
	'saturationstandard' => { 15 => 0xfa, 49 => 0x8, 50 => 0x8 },
	'saturationunknown' => { 50 => 0x98 },
	'saturationuserdef1' => { 15 => 0x100, 49 => 0x98, 50 => 0xb0 },
	'saturationuserdef2' => { 15 => 0x101, 49 => 0xb0, 50 => 0xc8 },
	'saturationuserdef3' => { 15 => 0x102, 49 => 0xc8, 50 => 0xe0 },
	'saveid' => { 319 => 'SaveID' },
	'scaletype' => { 318 => 'scaleType' },
	'scanimageenhancer' => { 168 => 0x60 },
	'scanningdirection' => { 95 => 0x64 },
	'scene' => { 301 => 'Scene', 318 => 'scene' },
	'scenearea' => { 210 => 0x211, 212 => 0x1031 },
	'sceneassist' => { 163 => 0x9c },
	'scenecapturetype' => { 86 => 0xa406, 299 => 'SceneCaptureType' },
	'scenedetect' => { 210 => 0x210, 212 => 0x1030 },
	'scenedetectdata' => { 210 => 0x212, 212 => 0x1033 },
	'scenemode' => { 102 => 0xfa02, 136 => 0x100, 163 => 0x8f, 207 => 0x509, 212 => 0x403, 226 => 0x8001, 283 => 0xb023 },
	'scenemodeused' => { 104 => [0x6002,0xf002] },
	'sceneselect' => { 273 => 0x21f },
	'scenetype' => { 86 => 0xa301, 299 => 'SceneType' },
	'screentips' => { 200 => '12.7', 203 => '13.1', 204 => '4.4', 206 => '5.1' },
	'section' => { 309 => 'section' },
	'securityclassification' => { 86 => 0x9212 },
	'selectableafpoint' => { 60 => 0x509 },
	'selectafareaselectmode' => { 60 => 0x512 },
	'selftimer' => { 25 => 0x2, 226 => 0x2e, 273 => 0x214 },
	'selftimer2' => { 55 => 0x1d },
	'selftimerinterval' => { 204 => '19.2' },
	'selftimermode' => { 86 => 0x882b },
	'selftimershotcount' => { 202 => '18.2', 204 => '19.3', 206 => '20.2' },
	'selftimertime' => { 73 => 0x1806, 135 => 0x1f, 200 => '18.1', 201 => '3.3', 202 => '18.1', 203 => '7.2', 204 => '19.1', 205 => '3.3', 206 => '20.1' },
	'seminfo' => { 86 => 0x8546 },
	'sensingmethod' => { 86 => 0xa217, 299 => 'SensingMethod' },
	'sensitivityadjust' => { 250 => 0x40 },
	'sensitivitysteps' => { 234 => ['14.3','17.4'], 236 => 0x1 },
	'sensitivitytype' => { 86 => 0x8830 },
	'sensorareas' => { 271 => 0xa010 },
	'sensorbitdepth' => { 227 => 0x312d },
	'sensorbluelevel' => { 53 => 0x5 },
	'sensorcleaning' => { 66 => 0xd },
	'sensorfullheight' => { 97 => 0xf904 },
	'sensorfullwidth' => { 97 => 0xf903 },
	'sensorheight' => { 97 => 0xf901, 102 => 0xfa21, 138 => 0x8, 227 => 0x312c },
	'sensorpixelsize' => { 163 => 0x9a },
	'sensorredlevel' => { 53 => 0x4 },
	'sensorsize' => { 114 => 'SensorSize', 250 => 0x35 },
	'sensortemperature' => { 210 => 0x1500, 212 => 0x1007, 274 => [0x39,0x55] },
	'sensorwidth' => { 97 => 0xf900, 102 => 0xfa20, 138 => 0xa, 227 => 0x312b },
	'sequence' => { 262 => 0x7 },
	'sequencenumber' => { 55 => 0x9, 83 => 0x301c, 90 => 0x1101, 100 => 0x1d, 226 => 0x2b, 283 => 0xb04a },
	'sequenceshotinterval' => { 273 => 0x224 },
	'sequentialshot' => { 273 => 0x20e },
	'serialnumber' => { 44 => 0xc, 73 => 0x180b, 86 => [0xa431,0xfde9], 97 => 0xfa04, 99 => 0xfa00, 101 => 0xc354, 102 => 0xfa19, 111 => 0x0, 114 => 'SerialNumber', 163 => [0xa0,0x1d], 208 => 0x101, 212 => [0x404,0x101a], 222 => 0x303, 227 => 0x3103, 250 => 0x229, 262 => 0x15, 266 => 0x5, 274 => 0x2, 292 => 'SerialNumber' },
	'serialnumberformat' => { 44 => 0x15, 73 => 0x183b },
	'seriesdatetime' => { 288 => 'SeriesDateTime' },
	'seriesdescription' => { 288 => 'SeriesDescription' },
	'seriesmodality' => { 288 => 'SeriesModality' },
	'seriesnumber' => { 288 => 'SeriesNumber' },
	'serviceidentifier' => { 94 => 0x1e },
	'setbuttoncrosskeysfunc' => { 63 => 0x0, 64 => 0x0 },
	'setbuttonwhenshooting' => { 58 => 0x1, 60 => 0x704, 66 => 0xc },
	'setfunctionwhenshooting' => { 61 => 0x0, 62 => 0x1, 65 => 0x1 },
	'shadingcompensation' => { 207 => 0x50c },
	'shadingcompensation2' => { 211 => 0x1012 },
	'shadow' => { 274 => 0xe },
	'shadowcompensation' => { 250 => 0x79 },
	'shadowprotection' => { 192 => 0x0 },
	'shadows' => { 86 => 0xfe52, 295 => 'Shadows' },
	'shadowscale' => { 86 => 0xc633 },
	'shadowtint' => { 295 => 'ShadowTint' },
	'shakereduction' => { 251 => 0x1 },
	'sharpendetail' => { 295 => 'SharpenDetail' },
	'sharpenedgemasking' => { 295 => 'SharpenEdgeMasking' },
	'sharpening' => { 227 => 0x300b },
	'sharpeningadj' => { 196 => 0x2b },
	'sharpenradius' => { 295 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 6 => 0x72, 8 => 0x74, 25 => 0xf, 53 => 0x2, 82 => 0xb, 83 => [0x3011,0x21], 86 => [0xa40a,0xfe56], 90 => 0x1001, 100 => 0x6b, 109 => 0x37, 114 => 'Sharpness', 132 => 0x21, 133 => 0x30, 134 => 0x26, 135 => 0x18, 139 => 0x3, 163 => 0x6, 165 => 0x32, 212 => 0x100f, 226 => 0x41, 250 => 0x21, 255 => 0xb, 262 => 0x26, 265 => 0x22, 266 => 0x1003, 274 => 0x11, 276 => 0x1c, 277 => 0x19, 283 => 0x2006, 295 => 'Sharpness', 299 => 'Sharpness' },
	'sharpnessadj' => { 78 => 0x25a, 286 => 0x801a },
	'sharpnessfactor' => { 212 => 0x102a },
	'sharpnessfaithful' => { 15 => 0xf5, 49 => 0x64, 50 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 53 => 0x3 },
	'sharpnesslandscape' => { 15 => 0xf3, 49 => 0x34, 50 => 0x34 },
	'sharpnessmonochrome' => { 15 => 0xf6, 49 => 0x7c, 50 => 0x7c },
	'sharpnessneutral' => { 15 => 0xf4, 49 => 0x4c, 50 => 0x4c },
	'sharpnessovershoot' => { 286 => 0x801b },
	'sharpnessportrait' => { 15 => 0xf2, 49 => 0x1c, 50 => 0x1c },
	'sharpnesssetting' => { 207 => 0x506, 215 => 0x1013 },
	'sharpnessstandard' => { 15 => 0xf1, 49 => 0x4, 50 => 0x4 },
	'sharpnessthreshold' => { 286 => 0x801d },
	'sharpnessundershoot' => { 286 => 0x801c },
	'sharpnessunknown' => { 50 => 0x94 },
	'sharpnessuserdef1' => { 15 => 0xf7, 49 => 0x94, 50 => 0xac },
	'sharpnessuserdef2' => { 15 => 0xf8, 49 => 0xac, 50 => 0xc4 },
	'sharpnessuserdef3' => { 15 => 0xf9, 49 => 0xc4, 50 => 0xdc },
	'shootinginfodisplay' => { 200 => '13.2', 203 => '10.2', 204 => '4.1', 206 => '5.3' },
	'shootinginfomonitorofftime' => { 203 => '9.1', 204 => '21.2', 206 => '22.2' },
	'shootingmode' => { 114 => 'ShootingMode', 163 => 0x89, 226 => 0x1f },
	'shootingmodesetting' => { 201 => '5.1' },
	'shortdescription' => { 297 => 'shortdescription' },
	'shortdocumentid' => { 93 => 0xba },
	'shortfocal' => { 4 => 0xe4, 5 => 0xe, 6 => 0x11, 7 => 0x113, 8 => 0x11, 9 => [0x150,0x151], 10 => 0xd8, 12 => 0xf8, 13 => 0xec, 14 => 0x101, 15 => 0x93, 16 => 0xe8, 18 => 0xec, 19 => 0xea, 21 => 0xf0, 25 => 0x18 },
	'shortownername' => { 15 => 0xac },
	'shortreleasetimelag' => { 60 => 0x80d },
	'shotdate' => { 318 => 'shotDate' },
	'shotday' => { 318 => 'shotDay' },
	'shotlocation' => { 318 => 'shotLocation' },
	'shotname' => { 318 => 'shotName' },
	'shotnumber' => { 318 => 'shotNumber' },
	'shotsize' => { 318 => 'shotSize' },
	'shutter-aelock' => { 58 => 0x4, 60 => 0x701, 61 => 0x3, 62 => 0x4, 63 => 0x3, 64 => 0x3, 65 => 0x4, 66 => 0x2 },
	'shutteraelbutton' => { 59 => 0x4 },
	'shutterbuttonafonbutton' => { 60 => 0x701 },
	'shuttercount' => { 7 => 0x176, 39 => 0x1, 163 => 0xa7, 169 => [0x6a,0x157,0x24d], 170 => 0x286, 171 => 0x279, 172 => 0x284, 173 => 0x242, 174 => 0x280, 175 => 0x276, 176 => [0x27d,0x27f], 177 => 0x246, 178 => 0x2d6, 179 => 0x287, 180 => 0x320, 181 => 0x24a, 182 => 0x2d5, 250 => 0x5d },
	'shuttercurtainsync' => { 58 => 0xf, 59 => 0xf, 60 => 0x305, 61 => 0xe, 62 => 0xf, 63 => 0x8, 64 => 0x8, 65 => 0xf, 66 => 0x8 },
	'shuttermode' => { 100 => 0x1b },
	'shutterreleasebuttonae-l' => { 200 => '17.7', 202 => '16.1', 203 => '7.1', 204 => '17.5', 206 => '18.2' },
	'shutterreleasemethod' => { 73 => 0x1010 },
	'shutterreleasenocfcard' => { 58 => 0x2, 59 => 0x2, 66 => 0xf },
	'shutterreleasetiming' => { 73 => 0x1011 },
	'shutterspeedrange' => { 60 => 0x10c },
	'shutterspeedvalue' => { 69 => 0x1, 86 => 0x9201, 212 => 0x1000, 299 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 307 => 'SidecarForExtension' },
	'similarityindex' => { 93 => 0xe4 },
	'singleframebracketing' => { 135 => 0x21 },
	'slaveflashmeteringsegments' => { 250 => 0x20b },
	'slowshutter' => { 55 => 0x8 },
	'slowsync' => { 90 => 0x1030 },
	'smartrange' => { 271 => 0xa012 },
	'smoothness' => { 86 => 0xfe57, 295 => 'Smoothness' },
	'software' => { 86 => 0x131, 115 => 'Software', 218 => 'Software', 274 => 0x18, 314 => 'Software' },
	'softwareversion' => { 273 => 0x207 },
	'sonydatetime' => { 285 => 0x6 },
	'sonyimagesize' => { 135 => 0x3b, 276 => 0x54, 277 => 0x54 },
	'sonymodelid' => { 283 => 0xb001 },
	'sonyquality' => { 135 => 0x3c },
	'source' => { 93 => 0x73, 218 => 'Source', 296 => 'source', 297 => 'source', 307 => 'Source' },
	'sourcedirectoryindex' => { 240 => 0x0 },
	'sourcefileindex' => { 240 => 0x2 },
	'spatialfrequencyresponse' => { 299 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 299 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 299 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 299 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 299 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 318 => 'speakerPlacement' },
	'specialeffectlevel' => { 83 => 0x3030 },
	'specialeffectmode' => { 83 => 0x2076 },
	'specialeffectsetting' => { 83 => 0x3031 },
	'specialinstructions' => { 93 => 0x28 },
	'specialmode' => { 212 => 0x200, 273 => 0x200 },
	'spectralsensitivity' => { 86 => 0x8824, 299 => 'SpectralSensitivity' },
	'splittoningbalance' => { 295 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 295 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 295 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 295 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 295 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 132 => 0x2d },
	'spotfocuspointy' => { 132 => 0x2e },
	'spotmeteringmode' => { 25 => 0x27 },
	'spotmeterlinktoafpoint' => { 60 => 0x107 },
	'sractive' => { 234 => '17.1' },
	'srawquality' => { 25 => 0x2e },
	'srfocallength' => { 251 => 0x3 },
	'srhalfpresstime' => { 251 => 0x2 },
	'srresult' => { 251 => 0x0 },
	'standardoutputhighlightpoint' => { 79 => 0x14 },
	'standardoutputsensitivity' => { 86 => 0x8831 },
	'standardoutputshadowpoint' => { 79 => 0x15 },
	'standardrawcolortone' => { 79 => 0xd },
	'standardrawcontrast' => { 79 => 0xf },
	'standardrawhighlight' => { 79 => 0x75 },
	'standardrawhighlightpoint' => { 79 => 0x12 },
	'standardrawlinear' => { 79 => 0x10 },
	'standardrawsaturation' => { 79 => 0xe },
	'standardrawshadow' => { 79 => 0x7e },
	'standardrawshadowpoint' => { 79 => 0x13 },
	'standardrawsharpness' => { 79 => 0x11 },
	'startingpage' => { 309 => 'startingPage' },
	'startmovieshooting' => { 60 => 0x70d },
	'starttimecode' => { 318 => 'startTimecode' },
	'starttimecodetimeformat' => { 318 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 318 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 318 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 119 => 'State', 226 => 0x6b, 307 => 'State' },
	'status' => { 290 => 'Status' },
	'storagemethod' => { 138 => 0x12 },
	'straightenangle' => { 193 => 0x2fc08431 },
	'stretchmode' => { 318 => 'stretchMode' },
	'studydatetime' => { 288 => 'StudyDateTime' },
	'studydescription' => { 288 => 'StudyDescription' },
	'studyid' => { 288 => 'StudyID' },
	'studyphysician' => { 288 => 'StudyPhysician' },
	'sub-location' => { 93 => 0x5c },
	'subfiledata' => { 122 => 'data' },
	'subfiledirectory' => { 122 => '1Directory' },
	'subfilemimetype' => { 122 => '2MIME' },
	'subfilename' => { 122 => '1Name' },
	'subfileresource' => { 122 => 'rsrc' },
	'subfiletype' => { 86 => 0xfe, 122 => '0Type' },
	'subject' => { 216 => 'Subject', 261 => 'Subject', 296 => 'subject', 306 => 'Subject', 319 => 'subject' },
	'subjectarea' => { 86 => 0x9214, 299 => 'SubjectArea' },
	'subjectcode' => { 301 => 'SubjectCode' },
	'subjectdistance' => { 86 => 0x9206, 100 => 0x3e, 299 => 'SubjectDistance' },
	'subjectdistancerange' => { 86 => 0xa40c, 299 => 'SubjectDistanceRange' },
	'subjectlocation' => { 86 => 0xa214, 299 => 'SubjectLocation' },
	'subjectprogram' => { 132 => 0x22 },
	'subjectreference' => { 93 => 0xc },
	'subsectime' => { 86 => 0x9290 },
	'subsectimedigitized' => { 86 => 0x9292 },
	'subsectimeoriginal' => { 86 => 0x9291 },
	'subsection1' => { 309 => 'subsection1' },
	'subsection2' => { 309 => 'subsection2' },
	'subsection3' => { 309 => 'subsection3' },
	'subsection4' => { 309 => 'subsection4' },
	'superimposeddisplay' => { 58 => 0xa, 60 => 0x510, 61 => 0x9, 62 => 0xa, 65 => 0xa, 66 => 0xe },
	'supermacro' => { 44 => 0x1a },
	'supplementalcategories' => { 93 => 0x14, 307 => 'SupplementalCategories' },
	'supplementaltype' => { 95 => 0x37 },
	'svisosetting' => { 234 => 0x14 },
	'switchtoregisteredafpoint' => { 59 => 0x12, 60 => 0x50a },
	'tagged' => { 256 => 0xdd, 291 => 'tagged' },
	'tagslist' => { 298 => 'TagsList' },
	'takenumber' => { 318 => 'takeNumber' },
	'tapename' => { 318 => 'tapeName' },
	'targetaperture' => { 55 => 0x4 },
	'targetcompressionratio' => { 71 => 0x1 },
	'targetdistancesetting' => { 73 => 0x1807 },
	'targetexposuretime' => { 55 => 0x5 },
	'targetimagetype' => { 73 => 0x100a },
	'teaser' => { 309 => 'teaser' },
	'teleconverter' => { 136 => 0x105, 283 => 0x105 },
	'tempo' => { 318 => 'tempo' },
	'termsandconditionstext' => { 308 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 308 => 'TermsAndConditionsURL' },
	'textencoding' => { 162 => 0x4 },
	'textlayername' => { 307 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 307 => 'TextLayers' },
	'textlayertext' => { 307 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 226 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 86 => 0x107 },
	'thumbnailfilename' => { 73 => 0x817 },
	'thumbnailformat' => { 316 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 102 => 0xfa55, 316 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 73 => 0x2008, 84 => 'ThumbnailImage', 88 => 0x3, 125 => 'data', 212 => 0x100, 316 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 125 => '1Name' },
	'thumbnailimagesize' => { 125 => 'ImageSize' },
	'thumbnailimagetype' => { 125 => '0Type' },
	'thumbnailimagevalidarea' => { 44 => 0x13 },
	'thumbnaillength' => { 86 => 0x202 },
	'thumbnailoffset' => { 86 => 0x201 },
	'thumbnails' => { 316 => 'Thumbnails' },
	'thumbnailwidth' => { 102 => 0xfa54, 316 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 309 => 'ticker' },
	'tilelength' => { 86 => 0x143 },
	'tilewidth' => { 86 => 0x142 },
	'time' => { 98 => 0x401, 250 => 0x7 },
	'timecreated' => { 93 => 0x3c, 100 => 0x14, 109 => 0x10, 257 => 'TimeCreated' },
	'timeperiod' => { 309 => 'timePeriod' },
	'timerfunctionbutton' => { 201 => '5.2', 202 => '12.1' },
	'timerlength' => { 60 => 0x80c },
	'timescaleparams' => { 318 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 318 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 318 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 318 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 94 => 0x50 },
	'timesignature' => { 318 => 'timeSignature' },
	'timesincepoweron' => { 226 => 0x29 },
	'timestamp' => { 7 => 0x45e, 15 => 0x11c, 218 => 'TimeStamp' },
	'timestamp1' => { 7 => 0x45a },
	'timezone' => { 185 => 0x0 },
	'timezonecode' => { 76 => 0x1 },
	'timezoneinfo' => { 76 => 0x2 },
	'timezoneoffset' => { 86 => 0x882a },
	'tint' => { 295 => 'Tint' },
	'title' => { 115 => 'Title', 216 => 'Title', 218 => 'Title', 226 => 0x65, 261 => 'Title', 296 => 'title', 306 => 'Title', 316 => 'Title' },
	'tonecomp' => { 163 => 0x81 },
	'tonecurve' => { 53 => 0x1, 250 => 0x402, 295 => 'ToneCurve' },
	'tonecurve1' => { 271 => 0xa040 },
	'tonecurve2' => { 271 => 0xa041 },
	'tonecurve3' => { 271 => 0xa042 },
	'tonecurve4' => { 271 => 0xa043 },
	'tonecurveactive' => { 78 => 0x110 },
	'tonecurvebluex' => { 286 => 0x9003 },
	'tonecurvebluey' => { 286 => 0x9007 },
	'tonecurvebrightnessx' => { 286 => 0x9000 },
	'tonecurvebrightnessy' => { 286 => 0x9004 },
	'tonecurvefilename' => { 98 => 0x1391 },
	'tonecurvegreenx' => { 286 => 0x9002 },
	'tonecurvegreeny' => { 286 => 0x9006 },
	'tonecurveinterpolation' => { 78 => 0x159 },
	'tonecurvemode' => { 78 => 0x113 },
	'tonecurvename' => { 295 => 'ToneCurveName' },
	'tonecurveproperty' => { 78 => 0x3c },
	'tonecurveredx' => { 286 => 0x9001 },
	'tonecurveredy' => { 286 => 0x9005 },
	'tonecurves' => { 250 => 0x403 },
	'toningeffect' => { 39 => 0xf, 163 => 0xb3, 165 => 0x38 },
	'toningeffectfaithful' => { 49 => 0x74, 50 => 0x74 },
	'toningeffectlandscape' => { 49 => 0x44, 50 => 0x44 },
	'toningeffectmonochrome' => { 15 => 0x108, 49 => 0x8c, 50 => 0x8c },
	'toningeffectneutral' => { 49 => 0x5c, 50 => 0x5c },
	'toningeffectportrait' => { 49 => 0x2c, 50 => 0x2c },
	'toningeffectstandard' => { 49 => 0x14, 50 => 0x14 },
	'toningeffectunknown' => { 50 => 0xa4 },
	'toningeffectuserdef1' => { 49 => 0xa4, 50 => 0xbc },
	'toningeffectuserdef2' => { 49 => 0xbc, 50 => 0xd4 },
	'toningeffectuserdef3' => { 49 => 0xd4, 50 => 0xec },
	'toningsaturation' => { 165 => 0x39 },
	'totalzoom' => { 100 => 0x62 },
	'tracknumber' => { 318 => 'trackNumber' },
	'tracks' => { 318 => 'Tracks' },
	'tracksframerate' => { 318 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 318 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 318 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 318 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 318 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 318 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 318 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 318 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 318 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 318 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 318 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 318 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 318 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 318 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 318 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 318 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 318 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 122 => 'zmie' },
	'transferfunction' => { 86 => 0x12d, 314 => 'TransferFunction' },
	'transform' => { 226 => [0x8012,0x59] },
	'transmissionreference' => { 307 => 'TransmissionReference' },
	'trapped' => { 216 => 'Trapped', 306 => 'Trapped' },
	'travelday' => { 226 => 0x36 },
	'triggermode' => { 262 => 0x6 },
	'ttl_da_adown' => { 241 => 0x5 },
	'ttl_da_aup' => { 241 => 0x4 },
	'ttl_da_bdown' => { 241 => 0x7 },
	'ttl_da_bup' => { 241 => 0x6 },
	'tungstenawb' => { 231 => 0x1 },
	'tvexposuretimesetting' => { 234 => 0x12 },
	'type' => { 296 => 'type', 313 => 'type' },
	'uniquecameramodel' => { 86 => 0xc614 },
	'uniquedocumentid' => { 93 => 0xbb },
	'uniqueobjectname' => { 94 => 0x64 },
	'unknownblock' => { 211 => 0x1103 },
	'unknowncontrast' => { 79 => 0x45 },
	'unknownev' => { 98 => 0x1 },
	'unknownlinear' => { 79 => 0x46 },
	'unknownmode' => { 83 => 0x301b },
	'unknownnumber' => { 73 => 0x180b, 112 => [0xa8,0xc4] },
	'unknownoutputhighlightpoint' => { 79 => 0x4a },
	'unknownoutputshadowpoint' => { 79 => 0x4b },
	'unknownrawhighlight' => { 79 => 0x7b },
	'unknownrawhighlightpoint' => { 79 => 0x48 },
	'unknownrawshadow' => { 79 => 0x84 },
	'unknownrawshadowpoint' => { 79 => 0x49 },
	'unknownsharpness' => { 79 => 0x47 },
	'unsharp1color' => { 198 => 0x13 },
	'unsharp1halowidth' => { 198 => 0x19 },
	'unsharp1intensity' => { 198 => 0x17 },
	'unsharp1threshold' => { 198 => 0x1b },
	'unsharp2color' => { 198 => 0x2e },
	'unsharp2halowidth' => { 198 => 0x34 },
	'unsharp2intensity' => { 198 => 0x32 },
	'unsharp2threshold' => { 198 => 0x36 },
	'unsharp3color' => { 198 => 0x49 },
	'unsharp3halowidth' => { 198 => 0x4f },
	'unsharp3intensity' => { 198 => 0x4d },
	'unsharp3threshold' => { 198 => 0x51 },
	'unsharp4color' => { 198 => 0x64 },
	'unsharp4halowidth' => { 198 => 0x6a },
	'unsharp4intensity' => { 198 => 0x68 },
	'unsharp4threshold' => { 198 => 0x6c },
	'unsharpcount' => { 198 => 0x0 },
	'unsharpmask' => { 79 => 0x90, 193 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0x94 },
	'unsharpmaskstrength' => { 79 => 0x92 },
	'unsharpmaskthreshold' => { 79 => 0x96 },
	'urgency' => { 93 => 0xa, 307 => 'Urgency' },
	'url' => { 115 => 'URL', 218 => 'URL', 259 => 0x40b, 309 => 'url' },
	'usablemeteringmodes' => { 60 => 0x10a },
	'usableshootingmodes' => { 60 => 0x109 },
	'usage' => { 310 => 'usage' },
	'usagefee' => { 311 => 'usageFee' },
	'usageterms' => { 322 => 'UsageTerms' },
	'usercomment' => { 73 => 0x805, 86 => 0x9286, 299 => 'UserComment' },
	'userdef1picturestyle' => { 15 => 0x10c, 49 => 0xd8, 50 => 0xf0 },
	'userdef2picturestyle' => { 15 => 0x10e, 49 => 0xda, 50 => 0xf2 },
	'userdef3picturestyle' => { 15 => 0x110, 49 => 0xdc, 50 => 0xf4 },
	'userfields' => { 290 => 'UserFields' },
	'userlabel' => { 262 => 0x2b },
	'userprofile' => { 222 => 0x302, 227 => 0x3038 },
	'usmlenselectronicmf' => { 59 => 0x7, 60 => 0x501 },
	'utmeasting' => { 126 => 'Easting' },
	'utmmapdatum' => { 126 => 'Datum' },
	'utmnorthing' => { 126 => 'Northing' },
	'utmzone' => { 126 => 'Zone' },
	'uv-irfiltercorrection' => { 222 => 0x325 },
	'validbits' => { 211 => 0x611, 212 => 0x102c },
	'validpixeldepth' => { 215 => 0x611 },
	'variousmodes' => { 100 => 0x26 },
	'variousmodes2' => { 100 => 0x3a },
	'variprogram' => { 163 => 0xab },
	'version' => { 90 => 0x0, 261 => 'Version', 295 => 'Version' },
	'versioncreatedate' => { 286 => 0xd100 },
	'versionid' => { 319 => 'VersionID' },
	'versionidentifier' => { 309 => 'versionIdentifier' },
	'versionmodifydate' => { 286 => 0xd101 },
	'versions' => { 319 => 'Versions' },
	'versionscomments' => { 319 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 319 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 319 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 319 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 319 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 319 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 319 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 319 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 319 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 319 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 319 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 200 => '3.2' },
	'vfdisplayillumination' => { 60 => 0x510 },
	'vibrance' => { 295 => 'Vibrance' },
	'vibrationreduction' => { 169 => [0x75,0x82,0x1ae], 177 => '586.1', 181 => '590.2', 184 => 0x4 },
	'videoalphamode' => { 318 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 318 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 318 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 318 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 47 => 0x74 },
	'videocolorspace' => { 318 => 'videoColorSpace' },
	'videocompressor' => { 318 => 'videoCompressor' },
	'videofieldorder' => { 318 => 'videoFieldOrder' },
	'videoframerate' => { 318 => 'videoFrameRate' },
	'videoframesize' => { 318 => 'videoFrameSize' },
	'videoframesizeh' => { 318 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 318 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 318 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 318 => 'videoModDate' },
	'videopixelaspectratio' => { 318 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 318 => 'videoPixelDepth' },
	'videoquality' => { 83 => 0x4003 },
	'viewfinderdisplay' => { 200 => '12.4' },
	'viewfinderwarning' => { 200 => '13.4', 204 => '3.5', 205 => '6.2', 206 => '4.4' },
	'viewinfoduringexposure' => { 60 => 0x407 },
	'vignetteamount' => { 295 => 'VignetteAmount' },
	'vignettecontrol' => { 163 => 0x2a, 193 => 0x76a43205 },
	'vignettecontrolintensity' => { 193 => 0xac6bd5c0 },
	'vignettemidpoint' => { 295 => 'VignetteMidpoint' },
	'vignettingcorrection' => { 283 => 0x2011 },
	'voicememo' => { 273 => 0x216 },
	'volume' => { 309 => 'volume' },
	'vr_0x66' => { 169 => 0x66 },
	'vrdoffset' => { 44 => 0xd0 },
	'wb_bluepresetsfluorescent' => { 137 => 0x40a },
	'wb_gbrglevels' => { 137 => 0xae, 140 => 0x4 },
	'wb_glevel' => { 211 => 0x11f },
	'wb_glevel3000k' => { 211 => 0x113 },
	'wb_glevel3300k' => { 211 => 0x114 },
	'wb_glevel3600k' => { 211 => 0x115 },
	'wb_glevel3900k' => { 211 => 0x116 },
	'wb_glevel4000k' => { 211 => 0x117 },
	'wb_glevel4300k' => { 211 => 0x118 },
	'wb_glevel4500k' => { 211 => 0x119 },
	'wb_glevel4800k' => { 211 => 0x11a },
	'wb_glevel5300k' => { 211 => 0x11b },
	'wb_glevel6000k' => { 211 => 0x11c },
	'wb_glevel6600k' => { 211 => 0x11d },
	'wb_glevel7500k' => { 211 => 0x11e },
	'wb_grbglevels' => { 148 => 0x0 },
	'wb_rbgglevels' => { 145 => 0x0 },
	'wb_rblevels' => { 163 => 0xc, 211 => 0x100 },
	'wb_rblevels3000k' => { 211 => 0x102 },
	'wb_rblevels3300k' => { 211 => 0x103 },
	'wb_rblevels3600k' => { 211 => 0x104 },
	'wb_rblevels3900k' => { 211 => 0x105 },
	'wb_rblevels4000k' => { 211 => 0x106 },
	'wb_rblevels4300k' => { 211 => 0x107 },
	'wb_rblevels4500k' => { 211 => 0x108 },
	'wb_rblevels4800k' => { 211 => 0x109 },
	'wb_rblevels5300k' => { 211 => 0x10a },
	'wb_rblevels6000k' => { 211 => 0x10b },
	'wb_rblevels6600k' => { 211 => 0x10c },
	'wb_rblevels7500k' => { 211 => 0x10d },
	'wb_rblevelsauto' => { 215 => 0x110 },
	'wb_rblevelscloudy' => { 139 => 0x10, 215 => 0x121 },
	'wb_rblevelscoolwhitef' => { 139 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 215 => 0x132 },
	'wb_rblevelscwb1' => { 211 => 0x10e },
	'wb_rblevelscwb2' => { 211 => 0x10f },
	'wb_rblevelscwb3' => { 211 => 0x110 },
	'wb_rblevelscwb4' => { 211 => 0x111 },
	'wb_rblevelsdaylight' => { 139 => 0xc },
	'wb_rblevelsdaylightf' => { 139 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 215 => 0x130 },
	'wb_rblevelsdaywhitef' => { 139 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 215 => 0x131 },
	'wb_rblevelseveningsunlight' => { 215 => 0x124 },
	'wb_rblevelsfineweather' => { 215 => 0x122 },
	'wb_rblevelsflash' => { 139 => 0x18 },
	'wb_rblevelsshade' => { 139 => 0x20, 215 => 0x120 },
	'wb_rblevelstungsten' => { 139 => 0x8, 215 => 0x123 },
	'wb_rblevelsunknown' => { 139 => 0x1c },
	'wb_rblevelsused' => { 215 => 0x100 },
	'wb_rblevelswhitef' => { 139 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 215 => 0x133 },
	'wb_rbpresetcloudy' => { 137 => 0x3f0 },
	'wb_rbpresetcoolwhitef' => { 137 => 0x308 },
	'wb_rbpresetcustom' => { 137 => 0x424 },
	'wb_rbpresetdaylight' => { 137 => 0x3ec },
	'wb_rbpresetflash' => { 137 => [0x3f4,0x304] },
	'wb_rbpresetshade' => { 137 => 0x418 },
	'wb_rbpresettungsten' => { 137 => 0x3e8 },
	'wb_redpresetsfluorescent' => { 137 => 0x3fc },
	'wb_rgbglevels' => { 147 => 0x0 },
	'wb_rgblevels' => { 137 => 0x96, 223 => 0xd, 224 => 0x413, 227 => 0x3036 },
	'wb_rggblevels' => { 140 => 0x4, 146 => 0x0 },
	'wb_rggblevelsasshot' => { 28 => 0x0, 29 => 0x19, 30 => 0x22, 31 => 0x3f, 34 => 0x3f },
	'wb_rggblevelsauto' => { 26 => 0x0, 28 => 0x5, 29 => 0x1e, 30 => 0x18, 31 => 0x44, 34 => 0x44, 271 => 0xa022 },
	'wb_rggblevelsblack' => { 271 => 0xa028 },
	'wb_rggblevelscloudy' => { 26 => 0xc, 28 => 0x1e, 29 => 0x2d, 30 => 0x31, 31 => 0x58, 34 => 0x71, 250 => 0x20f },
	'wb_rggblevelscustom' => { 26 => 0x1c, 31 => 0x80 },
	'wb_rggblevelscustom1' => { 29 => 0x41 },
	'wb_rggblevelscustom2' => { 29 => 0x46 },
	'wb_rggblevelsdaylight' => { 26 => 0x4, 28 => 0x14, 29 => 0x23, 30 => 0x27, 31 => 0x4e, 34 => 0x67, 250 => 0x20d },
	'wb_rggblevelsflash' => { 26 => 0x18, 28 => 0x32, 29 => 0x3c, 30 => 0x45, 31 => 0x6c, 34 => 0x85, 250 => 0x214 },
	'wb_rggblevelsfluorescent' => { 26 => 0x14, 28 => 0x28, 29 => 0x37, 30 => 0x3b, 31 => 0x62, 34 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 250 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 250 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 250 => 0x213 },
	'wb_rggblevelsilluminator1' => { 271 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 271 => 0xa024 },
	'wb_rggblevelskelvin' => { 26 => 0x20, 28 => 0x2d, 30 => 0x40, 31 => 0x67, 34 => 0x80 },
	'wb_rggblevelsmeasured' => { 28 => 0xa, 31 => 0x49, 34 => 0x49 },
	'wb_rggblevelspc1' => { 30 => 0x90, 31 => 0x71 },
	'wb_rggblevelspc2' => { 30 => 0x95, 31 => 0x76 },
	'wb_rggblevelspc3' => { 30 => 0x9a, 31 => 0x7b },
	'wb_rggblevelsshade' => { 26 => 0x8, 28 => 0x19, 29 => 0x28, 30 => 0x2c, 31 => 0x53, 34 => 0x6c, 250 => 0x20e },
	'wb_rggblevelstungsten' => { 26 => 0x10, 28 => 0x23, 29 => 0x32, 30 => 0x36, 31 => 0x5d, 34 => 0x76, 250 => 0x210 },
	'wb_rggblevelsuncorrected' => { 271 => 0xa021 },
	'wb_rggblevelsunknown' => { 28 => 0xf, 30 => 0x1d, 34 => 0x4e },
	'wb_rggblevelsunknown10' => { 28 => 0x5f, 30 => 0x72, 34 => 0x9e },
	'wb_rggblevelsunknown11' => { 28 => 0x64, 30 => 0x77, 34 => 0xa3 },
	'wb_rggblevelsunknown12' => { 28 => 0x69, 30 => 0x7c, 34 => 0xa8 },
	'wb_rggblevelsunknown13' => { 28 => 0x6e, 30 => 0x81, 34 => 0xad },
	'wb_rggblevelsunknown14' => { 30 => 0x86, 34 => 0xb2 },
	'wb_rggblevelsunknown15' => { 30 => 0x8b, 34 => 0xb7 },
	'wb_rggblevelsunknown16' => { 30 => 0x9f },
	'wb_rggblevelsunknown2' => { 28 => 0x37, 30 => 0x4a, 34 => 0x53 },
	'wb_rggblevelsunknown3' => { 28 => 0x3c, 30 => 0x4f, 34 => 0x58 },
	'wb_rggblevelsunknown4' => { 28 => 0x41, 30 => 0x54, 34 => 0x5d },
	'wb_rggblevelsunknown5' => { 28 => 0x46, 30 => 0x59, 34 => 0x62 },
	'wb_rggblevelsunknown6' => { 28 => 0x4b, 30 => 0x5e, 34 => 0x8a },
	'wb_rggblevelsunknown7' => { 28 => 0x50, 30 => 0x63, 34 => 0x8f },
	'wb_rggblevelsunknown8' => { 28 => 0x55, 30 => 0x68, 34 => 0x94 },
	'wb_rggblevelsunknown9' => { 28 => 0x5a, 30 => 0x6d, 34 => 0x99 },
	'wbadjbluebalance' => { 199 => 0x8 },
	'wbadjcolortemp' => { 78 => 0x1a },
	'wbadjlighting' => { 199 => 0x15 },
	'wbadjlightingsubtype' => { 199 => 0x14 },
	'wbadjmode' => { 199 => 0x10 },
	'wbadjredbalance' => { 199 => 0x0 },
	'wbadjrggblevels' => { 78 => 0x6 },
	'wbadjtemperature' => { 199 => 0x18 },
	'wbadjtint' => { 199 => 0x25 },
	'wbadjustab' => { 226 => 0x46 },
	'wbadjustgm' => { 226 => 0x47 },
	'wbbluelevel' => { 222 => 0x324, 226 => 0x8006, 228 => 0x26 },
	'wbbracketmode' => { 39 => 0x9 },
	'wbbracketvalueab' => { 39 => 0xc },
	'wbbracketvaluegm' => { 39 => 0xd },
	'wbfinetuneactive' => { 78 => 0x24 },
	'wbfinetunesaturation' => { 78 => 0x28 },
	'wbfinetunetone' => { 78 => 0x2c },
	'wbgreenlevel' => { 222 => 0x323, 226 => 0x8005, 228 => 0x25 },
	'wbmediaimagesizesetting' => { 60 => 0x708 },
	'wbmode' => { 139 => 0x4, 212 => 0x1015 },
	'wbredlevel' => { 222 => 0x322, 226 => 0x8004, 228 => 0x24 },
	'wbscale' => { 140 => 0x0 },
	'wbshiftab' => { 53 => 0xc, 235 => 0x10 },
	'wbshiftgm' => { 53 => 0xd },
	'wbshiftmg' => { 235 => 0x11 },
	'webstatement' => { 322 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0x36, 7 => 0x5e, 8 => 0x36, 9 => [0x77,0x78], 10 => 0x6f, 11 => 0x6f, 12 => 0x73, 13 => 0x6f, 14 => 0x78, 15 => 0x54, 16 => 0x6f, 18 => 0x7b, 21 => 0x53, 53 => 0x8, 55 => 0x7, 82 => 0x7, 83 => [0x19,0x2012], 86 => [0xa403,0xfe4e], 90 => 0x1002, 98 => 0x3fc, 99 => 0xfa0d, 100 => 0x40, 132 => 0x3, 133 => 0xe, 134 => 0x4, 135 => 0xb, 136 => 0x115, 163 => 0x5, 183 => 0x7, 222 => 0x304, 226 => 0x3, 227 => 0x3033, 250 => 0x19, 255 => 0x7, 265 => 0x26, 274 => [0x3c,0x7,0x58], 283 => [0x115,0xb054], 295 => 'WhiteBalance', 299 => 'WhiteBalance' },
	'whitebalance2' => { 207 => 0x500 },
	'whitebalanceadj' => { 78 => 0x18, 193 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 231 => 0x0 },
	'whitebalancebias' => { 83 => 0x2011, 212 => 0x304, 226 => 0x23 },
	'whitebalanceblue' => { 53 => 0x7 },
	'whitebalancebracket' => { 207 => 0x502, 212 => 0x303 },
	'whitebalancebracketing' => { 135 => 0x22 },
	'whitebalancecomp' => { 215 => 0x1001 },
	'whitebalancefinetune' => { 90 => 0x100a, 135 => 0x38, 136 => 0x112, 163 => 0xb, 276 => 0x6, 283 => 0x112 },
	'whitebalancemode' => { 250 => 0x1a },
	'whitebalancered' => { 53 => 0x6 },
	'whitebalanceset' => { 234 => 0xa },
	'whitebalancesetting' => { 135 => 0x23 },
	'whitebalancetemperature' => { 207 => 0x501 },
	'whiteboard' => { 212 => 0x301 },
	'whitelevel' => { 86 => 0xc61d },
	'whitepoint' => { 86 => 0x13e, 250 => 0x201, 314 => 'WhitePoint' },
	'widefocuszone' => { 132 => 0x2f },
	'widerange' => { 273 => 0x20f },
	'wordcount' => { 309 => 'wordCount' },
	'workcolorspace' => { 78 => 0x270 },
	'worktodo' => { 300 => 'WorkToDo' },
	'worldtimelocation' => { 226 => 0x3a, 250 => 0x22, 254 => '0.1' },
	'writer-editor' => { 93 => 0x7a },
	'x3filllight' => { 274 => 0x12 },
	'xmp' => { 77 => 0xffff00f6, 87 => 'XMP' },
	'xmptoolkit' => { 315 => 'xmptk' },
	'xpauthor' => { 86 => 0x9c9d },
	'xpcomment' => { 86 => 0x9c9c },
	'xpkeywords' => { 86 => 0x9c9e },
	'xposition' => { 86 => 0x11e },
	'xpsubject' => { 86 => 0x9c9f },
	'xptitle' => { 86 => 0x9c9b },
	'xresolution' => { 86 => 0x11a, 96 => 0x3, 260 => 0x0, 314 => 'XResolution' },
	'xyresolution' => { 89 => 0x3 },
	'ycbcrcoefficients' => { 86 => 0x211, 314 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 86 => 0x213, 314 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 86 => 0x212, 314 => 'YCbCrSubSampling' },
	'yearcreated' => { 100 => 0x10, 109 => 0xc },
	'yposition' => { 86 => 0x11f },
	'yresolution' => { 86 => 0x11b, 96 => 0x5, 260 => 0x4, 314 => 'YResolution' },
	'zonematching' => { 136 => 0x10a, 139 => [0x3a,0x4a], 283 => 0xb024 },
	'zonematchingmode' => { 135 => 0x14 },
	'zonematchingon' => { 134 => 0x75 },
	'zonematchingvalue' => { 276 => 0x1f },
	'zoomedpreviewlength' => { 212 => 0xf05 },
	'zoomedpreviewsize' => { 212 => 0xf06 },
	'zoomedpreviewstart' => { 212 => 0xf04 },
	'zoomsourcewidth' => { 25 => 0x24 },
	'zoomstepcount' => { 210 => 0x300, 212 => 0x100d },
	'zoomtargetwidth' => { 25 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'35mmfocallength' => 1,
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'absract' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationiterations' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo5dmkii_2a' => 1,
	'camerainfo5dmkii_2b' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'camerainfoa55' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0104' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'framewidth' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'givenname' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'participants' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'readstatus' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyimageheight' => 1,
	'sonyimagewidth' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyrictext' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userlastplayedtime' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grblevels' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtra' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = $strName;
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2012, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
