# This -*- perl -*- script writes the Makefile for libwww-perl
# $Id: Makefile.PL,v 1.14 1995/10/04 11:05:47 aas Exp $

#--- Configuration section ---

@programs_to_install = qw(request);      # qw(request mirror);
@request_aliases     = qw(GET HEAD POST);

#--- End Configuration - You should not have to change anything below this line

require 5.001;

# Allow us to suppress of all program installation with the -l (library only)
# option.  This is for those that don't want to mess with this file.
use Getopt::Std;
$opt_l = undef;   # avoid -w typo waring
unless (getopts("l")) {
    die "Usage: $0 [-l]\n";
}
@programs_to_install = () if $opt_l;

# Find the perl executable
$PERL = find_perl(5.001, [ $^X, "perl", "perl5", "perl$]" ],
                         [split ":", $ENV{PATH}], 0);
$NAME = 'libwww-perl';
chomp ($VERSION = `$PERL VERSION`);

# Write findings to a file so that other .PL files can read them.
open(OUT, ">myConfig.out") or die "Can't open myConfig.out: $!";
print OUT <<"EOT";
# This file was generated by MakeFile.PL
\$PERL = "$PERL";
\$NAME = "$NAME";
\$VERSION = "$VERSION";
1;
EOT
close(OUT);

# Generate Makefile
use ExtUtils::MakeMaker;

sub initialize
{
    %hash = (
	NAME      => $NAME,
	VERSION   => $VERSION,
	SKIP      => [qw(static dynamic)],
	PL_FILES  => {
	    'bin/request.PL' => 'bin/request',
	    'bin/mirror.PL'  => 'bin/mirror',
	},
	'clean'   => {FILES => '$(EXE_FILES)'},
	'linkext' => {LINKTYPE => '' },
	'dist'    => {
            COMPRESS     => 'gzip -9f',
	    SUFFIX       => 'gz', 
            DIST_DEFAULT => 'all tardist'
        },
	'installpm' => {
	    SPLITLIB     => '',
	},
    );
    for (@programs_to_install) {
	push(@{ $hash{EXE_FILES} }, "bin/$_");
    }
    \%hash;
}


if ($ExtUtils::MakeMaker::Version >= 4.15) {
    # This is important only for the developer:
    $hash{'macro'} = {
        CONFIGDEP => '$(PERL_ARCHLIB)/Config.pm $(PERL_INC)/config.h VERSION'
    };
}

if ($ExtUtils::MakeMaker::Version < 4.17) {
    initialize();
} else {
    $hash{CONFIGURE} = \&initialize;
}

WriteMakefile(%hash);
exit;

sub MY::postamble {
    my @m;
    push @m, "
config ::
	@\$(PERL) VERSION > /dev/null

";
    if (@request_aliases && grep($_ eq 'request', @programs_to_install)) {
	push @m, "all ::\n";
	push @m, "\t\$(FULLPERL) -e 'use Config; foreach (qw(@request_aliases)) {' \\\n";
	push @m, <<'EOT';
	-e 'unlink "$(INST_EXE)/$$_";' \
	-e 'system("$$Config{\"lns\"} request $(INST_EXE)/$$_") && die; }'
EOT
    }
    join "", @m;
}

sub MY::test {
    q{
TEST_VERBOSE=0

test:
	$(FULLPERL) -I$(INST_LIB) t/TEST $(TEST_VERBOSE)

};
}

sub MY::libscan {
    return '' if m:/(RCS|CVS)/:;
    return '' if m/~$/;
    return '' if m/.pl$/;
    $_;
}


# Borrowed from MakeMaker
sub find_perl {
    my($ver, $names, $dirs, $trace) = @_;
    my($name, $dir);
    if ($trace >= 2){
	print "Looking for perl $ver by these names: ";
	print "@$names, ";
	print "in these dirs:";
	print "@$dirs";
    }
    foreach $dir (@$dirs){
	next unless defined $dir; # $att{PERL_SRC} may be undefined
	foreach $name (@$names){
	    my $abs;
	    if ($name =~ m|^/|) {
		$abs = $name;
	    } else {
		$abs = "$dir/$name";
	    }
	    print "Checking $abs " if ($trace >= 2);
	    next unless -x "$abs";
	    print "Executing $abs" if ($trace >= 2);
	    if (`$abs -e 'require $ver; print "VER_OK\n" ' 2>&1` =~ /VER_OK/) {
	        print "Using PERL=$abs" if $trace;
	        return $abs;
	    }

	}
    }
    die "Unable to find a perl $ver (by these names: @$names, in these dirs: @$dirs)\n";
}
