package Algorithm::Line::Lerp;
our $VERSION = '0.01';
use Exporter 'import';
our @EXPORT_OK = qw(line);
require XSLoader;
XSLoader::load( 'Algorithm::Line::Lerp', $VERSION );
1;
__END__
=head1 NAME

Algorithm::Line::Lerp - 2D grid line drawing via linear interpolation

=head1 SYNOPSIS

    use Algorithm::Line::Lerp 'line';

    my $points = line( [0,0], [2,11] );
    for my $p (@$points) { ...

=head1 DESCRIPTION

This module uses linear interpolation to return a list of points forming
a line between two points on a grid. See C<eg/bench> for a comparison of
a perl Bresenham, a perl lerp, and the B<line> function of this module.

Caveats include potential floating point portability problems and
"aesthetic issues" depending on how C<lround> behaves.

=head1 FUNCTION

Not exported by default.

=over 4

=item B<line> I<p1> I<p2>

Given two points (array references of x, y values) returns an array
reference of the points between the two points. This may simply be a
copy of point I<p1> (when I<p1> and I<p2> are equal) or a longer list
of points.

Magic is not supported.

=back

=head1 SEE ALSO

L<Algorithm::Line::Bresenham>

L<https://www.redblobgames.com/grids/line-drawing.html>

=head1 AUTHOR

Jeremy Mates, C<< <jmates@thrig.me> >>

=head1 COPYRIGHT AND LICENSE

Copyright 2023 Jeremy Mates

This program is distributed under the (Revised) BSD License:
L<https://opensource.org/licenses/BSD-3-Clause>

=cut
