CREATE TABLE func_import_update_hub_repo(
    uuid VARCHAR(40) NOT NULL,
    hub_uuid VARCHAR(40) NOT NULL,
    location VARCHAR
);


CREATE TRIGGER
    func_import_update_hub_repo_bi_1
BEFORE INSERT ON
    func_import_update_hub_repo
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.hub_uuid,
        NEW.location
    );

    -- TODO: hah - doesn't exist yet and obviously never tested!
    INSERT INTO
        func_update_hub_repo(
            change_id,
            id,
            hub_id,
            location
        )
    SELECT
        currval('changes'),
        hr.id,
        h.id,
        NEW.location
    FROM
        topics hr
    LEFT JOIN
        topics h
    ON
        h.uuid = NEW.hub_uuid
    WHERE
        hr.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
