CREATE TABLE func_merge_changes(
    merge INTEGER NOT NULL
);

CREATE TRIGGER
    func_merge_changes_bi_1
BEFORE INSERT ON
    func_merge_changes
FOR EACH ROW WHEN
    NEW.merge = 1
BEGIN

    UPDATE topics_tomerge                 SET resolve = 1;
    UPDATE entities_tomerge               SET resolve = 1;
    UPDATE entity_contact_methods_tomerge SET resolve = 1;
    UPDATE identities_tomerge             SET resolve = 1;
    UPDATE hubs_tomerge                   SET resolve = 1;
    UPDATE projects_tomerge               SET resolve = 1;
    UPDATE project_status_tomerge         SET resolve = 1;
    UPDATE task_status_tomerge            SET resolve = 1;
    UPDATE issue_status_tomerge           SET resolve = 1;
    UPDATE tasks_tomerge                  SET resolve = 1;
    UPDATE issues_tomerge                 SET resolve = 1;

    -- First of all the identities
    INSERT INTO
        hub_entities(
            hub_id,
            entity_id
        )
    SELECT DISTINCT
        ph.hub_id,
        c.identity_id
    -- Find related hubs of change_topics.topic_id
    FROM
        change_topics ct
    INNER JOIN
        topics_tree tt
    ON
        tt.child = ct.topic_id
    INNER JOIN
        project_hubs ph
    ON
        ph.project_id = tt.parent
    -- Match with identity of the change
    INNER JOIN
        changes c
    ON
        c.id = ct.change_id
    WHERE
        ct.hub_change > 0
    ;

    INSERT INTO
        project_entities(
            project_id,
            entity_id
        )
    SELECT DISTINCT
        tt.parent,
        c.identity_id
    FROM
        /*
            Find the first parent project of change_topics.topic_id,
            (identified only by its depth)
        */
        (SELECT
            ct.change_id,
            ct.topic_id,
            MIN(tt.depth) AS depth
        FROM
            change_topics ct
        INNER JOIN
            topics_tree tt
        ON
            tt.child = ct.topic_id
        INNER JOIN
            projects p
        ON
            p.id = tt.parent
        WHERE
            ct.project_change > 0
        GROUP BY
            ct.change_id,
            ct.topic_id
        ) x
    -- Now get the actual parent project id (x.parent)
    INNER JOIN
        topics_tree tt
    ON
        tt.child = x.topic_id AND tt.depth = x.depth
    -- Match with the identity of this change
    INNER JOIN
        changes c
    ON
        c.id = x.change_id
    ;


    -- TODO split this union up so we can check for duplicates? (no IGNORE)
    INSERT OR IGNORE INTO
        hub_changes(
            hub_id,
            prefix,
            change_id
        )
    -- Changes to hub/project/status topics, mapped to a hub
    SELECT DISTINCT
        ph.hub_id,
        SUBSTR(c.uuid, 1, 1),
        ct.change_id
    FROM
        change_topics ct
    INNER JOIN
        topics_tree tt
    ON
        tt.child = ct.topic_id
    INNER JOIN
        project_hubs ph
    ON
        ph.project_id = tt.parent
    INNER JOIN
        changes c
    ON
        c.id = ct.change_id
    WHERE
        ct.hub_change > 0
    -- And also changes to identities involved with hubs/projects
    UNION SELECT DISTINCT
        he.hub_id,
        SUBSTR(c.uuid, 1, 1),
        ct.change_id
    FROM
        change_topics ct
    INNER JOIN
        hub_entities he
    ON
        he.entity_id = ct.topic_id
    INNER JOIN
        changes c
    ON
        c.id = ct.change_id
    WHERE
        ct.hub_change > 0
    ;


    INSERT OR IGNORE INTO
        project_changes(
            project_id,
            prefix,
            change_id
        )
    -- Changes to task/issue topics, mapped to a project
    SELECT DISTINCT
        tt.parent,
        SUBSTR(c.uuid, 1, 1),
        x.change_id
    FROM
        (SELECT
            ct.change_id,
            ct.topic_id,
            MIN(tt.depth) AS depth
        FROM
            change_topics ct
        INNER JOIN
            topics_tree tt
        ON
            tt.child = ct.topic_id
        INNER JOIN
            projects p
        ON
            p.id = tt.parent
        WHERE
            ct.project_change > 0
        GROUP BY
            ct.change_id,
            ct.topic_id
        ) x
    -- Now get the actual parent project id (x.parent)
    INNER JOIN
        topics_tree tt
    ON
        tt.child = x.topic_id AND tt.depth = x.depth
    -- Match with the identity of this change
    INNER JOIN
        changes c
    ON
        c.id = x.change_id
    -- And also changes to identities involved with projects/projects
    UNION SELECT DISTINCT
        pe.project_id,
        SUBSTR(c.uuid, 1, 1),
        ct.change_id
    FROM
        change_topics ct
    INNER JOIN
        project_entities pe
    ON
        pe.entity_id = ct.topic_id
    INNER JOIN
        changes c
    ON
        c.id = ct.change_id
    WHERE
        ct.project_change > 0
    ;

    -- TODO Keep this around, and use it for when projects pushed to a hub?
--    DELETE FROM change_topics;

    SELECT RAISE(IGNORE);

END;
