CREATE TABLE func_new_issue(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    src_id INTEGER,
    issue_status_id INTEGER NOT NULL,
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40)
);

CREATE TRIGGER
    func_new_issue_bi_1
BEFORE INSERT ON
    func_new_issue
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.src_id,
        NEW.issue_status_id,
        NEW.title,
        NEW.uuid
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_issue' || x'0A'
                || '  issue_status_uuid: ' || s.uuid || x'0A'
                || '  src_uuid: ' || COALESCE(src.uuid,'~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
            FROM
                topics s
            LEFT JOIN
                topics src
            ON
                src.id = NEW.src_id
            WHERE
                s.id = NEW.issue_status_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_topic(
        id,
        parent_id,
        change_id,
        name,
        kind,
        uuid
    )
    SELECT
        NEW.id,
        ist.project_id,
        NEW.change_id,
        NEW.id,
        'issue',
        NEW.uuid
    FROM
        issue_status ist
    WHERE
        ist.id = NEW.issue_status_id
    ;
 

    INSERT INTO issues(
        id,
        src_id,
        project_id,
        issue_status_id,
        title
    )
    SELECT
        NEW.id,
        NEW.src_id,
        ist.project_id,
        NEW.issue_status_id,
        NEW.title
    FROM
        issue_status ist
    WHERE
        ist.id = NEW.issue_status_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_issue'
    );

    INSERT INTO
        topic_deltas(
            id,
            change_id,
            topic_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id
    );

    INSERT INTO
        issue_deltas(
            id,
            change_id,
            new,
            issue_id,
            issue_status_id,
            title
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        1,
        NEW.id,
        NEW.issue_status_id,
        NEW.title
    );

    SELECT RAISE(IGNORE);
END;
