package App::bif::update::project;
use strict;
use warnings;
use Bif::Mo;
use DBIx::ThinSQL qw/sq qv/;
use IO::Prompt::Tiny qw/prompt/;

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;

    $dbw->txn(
        sub {
            $self->pause_work;
            my $start = time;

            my $info =
              $self->get_project( $opts->{id} ? $opts->{id} : $opts->{path} );

            my ( $status_ids, $invalid );
            if ( $opts->{status} ) {

                ( $status_ids, $invalid ) =
                  $dbw->status_ids( $info->{id}, 'project', $opts->{status} );

                return $self->err( 'InvalidStatus',
                    'unknown status(s): ' . join( ', ', @$invalid ) )
                  if @$invalid;
            }

            if ( $opts->{reply} ) {
                my $uinfo =
                  $self->get_change( $opts->{reply}, $info->{first_change_id} );
                $opts->{parent_uid} = $uinfo->{id};
            }
            else {
                $opts->{parent_uid} = $info->{first_change_id};
            }

            $opts->{message} ||=
              $self->prompt_edit( opts => $self, id => $info->{id} );

            $opts->{change_id} =
              $self->new_change( parent_id => $opts->{parent_uid}, );

            $dbw->xdo(
                insert_into => 'func_update_project',
                values      => {
                    id                => $info->{id},
                    change_id         => $opts->{change_id},
                    title             => $opts->{title},
                    project_status_id => $status_ids->[0],
                }
            );

            $self->save_new_work(
                change_id => $opts->{change_id},
                node_id   => $info->{id},
                start     => $start,
                stop      => time,
                bill      => 1,
            );

            $self->end_change(
                id               => $opts->{change_id},
                action_format    => "update project $info->{path} (%s)",
                action_node_id_1 => $info->{id},
                message          => $opts->{message},
            );

            $self->resume_work;
        }
    );

    return $self->ok('ChangeProject');
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-update-project - update a project

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif update project ID [STATUS] [OPTIONS...]

=head1 DESCRIPTION

Add a comment to a project, possibly setting a new status at the same
time. Valid values for a project's status depend on the project it is
associated with. The list of valid status for a project can be found
using L<bif-list-status>(1).

=head1 ARGUMENTS

=over

=item PATH

A project PATH. Required.

=item STATUS

The new status for the node.

=back

=head1 OPTIONS

=over

=item --title, -t

The new title for the node.

=item --message, -m

The message describing this issue in detail. If this option is not used
an editor will be invoked.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

