CREATE TABLE func_import_new_hub(
    location VARCHAR NOT NULL,
    bill BOOL NOT NULL,
    uuid VARCHAR NOT NULL
);

CREATE TRIGGER
    func_import_new_hub_bi_1
BEFORE INSERT ON
    func_import_new_hub
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.location,
        NEW.bill,
        NEW.uuid
    );

    INSERT INTO
        func_new_hub(
            change_id,
            id,
            location,
            bill,
            uuid
        )
    SELECT
        currval('changes'),
        h.id,
        NEW.location,
        NEW.bill,
        NEW.uuid
    FROM
        nodes h
    WHERE
        h.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
