CREATE TABLE func_import_update_entity_contact_method(
    uuid VARCHAR(40) NOT NULL,
    method VARCHAR,
    mvalue VARCHAR
);


CREATE TRIGGER
    func_import_update_entity_contact_method_bi_1
BEFORE INSERT ON
    func_import_update_entity_contact_method
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.method,
        NEW.mvalue
    );

    INSERT INTO
        func_update_entity_contact_method(
            change_id,
            entity_contact_method_id,
            method,
            mvalue
        )
    SELECT
        c.uuid,
        n.id,
        NEW.method,
        NEW.mvalue
    FROM
        nodes n
    INNER JOIN
        changes c
    ON
        c.uuid = NEW.change_uuid
    WHERE
        n.uuid = NEW.entity_contact_method_uuid
    ;

    SELECT RAISE(IGNORE);
END;
