CREATE TABLE host_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    host_id INTEGER NOT NULL,
    name VARCHAR,
    new INTEGER,
    FOREIGN KEY(id) REFERENCES deltas(id),
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(host_id) REFERENCES hosts(id) ON DELETE CASCADE
);

CREATE TRIGGER
    host_deltas_ai_1
AFTER INSERT ON
    host_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.host_id,
        NEW.name
    );

    UPDATE
        changes
    SET
        ucount = ucount + 1
    WHERE
        id = NEW.change_id
    ;


END;
