use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/drop change /) },  'OptArgs::Usage';
    isa_ok exception { bif(qw/drop change 1/) }, 'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/drop change c999/) },
      'Bif::Error::ChangeNotFound';

    isa_ok bif(qw/drop change c1/), 'Bif::OK::DropNoForce';

    my $changes = 1;    # init, which is actually new-identity
    bif( qw/update identity 1 -m /, 'm' . $changes++ );

    my $h = bif( qw/new hub h.bifhub title -m /, 'm' . $changes++ );
    bif( qw/update hub/, $h->{id}, '-m', 'm' . $changes++ );

    my $p = bif( qw/new project p title -m /, 'm' . $changes++ );
    bif( qw/update project/, $p->{id}, '-m', 'm' . $changes++ );

    my $i = bif( qw/new issue i title -m /, 'm' . $changes++ );
    bif( qw/update /, $i->{id}, '-m', 'm' . $changes++ );

    my $t = bif( qw/new task t title -m /, 'm' . $changes++ );
    bif( qw/update /, $t->{id}, '-m', 'm' . $changes++ );

    while ( $changes > 0 ) {
        isa_ok bif( qw/drop change --force/, 'c' . $changes-- ),
          'Bif::OK::DropChange';
    }

    bifcheck;
};

done_testing();
