use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/drop topic /) },  'OptArgs::Usage';
    isa_ok exception { bif(qw/drop topic 1/) }, 'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/drop topic 101/) }, 'Bif::Error::TopicNotFound';

    bif(qw/new project todo title -m m1/);
    my $t = bif(qw/new task title -p todo -m m2/);

    isa_ok bif( qw/drop topic/,         $t->{id} ), 'Bif::OK::DropNoForce';
    isa_ok bif( qw/drop topic --force/, $t->{id} ), 'Bif::OK::DropTask';

    bifcheck;
};

done_testing();
