use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Statistics::ANOVA',
    license             => 'perl',
    dist_author         => 'Roderick Garton <rgarton@cpan.org>',
    dist_version_from   => 'lib/Statistics/ANOVA.pm',
    build_requires => {
        'Test::More' => 0,
        'Statistics::TTest' => 1.1,
        'Statistics::DependantTTest' => 0.03,
        'Algorithm::Combinatorics' => 0.23,
        'Statistics::Distributions' => 1.02,
        'Statistics::Descriptive' => 2.6,
        'Math::Cephes' => 0.43,
        'Scalar::Util' => 1.18,
    },
    add_to_cleanup      => [ 'Statistics-ANOVA-0.062-*' ],
);

$builder->create_build_script();
