; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.

(require (in-vicinity (program-vicinity) "sys"))

;;; DEBUG AND TEST CODE

(define (create-bt seg typ wcb)
  (let* ((a-han (make-han))
	 (ans (bt-create seg typ a-han wcb)))
    (if (err? ans) ans a-han)))

(define (open-bt seg blknum wcb)
  (let* ((a-han (make-han))
	 (ans (bt-open seg blknum a-han wcb)))
    (if (err? ans) ans a-han)))

(define (close-bt! han)
  (bt-close han))

;;; rem! removes key-str and value.  returns #t if found, #f if not.
(define (bt:rem! han key-str)
  (bt-rem han key-str (string-length key-str) #f))

(define (bt:rem* han key-str key2-str)
  (define tmpstr (make-string 256))
  (substring-move! key-str 0 (string-length key-str) tmpstr 0)
  (bt-rem-range han tmpstr (if (zero? (string-length key-str))
			       START-OF-CHAIN (string-length key-str))
		key2-str (if (zero? (string-length key2-str))
			     END-OF-CHAIN (string-length key2-str))))

;;; rem removes key-str and value.  returns value.
(define (bt:rem han key-str)
  (let* ((tmp-str (make-string 256))
	 (tlen (bt-rem han key-str (string-length key-str) tmp-str)))
    (if (err? tlen) #f (substring tmp-str 0 tlen))))

;;; put adds an key-str value pair to the database whose root is blk
(define (bt:put! han key-str val-str)
  (bt-put han key-str (string-length key-str) val-str (string-length val-str)))

;;; get returns a string of the value or #f
(define (bt:get han key)
  (let* ((tmp-str (make-string 256))
	 (tlen (bt-get han key (string-length key) tmp-str)))
    (if (err? tlen) #f (substring tmp-str 0 tlen))))

;;; next returns a string of the next key-str or #f if at end.
;;; (bt:next blk #f) or (bt:next blk "") returns the first key-str.
;;; to make BLINK happy I'm passing length 0 instead of START-OF-CHAIN

(define (bt:next han key-str)
  (let* ((tmp-str (make-string 256))
	 (tlen
	  (if (and key-str (> (string-length key-str) 0) )
	      (bt-next han key-str (string-length key-str) tmp-str)
	      (bt-next han "" START-OF-CHAIN tmp-str))))
    (if (err? tlen) #f (substring tmp-str 0 tlen))))

;;; prev returns a string of the previous key-str or #f if at end.
;;; (bt:prev blk #f) or (bt:prev blk "") returns the last key-str.

(define (bt:prev han key-str)
  (let* ((tmp-str (make-string 256))
	 (tlen
	  (if (and key-str (> (string-length key-str) 0))
	      (bt-prev han key-str (string-length key-str) tmp-str)
	      (bt-prev han "" END-OF-CHAIN tmp-str))))
    (if (err? tlen) #f (substring tmp-str 0 tlen))))

(define (create-db seg typ namestr)
  (let* ((tmp-str (make-string 256))
	 (a-han (create-bt seg typ 0))
	 (d-han (open-bt seg 1 (+ WCB-SAP WCB-SAR))))
    (if (or (err? a-han) (err? d-han)) #f
 	(begin
	  (long2str! tmp-str 1 (HAN-ID a-han))
	  (string-set! tmp-str 0 (integer->char 4))
	  (bt-put d-han namestr (string-length namestr) tmp-str 5)
	  (close-bt! d-han)
	  a-han))))

(define (open-db seg namestr)
  (let* ((tmp-str (make-string 256))
	 (d-han (open-bt seg 1 (+ WCB-SAP WCB-SAR))))
    (if (err? d-han) #f
	(let* ((tlen (bt-get d-han namestr (string-length namestr) tmp-str)))
	  (close-bt! d-han)
	  (if (err? tlen) #f
	      (if (eqv? tlen 5)
		  (open-bt seg (str2long tmp-str 1) 0)
		  #f))))))

(define (bt:scan bthan op key1 key2 scmproc blklim)
  (let ((ikey (make-string 256))
	(respkt (make-vector pkt-size))
	(proc
	 (and scmproc
	      (lambda (key klen val vlen extra)
		(let ((res (scmproc (substring key 0 klen) (substring val 0 vlen))))
		  (cond ((number? res) res)
			((not res) NOTPRES)
			((boolean? res) SUCCESS)
			((not (string? res)) TYPERR)
			((substring-move! res 0 (string-length res) val 0)
			 (string-length res))))))))
    (set-skey-count! respkt 0)
    (set-skey-len! respkt (string-length key1))
    (substring-move! key1 0 (string-length key1) ikey 0)
    (let ((res (bt-scan bthan op ikey (skey-len respkt)
			key2 (string-length key2) proc #f respkt blklim)))
      (list res (skey-count respkt) (substring ikey 0 (skey-len respkt))))))
