/* WB-tree File Based Associative String Data Base System.
   Copyright (c) 1991, 1992, 1993 Holland Mark Martin

Permission to use, copy, modify, and distribute this software and its
documentation for educational, research, and non-profit purposes and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of Holland Mark Martin not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior consent in each case.  Permission to incorporate this
software into commercial products can be obtained from Jonathan
Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
01803-4467, USA.  Holland Mark Martin makes no representations about
the suitability or correctness of this software for any purpose.  It
is provided "as is" without express or implied warranty.  Holland Mark
Martin is under no obligation to provide any services, by way of
maintenance, update, or otherwise. */

#include "sys.h"
#include "defs.h"

/* this is where all diagnostic and error messages will appear */
FILE *diagout;

#ifndef STDC_INCLUDES
unsigned char *memcpy(dest, src, len)
     unsigned char *dest, *src;
     int len;
{
  while(len--) dest[len]=src[len];
  return src;
}
#define LACK_MEMMOVE
#endif
#ifdef GNUDOS
#define LACK_MEMMOVE
#endif
#ifdef LACK_MEMMOVE
unsigned char *memmove(dest, src, len)
     unsigned char *dest, *src;
     int len;
{
  if (dest >= src)
    while(len--) dest[len]=src[len];
  else
    {
      int i=0;
      while(i<len)
	{
	  dest[i]=src[i];
	  i++;
	}
    }
  return src;
}
#endif

LCK *last_lck=0;

LCK *make_lck(name)
     int name;
{
  LCK *l = (LCK *)malloc(sizeof (LCK));
  if (!l) {
    fprintf(diagout, ">>>>ERROR<<<< could not allocate lck\n");
    exit(errno);
  }
  l->NEXT = last_lck;
  l->FLG = 0;
  l->NAME = name;
  last_lck=l;
  return l;
}

/* #define try_lck(lk) (!((lk)->FLG--)) */
int try_lck(lk)
     LCK *lk;
{
  return !(lk->FLG--);
}

/* #define lck(lk) {if((lk)->FLG--)fprintf(diagout,">>>>ERROR<<<< spinning on lck %d\n,(lk)->NAME");} */
void lck(lk)
     LCK *lk;
{
  if (lk->FLG--) fprintf(diagout,">>>>ERROR<<<< spinning on lck %d\n",(lk)->NAME);
}

/* #define unlck(lk) {if((lk)->FLG)(lk)->FLG=0;else fprintf(diagout,"unlcking unlck %d\n",(lk)->NAME);} */
void unlck(lk)
     LCK *lk;
{
  if (lk->FLG) lk->FLG=0;
  else fprintf(diagout,">>>>ERROR<<<< unlcking unlck %d\n",lk->NAME);
}

void check_lcks()
{
  LCK *ll = last_lck;
  while(ll) {
    if (ll->FLG) {
      if (ll->NAME < 0)
	switch (ll->NAME) {
	  case -1:fprintf(diagout,">>>>ERROR<<<< free-ent-lck left lcked\n");
	  case -2:fprintf(diagout,">>>>ERROR<<<< flush-buk-lck left lcked\n");
	  default:fprintf(diagout,">>>>ERROR<<<< unknown lck left lcked\n");
	}
      else fprintf(diagout,">>>>ERROR<<<< lck %d left lcked\n", ll->NAME);
      ll->FLG = 0;
    }
    ll = ll->NEXT;
  }
}

SEGD segd_tab[num_segs]
  = {{0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0},
       {0,0,0,0,{0,0,0},{0,0,0},{0,0,0},{0,0,0},0,0}};

ENTRY *make_ent(tag)
     int tag;
{
  ENTRY *ent = (ENTRY *)malloc(sizeof (ENTRY));
  if (!ent) {
    fprintf(diagout, "WARNING: could not allocate entry\n");
    return 0;
  }
  ent->TAG = tag;
  ent->NEXT = 0;
  ent->SEG = -1;
  ent->ID = -1;
  ent->BLK = (unsigned char *)malloc(blk_size);
  if (!ent->BLK) {
    fprintf(diagout, "WARNING: could not allocate blk for entry\n");
    free(ent);
    return 0;
  }
  ent->AGE = 0;
  ent->DTY = 0;
  ent->PUS = 0;
  ent->ACC = 0;
  ent->REF = 0;
  return ent;
}

HAND *make_han()
{
  HAND *han;
  han = (HAND *)calloc(1,sizeof(HAND));
  if (!han) {
    fprintf(diagout, ">>>>ERROR<<<< could not allocate handle\n");
    exit(errno);
  }
/*
  han_set_num(han, 0);
  han_set_seg(han, 0);
  han_set_typ(han, 0);
  han_set_last(han, 0);
*/
  return han;
}
