/* WB-tree File Based Associative String Data Base System.
   Copyright (c) 1991, 1992, 1993 Holland Mark Martin

Permission to use, copy, modify, and distribute this software and its
documentation for educational, research, and non-profit purposes and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of Holland Mark Martin not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior consent in each case.  Permission to incorporate this
software into commercial products can be obtained from Jonathan
Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
01803-4467, USA.  Holland Mark Martin makes no representations about
the suitability or correctness of this software for any purpose.  It
is provided "as is" without express or implied warranty.  Holland Mark
Martin is under no obligation to provide any services, by way of
maintenance, update, or otherwise. */

#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include <time.h>

#define BLOCK_SIZE 2048		/* Maximum supported block size */
#define BLKSIZST 44		/* Location of Block Size in Block 0 - BAD HACK */
int block_size = 2048;

FILE *stream;
unsigned long blk_num,cont_ptr,tree_head;
int size,level,typ;
char directory;

void dspl_char(ch)
int ch;
{
 if ((ch >= ' ') && (ch <= '~')) putchar(ch);
  else printf("'%d'",ch);
}


long convert_bytes_to_long(bytes,size)
unsigned char *bytes;
int size;
{
 long value = 0;
 while (size-- > 0) value = (value * 256) + *bytes++;
 return(value);
}

unsigned char buffer[BLOCK_SIZE],command_line[1000],*input_ptr,*input_end;

int input_read(buff,size)
unsigned char *buff;
int size;
{
 unsigned char *input_ptr,*input_end,ch;
 printf("\n?");
 fflush(stdout);
 input_ptr = buff;
 input_end = buff + size;
 while ( (ch=getchar()) != 13 && (ch != 10))
    {
     if ((ch >= ' ') && (ch <= '~') )
       {
	if (input_ptr < input_end)
	    {
	     *input_ptr++ = ch;
	     putchar(ch);
	    }
	 else putchar(7);
       }
      else if ( (ch == '\b') &&
	      (input_ptr > buff) )
	   {
	    input_ptr--;
	    putchar('\b');
	    putchar(' ');
	    putchar('\b');
	   }
     else if (ch == 17) /* ^Q */
	   putchar(*input_ptr++ = getchar());
     }
 *input_ptr = 0;
 return(input_ptr - buff);
}

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

void display_block(blk)
long blk;
{
 long i;
 unsigned char *ptr1,*ptr2,*ptr3,namebuf[256],namebuf1[256];
 int namelen,namelen1;
 fseek(stream,blk * block_size,SEEK_SET);
 i = fread(buffer,sizeof(char),block_size,stream);
 if (i != block_size)
   {
    printf("\nERROR READING BLOCK %ld",blk);
    return;
   }
 blk_num = convert_bytes_to_long(&buffer[blk_id_pos],4);
 cont_ptr = convert_bytes_to_long(&buffer[blk_nxt_id_pos],4);
 tree_head = convert_bytes_to_long(&buffer[blk_top_id_pos],4);
 size = convert_bytes_to_long(&buffer[blk_end_pos],2) - blk_data_start;
 level = buffer[blk_level_pos] - '0';
 typ = blk_typ(buffer);
 if (typ == 'D') directory = 'Y';
  else directory = 'N';
 if (blk != blk_num)
  printf("BLOCK HEAD MISMATCH BLK: %ld != BLK_HEAD: %ld",blk,blk_num);
 ptr1 = &buffer[blk_data_start];
 ptr2 = ptr1 + size;
 if (typ == seq_typ)
    {
     int j;
     printf("\nSEQ BLOCK: %ld   LEVEL: %d  HEAD: %ld  CONT: %ld DIR: %c  SIZE: %d",
        blk_num,level,tree_head,cont_ptr,directory,size);
    {
     long i = convert_bytes_to_long(&buffer[blk_time_pos],4);
     printf("\nLAST WRITTEN: %s",ctime(&i));
    }
     while (ptr1 < ptr2)
       {
	unsigned char *ptr3 = ptr1 + *ptr1 + 1;
        j = *ptr1;
	if (j > (ptr2 - ptr1)) j = ptr2 - ptr1;
        printf("\n");
        ptr1++;
	while (j > 0) { dspl_char(*ptr1++); j--; }
	ptr1 = ptr3;
       }
     }
 else
   {
    int beg = 1;
    printf("\nBLOCK: %ld   LEVEL: %d  HEAD: %ld  CONT: %ld DIR: %c  SIZE: %d TYPE: %c",
    blk_num,level,tree_head,cont_ptr,directory,size,(char) typ);
    {
     long i = convert_bytes_to_long(&buffer[blk_time_pos],4);
     printf("\nLAST WRITTEN: %s",ctime(&i));
    }
    namelen = 0;
    namelen1 = 0;
    while (ptr1 < ptr2)
      {
       namelen = *ptr1++;
       i = *ptr1++;
       ptr3 = ptr1 + i;
       ptr3 += *ptr3 + 1;
       if (ptr3 >= ptr2) printf("\nLINK POINTER TO %ld",cont_ptr);
       while (i-- > 0) namebuf[namelen++] = *ptr1++;
       printf("\n");
       i = 0;
       while (i < namelen) dspl_char(namebuf[i++]);
       i = 0;
       while (  (i < namelen) && (i < namelen1)
	      && (namebuf[i] == namebuf1[i]) ) i++;
       if ( !beg &&
	      ( ( (i < namelen) && (i < namelen1)
	      && (namebuf[i] < namebuf1[i]) )
	    || (i == namelen) )  )
	    printf("\nCOLLATION SEQUENCE ERROR");
       namelen1 = 0;
       beg = 0;
       while (namelen1 < namelen)
	   {
	    namebuf1[namelen1] = namebuf[namelen1];
	    namelen1++;
	   }
       if (ptr3 >= ptr2) ;
	else {
	      printf("\n --> ");
	      i = *ptr1++;
	      if ( (i == 4) && ((*ptr1 < ' ') || (level > 0)))
		  {
		   printf("%ld",convert_bytes_to_long(ptr1,4));
		   ptr1 += 4;
		  }
	       else while (i-- > 0) dspl_char(*ptr1++);
	     }
       }
   }
  if (ptr1 != ptr2) printf("\nBLOCK SIZE ERROR");
}



int main( argc, argv )
int argc;
char *argv[];
{
 long i;
 int j,k;
 if ((stream = fopen(argv[1],"rb")) == NULL)
           {
            printf("\nUNABLE TO OPEN %s",argv[1]);
            return;
           }
 i = fread(buffer,sizeof(char),BLKSIZST+2,stream);
 if (i != BLKSIZST+2)
   {
    printf("\nERROR READING BLOCK 0");
    return;
   }
 block_size = buffer[44]*256 + buffer[45];
 printf("\nSUPERBLOCK (size = %d)", block_size);
 display_block(0L);
 while ( ( k = input_read(command_line,900) ))
    {
     j = 0;
     if (strcmp(command_line,"L") == 0)
        {
	 if (cont_ptr) display_block(cont_ptr);
        }
      else if (strcmp(command_line,"R") == 0) display_block(blk_num);
      else if (strcmp(command_line,"H") == 0) display_block(tree_head);
      else {
            while ( (j < k) && isdigit(command_line[j])) j++;
	    if (j == k)
	      {
	       i = 0;
	       j = 0;
	       while (j < k) i = (i * 10) + command_line[j++] - '0';
	       display_block(i);
	      }
            }
    }
 fclose(stream);
 return 0;
}

