#ifndef X__INCLUDED
#define X__INCLUDED

/*
 * $Header: /home/campbell/Languages/Scheme/scm/x-scm/RCS/x.h,v 1.3 1992/08/12 04:23:07 campbell Beta $
 *
 * Author: Larry Campbell (campbell@redsox.bsw.com)
 *
 * Copyright 1992 by The Boston Software Works, Inc.
 * Permission to use for any purpose whatsoever granted, as long
 * as this copyright notice remains intact.  Please send bug fixes
 * or enhancements to the above email address.
 *
 * Xlib interface for scm - common definitions
 */

extern SCM mark_no_further();
extern sizet x_free_xevent();		/* free it if we own it */

/*
 * Non-ANSI C compilers (shame on vendors still shipping them!)
 * have no token-pasting operator.  Here's a substitute that
 * works for most compilers.
 */

#ifdef __STDC__
# define TOKEN_PASTE(a,b) a##b
#else
# define TOKEN_PASTE(a,b) TOKEN_PASTE_(a)b
# define TOKEN_PASTE_(a) a
#endif

#define X_SMOBS						\
XX(xcolormap,	mark_no_further,	free0)		\
XX(xdisplay,	mark_no_further,	free0)	 	\
XX(xevent,	mark_no_further,	x_free_xevent)	\
XX(xgc,		mark_no_further,	free0)		\
XX(xpixmap,	mark_no_further,	free0)		\
XX(xwindow,	mark_no_further,	free0)

#define XX(name, mark, free) extern long TOKEN_PASTE(tc16_,name);
X_SMOBS

#define XCOLORMAPP(x) (TYP16(x) == tc16_xcolormap)
#define XCOLORMAP(x) ((Colormap) CDR(x))
#define XDISPLAYP(x) (TYP16(x) == tc16_xdisplay)
#define XDISPLAY(x) ((Display *) CDR(x))
#define XEVENTP(x) (TYP16(x) == tc16_xevent)
#define XEVENT(x) ((XAnyEvent *) CDR(x))
#define XGCP(x) (TYP16(x) == tc16_xgc)
#define XGC(x) ((GC) CDR(x))
#define XPIXMAPP(x) (TYP16(x) == tc16_xpixmap)
#define XPIXMAP(x) ((Pixmap) CDR(x))
#define XWINDOWP(x) (TYP16(x) == tc16_xwindow)
#define XWINDOW(x) ((Window) CDR(x))

#endif /* X__INCLUDED */
